/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.filtering;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorList
implements EntryFilteringCursor {
    private final List<EntryFilteringCursor> list;
    private final int start;
    private final int end;
    private int index = -1;
    private SearchingOperationContext opContext;
    private boolean closed;
    private static final Logger LOG = LoggerFactory.getLogger(CursorList.class);

    public CursorList(int start, List<EntryFilteringCursor> list, int end, SearchingOperationContext opContext) {
        if (start < 0 || start > list.size()) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_02005", (Object[])new Object[]{start}));
        }
        if (end < 0 || end > list.size()) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_02006", (Object[])new Object[]{end}));
        }
        if (list.size() > 0 && start >= end) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_02007", (Object[])new Object[]{start, end}));
        }
        this.list = list != null ? list : Collections.emptyList();
        this.start = start;
        this.end = end;
        this.opContext = opContext;
    }

    public CursorList(List<EntryFilteringCursor> list, SearchingOperationContext opContext) {
        this(0, list, list.size(), opContext);
    }

    public boolean available() {
        if (this.index >= 0 && this.index < this.end) {
            return this.list.get(this.index).available();
        }
        return false;
    }

    public void before(ClonedServerEntry element) throws Exception {
        throw new UnsupportedOperationException(I18n.err((String)"ERR_02008", (Object[])new Object[0]));
    }

    public void after(ClonedServerEntry element) throws Exception {
        throw new UnsupportedOperationException(I18n.err((String)"ERR_02008", (Object[])new Object[0]));
    }

    public void beforeFirst() throws Exception {
        this.index = -1;
        this.list.get(this.index).beforeFirst();
    }

    public void afterLast() throws Exception {
        this.index = this.end;
        this.list.get(this.index).afterLast();
    }

    public boolean first() throws Exception {
        if (this.list.size() > 0) {
            this.index = this.start;
            return this.list.get(this.index).first();
        }
        return false;
    }

    public boolean last() throws Exception {
        if (this.list.size() > 0) {
            this.index = this.end - 1;
            return this.list.get(this.index).last();
        }
        return false;
    }

    public boolean isFirst() throws Exception {
        return this.list.size() > 0 && this.index == this.start && this.list.get(this.index).first();
    }

    public boolean isLast() throws Exception {
        return this.list.size() > 0 && this.index == this.end - 1 && this.list.get(this.index).last();
    }

    public boolean isAfterLast() throws Exception {
        return this.index == this.end;
    }

    public boolean isBeforeFirst() throws Exception {
        return this.index == -1;
    }

    public boolean previous() throws Exception {
        if (this.index == -1) {
            return false;
        }
        if (this.index - 1 >= this.start) {
            if (this.index == this.end) {
                --this.index;
            }
            if (!this.list.get(this.index).previous()) {
                --this.index;
                if (this.index != -1) {
                    return this.list.get(this.index).previous();
                }
                return false;
            }
            return true;
        }
        if (this.index <= this.start) {
            if (!this.list.get(this.index).previous()) {
                this.index = -1;
                return false;
            }
            return true;
        }
        if (this.list.size() <= 0) {
            this.index = -1;
        }
        return false;
    }

    public boolean next() throws Exception {
        if (this.list.size() > 0 && this.index == -1) {
            this.index = this.start;
            return this.list.get(this.index).next();
        }
        if (this.list.size() > 0 && this.index + 1 < this.end) {
            if (!this.list.get(this.index).next()) {
                ++this.index;
                if (this.index < this.end) {
                    return this.list.get(this.index).next();
                }
                return false;
            }
            return true;
        }
        if (this.list.size() > 0 && this.index + 1 == this.end) {
            if (!this.list.get(this.index).next()) {
                ++this.index;
                return false;
            }
            return true;
        }
        if (this.list.size() <= 0) {
            this.index = this.end;
        }
        return false;
    }

    public ClonedServerEntry get() throws Exception {
        if (this.index < this.start || this.index >= this.end) {
            throw new IOException(I18n.err((String)"ERR_02009", (Object[])new Object[0]));
        }
        if (this.list.get(this.index).available()) {
            return (ClonedServerEntry)this.list.get(this.index).get();
        }
        throw new InvalidCursorPositionException();
    }

    public boolean isElementReused() {
        return true;
    }

    @Override
    public boolean addEntryFilter(EntryFilter filter) {
        for (EntryFilteringCursor efc : this.list) {
            efc.addEntryFilter(filter);
        }
        return true;
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        throw new UnsupportedOperationException("CursorList doesn't support this operation");
    }

    @Override
    public SearchingOperationContext getOperationContext() {
        return this.opContext;
    }

    @Override
    public boolean isAbandoned() {
        return this.getOperationContext().isAbandoned();
    }

    @Override
    public boolean removeEntryFilter(EntryFilter filter) {
        return false;
    }

    @Override
    public void setAbandoned(boolean abandoned) {
        this.getOperationContext().setAbandoned(abandoned);
        if (abandoned) {
            LOG.info("Cursor has been abandoned.");
        }
    }

    public void close() throws Exception {
        this.close(null);
    }

    public void close(Exception reason) throws Exception {
        this.closed = true;
        for (EntryFilteringCursor c : this.list) {
            try {
                if (reason != null) {
                    c.close();
                    continue;
                }
                c.close(reason);
            }
            catch (Exception e) {
                LOG.warn("Failed to close the cursor");
            }
        }
    }

    public boolean isClosed() throws Exception {
        return this.closed;
    }

    public Iterator<ClonedServerEntry> iterator() {
        throw new UnsupportedOperationException();
    }

    public void setClosureMonitor(ClosureMonitor monitor) {
        for (EntryFilteringCursor c : this.list) {
            c.setClosureMonitor(monitor);
        }
    }
}

