/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Principal;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;

public final class LdapPrincipal
implements Principal,
Cloneable,
Externalizable {
    private static final long serialVersionUID = 3906650782395676720L;
    private DN name;
    public static final LdapPrincipal ANONYMOUS = new LdapPrincipal();
    private AuthenticationLevel authenticationLevel;
    private transient byte[] userPassword;

    public LdapPrincipal(DN name, AuthenticationLevel authenticationLevel) {
        this.name = name;
        if (!name.isNormalized()) {
            throw new IllegalStateException(I18n.err((String)I18n.ERR_436, (Object[])new Object[0]));
        }
        this.authenticationLevel = authenticationLevel;
        this.userPassword = null;
    }

    public LdapPrincipal(DN name, AuthenticationLevel authenticationLevel, byte[] userPassword) {
        this.name = name;
        this.authenticationLevel = authenticationLevel;
        this.userPassword = new byte[userPassword.length];
        System.arraycopy(userPassword, 0, this.userPassword, 0, userPassword.length);
    }

    public LdapPrincipal() {
        this.name = new DN();
        this.authenticationLevel = AuthenticationLevel.NONE;
        this.userPassword = null;
    }

    public DN getClonedName() {
        return (DN)this.name.clone();
    }

    public String getName() {
        return this.name.getNormName();
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public String toString() {
        return "['" + this.name.getName() + "', '" + StringTools.utf8ToString((byte[])this.userPassword) + "']'";
    }

    public byte[] getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(byte[] userPassword) {
        this.userPassword = new byte[userPassword.length];
        System.arraycopy(userPassword, 0, this.userPassword, 0, userPassword.length);
    }

    public Object clone() throws CloneNotSupportedException {
        LdapPrincipal clone = (LdapPrincipal)super.clone();
        if (this.userPassword != null) {
            clone.setUserPassword(this.userPassword);
        }
        return clone;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (DN)in.readObject();
        int level = in.readInt();
        this.authenticationLevel = AuthenticationLevel.getLevel((int)level);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.name == null) {
            out.writeObject(DN.EMPTY_DN);
        } else {
            out.writeObject(this.name);
        }
        if (this.authenticationLevel == null) {
            out.writeInt(AuthenticationLevel.NONE.getLevel());
        } else {
            out.writeInt(this.authenticationLevel.getLevel());
        }
    }
}

