/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.HttpServletRequestSnapshot;
import org.apache.cxf.transport.http.Servlet3ContinuationProvider;
import org.apache.cxf.transport.http.policy.PolicyUtils;
import org.apache.cxf.transport.https.CertConstraints;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPDestination
extends AbstractMultiplexDestination
implements Configurable,
Assertor {
    public static final String HTTP_REQUEST = "HTTP.REQUEST";
    public static final String HTTP_RESPONSE = "HTTP.RESPONSE";
    public static final String HTTP_CONTEXT = "HTTP.CONTEXT";
    public static final String HTTP_CONFIG = "HTTP.CONFIG";
    public static final String PROTOCOL_HEADERS_CONTENT_TYPE = "Content-Type".toLowerCase();
    public static final String RESPONSE_HEADERS_COPIED = "http.headers.copied";
    public static final String RESPONSE_COMMITED = "http.response.done";
    public static final String REQUEST_REDIRECTED = "http.request.redirected";
    public static final String CXF_CONTINUATION_MESSAGE = "cxf.continuation.message";
    private static final String HTTP_HEADERS_SETCOOKIE = "Set-Cookie";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractHTTPDestination.class);
    private static final long serialVersionUID = 1L;
    protected final Bus bus;
    protected HTTPServerPolicy server;
    protected String contextMatchStrategy = "stem";
    protected boolean fixedParameterOrder;
    protected boolean multiplexWithAddress;
    protected CertConstraints certConstraints;
    protected boolean isServlet3;

    public AbstractHTTPDestination(Bus b, EndpointInfo ei, boolean dp) throws IOException {
        super(b, AbstractHTTPDestination.getTargetReference((EndpointInfo)AbstractHTTPDestination.getAddressValue(ei, dp), (Bus)b), ei);
        this.bus = b;
        try {
            ServletRequest.class.getMethod("isAsyncSupported", new Class[0]);
            this.isServlet3 = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.initConfig();
    }

    protected void setHeaders(Message message) {
        String authType;
        List authorizationLines;
        String credentials;
        HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        this.copyRequestHeaders(message, requestHeaders);
        message.put((Object)Message.PROTOCOL_HEADERS, requestHeaders);
        if (requestHeaders.containsKey("Authorization") && (credentials = (String)(authorizationLines = (List)requestHeaders.get("Authorization")).get(0)) != null && !StringUtils.isEmpty((String)credentials.trim()) && "Basic".equals(authType = credentials.split(" ")[0])) {
            String authEncoded = credentials.split(" ")[1];
            try {
                String authDecoded = new String(Base64Utility.decode((String)authEncoded));
                String[] authInfo = authDecoded.split(":");
                String username = authInfo.length > 0 ? authInfo[0] : "";
                String password = authInfo.length > 1 ? authInfo[1] : "";
                AuthorizationPolicy policy = new AuthorizationPolicy();
                policy.setUserName(username);
                policy.setPassword(password);
                message.put(AuthorizationPolicy.class, (Object)policy);
            }
            catch (Base64Exception ex) {
                // empty catch block
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Request Headers: " + ((Object)requestHeaders).toString());
        }
    }

    protected void updateResponseHeaders(Message message) {
        HashMap responseHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (responseHeaders == null) {
            responseHeaders = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
        }
        this.setPolicies(responseHeaders);
    }

    protected final boolean isOneWay(Message message) {
        Exchange ex = message.getExchange();
        return ex == null ? false : ex.isOneWay();
    }

    protected void copyRequestHeaders(Message message, Map<String, List<String>> headers) {
        HttpServletRequest req = (HttpServletRequest)message.get((Object)HTTP_REQUEST);
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            List<Object> values;
            String fname = (String)e.nextElement();
            String mappedName = HttpHeaderHelper.getHeaderKey((String)fname);
            if (headers.containsKey(mappedName)) {
                values = headers.get(mappedName);
            } else {
                values = new ArrayList();
                headers.put(mappedName, values);
            }
            Enumeration e2 = req.getHeaders(fname);
            while (e2.hasMoreElements()) {
                String val = (String)e2.nextElement();
                values.add(val);
            }
        }
        headers.put("Content-Type", Collections.singletonList(req.getContentType()));
    }

    protected void copyResponseHeaders(Message message, HttpServletResponse response) {
        Map headers;
        String ct = (String)message.get((Object)"Content-Type");
        String enc = (String)message.get((Object)Message.ENCODING);
        if (null != ct && null != enc && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
            ct = ct + "; charset=" + enc;
        }
        if (null != (headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS))) {
            if (!headers.containsKey("Content-Type") && ct != null) {
                response.setContentType(ct);
            }
            for (String header : headers.keySet()) {
                int i;
                List headerList = (List)headers.get(header);
                StringBuilder sb = new StringBuilder();
                if (HTTP_HEADERS_SETCOOKIE.equals(header)) {
                    for (i = 0; i < headerList.size(); ++i) {
                        response.addHeader(header, headerList.get(i).toString());
                    }
                } else {
                    for (i = 0; i < headerList.size(); ++i) {
                        sb.append(headerList.get(i));
                        if (i + 1 >= headerList.size()) continue;
                        sb.append(',');
                    }
                }
                response.addHeader(header, sb.toString());
            }
        } else {
            response.setContentType(ct);
        }
    }

    protected void setupMessage(Message inMessage, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setupMessage(inMessage, null, context, req, resp);
    }

    protected void setupMessage(final Message inMessage, ServletConfig config, ServletContext context, final HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.setupContinuation(inMessage, req, resp);
        DelegatingInputStream in = new DelegatingInputStream((InputStream)req.getInputStream()){

            public void cacheInput() {
                if (!this.cached) {
                    inMessage.put((Object)AbstractHTTPDestination.HTTP_REQUEST, (Object)new HttpServletRequestSnapshot(req));
                }
                super.cacheInput();
            }
        };
        inMessage.setContent(DelegatingInputStream.class, (Object)in);
        inMessage.setContent(InputStream.class, (Object)in);
        inMessage.put((Object)HTTP_REQUEST, (Object)req);
        inMessage.put((Object)HTTP_RESPONSE, (Object)resp);
        inMessage.put((Object)HTTP_CONTEXT, (Object)context);
        inMessage.put((Object)HTTP_CONFIG, (Object)config);
        inMessage.put((Object)"org.apache.cxf.request.method", (Object)req.getMethod());
        inMessage.put((Object)"org.apache.cxf.request.uri", (Object)req.getRequestURI());
        String contextPath = req.getContextPath();
        if (contextPath == null) {
            contextPath = "";
        }
        inMessage.put((Object)Message.PATH_INFO, (Object)(contextPath + req.getPathInfo()));
        String contentType = req.getContentType();
        String enc = HttpHeaderHelper.findCharset((String)contentType);
        if (enc == null) {
            enc = req.getCharacterEncoding();
        }
        if (enc != null && enc.endsWith("\"")) {
            enc = enc.substring(0, enc.length() - 1);
        }
        if (enc != null || "POST".equals(req.getMethod()) || "PUT".equals(req.getMethod())) {
            String normalizedEncoding = HttpHeaderHelper.mapCharset((String)enc);
            if (normalizedEncoding == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, new Object[]{enc}).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put((Object)Message.ENCODING, (Object)normalizedEncoding);
        }
        inMessage.put((Object)Message.QUERY_STRING, (Object)req.getQueryString());
        inMessage.put((Object)"Content-Type", (Object)contentType);
        inMessage.put((Object)"Accept", (Object)req.getHeader("Accept"));
        String basePath = this.getBasePath(contextPath);
        if (!StringUtils.isEmpty((String)basePath)) {
            inMessage.put((Object)Message.BASE_PATH, (Object)basePath);
        }
        inMessage.put((Object)Message.FIXED_PARAMETER_ORDER, (Object)this.isFixedParameterOrder());
        inMessage.put((Object)"org.apache.cxf.async.post.response.dispatch", (Object)Boolean.TRUE);
        inMessage.put(SecurityContext.class, (Object)new SecurityContext(){

            public Principal getUserPrincipal() {
                return req.getUserPrincipal();
            }

            public boolean isUserInRole(String role) {
                return req.isUserInRole(role);
            }
        });
        this.setHeaders(inMessage);
        SSLUtils.propogateSecureSession(req, inMessage);
        inMessage.put((Object)CertConstraints.class.getName(), (Object)this.certConstraints);
        inMessage.put((Object)Message.IN_INTERCEPTORS, Arrays.asList(new Interceptor[]{CertConstraintsInterceptor.INSTANCE}));
    }

    protected Message retrieveFromContinuation(HttpServletRequest req) {
        if (!this.isServlet3) {
            return null;
        }
        return this.retrieveFromServlet3Async(req);
    }

    protected Message retrieveFromServlet3Async(HttpServletRequest req) {
        if (req.isAsyncStarted()) {
            return (Message)req.getAttribute(CXF_CONTINUATION_MESSAGE);
        }
        return null;
    }

    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
        if (this.isServlet3) {
            inMessage.put((Object)ContinuationProvider.class.getName(), (Object)new Servlet3ContinuationProvider(req, resp, inMessage));
        }
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.endpointInfo.getAddress()).getPath();
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei) {
        return AbstractHTTPDestination.getAddressValue(ei, true);
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei, boolean dp) {
        if (dp) {
            String addr;
            String eiAddress = ei.getAddress();
            if (eiAddress == null) {
                try {
                    ServerSocket s = new ServerSocket(0);
                    ei.setAddress("http://localhost:" + s.getLocalPort());
                    s.close();
                    return ei;
                }
                catch (IOException ex) {
                    ei.setAddress("http://localhost");
                }
            }
            if ((addr = StringUtils.addDefaultPortIfMissing((String)ei.getAddress())) != null) {
                ei.setAddress(addr);
            }
        }
        return ei;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        HttpServletResponse response = (HttpServletResponse)inMessage.get((Object)HTTP_RESPONSE);
        return new BackChannelConduit(response);
    }

    private void initConfig() {
        PolicyEngine engine = (PolicyEngine)this.bus.getExtension(PolicyEngine.class);
        if (null != engine && engine.isEnabled() && null != this.endpointInfo.getService()) {
            this.server = PolicyUtils.getServer(engine, this.endpointInfo, (Destination)this);
        }
        if (null == this.server) {
            this.server = (HTTPServerPolicy)((Object)this.endpointInfo.getTraversedExtensor((Object)new HTTPServerPolicy(), HTTPServerPolicy.class));
        }
    }

    private static List<String> createMutableList(String val) {
        return new ArrayList<String>(Arrays.asList(val));
    }

    void setPolicies(Map<String, List<String>> headers) {
        HTTPServerPolicy policy = this.server;
        if (policy.isSetCacheControl()) {
            headers.put("Cache-Control", AbstractHTTPDestination.createMutableList(policy.getCacheControl()));
        }
        if (policy.isSetContentLocation()) {
            headers.put("Content-Location", AbstractHTTPDestination.createMutableList(policy.getContentLocation()));
        }
        if (policy.isSetContentEncoding()) {
            headers.put("Content-Encoding", AbstractHTTPDestination.createMutableList(policy.getContentEncoding()));
        }
        if (policy.isSetContentType()) {
            headers.put("Content-Type", AbstractHTTPDestination.createMutableList(policy.getContentType()));
        }
        if (policy.isSetServerType()) {
            headers.put("Server", AbstractHTTPDestination.createMutableList(policy.getServerType()));
        }
        if (policy.isSetHonorKeepAlive() && !policy.isHonorKeepAlive()) {
            headers.put("Connection", AbstractHTTPDestination.createMutableList("close"));
        } else if (policy.isSetKeepAliveParameters()) {
            headers.put("Keep-Alive", AbstractHTTPDestination.createMutableList(policy.getKeepAliveParameters()));
        }
    }

    private void cacheInput(Message outMessage) {
        DelegatingInputStream in;
        if (outMessage.getExchange() == null) {
            return;
        }
        Message inMessage = outMessage.getExchange().getInMessage();
        if (inMessage == null) {
            return;
        }
        Collection atts = inMessage.getAttachments();
        if (atts != null) {
            for (Attachment a : atts) {
                if (!(a.getDataHandler().getDataSource() instanceof AttachmentDataSource)) continue;
                try {
                    ((AttachmentDataSource)a.getDataHandler().getDataSource()).cache();
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
            }
        }
        if ((in = (DelegatingInputStream)inMessage.getContent(DelegatingInputStream.class)) != null) {
            in.cacheInput();
        }
    }

    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        return this.flushHeaders(outMessage, true);
    }

    protected OutputStream flushHeaders(Message outMessage, boolean getStream) throws IOException {
        if (this.isResponseRedirected(outMessage)) {
            return null;
        }
        this.cacheInput(outMessage);
        this.updateResponseHeaders(outMessage);
        Object responseObj = outMessage.get((Object)HTTP_RESPONSE);
        ServletOutputStream responseStream = null;
        boolean oneWay = this.isOneWay(outMessage);
        if (responseObj instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)responseObj;
            Integer i = (Integer)outMessage.get((Object)Message.RESPONSE_CODE);
            if (i != null) {
                Map pHeaders;
                int status = i;
                if (500 == i && null != (pHeaders = CastUtils.cast((Map)((Map)outMessage.get((Object)Message.PROTOCOL_HEADERS)))) && pHeaders.containsKey(PROTOCOL_HEADERS_CONTENT_TYPE)) {
                    pHeaders.remove(PROTOCOL_HEADERS_CONTENT_TYPE);
                }
                response.setStatus(status);
            } else if (oneWay && !MessageUtils.isPartialResponse((Message)outMessage)) {
                response.setStatus(202);
            } else {
                response.setStatus(200);
            }
            this.copyResponseHeaders(outMessage, response);
            outMessage.put((Object)RESPONSE_HEADERS_COPIED, (Object)"true");
            if (oneWay && !MessageUtils.isPartialResponse((Message)outMessage)) {
                response.setContentLength(0);
                response.flushBuffer();
                response.getOutputStream().close();
            } else if (!getStream) {
                response.getOutputStream().close();
            } else {
                responseStream = response.getOutputStream();
            }
        } else {
            if (null != responseObj) {
                String m = new org.apache.cxf.common.i18n.Message("UNEXPECTED_RESPONSE_TYPE_MSG", LOG, new Object[]{responseObj.getClass()}).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            String m = new org.apache.cxf.common.i18n.Message("NULL_RESPONSE_MSG", LOG, new Object[0]).toString();
            LOG.log(Level.WARNING, m);
            throw new IOException(m);
        }
        if (oneWay) {
            outMessage.remove((Object)HTTP_RESPONSE);
        }
        return responseStream;
    }

    private boolean isResponseRedirected(Message outMessage) {
        return Boolean.TRUE.equals(outMessage.get((Object)REQUEST_REDIRECTED));
    }

    protected boolean contextMatchOnExact() {
        return "exact".equals(this.contextMatchStrategy);
    }

    public String getBeanName() {
        String beanName = null;
        if (this.endpointInfo.getName() != null) {
            beanName = this.endpointInfo.getName().toString() + ".http-destination";
        }
        return beanName;
    }

    public EndpointReferenceType getAddressWithId(String id) {
        EndpointReferenceType ref = null;
        if (this.isMultiplexWithAddress()) {
            String address = EndpointReferenceUtils.getAddress((EndpointReferenceType)this.reference);
            ref = EndpointReferenceUtils.duplicate((EndpointReferenceType)this.reference);
            if (address.endsWith("/")) {
                EndpointReferenceUtils.setAddress((EndpointReferenceType)ref, (String)(address + id));
            } else {
                EndpointReferenceUtils.setAddress((EndpointReferenceType)ref, (String)(address + "/" + id));
            }
        } else {
            ref = super.getAddressWithId(id);
        }
        return ref;
    }

    public String getId(Map context) {
        String id = null;
        if (this.isMultiplexWithAddress()) {
            String address = (String)context.get(Message.PATH_INFO);
            if (null != address) {
                int afterLastSlashIndex = address.lastIndexOf("/") + 1;
                if (afterLastSlashIndex > 0 && afterLastSlashIndex < address.length()) {
                    id = address.substring(afterLastSlashIndex);
                }
            } else {
                this.getLogger().log(Level.WARNING, new org.apache.cxf.common.i18n.Message("MISSING_PATH_INFO", LOG, new Object[0]).toString());
            }
        } else {
            return super.getId(context);
        }
        return id;
    }

    public String getContextMatchStrategy() {
        return this.contextMatchStrategy;
    }

    public void setContextMatchStrategy(String contextMatchStrategy) {
        this.contextMatchStrategy = contextMatchStrategy;
    }

    public boolean isFixedParameterOrder() {
        return this.fixedParameterOrder;
    }

    public void setFixedParameterOrder(boolean fixedParameterOrder) {
        this.fixedParameterOrder = fixedParameterOrder;
    }

    public boolean isMultiplexWithAddress() {
        return this.multiplexWithAddress;
    }

    public void setMultiplexWithAddress(boolean multiplexWithAddress) {
        this.multiplexWithAddress = multiplexWithAddress;
    }

    public HTTPServerPolicy getServer() {
        return this.server;
    }

    public void setServer(HTTPServerPolicy server) {
        this.server = server;
    }

    public void assertMessage(Message message) {
        PolicyUtils.assertServerPolicy(message, this.server);
    }

    public boolean canAssert(QName type) {
        return PolicyUtils.HTTPSERVERPOLICY_ASSERTION_QNAME.equals(type);
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected HttpServletResponse response;
        private Message outMessage;

        WrappedOutputStream(Message m, HttpServletResponse resp) {
            this.outMessage = m;
            this.response = resp;
        }

        protected void onFirstWrite() throws IOException {
            OutputStream responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage);
            if (null != responseStream) {
                this.wrappedStream = responseStream;
            }
        }

        public void close() throws IOException {
            OutputStream responseStream;
            if (this.wrappedStream == null && null != (responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage, false))) {
                this.wrappedStream = responseStream;
            }
            if (this.wrappedStream != null) {
                this.wrappedStream.close();
                this.response.flushBuffer();
            }
        }

        public void flush() throws IOException {
        }
    }

    public class BackChannelConduit
    extends AbstractDestination.AbstractBackChannelConduit {
        protected HttpServletResponse response;

        BackChannelConduit(HttpServletResponse resp) {
            super((AbstractDestination)AbstractHTTPDestination.this);
            this.response = resp;
        }

        public void prepare(Message message) throws IOException {
            message.put((Object)AbstractHTTPDestination.HTTP_RESPONSE, (Object)this.response);
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            if (os == null) {
                message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, this.response));
            }
        }

        public void close(Message msg) throws IOException {
            super.close(msg);
            if (msg.getExchange() == null) {
                return;
            }
            Message m = msg.getExchange().getInMessage();
            if (m == null || msg.getExchange().isOneWay()) {
                return;
            }
            InputStream is = (InputStream)m.getContent(InputStream.class);
            if (is != null) {
                try {
                    is.close();
                    m.removeContent(InputStream.class);
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
        }
    }
}

