/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.cocoon.configuration.MutableSettings;
import org.apache.cocoon.spring.configurator.ResourceUtils;
import org.apache.cocoon.spring.configurator.impl.AbstractSettingsBeanFactoryPostProcessor;
import org.apache.cocoon.spring.configurator.impl.RunningModeHelper;

public class SettingsBeanFactoryPostProcessor
extends AbstractSettingsBeanFactoryPostProcessor {
    protected String runningMode = "prod";
    protected boolean readFromClasspath = true;
    protected boolean readFromGlobalLocation = true;

    public void setRunningMode(String mode) {
        this.runningMode = mode;
    }

    public void setReadFromClasspath(boolean readFromClasspath) {
        this.readFromClasspath = readFromClasspath;
    }

    public void setReadFromGlobalLocation(boolean readFromGlobalLocation) {
        this.readFromGlobalLocation = readFromGlobalLocation;
    }

    public void init() throws Exception {
        String mode = this.getRunningMode();
        RunningModeHelper.checkRunningMode(mode);
        Properties pomProps = ResourceUtils.getPOMProperties("org.apache.cocoon", "cocoon-spring-configurator");
        String version = pomProps != null ? pomProps.getProperty("version") : null;
        String msg = "Apache Cocoon Spring Configurator " + (version != null ? "v" + version + " " : "") + "is running in mode '" + mode + "'.";
        if (this.servletContext != null) {
            this.servletContext.log(msg);
        } else {
            this.logger.info((Object)msg);
        }
        this.dumpSystemProperties();
        super.init();
        this.forceLoad();
    }

    protected String getRunningMode() {
        return RunningModeHelper.determineRunningMode(this.runningMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preInit(MutableSettings s, Properties properties) {
        String additionalPropertyFile;
        FileInputStream fis;
        String fileName;
        File testFile;
        String homeDir;
        String mode = this.getRunningMode();
        if (this.readFromClasspath) {
            ResourceUtils.readProperties("classpath*:META-INF/cocoon/properties", properties, this.getResourceLoader(), this.resourceFilter, this.logger);
            ResourceUtils.readProperties("classpath*:META-INF/cocoon/properties/" + mode, properties, this.getResourceLoader(), this.resourceFilter, this.logger);
        }
        if (this.readFromGlobalLocation) {
            ResourceUtils.readProperties("/WEB-INF/cocoon/properties", properties, this.getResourceLoader(), this.resourceFilter, this.logger);
            ResourceUtils.readProperties("/WEB-INF/cocoon/properties/" + mode, properties, this.getResourceLoader(), this.resourceFilter, this.logger);
        }
        if (s.getWorkDirectory() == null) {
            File workDir = this.servletContext != null ? (File)this.servletContext.getAttribute("javax.servlet.context.tempdir") : new File("cocoon-files");
            s.setWorkDirectory(workDir.getAbsolutePath());
        }
        if (s.getCacheDirectory() == null) {
            s.setCacheDirectory(new File(s.getWorkDirectory(), "cache-dir").getAbsolutePath());
        }
        if ((homeDir = this.getSystemProperty("user.home")) != null && (testFile = new File(fileName = homeDir + File.separator + ".cocoon" + File.separator + "settings.properties")).exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Reading user settings from '" + fileName + "'"));
            }
            try {
                fis = new FileInputStream(fileName);
                try {
                    properties.load(fis);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {
                        this.logger.warn((Object)"Failed to close FileInputStream:", (Throwable)ioe);
                    }
                }
            }
            catch (IOException ignore) {
                this.logger.info((Object)("Unable to read '" + fileName + "' - continuing with initialization."), (Throwable)ignore);
            }
        }
        if ((additionalPropertyFile = s.getProperty("org.apache.cocoon.settings", this.getServletContextInitParameter("org.apache.cocoon.settings", this.getSystemProperty("org.apache.cocoon.settings")))) != null) {
            File additionalFile;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Reading user settings from '" + additionalPropertyFile + "'"));
            }
            if ((additionalFile = new File(additionalPropertyFile)).exists()) {
                if (additionalFile.isDirectory()) {
                    ResourceUtils.readProperties(additionalFile.getAbsolutePath(), properties, this.getResourceLoader(), this.resourceFilter, this.logger);
                    ResourceUtils.readProperties(additionalFile.getAbsolutePath() + File.separatorChar + mode, properties, this.getResourceLoader(), this.resourceFilter, this.logger);
                } else {
                    try {
                        fis = new FileInputStream(additionalFile);
                        properties.load(fis);
                        fis.close();
                    }
                    catch (IOException ignore) {
                        this.logger.info((Object)("Unable to read '" + additionalPropertyFile + "' - continuing with initialization."), (Throwable)ignore);
                    }
                }
            } else {
                this.logger.info((Object)("Additional settings file '" + additionalPropertyFile + "' does not exist - continuing with initialization."));
            }
        }
    }

    protected String getServletContextInitParameter(String key, String defaultValue) {
        if (this.servletContext == null) {
            return defaultValue;
        }
        String servletContextSettings = this.servletContext.getInitParameter(key);
        if (servletContextSettings == null || "".equals(servletContextSettings)) {
            return defaultValue;
        }
        return servletContextSettings;
    }

    protected MutableSettings createSettings() {
        MutableSettings s = super.createSettings();
        File workDir = new File(s.getWorkDirectory());
        workDir.mkdirs();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using work-directory " + workDir));
        }
        File cacheDir = new File(s.getCacheDirectory());
        cacheDir.mkdirs();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using cache-directory " + cacheDir));
        }
        return s;
    }

    protected void dumpSystemProperties() {
        if (this.logger.isDebugEnabled()) {
            try {
                Enumeration<?> e = System.getProperties().propertyNames();
                this.logger.debug((Object)"===== System Properties Start =====");
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.logger.debug((Object)(key + "=" + System.getProperty(key)));
                }
                this.logger.debug((Object)"===== System Properties End =====");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    protected void forceLoad() {
        for (String fqcn : this.settings.getLoadClasses()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loading class: " + fqcn));
                }
                Thread.currentThread().getContextClassLoader().loadClass(fqcn).newInstance();
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Could not load class: " + fqcn + ". Continuing initialization."), (Throwable)e);
            }
        }
    }
}

