/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.server.AxisHttpRequest;
import org.apache.http.Header;

public class HttpUtils {
    private HttpUtils() {
    }

    public static String getSoapAction(AxisHttpRequest request) {
        if (request == null) {
            return null;
        }
        Header header = request.getFirstHeader("SOAPAction");
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public static String getIpAddress() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        String address = "127.0.0.1";
        while (e.hasMoreElements()) {
            NetworkInterface netface = e.nextElement();
            Enumeration<InetAddress> addresses = netface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip.isLoopbackAddress() || !HttpUtils.isIP(ip.getHostAddress())) continue;
                return ip.getHostAddress();
            }
        }
        return address;
    }

    public static String getIpAddress(AxisConfiguration axisConfiguration) throws SocketException {
        String hostAddress;
        Parameter param;
        if (axisConfiguration != null && (param = axisConfiguration.getParameter("hostname")) != null && (hostAddress = ((String)param.getValue()).trim()) != null) {
            return hostAddress;
        }
        return HttpUtils.getIpAddress();
    }

    private static boolean isIP(String hostAddress) {
        return hostAddress.split("[.]").length == 4;
    }
}

