/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import javax.jms.JMSException;
import org.apache.activemq.blob.BlobDownloadStrategy;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.commons.net.ftp.FTPClient;

public class FTPBlobDownloadStrategy
implements BlobDownloadStrategy {
    private String ftpUser;
    private String ftpPass;

    public InputStream getInputStream(ActiveMQBlobMessage message) throws IOException, JMSException {
        URL url = message.getURL();
        this.setUserInformation(url.getUserInfo());
        String connectUrl = url.getHost();
        int port = url.getPort() < 1 ? 21 : url.getPort();
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(connectUrl, port);
        }
        catch (ConnectException e) {
            throw new JMSException("Problem connecting the FTP-server");
        }
        if (!ftp.login(this.ftpUser, this.ftpPass)) {
            ftp.quit();
            ftp.disconnect();
            throw new JMSException("Cant Authentificate to FTP-Server");
        }
        String path = url.getPath();
        String workingDir = path.substring(0, path.lastIndexOf("/"));
        String file = path.substring(path.lastIndexOf("/") + 1);
        ftp.changeWorkingDirectory(workingDir);
        ftp.setFileType(2);
        InputStream input = ftp.retrieveFileStream(file);
        ftp.quit();
        ftp.disconnect();
        return input;
    }

    private void setUserInformation(String userInfo) {
        if (userInfo != null) {
            String[] userPass = userInfo.split(":");
            if (userPass.length > 0) {
                this.ftpUser = userPass[0];
            }
            if (userPass.length > 1) {
                this.ftpPass = userPass[1];
            }
        } else {
            this.ftpUser = "anonymous";
            this.ftpPass = "anonymous";
        }
    }
}

