/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.activiti.spring.process.model.ProcessVariablesMapping;
import org.activiti.spring.process.model.VariableDefinition;

public class Extension {
    private Map<String, VariableDefinition> properties = new HashMap<String, VariableDefinition>();
    private Map<String, ProcessVariablesMapping> mappings = new HashMap<String, ProcessVariablesMapping>();
    private final ProcessVariablesMapping EMPTY_PROCESS_VARIABLES_MAPPING = new ProcessVariablesMapping();

    public Map<String, VariableDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, VariableDefinition> properties) {
        this.properties = properties;
    }

    public Map<String, ProcessVariablesMapping> getMappings() {
        return this.mappings;
    }

    public ProcessVariablesMapping getMappingForFlowElement(String flowElementUUID) {
        ProcessVariablesMapping processVariablesMapping = this.mappings.get(flowElementUUID);
        return processVariablesMapping != null ? processVariablesMapping : this.EMPTY_PROCESS_VARIABLES_MAPPING;
    }

    public void setMappings(Map<String, ProcessVariablesMapping> mappings) {
        this.mappings = mappings;
    }

    public VariableDefinition getProperty(String propertyUUID) {
        return this.properties != null ? this.properties.get(propertyUUID) : null;
    }

    public VariableDefinition getPropertyByName(String name) {
        if (this.properties != null) {
            for (Map.Entry<String, VariableDefinition> variableDefinition : this.properties.entrySet()) {
                if (variableDefinition.getValue() == null || !Objects.equals(variableDefinition.getValue().getName(), name)) continue;
                return variableDefinition.getValue();
            }
        }
        return null;
    }
}

