/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.junit;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import net.sourceforge.jwebunit.api.IJWebUnitDialog;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptAlertException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptConfirmException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptPromptException;
import net.sourceforge.jwebunit.exception.TestingEngineResponseException;
import net.sourceforge.jwebunit.exception.UnableToSetFormException;
import net.sourceforge.jwebunit.html.Table;
import net.sourceforge.jwebunit.javascript.JavascriptAlert;
import net.sourceforge.jwebunit.javascript.JavascriptConfirm;
import net.sourceforge.jwebunit.javascript.JavascriptPrompt;
import net.sourceforge.jwebunit.util.TestContext;
import net.sourceforge.jwebunit.util.TestingEngineRegistry;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class WebTester {
    private IJWebUnitDialog dialog = null;
    private TestContext testContext = null;
    private String testingEngineKey = null;

    public IJWebUnitDialog getDialog() {
        return this.getTestingEngine();
    }

    protected IJWebUnitDialog getTestingEngine() {
        if (this.dialog == null) {
            this.dialog = this.initializeDialog();
        }
        return this.dialog;
    }

    protected IJWebUnitDialog initializeDialog() {
        Class theClass;
        IJWebUnitDialog theIJWebUnitDialog = null;
        String theTestingEngineKey = this.getTestingEngineKey();
        try {
            theClass = TestingEngineRegistry.getTestingEngineClass(theTestingEngineKey);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        try {
            theIJWebUnitDialog = (IJWebUnitDialog)theClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException("Can't Instantiate Testing Engine with class [" + theClass + "] with key [" + theTestingEngineKey + "].", e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("IllegalAccessException using class [" + theClass + "] with key [" + theTestingEngineKey + "].", e);
        }
        return theIJWebUnitDialog;
    }

    public void closeBrowser() {
        try {
            this.getTestingEngine().closeBrowser();
        }
        catch (ExpectedJavascriptAlertException e) {
            Assert.fail((String)("You previously tell that alert with message [" + e.getAlertMessage() + "] was expected, but nothing appeared."));
        }
        catch (ExpectedJavascriptConfirmException e) {
            Assert.fail((String)("You previously tell that confirm with message [" + e.getConfirmMessage() + "] was expected, but nothing appeared."));
        }
        catch (ExpectedJavascriptPromptException e) {
            Assert.fail((String)("You previously tell that prompt with message [" + e.getPromptMessage() + "] was expected, but nothing appeared."));
        }
    }

    public void closeWindow() {
        this.getTestingEngine().closeWindow();
    }

    public void setDialog(IJWebUnitDialog aIJWebUnitDialog) {
        this.dialog = aIJWebUnitDialog;
    }

    public TestContext getTestContext() {
        if (this.testContext == null) {
            this.testContext = new TestContext();
        }
        return this.testContext;
    }

    public void setTestContext(TestContext aTestContext) {
        this.testContext = aTestContext;
    }

    public void beginAt(String aRelativeURL) throws TestingEngineResponseException {
        try {
            this.getTestingEngine().beginAt(this.createUrl(aRelativeURL, this.getTestContext().getBaseUrl()), this.testContext);
        }
        catch (MalformedURLException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    private URL createUrl(String url, URL baseURL) throws MalformedURLException {
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("file://")) {
            return new URL(url);
        }
        if (url.startsWith("www.")) {
            return new URL("http://" + url);
        }
        url = url.startsWith("/") ? url.substring(1) : url;
        return new URL(baseURL, url);
    }

    public String getMessage(String key) {
        String message = "";
        Locale locale = this.testContext.getLocale();
        try {
            message = ResourceBundle.getBundle(this.getTestContext().getResourceBundleName(), locale).getString(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("No message found for key [" + key + "].", e);
        }
        return message;
    }

    public String getMessage(String key, Object[] args) {
        String message = this.getMessage(key);
        MessageFormat format = new MessageFormat(message, this.getTestContext().getLocale());
        return format.format(args);
    }

    public void assertTitleEquals(String title) {
        Assert.assertEquals((String)title, (String)this.getTestingEngine().getPageTitle());
    }

    public void assertTitleMatch(String regexp) {
        RE re = null;
        try {
            re = new RE(regexp, 4);
        }
        catch (RESyntaxException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertTrue((String)("Unable to match [" + regexp + "] in title"), (boolean)re.match(this.getTestingEngine().getPageTitle()));
    }

    public void assertTitleEqualsKey(String titleKey) {
        Assert.assertEquals((String)this.getMessage(titleKey), (String)this.getTestingEngine().getPageTitle());
    }

    public void assertTitleEqualsKey(String titleKey, Object[] args) {
        Assert.assertEquals((String)this.getMessage(titleKey, args), (String)this.getTestingEngine().getPageTitle());
    }

    public void assertKeyPresent(String key) {
        this.assertTextPresent(this.getMessage(key));
    }

    public void assertKeyPresent(String key, Object[] args) {
        this.assertTextPresent(this.getMessage(key, args));
    }

    public void assertTextPresent(String text) {
        if (this.getTestingEngine().getPageText().indexOf(text) < 0) {
            Assert.fail((String)("Expected text not found in current page: [" + text + "]\n Page content was: [" + this.getTestingEngine().getPageText() + "]"));
        }
    }

    public void assertMatch(String regexp) {
        RE re = this.getRE(regexp);
        if (!re.match(this.getTestingEngine().getPageText())) {
            Assert.fail((String)("Expected rexexp not matched in response: [" + regexp + "]"));
        }
    }

    public void assertKeyNotPresent(String key) {
        this.assertTextNotPresent(this.getMessage(key));
    }

    public void assertKeyNotPresent(String key, Object[] args) {
        this.assertTextNotPresent(this.getMessage(key, args));
    }

    public void assertTextNotPresent(String text) {
        if (this.getTestingEngine().getPageText().indexOf(text) >= 0) {
            Assert.fail((String)("Text found in response when not expected: [" + text + "]"));
        }
    }

    public void assertNoMatch(String regexp) {
        RE re = this.getRE(regexp);
        if (re.match(this.getTestingEngine().getPageText())) {
            Assert.fail((String)("Regexp matched in response when not expected: [" + regexp + "]"));
        }
    }

    public Table getTable(String tableSummaryNameOrId) {
        return this.getTestingEngine().getTable(tableSummaryNameOrId);
    }

    public void assertTablePresent(String tableSummaryNameOrId) {
        if (!this.getTestingEngine().hasTable(tableSummaryNameOrId)) {
            Assert.fail((String)("Unable to locate table \"" + tableSummaryNameOrId + "\""));
        }
    }

    public void assertTableNotPresent(String tableSummaryNameOrId) {
        if (this.getTestingEngine().hasTable(tableSummaryNameOrId)) {
            Assert.fail((String)("Located table \"" + tableSummaryNameOrId + "\""));
        }
    }

    public void assertKeyInTable(String tableSummaryOrId, String key) {
        this.assertTextInTable(tableSummaryOrId, this.getMessage(key));
    }

    public void assertKeyInTable(String tableSummaryOrId, String key, Object[] args) {
        this.assertTextInTable(tableSummaryOrId, this.getMessage(key, args));
    }

    public void assertTextInTable(String tableSummaryNameOrId, String text) {
        this.assertTablePresent(tableSummaryNameOrId);
        Assert.assertTrue((String)("Could not find: [" + text + "]" + "in table [" + tableSummaryNameOrId + "]"), (boolean)this.getTestingEngine().getTable(tableSummaryNameOrId).hasText(text));
    }

    public void assertMatchInTable(String tableSummaryNameOrId, String regexp) {
        this.assertTablePresent(tableSummaryNameOrId);
        Assert.assertTrue((String)("Could not match: [" + regexp + "]" + "in table [" + tableSummaryNameOrId + "]"), (boolean)this.getTestingEngine().getTable(tableSummaryNameOrId).hasMatch(regexp));
    }

    public void assertKeysInTable(String tableSummaryOrId, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            this.assertKeyInTable(tableSummaryOrId, keys[i]);
        }
    }

    public void assertKeysInTable(String tableSummaryOrId, String[] keys, Object[][] args) {
        for (int i = 0; i < keys.length; ++i) {
            this.assertKeyInTable(tableSummaryOrId, keys[i], args[i]);
        }
    }

    public void assertTextInTable(String tableSummaryOrId, String[] text) {
        for (int i = 0; i < text.length; ++i) {
            this.assertTextInTable(tableSummaryOrId, text[i]);
        }
    }

    public void assertMatchInTable(String tableSummaryOrId, String[] regexp) {
        for (int i = 0; i < regexp.length; ++i) {
            this.assertMatchInTable(tableSummaryOrId, regexp[i]);
        }
    }

    public void assertKeyNotInTable(String tableSummaryOrId, String key) {
        this.assertTextNotInTable(tableSummaryOrId, this.getMessage(key));
    }

    public void assertTextNotInTable(String tableSummaryNameOrId, String text) {
        this.assertTablePresent(tableSummaryNameOrId);
        Assert.assertTrue((String)("Found text: [" + text + "] in table [" + tableSummaryNameOrId + "]"), (!this.getTestingEngine().getTable(tableSummaryNameOrId).hasText(text) ? 1 : 0) != 0);
    }

    public void assertTextNotInTable(String tableSummaryNameOrId, String[] text) {
        for (int i = 0; i < text.length; ++i) {
            this.assertTextNotInTable(tableSummaryNameOrId, text[i]);
        }
    }

    public void assertNoMatchInTable(String tableSummaryNameOrId, String regexp) {
        this.assertTablePresent(tableSummaryNameOrId);
        Assert.assertTrue((String)("Found regexp: [" + regexp + "] in table [" + tableSummaryNameOrId + "]"), (!this.getTestingEngine().getTable(tableSummaryNameOrId).hasMatch(regexp) ? 1 : 0) != 0);
    }

    public void assertNoMatchInTable(String tableSummaryNameOrId, String[] regexp) {
        for (int i = 0; i < regexp.length; ++i) {
            this.assertNoMatchInTable(tableSummaryNameOrId, regexp[i]);
        }
    }

    public void assertTableEquals(String tableSummaryNameOrId, Table expectedTable) {
        this.getTestingEngine().getTable(tableSummaryNameOrId).assertEquals(expectedTable);
    }

    public void assertTableEquals(String tableSummaryNameOrId, String[][] expectedCellValues) {
        this.getTestingEngine().getTable(tableSummaryNameOrId).assertEquals(new Table(expectedCellValues));
    }

    public void assertTableRowsEqual(String tableSummaryNameOrId, int startRow, Table expectedTable) {
        this.getTestingEngine().getTable(tableSummaryNameOrId).assertSubTableEquals(startRow, expectedTable);
    }

    public void assertTableRowsEqual(String tableSummaryNameOrId, int startRow, String[][] expectedTable) {
        this.getTestingEngine().getTable(tableSummaryNameOrId).assertSubTableEquals(startRow, new Table(expectedTable));
    }

    public void assertTableRowCountEquals(String tableSummaryNameOrId, int expectedRowCount) {
        this.assertTablePresent(tableSummaryNameOrId);
        int actualRowCount = this.getTestingEngine().getTable(tableSummaryNameOrId).getRowCount();
        Assert.assertTrue((String)("Expected row count was " + expectedRowCount + " but actual row count is " + actualRowCount), (actualRowCount == expectedRowCount ? 1 : 0) != 0);
    }

    public void assertTableMatch(String tableSummaryOrId, Table expectedTable) {
        this.getTestingEngine().getTable(tableSummaryOrId).assertMatch(expectedTable);
    }

    public void assertTableMatch(String tableSummaryOrId, String[][] expectedCellValues) {
        this.getTestingEngine().getTable(tableSummaryOrId).assertMatch(new Table(expectedCellValues));
    }

    public void assertTableRowsMatch(String tableSummaryOrId, int startRow, Table expectedTable) {
        this.getTestingEngine().getTable(tableSummaryOrId).assertSubTableMatch(startRow, expectedTable);
    }

    public void assertTableRowsMatch(String tableSummaryOrId, int startRow, String[][] expectedTable) {
        this.getTestingEngine().getTable(tableSummaryOrId).assertSubTableMatch(startRow, new Table(expectedTable));
    }

    public void assertFormElementPresent(String formElementName) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Did not find form element with name [" + formElementName + "]."), (boolean)this.getTestingEngine().hasFormParameterNamed(formElementName));
    }

    public void assertFormElementNotPresent(String formElementName) {
        this.assertFormPresent();
        try {
            Assert.assertTrue((String)("Found form element with name [" + formElementName + "] when not expected."), (!this.getDialog().hasFormParameterNamed(formElementName) ? 1 : 0) != 0);
        }
        catch (UnableToSetFormException unableToSetFormException) {
            // empty catch block
        }
    }

    public void assertCheckboxPresent(String checkboxName) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Did not find form checkbox with name [" + checkboxName + "]."), (boolean)this.getTestingEngine().hasElementByXPath("//input[@type='checkbox' and @name='" + checkboxName + "']"));
    }

    public void assertCheckboxPresent(String checkboxName, String checkboxValue) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Did not find form checkbox with name [" + checkboxName + "] and value [" + checkboxValue + "]."), (boolean)this.getTestingEngine().hasElementByXPath("//input[@type='checkbox' and @name='" + checkboxName + "' and @value='" + checkboxValue + "']"));
    }

    public void assertCheckboxNotPresent(String checkboxName) {
        this.assertFormPresent();
        Assert.assertFalse((String)("Found form checkbox with name [" + checkboxName + "] when not expected."), (boolean)this.getTestingEngine().hasElementByXPath("//input[@type='checkbox' and @name='" + checkboxName + "']"));
    }

    public void assertCheckboxNotPresent(String checkboxName, String checkboxValue) {
        this.assertFormPresent();
        Assert.assertFalse((String)("Found form checkbox with name [" + checkboxName + "] and value [" + checkboxValue + "] when not expected."), (boolean)this.getTestingEngine().hasElementByXPath("//input[@type='checkbox' and @name='" + checkboxName + "' and @value='" + checkboxValue + "']"));
    }

    public void assertFormPresent() {
        Assert.assertTrue((String)"No form present", (boolean)this.getTestingEngine().hasForm());
    }

    public void assertFormPresent(String nameOrID) {
        Assert.assertTrue((String)("No form present with name or id [" + nameOrID + "]"), (boolean)this.getTestingEngine().hasForm(nameOrID));
    }

    public void assertFormNotPresent() {
        Assert.assertFalse((String)"A form is present", (boolean)this.getTestingEngine().hasForm());
    }

    public void assertFormNotPresent(String nameOrID) {
        Assert.assertFalse((String)("Form present with name or id [" + nameOrID + "]"), (boolean)this.getTestingEngine().hasForm(nameOrID));
    }

    public void assertFormElementEquals(String formElementName, String expectedValue) {
        this.assertFormElementPresent(formElementName);
        Assert.assertEquals((String)expectedValue, (String)this.getDialog().getElementAttributByXPath("//input[@name='" + formElementName + "']", "value"));
    }

    public void assertFormElementMatch(String formElementName, String regexp) {
        this.assertFormElementPresent(formElementName);
        RE re = null;
        try {
            re = new RE(regexp, 4);
        }
        catch (RESyntaxException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertTrue((String)("Unable to match [" + regexp + "] in form element \"" + formElementName + "\""), (boolean)re.match(this.getDialog().getElementAttributByXPath("//input[@name='" + formElementName + "']", "value")));
    }

    public void assertFormElementEmpty(String formElementName) {
        this.assertFormElementPresent(formElementName);
        Assert.assertEquals((String)"", (String)this.getTestingEngine().getElementAttributByXPath("//input[@name='" + formElementName + "']", "value"));
    }

    public void assertTextFieldEquals(String formElementName, String expectedValue) {
        this.assertFormElementPresent(formElementName);
        Assert.assertEquals((String)expectedValue, (String)this.getTestingEngine().getTextFieldValue(formElementName));
    }

    public void assertHiddenFieldPresent(String formElementName, String expectedValue) {
        this.assertFormElementPresent(formElementName);
        Assert.assertEquals((String)expectedValue, (String)this.getTestingEngine().getHiddenFieldValue(formElementName));
    }

    public void assertCheckboxSelected(String checkBoxName) {
        this.assertCheckboxPresent(checkBoxName);
        if (!this.getTestingEngine().isCheckboxSelected(checkBoxName)) {
            Assert.fail((String)("Checkbox with name [" + checkBoxName + "] was not found selected."));
        }
    }

    public void assertCheckboxSelected(String checkBoxName, String checkBoxValue) {
        this.assertCheckboxPresent(checkBoxName, checkBoxValue);
        if (!this.getTestingEngine().isCheckboxSelected(checkBoxName, checkBoxValue)) {
            Assert.fail((String)("Checkbox with name [" + checkBoxName + "] and value [" + checkBoxValue + "] was not found selected."));
        }
    }

    public void assertCheckboxNotSelected(String checkBoxName) {
        this.assertCheckboxPresent(checkBoxName);
        if (this.getTestingEngine().isCheckboxSelected(checkBoxName)) {
            Assert.fail((String)("Checkbox with name [" + checkBoxName + "] was found selected."));
        }
    }

    public void assertCheckboxNotSelected(String checkBoxName, String checkBoxValue) {
        this.assertCheckboxPresent(checkBoxName, checkBoxValue);
        if (this.getTestingEngine().isCheckboxSelected(checkBoxName, checkBoxValue)) {
            Assert.fail((String)("Checkbox with name [" + checkBoxName + "] and value [" + checkBoxValue + "] was found selected."));
        }
    }

    public void assertRadioOptionPresent(String name, String radioOption) {
        this.assertFormElementPresent(name);
        if (!this.getTestingEngine().hasRadioOption(name, radioOption)) {
            Assert.fail((String)("Unable to find option [" + radioOption + "] in radio group [" + name + "]"));
        }
    }

    public void assertRadioOptionNotPresent(String name, String radioOption) {
        this.assertFormElementPresent(name);
        if (this.getTestingEngine().hasRadioOption(name, radioOption)) {
            Assert.fail((String)("Found option [" + radioOption + "] in radio group [" + name + "]"));
        }
    }

    public void assertRadioOptionSelected(String name, String radioOption) {
        this.assertRadioOptionPresent(name, radioOption);
        Assert.assertEquals((String)radioOption, (String)this.getTestingEngine().getSelectedRadio(name));
    }

    public void assertRadioOptionNotSelected(String name, String radioOption) {
        this.assertRadioOptionPresent(name, radioOption);
        Assert.assertFalse((String)("Radio option [" + radioOption + "] is selected."), (boolean)radioOption.equals(this.getTestingEngine().getSelectedRadio(name)));
    }

    public void assertSelectOptionsPresent(String selectName, String[] optionLabels) {
        this.assertFormElementPresent(selectName);
        for (int i = 0; i < optionLabels.length; ++i) {
            Assert.assertTrue((String)("Option [" + optionLabels[i] + "] not found in select element " + selectName), (boolean)this.getTestingEngine().hasSelectOption(selectName, optionLabels[i]));
        }
    }

    public void assertSelectOptionPresent(String selectName, String optionLabel) {
        this.assertSelectOptionsPresent(selectName, new String[]{optionLabel});
    }

    public void assertSelectOptionValuesPresent(String selectName, String[] optionValues) {
        this.assertFormElementPresent(selectName);
        for (int i = 0; i < optionValues.length; ++i) {
            Assert.assertTrue((String)("Option [" + optionValues[i] + "] not found in select element " + selectName), (boolean)this.getTestingEngine().hasSelectOptionValue(selectName, optionValues[i]));
        }
    }

    public void assertSelectOptionValuePresent(String selectName, String optionValue) {
        this.assertSelectOptionValuesPresent(selectName, new String[]{optionValue});
    }

    public void assertSelectOptionValueNotPresent(String selectName, String optionValue) {
        try {
            this.assertSelectOptionValuePresent(selectName, optionValue);
        }
        catch (AssertionFailedError e) {
            return;
        }
        Assert.fail((String)("Option value" + optionValue + " found in select element " + selectName + " when not expected."));
    }

    public void assertSelectOptionNotPresent(String selectName, String optionLabel) {
        try {
            this.assertSelectOptionPresent(selectName, optionLabel);
        }
        catch (AssertionFailedError e) {
            return;
        }
        Assert.fail((String)("Option " + optionLabel + " found in select element " + selectName + " when not expected."));
    }

    public void assertSelectOptionsEqual(String selectName, String[] expectedOptions) {
        this.assertFormElementPresent(selectName);
        this.assertArraysEqual(expectedOptions, this.getOptionsFor(selectName));
    }

    public void assertSelectOptionsNotEqual(String selectName, String[] expectedOptions) {
        this.assertFormElementPresent(selectName);
        try {
            this.assertSelectOptionsEqual(selectName, expectedOptions);
        }
        catch (AssertionFailedError e) {
            return;
        }
        Assert.fail((String)"Options not expected to be equal");
    }

    public void assertSelectOptionValuesEqual(String selectName, String[] expectedValues) {
        this.assertFormElementPresent(selectName);
        this.assertArraysEqual(expectedValues, this.getTestingEngine().getSelectOptionValues(selectName));
    }

    public void assertSelectOptionValuesNotEqual(String selectName, String[] optionValues) {
        this.assertFormElementPresent(selectName);
        try {
            this.assertSelectOptionValuesEqual(selectName, optionValues);
        }
        catch (AssertionFailedError e) {
            return;
        }
        Assert.fail((String)"Values not expected to be equal");
    }

    public void assertSelectedOptionsEqual(String selectName, String[] labels) {
        this.assertFormElementPresent(selectName);
        Assert.assertEquals((int)labels.length, (int)this.getTestingEngine().getSelectedOptions(selectName).length);
        for (int i = 0; i < labels.length; ++i) {
            Assert.assertEquals((String)labels[i], (String)this.getDialog().getSelectOptionLabelForValue(selectName, this.getTestingEngine().getSelectedOptions(selectName)[i]));
        }
    }

    public void assertSelectedOptionEquals(String selectName, String option) {
        this.assertSelectedOptionsEqual(selectName, new String[]{option});
    }

    public void assertSelectedOptionValuesEqual(String selectName, String[] values) {
        this.assertFormElementPresent(selectName);
        Assert.assertEquals((int)values.length, (int)this.getTestingEngine().getSelectedOptions(selectName).length);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((String)values[i], (String)this.getTestingEngine().getSelectedOptions(selectName)[i]);
        }
    }

    public void assertSelectedOptionValueEquals(String selectName, String value) {
        this.assertSelectedOptionValuesEqual(selectName, new String[]{value});
    }

    public void assertSelectedOptionsMatch(String selectName, String[] regexps) {
        this.assertFormElementPresent(selectName);
        Assert.assertEquals((int)regexps.length, (int)this.getTestingEngine().getSelectedOptions(selectName).length);
        for (int i = 0; i < regexps.length; ++i) {
            RE re = this.getRE(regexps[i]);
            Assert.assertTrue((String)("Unable to match [" + regexps[i] + "] in option \"" + this.getTestingEngine().getSelectedOptions(selectName)[i] + "\""), (boolean)re.match(this.getTestingEngine().getSelectedOptions(selectName)[i]));
        }
    }

    public void assertSelectedOptionMatches(String selectName, String regexp) {
        this.assertSelectedOptionsMatch(selectName, new String[]{regexp});
    }

    public void assertSubmitButtonPresent() {
        this.assertFormPresent();
        Assert.assertTrue((String)"no submit button found.", (boolean)this.getDialog().hasSubmitButton());
    }

    public void assertSubmitButtonPresent(String buttonName) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Submit Button [" + buttonName + "] not found."), (boolean)this.getTestingEngine().hasSubmitButton(buttonName));
    }

    public void assertSubmitButtonNotPresent() {
        this.assertFormPresent();
        Assert.assertFalse((String)"Submit Button found.", (boolean)this.getDialog().hasSubmitButton());
    }

    public void assertSubmitButtonNotPresent(String buttonName) {
        this.assertFormPresent();
        Assert.assertFalse((String)("Submit Button [" + buttonName + "] found."), (boolean)this.getTestingEngine().hasSubmitButton(buttonName));
    }

    public void assertSubmitButtonPresent(String buttonName, String buttonValue) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Submit Button [" + buttonName + "] with value [" + buttonValue + "] not found."), (boolean)this.getTestingEngine().hasSubmitButton(buttonName, buttonValue));
    }

    public void assertResetButtonPresent() {
        this.assertFormPresent();
        Assert.assertTrue((String)"no reset button found.", (boolean)this.getDialog().hasResetButton());
    }

    public void assertResetButtonPresent(String buttonName) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Reset Button [" + buttonName + "] not found."), (boolean)this.getTestingEngine().hasResetButton(buttonName));
    }

    public void assertResetButtonNotPresent() {
        this.assertFormPresent();
        Assert.assertFalse((String)"Reset Button found.", (boolean)this.getTestingEngine().hasResetButton());
    }

    public void assertResetButtonNotPresent(String buttonName) {
        this.assertFormPresent();
        Assert.assertFalse((String)("Reset Button [" + buttonName + "] found."), (boolean)this.getTestingEngine().hasResetButton(buttonName));
    }

    public void assertButtonPresent(String buttonId) {
        this.assertFormPresent();
        Assert.assertTrue((String)("Button [" + buttonId + "] not found."), (boolean)this.getDialog().hasButton(buttonId));
    }

    public void assertButtonPresentWithText(String text) {
        Assert.assertTrue((String)("Did not find button with text [" + text + "]."), (boolean)this.getTestingEngine().hasButtonWithText(text));
    }

    public void assertButtonNotPresentWithText(String text) {
        Assert.assertFalse((String)("Found button with text [" + text + "]."), (boolean)this.getTestingEngine().hasButtonWithText(text));
    }

    public void assertButtonNotPresent(String buttonId) {
        this.assertFormPresent();
        Assert.assertFalse((String)("Button [" + buttonId + "] found when not expected."), (boolean)this.getTestingEngine().hasButton(buttonId));
    }

    public void assertLinkPresent(String linkId) {
        Assert.assertTrue((String)("Unable to find link with id [" + linkId + "]"), (boolean)this.getTestingEngine().hasLink(linkId));
    }

    public void assertLinkNotPresent(String linkId) {
        Assert.assertTrue((String)("link with id [" + linkId + "] found in response"), (!this.getTestingEngine().hasLink(linkId) ? 1 : 0) != 0);
    }

    public void assertLinkPresentWithText(String linkText) {
        Assert.assertTrue((String)("Link with text [" + linkText + "] not found in response."), (boolean)this.getTestingEngine().hasLinkWithText(linkText, 0));
    }

    public void assertLinkNotPresentWithText(String linkText) {
        Assert.assertTrue((String)("Link with text [" + linkText + "] found in response."), (!this.getTestingEngine().hasLinkWithText(linkText, 0) ? 1 : 0) != 0);
    }

    public void assertLinkPresentWithText(String linkText, int index) {
        Assert.assertTrue((String)("Link with text [" + linkText + "] and index [" + index + "] not found in response."), (boolean)this.getDialog().hasLinkWithText(linkText, index));
    }

    public void assertLinkNotPresentWithText(String linkText, int index) {
        Assert.assertTrue((String)("Link with text [" + linkText + "] and index " + index + " found in response."), (!this.getTestingEngine().hasLinkWithText(linkText, index) ? 1 : 0) != 0);
    }

    public void assertLinkPresentWithExactText(String linkText) {
        Assert.assertTrue((String)("Link with Exact text [" + linkText + "] not found in response."), (boolean)this.getTestingEngine().hasLinkWithExactText(linkText, 0));
    }

    public void assertLinkNotPresentWithExactText(String linkText) {
        Assert.assertTrue((String)("Link with Exact text [" + linkText + "] found in response."), (!this.getTestingEngine().hasLinkWithExactText(linkText, 0) ? 1 : 0) != 0);
    }

    public void assertLinkPresentWithExactText(String linkText, int index) {
        Assert.assertTrue((String)("Link with Exact text [" + linkText + "] and index [" + index + "] not found in response."), (boolean)this.getDialog().hasLinkWithExactText(linkText, index));
    }

    public void assertLinkNotPresentWithExactText(String linkText, int index) {
        Assert.assertTrue((String)("Link with Exact text [" + linkText + "] and index " + index + " found in response."), (!this.getDialog().hasLinkWithExactText(linkText, index) ? 1 : 0) != 0);
    }

    public void assertLinkPresentWithImage(String imageFileName) {
        Assert.assertTrue((String)("Link with image file [" + imageFileName + "] not found in response."), (boolean)this.getTestingEngine().hasLinkWithImage(imageFileName, 0));
    }

    public void assertLinkNotPresentWithImage(String imageFileName) {
        Assert.assertTrue((String)("Link with image file [" + imageFileName + "] found in response."), (!this.getTestingEngine().hasLinkWithImage(imageFileName, 0) ? 1 : 0) != 0);
    }

    public void assertElementPresent(String anID) {
        Assert.assertTrue((String)("Unable to locate element with id \"" + anID + "\""), (boolean)this.getTestingEngine().hasElement(anID));
    }

    public void assertElementNotPresent(String anID) {
        Assert.assertFalse((String)("Located element with id \"" + anID + "\""), (boolean)this.getTestingEngine().hasElement(anID));
    }

    public void assertElementPresentByXPath(String xpath) {
        Assert.assertTrue((String)("Unable to locate element with xpath \"" + xpath + "\""), (boolean)this.getTestingEngine().hasElementByXPath(xpath));
    }

    public void assertElementNotPresentByXPath(String xpath) {
        Assert.assertFalse((String)("Located element with xpath \"" + xpath + "\""), (boolean)this.getTestingEngine().hasElementByXPath(xpath));
    }

    public void assertTextInElement(String elementID, String text) {
        Assert.assertTrue((String)("Unable to locate element with id \"" + elementID + "\""), (boolean)this.getTestingEngine().hasElement(elementID));
        Assert.assertTrue((String)("Unable to locate [" + text + "] in element \"" + elementID + "\""), (boolean)this.getDialog().isTextInElement(elementID, text));
    }

    public void assertTextNotInElement(String elementID, String text) {
        this.assertElementPresent(elementID);
        Assert.assertTrue((String)("Unable to locate element with id \"" + elementID + "\""), (boolean)this.getTestingEngine().hasElement(elementID));
        Assert.assertFalse((String)("Text [" + text + "] found in element [" + elementID + "] when not expected"), (boolean)this.getTestingEngine().isTextInElement(elementID, text));
    }

    public void assertMatchInElement(String elementID, String regexp) {
        Assert.assertTrue((String)("Unable to locate element with id \"" + elementID + "\""), (boolean)this.getTestingEngine().hasElement(elementID));
        Assert.assertTrue((String)("Unable to match [" + regexp + "] in element \"" + elementID + "\""), (boolean)this.getTestingEngine().isMatchInElement(elementID, regexp));
    }

    public void assertNoMatchInElement(String elementID, String regexp) {
        this.assertElementPresent(elementID);
        Assert.assertTrue((String)("Unable to locate element with id \"" + elementID + "\""), (boolean)this.getTestingEngine().hasElement(elementID));
        Assert.assertFalse((String)("Regexp [" + regexp + "] matched in element [" + elementID + "] when not expected"), (boolean)this.getDialog().isMatchInElement(elementID, regexp));
    }

    public void assertWindowPresent(String windowName) {
        Assert.assertTrue((String)("Unable to locate window [" + windowName + "]."), (boolean)this.getTestingEngine().hasWindow(windowName));
    }

    public void assertWindowPresent(int windowID) {
        Assert.assertTrue((String)("There is no window with index [" + windowID + "]."), (this.getTestingEngine().getWindowCount() > windowID ? 1 : 0) != 0);
    }

    public void assertWindowPresentWithTitle(String title) {
        Assert.assertTrue((String)("Unable to locate window with title [" + title + "]."), (boolean)this.getTestingEngine().hasWindowByTitle(title));
    }

    public void assertWindowCountEquals(int windowCount) {
        Assert.assertTrue((String)("Window count is " + this.getTestingEngine().getWindowCount() + " but " + windowCount + " was expected."), (this.getDialog().getWindowCount() == windowCount ? 1 : 0) != 0);
    }

    public void assertFramePresent(String frameNameOrId) {
        Assert.assertTrue((String)("Unable to locate frame with name or ID [" + frameNameOrId + "]."), (boolean)this.getTestingEngine().hasFrame(frameNameOrId));
    }

    public void assertCookiePresent(String cookieName) {
        List cookies = this.getTestingEngine().getCookies();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            if (!((Cookie)i.next()).getName().equals(cookieName)) continue;
            return;
        }
        Assert.fail((String)("Could not find Cookie with name [" + cookieName + "]"));
    }

    public void assertCookieValueEquals(String cookieName, String expectedValue) {
        this.assertCookiePresent(cookieName);
        List cookies = this.getTestingEngine().getCookies();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            Cookie c = (Cookie)i.next();
            if (!c.getName().equals(cookieName)) continue;
            Assert.assertEquals((String)expectedValue, (String)c.getValue());
            return;
        }
        Assert.fail((String)"Should not be reached");
    }

    public void assertCookieValueMatch(String cookieName, String regexp) {
        this.assertCookiePresent(cookieName);
        RE re = null;
        try {
            re = new RE(regexp, 4);
        }
        catch (RESyntaxException e) {
            Assert.fail((String)e.toString());
        }
        List cookies = this.getTestingEngine().getCookies();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            Cookie c = (Cookie)i.next();
            if (!c.getName().equals(cookieName)) continue;
            Assert.assertTrue((String)("Unable to match [" + regexp + "] in cookie \"" + cookieName + "\""), (boolean)re.match(c.getValue()));
            return;
        }
        Assert.fail((String)"Should not be reached");
    }

    public String getFormElementValue(String formElementName) {
        this.assertFormPresent();
        this.assertFormElementPresent(formElementName);
        return this.getTestingEngine().getElementAttributByXPath("//input[@name='" + formElementName + "']", "value");
    }

    public void setWorkingForm(int index) {
        this.getTestingEngine().setWorkingForm(index);
    }

    public void setWorkingForm(String nameOrId) {
        this.getTestingEngine().setWorkingForm(nameOrId, 0);
    }

    public void setWorkingForm(String nameOrId, int index) {
        this.getTestingEngine().setWorkingForm(nameOrId, index);
    }

    public void setTextField(String inputName, String value) {
        this.assertFormPresent();
        this.assertFormElementPresent(inputName);
        this.getTestingEngine().setTextField(inputName, value);
    }

    public void checkCheckbox(String checkBoxName) {
        this.assertCheckboxPresent(checkBoxName);
        this.getTestingEngine().checkCheckbox(checkBoxName);
    }

    public void checkCheckbox(String checkBoxName, String value) {
        this.assertCheckboxPresent(checkBoxName);
        this.getTestingEngine().checkCheckbox(checkBoxName, value);
    }

    public void uncheckCheckbox(String checkBoxName) {
        this.assertFormElementPresent(checkBoxName);
        this.getTestingEngine().uncheckCheckbox(checkBoxName);
    }

    public void uncheckCheckbox(String checkBoxName, String value) {
        this.assertFormElementPresent(checkBoxName);
        this.getTestingEngine().uncheckCheckbox(checkBoxName, value);
    }

    public void selectOptions(String selectName, String[] labels) {
        this.assertSelectOptionsPresent(selectName, labels);
        this.selectOptionsByLabel(selectName, labels);
    }

    public void selectOption(String selectName, String label) {
        this.selectOptions(selectName, new String[]{label});
    }

    public void selectOptionsByValues(String selectName, String[] values) {
        this.assertSelectOptionValuesPresent(selectName, values);
        this.getTestingEngine().selectOptions(selectName, values);
    }

    public void selectOptionByValue(String selectName, String value) {
        this.selectOptionsByValues(selectName, new String[]{value});
    }

    public void submit() {
        this.assertSubmitButtonPresent();
        this.getTestingEngine().submit();
    }

    public void submit(String buttonName) {
        this.assertSubmitButtonPresent(buttonName);
        this.getTestingEngine().submit(buttonName);
    }

    public void submit(String buttonName, String buttonValue) {
        this.assertSubmitButtonPresent(buttonName, buttonValue);
        this.getTestingEngine().submit(buttonName, buttonValue);
    }

    public void reset() {
        this.assertResetButtonPresent();
        this.getTestingEngine().reset();
    }

    public void clickLinkWithText(String linkText) {
        this.assertLinkPresentWithText(linkText);
        this.getTestingEngine().clickLinkWithText(linkText, 0);
    }

    public void clickLinkWithText(String linkText, int index) {
        this.assertLinkPresentWithText(linkText, index);
        this.getTestingEngine().clickLinkWithText(linkText, index);
    }

    public void clickLinkWithExactText(String linkText) {
        this.assertLinkPresentWithExactText(linkText);
        this.getTestingEngine().clickLinkWithExactText(linkText, 0);
    }

    public void clickLinkWithExactText(String linkText, int index) {
        this.assertLinkPresentWithExactText(linkText, index);
        this.getTestingEngine().clickLinkWithExactText(linkText, index);
    }

    public void clickButton(String buttonId) {
        this.assertButtonPresent(buttonId);
        this.getTestingEngine().clickButton(buttonId);
    }

    public void clickButtonWithText(String buttonValueText) {
        this.assertButtonPresentWithText(buttonValueText);
        this.getTestingEngine().clickButtonWithText(buttonValueText);
    }

    public void clickLinkWithImage(String imageFileName) {
        this.assertLinkPresentWithImage(imageFileName);
        this.getTestingEngine().clickLinkWithImage(imageFileName, 0);
    }

    public void clickLink(String linkId) {
        this.assertLinkPresent(linkId);
        this.getTestingEngine().clickLink(linkId);
    }

    public void clickRadioOption(String radioGroup, String radioOption) {
        this.assertRadioOptionPresent(radioGroup, radioOption);
        this.getTestingEngine().clickRadioOption(radioGroup, radioOption);
    }

    public void clickElementByXPath(String xpath) {
        this.assertElementPresentByXPath(xpath);
        this.getTestingEngine().clickElementByXPath(xpath);
    }

    public String getElementAttributByXPath(String xpath, String attribut) {
        this.assertElementPresentByXPath(xpath);
        return this.getTestingEngine().getElementAttributByXPath(xpath, attribut);
    }

    public String getElementTextByXPath(String xpath) {
        this.assertElementPresentByXPath(xpath);
        return this.getTestingEngine().getElementTextByXPath(xpath);
    }

    public void gotoWindow(String windowName) {
        this.assertWindowPresent(windowName);
        this.getTestingEngine().gotoWindow(windowName);
    }

    public void gotoWindow(int windowID) {
        this.assertWindowPresent(windowID);
        this.getTestingEngine().gotoWindow(windowID);
    }

    public void gotoRootWindow() {
        this.getTestingEngine().gotoRootWindow();
    }

    public void gotoWindowByTitle(String title) {
        this.assertWindowPresentWithTitle(title);
        this.getTestingEngine().gotoWindowByTitle(title);
    }

    public void gotoFrame(String frameNameOrId) {
        this.getTestingEngine().gotoFrame(frameNameOrId);
    }

    public void gotoPage(String url) throws TestingEngineResponseException {
        try {
            this.getTestingEngine().gotoPage(this.createUrl(url, this.getTestContext().getBaseUrl()));
        }
        catch (MalformedURLException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    public void dumpCookies() {
        List cookies = this.getTestingEngine().getCookies();
        Iterator i = cookies.iterator();
        while (i.hasNext()) {
            Cookie c = (Cookie)i.next();
            System.out.println("Name=" + c.getName() + "; Value=" + c.getValue() + "; Domain=" + c.getDomain() + "; Comment=" + c.getComment() + "; MaxAge=" + c.getMaxAge() + "; Path=" + c.getPath() + "; Version=" + c.getVersion());
        }
    }

    public String getPageSource() {
        return this.getTestingEngine().getPageSource();
    }

    public String getServeurResponse() {
        return this.getTestingEngine().getServerResponse();
    }

    public void saveAs(File f) {
        InputStream in = this.getTestingEngine().getInputStream();
        int c = 0;
        try {
            f.createNewFile();
            FileOutputStream out = new FileOutputStream(f);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error when writing to file", e);
        }
    }

    public void assertDownloadedFileEquals(URL expected) {
        try {
            File tmp = File.createTempFile("jwebunit", null);
            tmp.deleteOnExit();
            this.saveAs(tmp);
            Assert.assertTrue((String)"Files are not binary equals.", (boolean)this.areFilesEqual(expected, tmp.toURL()));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    public void dumpHtml() {
        this.dumpHtml(System.out);
    }

    public void dumpHtml(PrintStream stream) {
        stream.println(this.getTestingEngine().getPageSource());
    }

    public void dumpTable(String tableNameOrId) {
        this.dumpTable(tableNameOrId, System.out);
    }

    public void dumpTable(String tableNameOrId, PrintStream stream) {
    }

    public void setScriptingEnabled(boolean value) {
        this.getTestingEngine().setScriptingEnabled(value);
    }

    public void setTestingEngineKey(String testingEngineKey) {
        this.testingEngineKey = testingEngineKey;
        this.dialog = null;
    }

    public String getTestingEngineKey() {
        if (this.testingEngineKey == null) {
            String key = TestingEngineRegistry.getFirstAvailable();
            if (key != null) {
                this.setTestingEngineKey(key);
            } else {
                throw new RuntimeException("TestingEngineRegistry contains no dialog. Check you put at least one plugin in the classpath.");
            }
        }
        return this.testingEngineKey;
    }

    private RE getRE(String regexp) {
        RE re = null;
        try {
            re = new RE(regexp, 4);
        }
        catch (RESyntaxException e) {
            Assert.fail((String)e.toString());
        }
        return re;
    }

    private String[] getOptionsFor(String selectName) {
        String[] values = this.getTestingEngine().getSelectOptionValues(selectName);
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.getTestingEngine().getSelectOptionLabelForValue(selectName, values[i]);
        }
        return result;
    }

    private void selectOptionsByLabel(String selectName, String[] labels) {
        String[] values = new String[labels.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getTestingEngine().getSelectOptionValueForLabel(selectName, labels[i]);
        }
        this.getTestingEngine().selectOptions(selectName, values);
    }

    private void assertArraysEqual(String[] exptected, String[] returned) {
        Assert.assertEquals((String)"Arrays not same length", (int)exptected.length, (int)returned.length);
        for (int i = 0; i < returned.length; ++i) {
            Assert.assertEquals((String)("Elements " + i + "not equal"), (String)exptected[i], (String)returned[i]);
        }
    }

    public void setFormElement(String formElementName, String value) {
        this.assertFormPresent();
        this.assertFormElementPresent(formElementName);
        this.getTestingEngine().setTextField(formElementName, value);
    }

    public void setExpectedJavaScriptAlert(String message) {
        try {
            this.getTestingEngine().setExpectedJavaScriptAlert(new JavascriptAlert[]{new JavascriptAlert(message)});
        }
        catch (ExpectedJavascriptAlertException e) {
            Assert.fail((String)("You previously tell that alert with message [" + e.getAlertMessage() + "] was expected, but nothing appeared."));
        }
    }

    public void setExpectedJavaScriptAlert(String[] messages) {
        JavascriptAlert[] alerts = new JavascriptAlert[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            alerts[i] = new JavascriptAlert(messages[i]);
        }
        try {
            this.getTestingEngine().setExpectedJavaScriptAlert(alerts);
        }
        catch (ExpectedJavascriptAlertException e) {
            Assert.fail((String)("You previously tell that alert with message [" + e.getAlertMessage() + "] was expected, but nothing appeared."));
        }
    }

    public void setExpectedJavaScriptConfirm(String message, boolean action) {
        try {
            this.getTestingEngine().setExpectedJavaScriptConfirm(new JavascriptConfirm[]{new JavascriptConfirm(message, action)});
        }
        catch (ExpectedJavascriptConfirmException e) {
            Assert.fail((String)("You previously tell that confirm with message [" + e.getConfirmMessage() + "] was expected, but nothing appeared."));
        }
    }

    public void setExpectedJavaScriptConfirm(String[] messages, boolean[] actions) {
        Assert.assertEquals((String)"You should give the same number of messages and actions", (int)messages.length, (int)actions.length);
        JavascriptConfirm[] confirms = new JavascriptConfirm[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            confirms[i] = new JavascriptConfirm(messages[i], actions[i]);
        }
        try {
            this.getTestingEngine().setExpectedJavaScriptConfirm(confirms);
        }
        catch (ExpectedJavascriptConfirmException e) {
            Assert.fail((String)("You previously tell that confirm with message [" + e.getConfirmMessage() + "] was expected, but nothing appeared."));
        }
    }

    public void setExpectedJavaScriptPrompt(String message, String input) {
        try {
            this.getTestingEngine().setExpectedJavaScriptPrompt(new JavascriptPrompt[]{new JavascriptPrompt(message, input)});
        }
        catch (ExpectedJavascriptPromptException e) {
            Assert.fail((String)("You previously tell that prompt with message [" + e.getPromptMessage() + "] was expected, but nothing appeared."));
        }
    }

    public void setExpectedJavaScriptPrompt(String[] messages, String[] inputs) {
        Assert.assertEquals((String)"You should give the same number of messages and inputs", (int)messages.length, (int)inputs.length);
        JavascriptPrompt[] prompts = new JavascriptPrompt[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            prompts[i] = new JavascriptPrompt(messages[i], inputs[i]);
        }
        try {
            this.getTestingEngine().setExpectedJavaScriptPrompt(prompts);
        }
        catch (ExpectedJavascriptPromptException e) {
            Assert.fail((String)("You previously tell that prompt with message [" + e.getPromptMessage() + "] was expected, but nothing appeared."));
        }
    }

    public void assertImagePresent(String imageSrc, String imageAlt) {
        String xpath = "//img[@src=\"" + imageSrc + "\"";
        if (imageAlt != null) {
            xpath = xpath + " and @alt=\"" + imageAlt + "\"";
        }
        xpath = xpath + "]";
        this.assertElementPresentByXPath(xpath);
    }

    public void assertImageValid(String imageSrc, String imageAlt) {
        this.validateImage(imageSrc, imageAlt, null);
    }

    public void assertImageValidAndStore(String imageSrc, String imageAlt, File out) {
        this.validateImage(imageSrc, imageAlt, out);
    }

    public Image getImage(String imageSrc, String imageAlt) {
        return this.validateImage(imageSrc, imageAlt, null);
    }

    private Image validateImage(String imageSrc, String imageAlt, File out) {
        this.assertImagePresent(imageSrc, imageAlt);
        URL imageUrl = null;
        try {
            imageUrl = this.createUrl(imageSrc, this.getTestingEngine().getPageURL());
        }
        catch (MalformedURLException e1) {
            Assert.fail((String)e1.getLocalizedMessage());
        }
        try {
            InputStream imgStream = this.getTestingEngine().getInputStream(imageUrl);
            BufferedImage img = ImageIO.read(imgStream);
            if (img == null) {
                Assert.fail((String)("Could not load image from " + imageUrl));
            }
            if (out != null) {
                ImageIO.write((RenderedImage)img, "png", out);
            }
            return img;
        }
        catch (IOException e) {
            Assert.fail((String)("Could not load or save image from " + imageUrl));
        }
        catch (TestingEngineResponseException e) {
            Assert.fail((String)("The server returns the code " + e.getHttpStatusCode()));
        }
        throw new IllegalStateException();
    }

    protected boolean areFilesEqual(URL f1, URL f2) throws IOException {
        int b2;
        int b1;
        InputStream i1 = f1.openStream();
        InputStream i2 = f2.openStream();
        if (f1 == null) {
            throw new IOException(f1.toString() + " can't be opened.");
        }
        if (f2 == null) {
            throw new IOException(f2.toString() + " can't be opened.");
        }
        while ((b1 = i1.read()) == (b2 = i2.read()) && b1 != -1 && b2 != -1) {
        }
        i1.close();
        i2.close();
        return b1 == -1 && b2 == -1;
    }
}

