/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.html;

import java.util.ArrayList;
import junit.framework.Assert;
import net.sourceforge.jwebunit.html.Row;

public class Table {
    private ArrayList rows = new ArrayList();

    public Table() {
    }

    public Table(Object[][] values) {
        this.appendRows(values);
    }

    public void appendRows(Object[][] newExpectedValues) {
        for (int i = 0; i < newExpectedValues.length; ++i) {
            this.rows.add(new Row(newExpectedValues[i]));
        }
    }

    public void appendRows(Table table) {
        this.rows.addAll(table.getRows());
    }

    public void appendRow(Row row) {
        this.rows.add(row);
    }

    public int getRowCount() {
        return this.getRows().size();
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public boolean hasText(String text) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Row row = (Row)this.getRows().get(i);
            if (!row.hasText(text)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatch(String regexp) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Row row = (Row)this.getRows().get(i);
            if (!row.hasMatch(regexp)) continue;
            return true;
        }
        return false;
    }

    public void assertEquals(Table t) {
        Assert.assertTrue((String)"Row count are not equal", (this.getRows().size() == t.getRows().size() ? 1 : 0) != 0);
        for (int i = 0; i < this.getRows().size(); ++i) {
            ((Row)this.getRows().get(i)).assertEquals((Row)t.getRows().get(i));
        }
    }

    public void assertSubTableEquals(int startRow, Table t) {
        Table sub = new Table();
        if (startRow + t.getRowCount() > this.getRowCount()) {
            Assert.fail((String)("Expected rows [" + t.getRowCount() + "] larger than actual rows in range being compared" + " [" + (this.getRowCount() - startRow) + "]."));
        }
        for (int i = startRow; i < startRow + t.getRowCount(); ++i) {
            sub.appendRow((Row)this.getRows().get(i));
        }
        sub.assertEquals(t);
    }

    public void assertMatch(Table t) {
        Assert.assertTrue((String)"Row count are not equal", (this.getRows().size() == t.getRows().size() ? 1 : 0) != 0);
        for (int i = 0; i < this.getRows().size(); ++i) {
            ((Row)this.getRows().get(i)).assertMatch((Row)t.getRows().get(i));
        }
    }

    public void assertSubTableMatch(int startRow, Table t) {
        Table sub = new Table();
        if (startRow + t.getRowCount() > this.getRowCount()) {
            Assert.fail((String)("Expected rows [" + t.getRowCount() + "] larger than actual rows in range being compared" + " [" + (this.getRowCount() - startRow) + "]."));
        }
        for (int i = startRow; i < startRow + t.getRowCount(); ++i) {
            sub.appendRow((Row)this.getRows().get(i));
        }
        sub.assertMatch(t);
    }
}

