/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.worker;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import com.gargoylesoftware.htmlunit.javascript.host.worker.Worker;
import com.gargoylesoftware.htmlunit.javascript.host.worker.WorkerJob;
import java.io.IOException;
import java.net.URL;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClasses(value={@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF}), @JsxClass(className="WorkerGlobalScope", value={SupportedBrowser.IE})})
public class DedicatedWorkerGlobalScope
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(DedicatedWorkerGlobalScope.class);
    private final Window owningWindow_;
    private final String origin_;
    private final Worker worker_;

    public DedicatedWorkerGlobalScope() {
        this.owningWindow_ = null;
        this.origin_ = null;
        this.worker_ = null;
    }

    DedicatedWorkerGlobalScope(Window owningWindow, Context context, BrowserVersion browserVersion, Worker worker) throws Exception {
        context.initStandardObjects((ScriptableObject)this);
        ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(DedicatedWorkerGlobalScope.class, browserVersion);
        HtmlUnitScriptable prototype = JavaScriptEngine.configureClass(config, null, browserVersion);
        this.setPrototype((Scriptable)prototype);
        this.owningWindow_ = owningWindow;
        URL currentURL = owningWindow.getWebWindow().getEnclosedPage().getUrl();
        this.origin_ = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
        this.worker_ = worker;
    }

    @JsxGetter
    public Object getSelf() {
        return this;
    }

    @JsxFunction
    public void postMessage(Object message) {
        final MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, this.origin_, "", this.owningWindow_, null);
        event.setParentScope((Scriptable)this.owningWindow_);
        event.setPrototype(this.owningWindow_.getPrototype(event.getClass()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[DedicatedWorker] postMessage: {}" + message));
        }
        JavaScriptEngine jsEngine = (JavaScriptEngine)this.owningWindow_.getWebWindow().getWebClient().getJavaScriptEngine();
        ContextAction<Object> action = new ContextAction<Object>(){

            public Object run(Context cx) {
                DedicatedWorkerGlobalScope.this.worker_.getEventListenersContainer().executeCapturingListeners(event, null);
                Object[] args = new Object[]{event};
                DedicatedWorkerGlobalScope.this.worker_.getEventListenersContainer().executeBubblingListeners(event, args);
                return null;
            }
        };
        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
        WorkerJob job = new WorkerJob(cf, action, "postMessage: " + Context.toString((Object)message));
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
    }

    void messagePosted(Object message) {
        final MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, this.origin_, "", this.owningWindow_, null);
        event.setParentScope((Scriptable)this.owningWindow_);
        event.setPrototype(this.owningWindow_.getPrototype(event.getClass()));
        JavaScriptEngine jsEngine = (JavaScriptEngine)this.owningWindow_.getWebWindow().getWebClient().getJavaScriptEngine();
        ContextAction<Object> action = new ContextAction<Object>(){

            public Object run(Context cx) {
                return DedicatedWorkerGlobalScope.this.executeEvent(cx, event);
            }
        };
        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
        WorkerJob job = new WorkerJob(cf, action, "messagePosted: " + Context.toString((Object)message));
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
    }

    private Object executeEvent(Context cx, MessageEvent event) {
        Object handler = this.get("onmessage", (Scriptable)this);
        if (handler != null && handler instanceof Function) {
            Function handlerFunction = (Function)handler;
            Object[] args = new Object[]{event};
            handlerFunction.call(cx, (Scriptable)this, (Scriptable)this, args);
        }
        return null;
    }

    @JsxFunction
    public static void importScripts(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        DedicatedWorkerGlobalScope scope = (DedicatedWorkerGlobalScope)thisObj;
        for (Object arg : args) {
            String url = Context.toString((Object)arg);
            scope.loadAndExecute(url, cx);
        }
    }

    void loadAndExecute(String url, Context context) throws IOException {
        final HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        final URL fullUrl = page.getFullyQualifiedUrl(url);
        WebClient webClient = this.owningWindow_.getWebWindow().getWebClient();
        WebRequest webRequest = new WebRequest(fullUrl);
        WebResponse response = webClient.loadWebResponse(webRequest);
        final String scriptCode = response.getContentAsString();
        final JavaScriptEngine javaScriptEngine = (JavaScriptEngine)webClient.getJavaScriptEngine();
        final DedicatedWorkerGlobalScope thisScope = this;
        ContextAction<Object> action = new ContextAction<Object>(){

            public Object run(Context cx) {
                Script script = javaScriptEngine.compile(page, (Scriptable)thisScope, scriptCode, fullUrl.toExternalForm(), 1);
                return javaScriptEngine.execute(page, (Scriptable)thisScope, script);
            }
        };
        HtmlUnitContextFactory cf = javaScriptEngine.getContextFactory();
        if (context != null) {
            action.run(context);
        } else {
            WorkerJob job = new WorkerJob(cf, action, "loadAndExecute " + url);
            this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
        }
    }
}

