/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.host.css.BrowserConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StyleAttributes {
    private static final Map<String, Definition> styles_ = new HashMap<String, Definition>();

    private StyleAttributes() {
    }

    public static Definition getDefinition(String propertyName, BrowserVersion browserVersion) {
        if (browserVersion == null) {
            return null;
        }
        Definition definition = styles_.get(propertyName);
        if (definition == null) {
            return null;
        }
        if (!definition.isAvailable(browserVersion, false)) {
            return null;
        }
        return definition;
    }

    public static List<Definition> getDefinitions(BrowserVersion browserVersion) {
        ArrayList<Definition> list = new ArrayList<Definition>();
        for (Definition definition : Definition.values()) {
            if (!definition.isAvailable(browserVersion, true)) continue;
            list.add(definition);
        }
        return list;
    }

    static {
        for (Definition definition : Definition.values()) {
            styles_.put(definition.getPropertyName(), definition);
        }
    }

    public static enum Definition {
        ACCELERATOR("accelerator", "accelerator", BrowserConfiguration.ie("undefined")),
        ALIGN_CONTENT("alignContent", "align-content", BrowserConfiguration.ie("stretch"), BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        ALIGN_CONTENT_("align-content", "align-content", BrowserConfiguration.ff("normal")),
        ALIGN_ITEMS("alignItems", "align-items", BrowserConfiguration.ff("normal"), BrowserConfiguration.ie("stretch"), BrowserConfiguration.chrome("normal")),
        ALIGN_ITEMS_("align-items", "align-items", BrowserConfiguration.ff("normal")),
        ALIGN_SELF("alignSelf", "align-self", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto")),
        ALIGN_SELF_("align-self", "align-self", BrowserConfiguration.ff("auto")),
        ALIGNMENT_BASELINE("alignmentBaseline", "alignment-baseline", BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto")),
        ALL("all", "all", BrowserConfiguration.ff(""), BrowserConfiguration.chrome("")),
        ANIMATION("animation", "animation", BrowserConfiguration.ff(""), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("none 0s ease 0s 1 normal none running")),
        ANIMATION_DELAY("animationDelay", "animation-delay", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie("0s"), BrowserConfiguration.chrome("0s")),
        ANIMATION_DELAY_("animation-delay", "animation-delay", BrowserConfiguration.ff("0s")),
        ANIMATION_DIRECTION("animationDirection", "animation-direction", BrowserConfiguration.ff("normal"), BrowserConfiguration.ie("normal"), BrowserConfiguration.chrome("normal")),
        ANIMATION_DIRECTION_("animation-direction", "animation-direction", BrowserConfiguration.ff("normal")),
        ANIMATION_DURATION("animationDuration", "animation-duration", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie("0s"), BrowserConfiguration.chrome("0s")),
        ANIMATION_DURATION_("animation-duration", "animation-duration", BrowserConfiguration.ff("0s")),
        ANIMATION_FILL_MODE("animationFillMode", "animation-fill-mode", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        ANIMATION_FILL_MODE_("animation-fill-mode", "animation-fill-mode", BrowserConfiguration.ff("none")),
        ANIMATION_ITERATION_COUNT("animationIterationCount", "animation-iteration-count", BrowserConfiguration.ff("1"), BrowserConfiguration.ie("1"), BrowserConfiguration.chrome("1")),
        ANIMATION_ITERATION_COUNT_("animation-iteration-count", "animation-iteration-count", BrowserConfiguration.ff("1")),
        ANIMATION_NAME("animationName", "animation-name", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        ANIMATION_NAME_("animation-name", "animation-name", BrowserConfiguration.ff("none")),
        ANIMATION_PLAY_STATE("animationPlayState", "animation-play-state", BrowserConfiguration.ff("running"), BrowserConfiguration.ie("running"), BrowserConfiguration.chrome("running")),
        ANIMATION_PLAY_STATE_("animation-play-state", "animation-play-state", BrowserConfiguration.ff("running")),
        ANIMATION_TIMING_FUNCTION("animationTimingFunction", "animation-timing-function", BrowserConfiguration.ff("ease"), BrowserConfiguration.ie("cubic-bezier(0.25, 0.1, 0.25, 1)"), BrowserConfiguration.chrome("ease")),
        ANIMATION_TIMING_FUNCTION_("animation-timing-function", "animation-timing-function", BrowserConfiguration.ff("ease")),
        AZIMUTH("azimuth", "azimuth", new BrowserConfiguration[0]),
        BACKFACE_VISIBILITY("backfaceVisibility", "backface-visibility", BrowserConfiguration.ff("visible"), BrowserConfiguration.ie("visible"), BrowserConfiguration.chrome("visible")),
        BACKFACE_VISIBILITY_("backface-visibility", "backface-visibility", BrowserConfiguration.ff("visible")),
        BACKGROUND("background", "background", BrowserConfiguration.ff(""), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("rgba(0, 0, 0, 0) none repeat scroll 0% 0% / auto padding-box border-box")),
        BACKGROUND_ATTACHMENT("backgroundAttachment", "background-attachment", BrowserConfiguration.chrome("scroll"), BrowserConfiguration.ff("scroll"), BrowserConfiguration.ie("scroll")),
        BACKGROUND_ATTACHMENT_("background-attachment", "background-attachment", BrowserConfiguration.ff("scroll")),
        BACKGROUND_BLEND_MODE("backgroundBlendMode", "background-blend-mode", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        BACKGROUND_BLEND_MODE_("background-blend-mode", "background-blend-mode", BrowserConfiguration.ff("normal")),
        BACKGROUND_CLIP("backgroundClip", "background-clip", BrowserConfiguration.ff("border-box"), BrowserConfiguration.ie("border-box"), BrowserConfiguration.chrome("border-box")),
        BACKGROUND_CLIP_("background-clip", "background-clip", BrowserConfiguration.ff("border-box")),
        BACKGROUND_COLOR("backgroundColor", "background-color", BrowserConfiguration.chrome("rgba(0, 0, 0, 0)"), BrowserConfiguration.ffBelow60("transparent"), BrowserConfiguration.ff60up("rgba(0, 0, 0, 0)"), BrowserConfiguration.ie("transparent")),
        BACKGROUND_COLOR_("background-color", "background-color", BrowserConfiguration.ffBelow60("transparent"), BrowserConfiguration.ff60up("rgba(0, 0, 0, 0)")),
        BACKGROUND_IMAGE("backgroundImage", "background-image", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        BACKGROUND_IMAGE_("background-image", "background-image", BrowserConfiguration.ff("none")),
        BACKGROUND_ORIGIN("backgroundOrigin", "background-origin", BrowserConfiguration.ff("padding-box"), BrowserConfiguration.ie("padding-box"), BrowserConfiguration.chrome("padding-box")),
        BACKGROUND_ORIGIN_("background-origin", "background-origin", BrowserConfiguration.ff("padding-box")),
        BACKGROUND_POSITION("backgroundPosition", "background-position", BrowserConfiguration.chrome("0% 0%"), BrowserConfiguration.ff("0% 0%"), BrowserConfiguration.ie("0% 0%")),
        BACKGROUND_POSITION_("background-position", "background-position", BrowserConfiguration.ff("0% 0%")),
        BACKGROUND_POSITION_X("backgroundPositionX", "background-position-x", BrowserConfiguration.ie("undefined"), BrowserConfiguration.chrome("0%"), BrowserConfiguration.ff("0%")),
        BACKGROUND_POSITION_X_("background-position-x", "background-position-x", BrowserConfiguration.ff("0%")),
        BACKGROUND_POSITION_Y("backgroundPositionY", "background-position-y", BrowserConfiguration.ie("undefined"), BrowserConfiguration.chrome("0%"), BrowserConfiguration.ff("0%")),
        BACKGROUND_POSITION_Y_("background-position-y", "background-position-y", BrowserConfiguration.ff("0%")),
        BACKGROUND_REPEAT("backgroundRepeat", "background-repeat", BrowserConfiguration.chrome("repeat"), BrowserConfiguration.ff("repeat"), BrowserConfiguration.ie("repeat")),
        BACKGROUND_REPEAT_("background-repeat", "background-repeat", BrowserConfiguration.ff("repeat")),
        BACKGROUND_REPEAT_X("backgroundRepeatX", "background-repeat-x", BrowserConfiguration.chrome("")),
        BACKGROUND_REPEAT_Y("backgroundRepeatY", "background-repeat-y", BrowserConfiguration.chrome("")),
        BACKGROUND_SIZE("backgroundSize", "background-size", BrowserConfiguration.ff("auto auto"), BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto")),
        BACKGROUND_SIZE_("background-size", "background-size", BrowserConfiguration.ff("auto auto")),
        BASELINE_SHIFT("baselineShift", "baseline-shift", BrowserConfiguration.ie("baseline"), BrowserConfiguration.chrome("0px")),
        BEHAVIOR("behavior", "behavior", new BrowserConfiguration[0]),
        BLOCK_SIZE("blockSize", "block-size", BrowserConfiguration.ff(""), BrowserConfiguration.chrome("322px")),
        BLOCK_SIZE_("block-size", "block-size", BrowserConfiguration.ff("")),
        BORDER("border", "border", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_BLOCK_END("borderBlockEnd", "border-block-end", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff("")),
        BORDER_BLOCK_END_("border-block-end", "border-block-end", BrowserConfiguration.ff("")),
        BORDER_BLOCK_END_COLOR("borderBlockEndColor", "border-block-end-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("")),
        BORDER_BLOCK_END_COLOR_("border-block-end-color", "border-block-end-color", BrowserConfiguration.ff("")),
        BORDER_BLOCK_END_STYLE("borderBlockEndStyle", "border-block-end-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("")),
        BORDER_BLOCK_END_STYLE_("border-block-end-style", "border-block-end-style", BrowserConfiguration.ff("")),
        BORDER_BLOCK_END_WIDTH("borderBlockEndWidth", "border-block-end-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        BORDER_BLOCK_END_WIDTH_("border-block-end-width", "border-block-end-width", BrowserConfiguration.ff("")),
        BORDER_BLOCK_START("borderBlockStart", "border-block-start", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff("")),
        BORDER_BLOCK_START_("border-block-start", "border-block-start", BrowserConfiguration.ff("")),
        BORDER_BLOCK_START_COLOR("borderBlockStartColor", "border-block-start-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("")),
        BORDER_BLOCK_START_COLOR_("border-block-start-color", "border-block-start-color", BrowserConfiguration.ff("")),
        BORDER_BLOCK_START_STYLE("borderBlockStartStyle", "border-block-start-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("")),
        BORDER_BLOCK_START_STYLE_("border-block-start-style", "border-block-start-style", BrowserConfiguration.ff("")),
        BORDER_BLOCK_START_WIDTH("borderBlockStartWidth", "border-block-start-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        BORDER_BLOCK_START_WIDTH_("border-block-start-width", "border-block-start-width", BrowserConfiguration.ff("")),
        BORDER_BOTTOM("borderBottom", "border-bottom", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_BOTTOM_("border-bottom", "border-bottom", BrowserConfiguration.ff("")),
        BORDER_BOTTOM_COLOR("borderBottomColor", "border-bottom-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie("rgb(0, 0, 0)")),
        BORDER_BOTTOM_COLOR_("border-bottom-color", "border-bottom-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        BORDER_BOTTOM_LEFT_RADIUS("borderBottomLeftRadius", "border-bottom-left-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px"), BrowserConfiguration.chrome("0px")),
        BORDER_BOTTOM_LEFT_RADIUS_("border-bottom-left-radius", "border-bottom-left-radius", BrowserConfiguration.ff("0px")),
        BORDER_BOTTOM_RIGHT_RADIUS("borderBottomRightRadius", "border-bottom-right-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px"), BrowserConfiguration.chrome("0px")),
        BORDER_BOTTOM_RIGHT_RADIUS_("border-bottom-right-radius", "border-bottom-right-radius", BrowserConfiguration.ff("0px")),
        BORDER_BOTTOM_STYLE("borderBottomStyle", "border-bottom-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        BORDER_BOTTOM_STYLE_("border-bottom-style", "border-bottom-style", BrowserConfiguration.ff("none")),
        BORDER_BOTTOM_WIDTH("borderBottomWidth", "border-bottom-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px")),
        BORDER_BOTTOM_WIDTH_("border-bottom-width", "border-bottom-width", BrowserConfiguration.ff("0px")),
        BORDER_COLLAPSE("borderCollapse", "border-collapse", BrowserConfiguration.chrome("separate"), BrowserConfiguration.ff("separate"), BrowserConfiguration.ie("separate")),
        BORDER_COLLAPSE_("border-collapse", "border-collapse", BrowserConfiguration.ff("separate")),
        BORDER_COLOR("borderColor", "border-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_COLOR_("border-color", "border-color", BrowserConfiguration.ff("")),
        BORDER_IMAGE("borderImage", "border-image", BrowserConfiguration.ff(""), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("none")),
        BORDER_IMAGE_("border-image", "border-image", BrowserConfiguration.ff("")),
        BORDER_IMAGE_OUTSET("borderImageOutset", "border-image-outset", BrowserConfiguration.ie("0"), BrowserConfiguration.chrome("0px"), BrowserConfiguration.ffBelow60("0 0 0 0"), BrowserConfiguration.ff60up("0")),
        BORDER_IMAGE_OUTSET_("border-image-outset", "border-image-outset", BrowserConfiguration.ffBelow60("0 0 0 0"), BrowserConfiguration.ff60up("0")),
        BORDER_IMAGE_REPEAT("borderImageRepeat", "border-image-repeat", BrowserConfiguration.ff("stretch stretch"), BrowserConfiguration.ie("stretch"), BrowserConfiguration.chrome("stretch")),
        BORDER_IMAGE_REPEAT_("border-image-repeat", "border-image-repeat", BrowserConfiguration.ff("stretch stretch")),
        BORDER_IMAGE_SLICE("borderImageSlice", "border-image-slice", BrowserConfiguration.ie("100%"), BrowserConfiguration.chrome("100%"), BrowserConfiguration.ffBelow60("100% 100% 100% 100%"), BrowserConfiguration.ff60up("100%")),
        BORDER_IMAGE_SLICE_("border-image-slice", "border-image-slice", BrowserConfiguration.ffBelow60("100% 100% 100% 100%"), BrowserConfiguration.ff60up("100%")),
        BORDER_IMAGE_SOURCE("borderImageSource", "border-image-source", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        BORDER_IMAGE_SOURCE_("border-image-source", "border-image-source", BrowserConfiguration.ff("none")),
        BORDER_IMAGE_WIDTH("borderImageWidth", "border-image-width", BrowserConfiguration.ie("1"), BrowserConfiguration.chrome("1"), BrowserConfiguration.ffBelow60("1 1 1 1"), BrowserConfiguration.ff60up("1")),
        BORDER_IMAGE_WIDTH_("border-image-width", "border-image-width", BrowserConfiguration.ffBelow60("1 1 1 1"), BrowserConfiguration.ff60up("1")),
        BORDER_INLINE_END("borderInlineEnd", "border-inline-end", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff("")),
        BORDER_INLINE_END_("border-inline-end", "border-inline-end", BrowserConfiguration.ff("")),
        BORDER_INLINE_END_COLOR("borderInlineEndColor", "border-inline-end-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("")),
        BORDER_INLINE_END_COLOR_("border-inline-end-color", "border-inline-end-color", BrowserConfiguration.ff("")),
        BORDER_INLINE_END_STYLE("borderInlineEndStyle", "border-inline-end-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("")),
        BORDER_INLINE_END_STYLE_("border-inline-end-style", "border-inline-end-style", BrowserConfiguration.ff("")),
        BORDER_INLINE_END_WIDTH("borderInlineEndWidth", "border-inline-end-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        BORDER_INLINE_END_WIDTH_("border-inline-end-width", "border-inline-end-width", BrowserConfiguration.ff("")),
        BORDER_INLINE_START("borderInlineStart", "border-inline-start", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff("")),
        BORDER_INLINE_START_("border-inline-start", "border-inline-start", BrowserConfiguration.ff("")),
        BORDER_INLINE_START_COLOR("borderInlineStartColor", "border-inline-start-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("")),
        BORDER_INLINE_START_COLOR_("border-inline-start-color", "border-inline-start-color", BrowserConfiguration.ff("")),
        BORDER_INLINE_START_STYLE("borderInlineStartStyle", "border-inline-start-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("")),
        BORDER_INLINE_START_STYLE_("border-inline-start-style", "border-inline-start-style", BrowserConfiguration.ff("")),
        BORDER_INLINE_START_WIDTH("borderInlineStartWidth", "border-inline-start-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        BORDER_INLINE_START_WIDTH_("border-inline-start-width", "border-inline-start-width", BrowserConfiguration.ff("")),
        BORDER_LEFT("borderLeft", "border-left", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_LEFT_("border-left", "border-left", BrowserConfiguration.ff("")),
        BORDER_LEFT_COLOR("borderLeftColor", "border-left-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie("rgb(0, 0, 0)")),
        BORDER_LEFT_COLOR_("border-left-color", "border-left-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        BORDER_LEFT_STYLE("borderLeftStyle", "border-left-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        BORDER_LEFT_STYLE_("border-left-style", "border-left-style", BrowserConfiguration.ff("none")),
        BORDER_LEFT_WIDTH("borderLeftWidth", "border-left-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_LEFT_WIDTH_("border-left-width", "border-left-width", BrowserConfiguration.ff("0px")),
        BORDER_RADIUS("borderRadius", "border-radius", BrowserConfiguration.ff(""), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("0px")),
        BORDER_RADIUS_("border-radius", "border-radius", BrowserConfiguration.ff("")),
        BORDER_RIGHT("borderRight", "border-right", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_RIGHT_("border-right", "border-right", BrowserConfiguration.ff("")),
        BORDER_RIGHT_COLOR("borderRightColor", "border-right-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_RIGHT_COLOR_("border-right-color", "border-right-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        BORDER_RIGHT_STYLE("borderRightStyle", "border-right-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_RIGHT_STYLE_("border-right-style", "border-right-style", BrowserConfiguration.ff("none")),
        BORDER_RIGHT_WIDTH("borderRightWidth", "border-right-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_RIGHT_WIDTH_("border-right-width", "border-right-width", BrowserConfiguration.ff("0px")),
        BORDER_SPACING("borderSpacing", "border-spacing", BrowserConfiguration.chrome("0px 0px"), BrowserConfiguration.ff("0px 0px"), BrowserConfiguration.ie("0px 0px")),
        BORDER_SPACING_("border-spacing", "border-spacing", BrowserConfiguration.ff("0px 0px")),
        BORDER_STYLE("borderStyle", "border-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_STYLE_("border-style", "border-style", BrowserConfiguration.ff("")),
        BORDER_TOP("borderTop", "border-top", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_TOP_("border-top", "border-top", BrowserConfiguration.ff("")),
        BORDER_TOP_COLOR("borderTopColor", "border-top-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_TOP_COLOR_("border-top-color", "border-top-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        BORDER_TOP_LEFT_RADIUS("borderTopLeftRadius", "border-top-left-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px"), BrowserConfiguration.chrome("0px")),
        BORDER_TOP_LEFT_RADIUS_("border-top-left-radius", "border-top-left-radius", BrowserConfiguration.ff("0px")),
        BORDER_TOP_RIGHT_RADIUS("borderTopRightRadius", "border-top-right-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px"), BrowserConfiguration.chrome("0px")),
        BORDER_TOP_RIGHT_RADIUS_("border-top-right-radius", "border-top-right-radius", BrowserConfiguration.ff("0px")),
        BORDER_TOP_STYLE("borderTopStyle", "border-top-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_TOP_STYLE_("border-top-style", "border-top-style", BrowserConfiguration.ff("none")),
        BORDER_TOP_WIDTH("borderTopWidth", "border-top-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_TOP_WIDTH_("border-top-width", "border-top-width", BrowserConfiguration.ff("0px")),
        BORDER_WIDTH("borderWidth", "border-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BORDER_WIDTH_("border-width", "border-width", BrowserConfiguration.ff("")),
        BOTTOM("bottom", "bottom", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        BOX_DECORATION_BREAK("boxDecorationBreak", "box-decoration-break", BrowserConfiguration.ff("slice")),
        BOX_DECORATION_BREAK_("box-decoration-break", "box-decoration-break", BrowserConfiguration.ff("slice")),
        BOX_SHADOW("boxShadow", "box-shadow", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        BOX_SHADOW_("box-shadow", "box-shadow", BrowserConfiguration.ff("none")),
        BOX_SIZING("boxSizing", "box-sizing", BrowserConfiguration.ff("content-box"), BrowserConfiguration.ie("content-box"), BrowserConfiguration.chrome("content-box")),
        BOX_SIZING_("box-sizing", "box-sizing", BrowserConfiguration.ff("content-box")),
        BREAK_AFTER("breakAfter", "break-after", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ie("auto")),
        BREAK_BEFORE("breakBefore", "break-before", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ie("auto")),
        BREAK_INSIDE("breakInside", "break-inside", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ie("auto")),
        BUFFERED_RENDERING("bufferedRendering", "buffered-rendering", BrowserConfiguration.chrome("auto")),
        CAPTION_SIDE("captionSide", "caption-side", BrowserConfiguration.chrome("top"), BrowserConfiguration.ff("top"), BrowserConfiguration.ie("top")),
        CAPTION_SIDE_("caption-side", "caption-side", BrowserConfiguration.ff("top")),
        CARET_COLOR("caretColor", "caret-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff60up("rgb(0, 0, 0)")),
        CARET_COLOR_("caret-color", "caret-color", BrowserConfiguration.ff60up("rgb(0, 0, 0)")),
        CLEAR("clear", "clear", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        CLIP("clip", "clip", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto")),
        CLIP_PATH("clipPath", "clip-path", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        CLIP_PATH_("clip-path", "clip-path", BrowserConfiguration.ff("none")),
        CLIP_RULE("clipRule", "clip-rule", BrowserConfiguration.ff("nonzero"), BrowserConfiguration.ie("nonzero"), BrowserConfiguration.chrome("nonzero")),
        CLIP_RULE_("clip-rule", "clip-rule", BrowserConfiguration.ff("nonzero")),
        COLOR("color", "color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        COLOR_ADJUST("colorAdjust", "color-adjust", BrowserConfiguration.ff("economy")),
        COLOR_ADJUST_("color-adjust", "color-adjust", BrowserConfiguration.ff("economy")),
        COLOR_INTERPOLATION("colorInterpolation", "color-interpolation", BrowserConfiguration.ff("srgb"), BrowserConfiguration.chrome("srgb")),
        COLOR_INTERPOLATION_("color-interpolation", "color-interpolation", BrowserConfiguration.ff("srgb")),
        COLOR_INTERPOLATION_FILTERS("colorInterpolationFilters", "color-interpolation-filters", BrowserConfiguration.ff("linearrgb"), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("linearrgb")),
        COLOR_INTERPOLATION_FILTERS_("color-interpolation-filters", "color-interpolation-filters", BrowserConfiguration.ff("linearrgb")),
        COLOR_RENDERING("colorRendering", "color-rendering", BrowserConfiguration.chrome("auto")),
        COLUMN_COUNT("columnCount", "column-count", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto")),
        COLUMN_COUNT_("column-count", "column-count", BrowserConfiguration.ff("auto")),
        COLUMN_FILL("columnFill", "column-fill", BrowserConfiguration.chrome("balance"), BrowserConfiguration.ff("balance"), BrowserConfiguration.ie("balance")),
        COLUMN_FILL_("column-fill", "column-fill", BrowserConfiguration.ff("balance")),
        COLUMN_GAP("columnGap", "column-gap", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ie("normal"), BrowserConfiguration.ffBelow60("16px"), BrowserConfiguration.ff60up("normal")),
        COLUMN_GAP_("column-gap", "column-gap", BrowserConfiguration.ffBelow60("16px"), BrowserConfiguration.ff60up("normal")),
        COLUMN_RULE("columnRule", "column-rule", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        COLUMN_RULE_("column-rule", "column-rule", BrowserConfiguration.ff("")),
        COLUMN_RULE_COLOR("columnRuleColor", "column-rule-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie("rgb(0, 0, 0)")),
        COLUMN_RULE_COLOR_("column-rule-color", "column-rule-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        COLUMN_RULE_STYLE("columnRuleStyle", "column-rule-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        COLUMN_RULE_STYLE_("column-rule-style", "column-rule-style", BrowserConfiguration.ff("none")),
        COLUMN_RULE_WIDTH("columnRuleWidth", "column-rule-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("medium")),
        COLUMN_RULE_WIDTH_("column-rule-width", "column-rule-width", BrowserConfiguration.ff("0px")),
        COLUMN_SPAN("columnSpan", "column-span", BrowserConfiguration.chrome("none"), BrowserConfiguration.ie("1")),
        COLUMN_WIDTH("columnWidth", "column-width", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto")),
        COLUMN_WIDTH_("column-width", "column-width", BrowserConfiguration.ff("auto")),
        COLUMNS("columns", "columns", BrowserConfiguration.chrome("auto auto"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        CONTAIN("contain", "contain", BrowserConfiguration.chrome("none")),
        CONTENT("content", "content", BrowserConfiguration.ie("normal"), BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("none")),
        COUNTER_INCREMENT("counterIncrement", "counter-increment", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        COUNTER_INCREMENT_("counter-increment", "counter-increment", BrowserConfiguration.ff("none")),
        COUNTER_RESET("counterReset", "counter-reset", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        COUNTER_RESET_("counter-reset", "counter-reset", BrowserConfiguration.ff("none")),
        CSS_FLOAT("cssFloat", "css-float", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        CSS_TEXT("cssText", "css-text", BrowserConfiguration.chrome(""), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        CUE("cue", "cue", new BrowserConfiguration[0]),
        CUE_AFTER("cueAfter", "cue-after", new BrowserConfiguration[0]),
        CUE_BEFORE("cueBefore", "cue-before", new BrowserConfiguration[0]),
        CURSOR("cursor", "cursor", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto")),
        CX("cx", "cx", BrowserConfiguration.chrome("0px")),
        CY("cy", "cy", BrowserConfiguration.chrome("0px")),
        D("d", "d", BrowserConfiguration.chrome("none")),
        DIRECTION("direction", "direction", BrowserConfiguration.chrome("ltr"), BrowserConfiguration.ff("ltr"), BrowserConfiguration.ie("ltr")),
        DISPLAY("display", "display", BrowserConfiguration.chrome("block"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        DOMINANT_BASELINE("dominantBaseline", "dominant-baseline", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto")),
        DOMINANT_BASELINE_("dominant-baseline", "dominant-baseline", BrowserConfiguration.ff("auto")),
        ELEVATION("elevation", "elevation", new BrowserConfiguration[0]),
        EMPTY_CELLS("emptyCells", "empty-cells", BrowserConfiguration.ie("show"), BrowserConfiguration.ff("show"), BrowserConfiguration.chrome("show")),
        EMPTY_CELLS_("empty-cells", "empty-cells", BrowserConfiguration.ff("show")),
        ENABLE_BACKGROUND("enableBackground", "enable-background", BrowserConfiguration.ie("accumulate")),
        FILL("fill", "fill", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie("black"), BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        FILL_OPACITY("fillOpacity", "fill-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie("1"), BrowserConfiguration.chrome("1")),
        FILL_OPACITY_("fill-opacity", "fill-opacity", BrowserConfiguration.ff("1")),
        FILL_RULE("fillRule", "fill-rule", BrowserConfiguration.ff("nonzero"), BrowserConfiguration.ie("nonzero"), BrowserConfiguration.chrome("nonzero")),
        FILL_RULE_("fill-rule", "fill-rule", BrowserConfiguration.ff("nonzero")),
        FILTER("filter", "filter", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        FLEX("flex", "flex", BrowserConfiguration.ff(""), BrowserConfiguration.ie("0 1 auto"), BrowserConfiguration.chrome("0 1 auto")),
        FLEX_BASIS("flexBasis", "flex-basis", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto")),
        FLEX_BASIS_("flex-basis", "flex-basis", BrowserConfiguration.ff("auto")),
        FLEX_DIRECTION("flexDirection", "flex-direction", BrowserConfiguration.ff("row"), BrowserConfiguration.ie("row"), BrowserConfiguration.chrome("row")),
        FLEX_DIRECTION_("flex-direction", "flex-direction", BrowserConfiguration.ff("row")),
        FLEX_FLOW("flexFlow", "flex-flow", BrowserConfiguration.ff(""), BrowserConfiguration.ie("row nowrap"), BrowserConfiguration.chrome("row nowrap")),
        FLEX_FLOW_("flex-flow", "flex-flow", BrowserConfiguration.ff("")),
        FLEX_GROW("flexGrow", "flex-grow", BrowserConfiguration.ff("0"), BrowserConfiguration.ie("0"), BrowserConfiguration.chrome("0")),
        FLEX_GROW_("flex-grow", "flex-grow", BrowserConfiguration.ff("0")),
        FLEX_SHRINK("flexShrink", "flex-shrink", BrowserConfiguration.ff("1"), BrowserConfiguration.ie("1"), BrowserConfiguration.chrome("1")),
        FLEX_SHRINK_("flex-shrink", "flex-shrink", BrowserConfiguration.ff("1")),
        FLEX_WRAP("flexWrap", "flex-wrap", BrowserConfiguration.ff("nowrap"), BrowserConfiguration.ie("nowrap"), BrowserConfiguration.chrome("nowrap")),
        FLEX_WRAP_("flex-wrap", "flex-wrap", BrowserConfiguration.ff("nowrap")),
        FLOAT("float", "float", BrowserConfiguration.ff("none"), BrowserConfiguration.chrome("none")),
        FLOOD_COLOR("floodColor", "flood-color", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        FLOOD_COLOR_("flood-color", "flood-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        FLOOD_OPACITY("floodOpacity", "flood-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie("1"), BrowserConfiguration.chrome("1")),
        FLOOD_OPACITY_("flood-opacity", "flood-opacity", BrowserConfiguration.ff("1")),
        FONT("font", "font", BrowserConfiguration.chrome("normal normal 400 normal 16px / normal \"Times New Roman\""), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        FONT_DISPLAY("fontDisplay", "font-display", BrowserConfiguration.chrome("")),
        FONT_FAMILY("fontFamily", "font-family", BrowserConfiguration.chrome("\"Times New Roman\""), BrowserConfiguration.ie("Times New Roman"), BrowserConfiguration.ff("serif")),
        FONT_FAMILY_("font-family", "font-family", BrowserConfiguration.ff("serif")),
        FONT_FEATURE_SETTINGS("fontFeatureSettings", "font-feature-settings", BrowserConfiguration.ie("normal"), BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        FONT_FEATURE_SETTINGS_("font-feature-settings", "font-feature-settings", BrowserConfiguration.ff("normal")),
        FONT_KERNING("fontKerning", "font-kerning", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        FONT_KERNING_("font-kerning", "font-kerning", BrowserConfiguration.ff("auto")),
        FONT_LANGUAGE_OVERRIDE("fontLanguageOverride", "font-language-override", BrowserConfiguration.ff("normal")),
        FONT_LANGUAGE_OVERRIDE_("font-language-override", "font-language-override", BrowserConfiguration.ff("normal")),
        FONT_SIZE("fontSize", "font-size", BrowserConfiguration.chrome("16px"), BrowserConfiguration.ff("16px"), BrowserConfiguration.ie("16px")),
        FONT_SIZE_("font-size", "font-size", BrowserConfiguration.ff("16px")),
        FONT_SIZE_ADJUST("fontSizeAdjust", "font-size-adjust", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        FONT_SIZE_ADJUST_("font-size-adjust", "font-size-adjust", BrowserConfiguration.ff("none")),
        FONT_STRETCH("fontStretch", "font-stretch", BrowserConfiguration.chrome("100%"), BrowserConfiguration.ff("normal"), BrowserConfiguration.ie("normal")),
        FONT_STRETCH_("font-stretch", "font-stretch", BrowserConfiguration.ff("normal")),
        FONT_STYLE("fontStyle", "font-style", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal"), BrowserConfiguration.ie("normal")),
        FONT_STYLE_("font-style", "font-style", BrowserConfiguration.ff("normal")),
        FONT_SYNTHESIS("fontSynthesis", "font-synthesis", BrowserConfiguration.ff("weight style")),
        FONT_SYNTHESIS_("font-synthesis", "font-synthesis", BrowserConfiguration.ff("weight style")),
        FONT_VARIANT("fontVariant", "font-variant", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal"), BrowserConfiguration.ie("normal")),
        FONT_VARIANT_("font-variant", "font-variant", BrowserConfiguration.ff("normal")),
        FONT_VARIANT_ALTERNATES("fontVariantAlternates", "font-variant-alternates", BrowserConfiguration.ff("normal")),
        FONT_VARIANT_ALTERNATES_("font-variant-alternates", "font-variant-alternates", BrowserConfiguration.ff("normal")),
        FONT_VARIANT_CAPS("fontVariantCaps", "font-variant-caps", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        FONT_VARIANT_CAPS_("font-variant-caps", "font-variant-caps", BrowserConfiguration.ff("normal")),
        FONT_VARIANT_EAST_ASIAN("fontVariantEastAsian", "font-variant-east-asian", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        FONT_VARIANT_EAST_ASIAN_("font-variant-east-asian", "font-variant-east-asian", BrowserConfiguration.ff("normal")),
        FONT_VARIANT_LIGATURES("fontVariantLigatures", "font-variant-ligatures", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        FONT_VARIANT_LIGATURES_("font-variant-ligatures", "font-variant-ligatures", BrowserConfiguration.ff("normal")),
        FONT_VARIANT_NUMERIC("fontVariantNumeric", "font-variant-numeric", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        FONT_VARIANT_NUMERIC_("font-variant-numeric", "font-variant-numeric", BrowserConfiguration.ff("normal")),
        FONT_VARIANT_POSITION("fontVariantPosition", "font-variant-position", BrowserConfiguration.ff("normal")),
        FONT_VARIANT_POSITION_("font-variant-position", "font-variant-position", BrowserConfiguration.ff("normal")),
        FONT_VARIATION_SETTING("fontVariationSettings", "font-variation-settings", BrowserConfiguration.chrome("normal")),
        FONT_WEIGHT("fontWeight", "font-weight", BrowserConfiguration.chrome("400"), BrowserConfiguration.ff("400"), BrowserConfiguration.ie("400")),
        FONT_WEIGHT_("font-weight", "font-weight", BrowserConfiguration.ff("400")),
        GAP("gap", "gap", BrowserConfiguration.chrome("normal normal")),
        GLYPH_ORIENTATION_HORIZONTAL("glyphOrientationHorizontal", "glyph-orientation-horizontal", BrowserConfiguration.ie("0deg")),
        GLYPH_ORIENTATION_VERTICAL("glyphOrientationVertical", "glyph-orientation-vertical", BrowserConfiguration.ie("auto")),
        GRID("grid", "grid", BrowserConfiguration.chrome("none / none / none / row / auto / auto"), BrowserConfiguration.ff("")),
        GRID_AREA("gridArea", "grid-area", BrowserConfiguration.chrome("auto / auto / auto / auto"), BrowserConfiguration.ff("")),
        GRID_AREA_("grid-area", "grid-area", BrowserConfiguration.ff("")),
        GRID_AUTO_COLUMNS("gridAutoColumns", "grid-auto-columns", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        GRID_AUTO_COLUMNS_("grid-auto-columns", "grid-auto-columns", BrowserConfiguration.ff("auto")),
        GRID_AUTO_FLOW("gridAutoFlow", "grid-auto-flow", BrowserConfiguration.chrome("row"), BrowserConfiguration.ff("row")),
        GRID_AUTO_FLOW_("grid-auto-flow", "grid-auto-flow", BrowserConfiguration.ff("row")),
        GRID_AUTO_ROWS("gridAutoRows", "grid-auto-rows", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        GRID_AUTO_ROWS_("grid-auto-rows", "grid-auto-rows", BrowserConfiguration.ff("auto")),
        GRID_COLUMN("gridColumn", "grid-column", BrowserConfiguration.chrome("auto / auto"), BrowserConfiguration.ff("")),
        GRID_COLUMN_("grid-column", "grid-column", BrowserConfiguration.ff("")),
        GRID_COLUMN_END("gridColumnEnd", "grid-column-end", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        GRID_COLUMN_END_("grid-column-end", "grid-column-end", BrowserConfiguration.ff("auto")),
        GRID_COLUMN_GAP("gridColumnGap", "grid-column-gap", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("0px")),
        GRID_COLUMN_GAP_("grid-column-gap", "grid-column-gap", BrowserConfiguration.ff("0px")),
        GRID_COLUMN_START("gridColumnStart", "grid-column-start", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        GRID_COLUMN_START_("grid-column-start", "grid-column-start", BrowserConfiguration.ff("auto")),
        GRID_GAP("gridGap", "grid-gap", BrowserConfiguration.chrome("normal normal"), BrowserConfiguration.ff("")),
        GRID_GAP_("grid-gap", "grid-gap", BrowserConfiguration.ff("")),
        GRID_ROW("gridRow", "grid-row", BrowserConfiguration.chrome("auto / auto"), BrowserConfiguration.ff("")),
        GRID_ROW_("grid-row", "grid-row", BrowserConfiguration.ff("")),
        GRID_ROW_END("gridRowEnd", "grid-row-end", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        GRID_ROW_END_("grid-row-end", "grid-row-end", BrowserConfiguration.ff("auto")),
        GRID_ROW_GAP("gridRowGap", "grid-row-gap", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("0px")),
        GRID_ROW_GAP_("grid-row-gap", "grid-row-gap", BrowserConfiguration.ff("0px")),
        GRID_ROW_START("gridRowStart", "grid-row-start", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        GRID_ROW_START_("grid-row-start", "grid-row-start", BrowserConfiguration.ff("auto")),
        GRID_TEMPLATE("gridTemplate", "grid-template", BrowserConfiguration.chrome("none / none / none"), BrowserConfiguration.ff("")),
        GRID_TEMPLATE_("grid-template", "grid-template", BrowserConfiguration.ff("")),
        GRID_TEMPLATE_AREAS("gridTemplateAreas", "grid-template-areas", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        GRID_TEMPLATE_AREAS_("grid-template-areas", "grid-template-areas", BrowserConfiguration.ff("none")),
        GRID_TEMPLATE_COLUMNS("gridTemplateColumns", "grid-template-columns", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        GRID_TEMPLATE_COLUMNS_("grid-template-columns", "grid-template-columns", BrowserConfiguration.ff("none")),
        GRID_TEMPLATE_ROWS("gridTemplateRows", "grid-template-rows", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        GRID_TEMPLATE_ROWS_("grid-template-rows", "grid-template-rows", BrowserConfiguration.ff("none")),
        HEIGHT("height", "height", BrowserConfiguration.chrome(""), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        HYPHENS("hyphens", "hyphens", BrowserConfiguration.ff("manual"), BrowserConfiguration.chrome("manual")),
        IMAGE_ORIENTATION("imageOrientation", "image-orientation", BrowserConfiguration.ff("0deg")),
        IMAGE_ORIENTATION_("image-orientation", "image-orientation", BrowserConfiguration.ff("0deg")),
        IMAGE_RENDERING("imageRendering", "image-rendering", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        IMAGE_RENDERING_("image-rendering", "image-rendering", BrowserConfiguration.ff("auto")),
        IME_MODE("imeMode", "ime-mode", BrowserConfiguration.ie("undefined"), BrowserConfiguration.ff("auto")),
        IME_MODE_("ime-mode", "ime-mode", BrowserConfiguration.ff("auto")),
        INLINE_SIZE("inlineSize", "inline-size", BrowserConfiguration.ff(""), BrowserConfiguration.chrome("913px")),
        INLINE_SIZE_("inline-size", "inline-size", BrowserConfiguration.ff("")),
        ISOLATION("isolation", "isolation", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        JUSTIFY_CONTENT("justifyContent", "justify-content", BrowserConfiguration.ff("normal"), BrowserConfiguration.ie("flex-start"), BrowserConfiguration.chrome("normal")),
        JUSTIFY_CONTENT_("justify-content", "justify-content", BrowserConfiguration.ff("normal")),
        JUSTIFY_ITEMS("justifyItems", "justify-items", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        JUSTIFY_ITEMS_("justify-items", "justify-items", BrowserConfiguration.ff("normal")),
        JUSTIFY_SELF("justifySelf", "justify-self", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        JUSTIFY_SELF_("justify-self", "justify-self", BrowserConfiguration.ff("auto")),
        KERNING("kerning", "kerning", BrowserConfiguration.ie("auto")),
        LAYOUT_FLOW("layoutFlow", "layout-flow", BrowserConfiguration.ie("undefined")),
        LAYOUT_GRID("layoutGrid", "layout-grid", BrowserConfiguration.ie("undefined")),
        LAYOUT_GRID_CHAR("layoutGridChar", "layout-grid-char", BrowserConfiguration.ie("undefined")),
        LAYOUT_GRID_LINE("layoutGridLine", "layout-grid-line", BrowserConfiguration.ie("undefined")),
        LAYOUT_GRID_MODE("layoutGridMode", "layout-grid-mode", BrowserConfiguration.ie("undefined")),
        LAYOUT_GRID_TYPE("layoutGridType", "layout-grid-type", BrowserConfiguration.ie("undefined")),
        LEFT("left", "left", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        LETTER_SPACING("letterSpacing", "letter-spacing", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        LETTER_SPACING_("letter-spacing", "letter-spacing", BrowserConfiguration.ff("normal")),
        LIGHTING_COLOR("lightingColor", "lighting-color", BrowserConfiguration.ff("rgb(255, 255, 255)"), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("rgb(255, 255, 255)")),
        LIGHTING_COLOR_("lighting-color", "lighting-color", BrowserConfiguration.ff("rgb(255, 255, 255)")),
        LINE_BREAK("lineBreak", "line-break", BrowserConfiguration.ie("undefined"), BrowserConfiguration.chrome("auto")),
        LINE_HEIGHT("lineHeight", "line-height", BrowserConfiguration.ff("20px"), BrowserConfiguration.ie("normal"), BrowserConfiguration.chrome("normal")),
        LINE_HEIGHT_("line-height", "line-height", BrowserConfiguration.ff("20px")),
        LIST_STYLE("listStyle", "list-style", BrowserConfiguration.chrome("disc outside none"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        LIST_STYLE_("list-style", "list-style", BrowserConfiguration.ff("")),
        LIST_STYLE_IMAGE("listStyleImage", "list-style-image", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        LIST_STYLE_IMAGE_("list-style-image", "list-style-image", BrowserConfiguration.ff("none")),
        LIST_STYLE_POSITION("listStylePosition", "list-style-position", BrowserConfiguration.chrome("outside"), BrowserConfiguration.ff("outside"), BrowserConfiguration.ie("outside")),
        LIST_STYLE_POSITION_("list-style-position", "list-style-position", BrowserConfiguration.ff("outside")),
        LIST_STYLE_TYPE("listStyleType", "list-style-type", BrowserConfiguration.chrome("disc"), BrowserConfiguration.ff("disc"), BrowserConfiguration.ie("disc")),
        LIST_STYLE_TYPE_("list-style-type", "list-style-type", BrowserConfiguration.ff("disc")),
        MARGIN("margin", "margin", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MARGIN_BLOCK_END("marginBlockEnd", "margin-block-end", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        MARGIN_BLOCK_END_("margin-block-end", "margin-block-end", BrowserConfiguration.ff("")),
        MARGIN_BLOCK_START("marginBlockStart", "margin-block-start", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        MARGIN_BLOCK_START_("margin-block-start", "margin-block-start", BrowserConfiguration.ff("")),
        MARGIN_BOTTOM("marginBottom", "margin-bottom", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MARGIN_BOTTOM_("margin-bottom", "margin-bottom", BrowserConfiguration.ff("0px")),
        MARGIN_INLINE_END("marginInlineEnd", "margin-inline-end", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        MARGIN_INLINE_END_("margin-inline-end", "margin-inline-end", BrowserConfiguration.ff("")),
        MARGIN_INLINE_START("marginInlineStart", "margin-inline-start", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        MARGIN_INLINE_START_("margin-inline-start", "margin-inline-start", BrowserConfiguration.ff("")),
        MARGIN_LEFT("marginLeft", "margin-left", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MARGIN_LEFT_("margin-left", "margin-left", BrowserConfiguration.ff("0px")),
        MARGIN_RIGHT("marginRight", "margin-right", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MARGIN_RIGHT_("margin-right", "margin-right", BrowserConfiguration.ff("0px")),
        MARGIN_TOP("marginTop", "margin-top", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MARGIN_TOP_("margin-top", "margin-top", BrowserConfiguration.ff("0px")),
        MARKER("marker", "marker", BrowserConfiguration.ff(""), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("")),
        MARKER_END("markerEnd", "marker-end", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        MARKER_END_("marker-end", "marker-end", BrowserConfiguration.ff("none")),
        MARKER_MID("markerMid", "marker-mid", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        MARKER_MID_("marker-mid", "marker-mid", BrowserConfiguration.ff("none")),
        MARKER_OFFSET("markerOffset", "marker-offset", new BrowserConfiguration[0]),
        MARKER_OFFSET_("marker-offset", "marker-offset", new BrowserConfiguration[0]),
        MARKER_START("markerStart", "marker-start", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        MARKER_START_("marker-start", "marker-start", BrowserConfiguration.ff("none")),
        MASK("mask", "mask", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        MASK_CLIP("maskClip", "mask-clip", BrowserConfiguration.ff60up("border-box")),
        MASK_CLIP_("mask-clip", "mask-clip", BrowserConfiguration.ff60up("border-box")),
        MASK_COMPOSITE("maskComposite", "mask-composite", BrowserConfiguration.ff60up("add")),
        MASK_COMPOSITE_("mask-composite", "mask-composite", BrowserConfiguration.ff60up("add")),
        MASK_IMAGE("maskImage", "mask-image", BrowserConfiguration.ff60up("none")),
        MASK_IMAGE_("mask-image", "mask-image", BrowserConfiguration.ff60up("none")),
        MASK_MODE("maskMode", "mask-mode", BrowserConfiguration.ff60up("match-source")),
        MASK_MODE_("mask-mode", "mask-mode", BrowserConfiguration.ff60up("match-source")),
        MASK_ORIGIN("maskOrigin", "mask-origin", BrowserConfiguration.ff60up("border-box")),
        MASK_ORIGIN_("mask-origin", "mask-origin", BrowserConfiguration.ff60up("border-box")),
        MASK_POSITION("maskPosition", "mask-position", BrowserConfiguration.ff60up("0% 0%")),
        MASK_POSITION_("mask-position", "mask-position", BrowserConfiguration.ff60up("0% 0%")),
        MASK_POSITION_X("maskPositionX", "mask-position-x", BrowserConfiguration.ff60up("0%")),
        MASK_POSITION_X_("mask-position-x", "mask-position-x", BrowserConfiguration.ff60up("0%")),
        MASK_POSITION_Y("maskPositionY", "mask-position-y", BrowserConfiguration.ff60up("0%")),
        MASK_POSITION_Y_("mask-position-y", "mask-position-y", BrowserConfiguration.ff60up("0%")),
        MASK_REPEAT("maskRepeat", "mask-repeat", BrowserConfiguration.ff60up("repeat")),
        MASK_REPEAT_("mask-repeat", "mask-repeat", BrowserConfiguration.ff60up("repeat")),
        MASK_SIZE("maskSize", "mask-size", BrowserConfiguration.ff60up("auto auto")),
        MASK_SIZE_("mask-size", "mask-size", BrowserConfiguration.ff60up("auto auto")),
        MASK_TYPE("maskType", "mask-type", BrowserConfiguration.ff("luminance"), BrowserConfiguration.chrome("luminance")),
        MASK_TYPE_("mask-type", "mask-type", BrowserConfiguration.ff("luminance")),
        MAX_BLOCK_SIZE("maxBlockSize", "max-block-size", BrowserConfiguration.ff(""), BrowserConfiguration.chrome("none")),
        MAX_BLOCK_SIZE_("max-block-size", "max-block-size", BrowserConfiguration.ff("")),
        MAX_HEIGHT("maxHeight", "max-height", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MAX_HEIGHT_("max-height", "max-height", BrowserConfiguration.ff("none")),
        MAX_INLINE_SIZE("maxInlineSize", "max-inline-size", BrowserConfiguration.ff(""), BrowserConfiguration.chrome("none")),
        MAX_INLINE_SIZE_("max-inline-size", "max-inline-size", BrowserConfiguration.ff("")),
        MAX_WIDTH("maxWidth", "max-width", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MAX_WIDTH_("max-width", "max-width", BrowserConfiguration.ff("none")),
        MAX_ZOOM("maxZoom", "max-zoom", BrowserConfiguration.chrome("")),
        MIN_BLOCK_SIZE("minBlockSize", "min-block-size", BrowserConfiguration.ff(""), BrowserConfiguration.chrome("0px")),
        MIN_BLOCK_SIZE_("min-block-size", "min-block-size", BrowserConfiguration.ff("")),
        MIN_HEIGHT("minHeight", "min-height", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MIN_HEIGHT_("min-height", "min-height", BrowserConfiguration.ff("0px")),
        MIN_INLINE_SIZE("minInlineSize", "min-inline-size", BrowserConfiguration.ff(""), BrowserConfiguration.chrome("0px")),
        MIN_INLINE_SIZE_("min-inline-size", "min-inline-size", BrowserConfiguration.ff("")),
        MIN_WIDTH("minWidth", "min-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        MIN_WIDTH_("min-width", "min-width", BrowserConfiguration.ff("0px")),
        MIN_ZOOM("minZoom", "min-zoom", BrowserConfiguration.chrome("")),
        MIX_BLEND_MODE("mixBlendMode", "mix-blend-mode", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        MIX_BLEND_MODE_("mix-blend-mode", "mix-blend-mode", BrowserConfiguration.ff("normal")),
        MOZ_ANIMATION("MozAnimation", "-moz-animation", BrowserConfiguration.ff("")),
        MOZ_ANIMATION__("-moz-animation", "-moz-animation", BrowserConfiguration.ff("")),
        MOZ_ANIMATION_DELAY("MozAnimationDelay", "-moz-animation-delay", BrowserConfiguration.ff("0s")),
        MOZ_ANIMATION_DELAY__("-moz-animation-delay", "-moz-animation-delay", BrowserConfiguration.ff("0s")),
        MOZ_ANIMATION_DIRECTION("MozAnimationDirection", "-moz-animation-direction", BrowserConfiguration.ff("normal")),
        MOZ_ANIMATION_DIRECTION__("-moz-animation-direction", "-moz-animation-direction", BrowserConfiguration.ff("normal")),
        MOZ_ANIMATION_DURATION("MozAnimationDuration", "-moz-animation-duration", BrowserConfiguration.ff("0s")),
        MOZ_ANIMATION_DURATION__("-moz-animation-duration", "-moz-animation-duration", BrowserConfiguration.ff("0s")),
        MOZ_ANIMATION_FILL_MODE("MozAnimationFillMode", "-moz-animation-fill-mode", BrowserConfiguration.ff("none")),
        MOZ_ANIMATION_FILL_MODE__("-moz-animation-fill-mode", "-moz-animation-fill-mode", BrowserConfiguration.ff("none")),
        MOZ_ANIMATION_ITERATION_COUNT("MozAnimationIterationCount", "-moz-animation-iteration-count", BrowserConfiguration.ff("1")),
        MOZ_ANIMATION_ITERATION_COUNT__("-moz-animation-iteration-count", "-moz-animation-iteration-count", BrowserConfiguration.ff("1")),
        MOZ_ANIMATION_NAME("MozAnimationName", "-moz-animation-name", BrowserConfiguration.ff("none")),
        MOZ_ANIMATION_NAME__("-moz-animation-name", "-moz-animation-name", BrowserConfiguration.ff("none")),
        MOZ_ANIMATION_PLAY_STATE("MozAnimationPlayState", "-moz-animation-play-state", BrowserConfiguration.ff("running")),
        MOZ_ANIMATION_PLAY_STATE__("-moz-animation-play-state", "-moz-animation-play-state", BrowserConfiguration.ff("running")),
        MOZ_ANIMATION_TIMING_FUNCTION("MozAnimationTimingFunction", "-moz-animation-timing-function", BrowserConfiguration.ff("ease")),
        MOZ_ANIMATION_TIMING_FUNCTION__("-moz-animation-timing-function", "-moz-animation-timing-function", BrowserConfiguration.ff("ease")),
        MOZ_APPEARANCE("MozAppearance", "-moz-appearance", BrowserConfiguration.ff("none")),
        MOZ_APPEARANCE__("-moz-appearance", "-moz-appearance", BrowserConfiguration.ff("none")),
        MOZ_BACKFACE_VISIBILITY("MozBackfaceVisibility", "-moz-backface-visibility", BrowserConfiguration.ff("visible")),
        MOZ_BACKFACE_VISIBILITY__("-moz-backface-visibility", "-moz-backface-visibility", BrowserConfiguration.ff("visible")),
        MOZ_BACKGROUND_CLIP("MozBackgroundClip", "-moz-background-clip", new BrowserConfiguration[0]),
        MOZ_BACKGROUND_ORIGIN("MozBackgroundOrigin", "-moz-background-origin", new BrowserConfiguration[0]),
        MOZ_BACKGROUND_SIZE("MozBackgroundSize", "-moz-background-size", new BrowserConfiguration[0]),
        MOZ_BINDING("MozBinding", "-moz-binding", BrowserConfiguration.ff("none")),
        MOZ_BINDING__("-moz-binding", "-moz-binding", BrowserConfiguration.ff("none")),
        MOZ_BORDER_BOTTOM_COLORS("MozBorderBottomColors", "-moz-border-bottom-colors", BrowserConfiguration.ffBelow60("none"), BrowserConfiguration.ff60up("none").setIteratable(false)),
        MOZ_BORDER_BOTTOM_COLORS__("-moz-border-bottom-colors", "-moz-border-bottom-colors", BrowserConfiguration.ffBelow60("none"), BrowserConfiguration.ff60up("none").setIteratable(false)),
        MOZ_BORDER_END("MozBorderEnd", "-moz-border-end", BrowserConfiguration.ff("")),
        MOZ_BORDER_END__("-moz-border-end", "-moz-border-end", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_COLOR("MozBorderEndColor", "-moz-border-end-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_COLOR__("-moz-border-end-color", "-moz-border-end-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_STYLE("MozBorderEndStyle", "-moz-border-end-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_STYLE__("-moz-border-end-style", "-moz-border-end-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_WIDTH("MozBorderEndWidth", "-moz-border-end-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_WIDTH__("-moz-border-end-width", "-moz-border-end-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_IMAGE("MozBorderImage", "-moz-border-image", BrowserConfiguration.ff("")),
        MOZ_BORDER_IMAGE__("-moz-border-image", "-moz-border-image", BrowserConfiguration.ff("")),
        MOZ_BORDER_LEFT_COLORS("MozBorderLeftColors", "-moz-border-left-colors", BrowserConfiguration.ffBelow60("none"), BrowserConfiguration.ff60up("none").setIteratable(false)),
        MOZ_BORDER_LEFT_COLORS__("-moz-border-left-colors", "-moz-border-left-colors", BrowserConfiguration.ffBelow60("none"), BrowserConfiguration.ff60up("none").setIteratable(false)),
        MOZ_BORDER_RADIUS("MozBorderRadius", "-moz-border-radius", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_BOTTOMLEFT("MozBorderRadiusBottomleft", "-moz-border-radius-bottomleft", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_BOTTOMRIGHT("MozBorderRadiusBottomright", "-moz-border-radius-bottomright", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_TOPLEFT("MozBorderRadiusTopleft", "-moz-border-radius-topleft", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_TOPRIGHT("MozBorderRadiusTopright", "-moz-border-radius-topright", new BrowserConfiguration[0]),
        MOZ_BORDER_RIGHT_COLORS("MozBorderRightColors", "-moz-border-right-colors", BrowserConfiguration.ffBelow60("none"), BrowserConfiguration.ff60up("none").setIteratable(false)),
        MOZ_BORDER_RIGHT_COLORS__("-moz-border-right-colors", "-moz-border-right-colors", BrowserConfiguration.ffBelow60("none"), BrowserConfiguration.ff60up("none").setIteratable(false)),
        MOZ_BORDER_START("MozBorderStart", "-moz-border-start", BrowserConfiguration.ff("")),
        MOZ_BORDER_START__("-moz-border-start", "-moz-border-start", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_COLOR("MozBorderStartColor", "-moz-border-start-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_COLOR__("-moz-border-start-color", "-moz-border-start-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_STYLE("MozBorderStartStyle", "-moz-border-start-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_STYLE__("-moz-border-start-style", "-moz-border-start-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_WIDTH("MozBorderStartWidth", "-moz-border-start-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_WIDTH__("-moz-border-start-width", "-moz-border-start-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_TOP_COLORS("MozBorderTopColors", "-moz-border-top-colors", BrowserConfiguration.ffBelow60("none"), BrowserConfiguration.ff60up("none").setIteratable(false)),
        MOZ_BORDER_TOP_COLORS__("-moz-border-top-colors", "-moz-border-top-colors", BrowserConfiguration.ffBelow60("none"), BrowserConfiguration.ff60up("none").setIteratable(false)),
        MOZ_BOX_ALIGN("MozBoxAlign", "-moz-box-align", BrowserConfiguration.ff("stretch")),
        MOZ_BOX_ALIGN__("-moz-box-align", "-moz-box-align", BrowserConfiguration.ff("stretch")),
        MOZ_BOX_DIRECTION("MozBoxDirection", "-moz-box-direction", BrowserConfiguration.ff("normal")),
        MOZ_BOX_DIRECTION__("-moz-box-direction", "-moz-box-direction", BrowserConfiguration.ff("normal")),
        MOZ_BOX_FLEX("MozBoxFlex", "-moz-box-flex", BrowserConfiguration.ff("0")),
        MOZ_BOX_FLEX__("-moz-box-flex", "-moz-box-flex", BrowserConfiguration.ff("0")),
        MOZ_BOX_ORDINAL_GROUP("MozBoxOrdinalGroup", "-moz-box-ordinal-group", BrowserConfiguration.ff("1")),
        MOZ_BOX_ORDINAL_GROUP__("-moz-box-ordinal-group", "-moz-box-ordinal-group", BrowserConfiguration.ff("1")),
        MOZ_BOX_ORIENT("MozBoxOrient", "-moz-box-orient", BrowserConfiguration.ff("horizontal")),
        MOZ_BOX_ORIENT__("-moz-box-orient", "-moz-box-orient", BrowserConfiguration.ff("horizontal")),
        MOZ_BOX_PACK("MozBoxPack", "-moz-box-pack", BrowserConfiguration.ff("start")),
        MOZ_BOX_PACK__("-moz-box-pack", "-moz-box-pack", BrowserConfiguration.ff("start")),
        MOZ_BOX_SHADOW("MozBoxShadow", "-moz-box-shadow", new BrowserConfiguration[0]),
        MOZ_BOX_SIZING("MozBoxSizing", "-moz-box-sizing", BrowserConfiguration.ff("content-box")),
        MOZ_BOX_SIZING__("-moz-box-sizing", "-moz-box-sizing", BrowserConfiguration.ff("content-box")),
        MOZ_COLUMN_COUNT("MozColumnCount", "-moz-column-count", BrowserConfiguration.ff("auto")),
        MOZ_COLUMN_COUNT__("-moz-column-count", "-moz-column-count", BrowserConfiguration.ff("auto")),
        MOZ_COLUMN_FILL("MozColumnFill", "-moz-column-fill", BrowserConfiguration.ff("balance")),
        MOZ_COLUMN_FILL__("-moz-column-fill", "-moz-column-fill", BrowserConfiguration.ff("balance")),
        MOZ_COLUMN_GAP("MozColumnGap", "-moz-column-gap", BrowserConfiguration.ffBelow60("16px"), BrowserConfiguration.ff60up("normal")),
        MOZ_COLUMN_GAP__("-moz-column-gap", "-moz-column-gap", BrowserConfiguration.ffBelow60("16px"), BrowserConfiguration.ff60up("normal")),
        MOZ_COLUMN_RULE("MozColumnRule", "-moz-column-rule", BrowserConfiguration.ff("")),
        MOZ_COLUMN_RULE__("-moz-column-rule", "-moz-column-rule", BrowserConfiguration.ff("")),
        MOZ_COLUMN_RULE_COLOR("MozColumnRuleColor", "-moz-column-rule-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        MOZ_COLUMN_RULE_COLOR__("-moz-column-rule-color", "-moz-column-rule-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        MOZ_COLUMN_RULE_STYLE("MozColumnRuleStyle", "-moz-column-rule-style", BrowserConfiguration.ff("none")),
        MOZ_COLUMN_RULE_STYLE__("-moz-column-rule-style", "-moz-column-rule-style", BrowserConfiguration.ff("none")),
        MOZ_COLUMN_RULE_WIDTH("MozColumnRuleWidth", "-moz-column-rule-width", BrowserConfiguration.ff("0px")),
        MOZ_COLUMN_RULE_WIDTH__("-moz-column-rule-width", "-moz-column-rule-width", BrowserConfiguration.ff("0px")),
        MOZ_COLUMN_WIDTH("MozColumnWidth", "-moz-column-width", BrowserConfiguration.ff("auto")),
        MOZ_COLUMN_WIDTH__("-moz-column-width", "-moz-column-width", BrowserConfiguration.ff("auto")),
        MOZ_COLUMNS("MozColumns", "-moz-columns", BrowserConfiguration.ff("")),
        MOZ_COLUMNS__("-moz-columns", "-moz-columns", BrowserConfiguration.ff("")),
        MOZ_FLOAT_EDGE("MozFloatEdge", "-moz-float-edge", BrowserConfiguration.ff("content-box")),
        MOZ_FLOAT_EDGE__("-moz-float-edge", "-moz-float-edge", BrowserConfiguration.ff("content-box")),
        MOZ_FONT_FEATURE_SETTINGS("MozFontFeatureSettings", "-moz-font-feature-settings", BrowserConfiguration.ff("normal")),
        MOZ_FONT_FEATURE_SETTINGS__("-moz-font-feature-settings", "-moz-font-feature-settings", BrowserConfiguration.ff("normal")),
        MOZ_FONT_LANGUAGE_OVERRIDE("MozFontLanguageOverride", "-moz-font-language-override", BrowserConfiguration.ff("normal")),
        MOZ_FONT_LANGUAGE_OVERRIDE__("-moz-font-language-override", "-moz-font-language-override", BrowserConfiguration.ff("normal")),
        MOZ_FORCE_BROKEN_IMAGE_ICON("MozForceBrokenImageIcon", "-moz-force-broken-image-icon", BrowserConfiguration.ff("0")),
        MOZ_FORCE_BROKEN_IMAGE_ICON__("-moz-force-broken-image-icon", "-moz-force-broken-image-icon", BrowserConfiguration.ff("0")),
        MOZ_HYPHENS("MozHyphens", "-moz-hyphens", BrowserConfiguration.ff("manual")),
        MOZ_HYPHENS__("-moz-hyphens", "-moz-hyphens", BrowserConfiguration.ff("manual")),
        MOZ_IMAGE_REGION("MozImageRegion", "-moz-image-region", BrowserConfiguration.ff("auto")),
        MOZ_IMAGE_REGION__("-moz-image-region", "-moz-image-region", BrowserConfiguration.ff("auto")),
        MOZ_MARGIN_END("MozMarginEnd", "-moz-margin-end", BrowserConfiguration.ff("")),
        MOZ_MARGIN_END__("-moz-margin-end", "-moz-margin-end", BrowserConfiguration.ff("")),
        MOZ_MARGIN_START("MozMarginStart", "-moz-margin-start", BrowserConfiguration.ff("")),
        MOZ_MARGIN_START__("-moz-margin-start", "-moz-margin-start", BrowserConfiguration.ff("")),
        MOZ_OPACITY("MozOpacity", "-moz-opacity", new BrowserConfiguration[0]),
        MOZ_ORIENT("MozOrient", "-moz-orient", BrowserConfiguration.ff("inline")),
        MOZ_ORIENT__("-moz-orient", "-moz-orient", BrowserConfiguration.ff("inline")),
        MOZ_OUTLINE("MozOutline", "-moz-outline", new BrowserConfiguration[0]),
        MOZ_OUTLINE_COLOR("MozOutlineColor", "-moz-outline-color", new BrowserConfiguration[0]),
        MOZ_OUTLINE_OFFSET("MozOutlineOffset", "-moz-outline-offset", new BrowserConfiguration[0]),
        MOZ_OUTLINE_RADIUS("MozOutlineRadius", "-moz-outline-radius", BrowserConfiguration.ff("")),
        MOZ_OUTLINE_RADIUS__("-moz-outline-radius", "-moz-outline-radius", BrowserConfiguration.ff("")),
        MOZ_OUTLINE_RADIUS_BOTTOMLEFT("MozOutlineRadiusBottomleft", "-moz-outline-radius-bottomleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_BOTTOMLEFT__("-moz-outline-radius-bottomleft", "-moz-outline-radius-bottomleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_BOTTOMRIGHT("MozOutlineRadiusBottomright", "-moz-outline-radius-bottomright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_BOTTOMRIGHT__("-moz-outline-radius-bottomright", "-moz-outline-radius-bottomright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPLEFT("MozOutlineRadiusTopleft", "-moz-outline-radius-topleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPLEFT__("-moz-outline-radius-topleft", "-moz-outline-radius-topleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPRIGHT("MozOutlineRadiusTopright", "-moz-outline-radius-topright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPRIGHT__("-moz-outline-radius-topright", "-moz-outline-radius-topright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_STYLE("MozOutlineStyle", "-moz-outline-style", new BrowserConfiguration[0]),
        MOZ_OUTLINE_WIDTH("MozOutlineWidth", "-moz-outline-width", new BrowserConfiguration[0]),
        MOZ_PADDING_END("MozPaddingEnd", "-moz-padding-end", BrowserConfiguration.ff("")),
        MOZ_PADDING_END__("-moz-padding-end", "-moz-padding-end", BrowserConfiguration.ff("")),
        MOZ_PADDING_START("MozPaddingStart", "-moz-padding-start", BrowserConfiguration.ff("")),
        MOZ_PADDING_START__("-moz-padding-start", "-moz-padding-start", BrowserConfiguration.ff("")),
        MOZ_PERSPECTIVE("MozPerspective", "-moz-perspective", BrowserConfiguration.ff("none")),
        MOZ_PERSPECTIVE__("-moz-perspective", "-moz-perspective", BrowserConfiguration.ff("none")),
        MOZ_PERSPECTIVE_ORIGIN("MozPerspectiveOrigin", "-moz-perspective-origin", BrowserConfiguration.ff("625px 172.5px")),
        MOZ_PERSPECTIVE_ORIGIN__("-moz-perspective-origin", "-moz-perspective-origin", BrowserConfiguration.ff("625px 172.5px")),
        MOZ_STACK_SIZING("MozStackSizing", "-moz-stack-sizing", BrowserConfiguration.ff("stretch-to-fit")),
        MOZ_STACK_SIZING__("-moz-stack-sizing", "-moz-stack-sizing", BrowserConfiguration.ff("stretch-to-fit")),
        MOZ_TAB_SIZE("MozTabSize", "-moz-tab-size", BrowserConfiguration.ff("8")),
        MOZ_TAB_SIZE__("-moz-tab-size", "-moz-tab-size", BrowserConfiguration.ff("8")),
        MOZ_TEXT_ALIGN_LAST("MozTextAlignLast", "-moz-text-align-last", BrowserConfiguration.ffBelow60("auto"), BrowserConfiguration.ff60up("auto").setIteratable(false)),
        MOZ_TEXT_ALIGN_LAST__("-moz-text-align-last", "-moz-text-align-last", BrowserConfiguration.ffBelow60("auto"), BrowserConfiguration.ff60up("auto").setIteratable(false)),
        MOZ_TEXT_SIZE_ADJUST("MozTextSizeAdjust", "-moz-text-size-adjust", BrowserConfiguration.ff("auto")),
        MOZ_TEXT_SIZE_ADJUST__("-moz-text-size-adjust", "-moz-text-size-adjust", BrowserConfiguration.ff("auto")),
        MOZ_TRANSFORM("MozTransform", "-moz-transform", BrowserConfiguration.ff("none")),
        MOZ_TRANSFORM__("-moz-transform", "-moz-transform", BrowserConfiguration.ff("none")),
        MOZ_TRANSFORM_ORIGIN("MozTransformOrigin", "-moz-transform-origin", BrowserConfiguration.ff("625px 172.5px")),
        MOZ_TRANSFORM_ORIGIN__("-moz-transform-origin", "-moz-transform-origin", BrowserConfiguration.ff("625px 172.5px")),
        MOZ_TRANSFORM_STYLE("MozTransformStyle", "-moz-transform-style", BrowserConfiguration.ff("flat")),
        MOZ_TRANSFORM_STYLE__("-moz-transform-style", "-moz-transform-style", BrowserConfiguration.ff("flat")),
        MOZ_TRANSITION("MozTransition", "-moz-transition", BrowserConfiguration.ff("")),
        MOZ_TRANSITION__("-moz-transition", "-moz-transition", BrowserConfiguration.ff("")),
        MOZ_TRANSITION_DELAY("MozTransitionDelay", "-moz-transition-delay", BrowserConfiguration.ff("0s")),
        MOZ_TRANSITION_DELAY__("-moz-transition-delay", "-moz-transition-delay", BrowserConfiguration.ff("0s")),
        MOZ_TRANSITION_DURATION("MozTransitionDuration", "-moz-transition-duration", BrowserConfiguration.ff("0s")),
        MOZ_TRANSITION_DURATION__("-moz-transition-duration", "-moz-transition-duration", BrowserConfiguration.ff("0s")),
        MOZ_TRANSITION_PROPERTY("MozTransitionProperty", "-moz-transition-property", BrowserConfiguration.ff("all")),
        MOZ_TRANSITION_PROPERTY__("-moz-transition-property", "-moz-transition-property", BrowserConfiguration.ff("all")),
        MOZ_TRANSITION_TIMING_FUNCTION("MozTransitionTimingFunction", "-moz-transition-timing-function", BrowserConfiguration.ff("ease")),
        MOZ_TRANSITION_TIMING_FUNCTION__("-moz-transition-timing-function", "-moz-transition-timing-function", BrowserConfiguration.ff("ease")),
        MOZ_USER_FOCUS("MozUserFocus", "-moz-user-focus", BrowserConfiguration.ff("none")),
        MOZ_USER_FOCUS__("-moz-user-focus", "-moz-user-focus", BrowserConfiguration.ff("none")),
        MOZ_USER_INPUT("MozUserInput", "-moz-user-input", BrowserConfiguration.ff("auto")),
        MOZ_USER_INPUT__("-moz-user-input", "-moz-user-input", BrowserConfiguration.ff("auto")),
        MOZ_USER_MODIFY("MozUserModify", "-moz-user-modify", BrowserConfiguration.ff("read-only")),
        MOZ_USER_MODIFY__("-moz-user-modify", "-moz-user-modify", BrowserConfiguration.ff("read-only")),
        MOZ_USER_SELECT("MozUserSelect", "-moz-user-select", BrowserConfiguration.ff("auto")),
        MOZ_USER_SELECT__("-moz-user-select", "-moz-user-select", BrowserConfiguration.ff("auto")),
        MOZ_WINDOW_DRAGGING("MozWindowDragging", "-moz-window-dragging", BrowserConfiguration.ff("default")),
        MOZ_WINDOW_DRAGGING__("-moz-window-dragging", "-moz-window-dragging", BrowserConfiguration.ff("default")),
        MS_ANIMATION("msAnimation", "-ms-animation", BrowserConfiguration.ie("")),
        MS_ANIMATION_DELAY("msAnimationDelay", "-ms-animation-delay", BrowserConfiguration.ie("0s")),
        MS_ANIMATION_DIRECTION("msAnimationDirection", "-ms-animation-direction", BrowserConfiguration.ie("normal")),
        MS_ANIMATION_DURATION("msAnimationDuration", "-ms-animation-duration", BrowserConfiguration.ie("0s")),
        MS_ANIMATION_FILL_MODE("msAnimationFillMode", "-ms-animation-fill-mode", BrowserConfiguration.ie("none")),
        MS_ANIMATION_ITERATION_COUNT("msAnimationIterationCount", "-ms-animation-iteration-count", BrowserConfiguration.ie("1")),
        MS_ANIMATION_NAME("msAnimationName", "-ms-annimation-name", BrowserConfiguration.ie("none")),
        MS_ANIMATION_PLAY_STATE("msAnimationPlayState", "-ms-animation-play-state", BrowserConfiguration.ie("running")),
        MS_ANIMATION_TIMING_FUNCTION("msAnimationTimingFunction", "-ms-animation-timing-function", BrowserConfiguration.ie("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MS_BACKFACE_VISIBILITY("msBackfaceVisibility", "-ms-backface-visibility", BrowserConfiguration.ie("visible")),
        MS_BLOCK_PROGRESSION("msBlockProgression", "-ms-block-progression", BrowserConfiguration.ie("undefined")),
        MS_CONTENT_ZOOM_CHAINING("msContentZoomChaining", "-ms-content-zoom-chaining", BrowserConfiguration.ie("none")),
        MS_CONTENT_ZOOM_LIMIT("msContentZoomLimit", "-ms-content-zoom-limit", BrowserConfiguration.ie("")),
        MS_CONTENT_ZOOM_LIMIT_MAX("msContentZoomLimitMax", "-ms-content-zoom-limit-max", BrowserConfiguration.ie("400%")),
        MS_CONTENT_ZOOM_LIMIT_MIN("msContentZoomLimitMin", "-ms-content-zoom-limit-min", BrowserConfiguration.ie("100%")),
        MS_CONTENT_ZOOM_SNAP("msContentZoomSnap", "-ms-content-zoom-snap", BrowserConfiguration.ie("none snapInterval(0%, 100%)")),
        MS_CONTENT_ZOOM_SNAP_POINTS("msContentZoomSnapPoints", "-ms-content-zoom-snap-points", BrowserConfiguration.ie("snapInterval(0%, 100%)")),
        MS_CONTENT_ZOOM_SNAP_TYPE("msContentZoomSnapType", "-ms-content-zoom-snap-type", BrowserConfiguration.ie("none")),
        MS_CONTENT_ZOOMING("msContentZooming", "-ms-content-zooming", BrowserConfiguration.ie("none")),
        MS_FLEX("msFlex", "-ms-flex", BrowserConfiguration.ie("0 1 auto")),
        MS_FLEX_ALIGN("msFlexAlign", "-ms-flex-align", BrowserConfiguration.ie("stretch")),
        MS_FLEX_DIRECTION("msFlexDirection", "-ms-flex-direction", BrowserConfiguration.ie("row")),
        MS_FLEX_FLOW("msFlexFlow", "-ms-flex-flow", BrowserConfiguration.ie("row nowrap")),
        MS_FLEX_ITEM_ALIGN("msFlexItemAlign", "-ms-flex-item-align", BrowserConfiguration.ie("auto")),
        MS_FLEX_LINE_PACK("msFlexLinePack", "-ms-flex-line-pack", BrowserConfiguration.ie("stretch")),
        MS_FLEX_NEGATIVE("msFlexNegative", "-ms-flex-negative", BrowserConfiguration.ie("1")),
        MS_FLEX_ORDER("msFlexOrder", "-ms-flex-order", BrowserConfiguration.ie("0")),
        MS_FLEX_PACK("msFlexPack", "-ms-flex-pack", BrowserConfiguration.ie("start")),
        MS_FLEX_POSITIVE("msFlexPositive", "-ms-flex-positive", BrowserConfiguration.ie("0")),
        MS_FLEX_PREFERRED_SIZE("msFlexPreferredSize", "-ms-flex-preferred-size", BrowserConfiguration.ie("auto")),
        MS_FLEX_WRAP("msFlexWrap", "-ms-flex-wrap", BrowserConfiguration.ie("nowrap")),
        MS_FLOW_FROM("msFlowFrom", "-ms-flow-from", BrowserConfiguration.ie("none")),
        MS_FLOW_INTO("msFlowInto", "-ms-flow-into", BrowserConfiguration.ie("none")),
        MS_FONT_FEATURE_SETTINGS("msFontFeatureSettings", "-ms-font-feature-settings", BrowserConfiguration.ie("normal")),
        MS_GRID_COLUMN("msGridColumn", "-ms-grid-column", BrowserConfiguration.ie("1")),
        MS_GRID_COLUMN_ALIGN("msGridColumnAlign", "-ms-grid-column-align", BrowserConfiguration.ie("stretch")),
        MS_GRID_COLUMN_SPAN("msGridColumnSpan", "-ms-grid-column-span", BrowserConfiguration.ie("1")),
        MS_GRID_COLUMNS("msGridColumns", "-ms-grid-columns", BrowserConfiguration.ie("none")),
        MS_GRID_ROW("msGridRow", "-ms-grid-row", BrowserConfiguration.ie("1")),
        MS_GRID_ROW_ALIGN("msGridRowAlign", "-ms-grid-row-align", BrowserConfiguration.ie("stretch")),
        MS_GRID_ROW_SPAN("msGridRowSpan", "-ms-grid-row-span", BrowserConfiguration.ie("1")),
        MS_GRID_ROWS("msGridRows", "-ms-grid-rows", BrowserConfiguration.ie("none")),
        MS_HIGH_CONTRAST_ADJUST("msHighContrastAdjust", "-ms-high-contrast-adjust", BrowserConfiguration.ie("auto")),
        MS_HYPHENATE_LIMIT_CHARS("msHyphenateLimitChars", "-ms-hyphenate-limit-chars", BrowserConfiguration.ie("5 2 2")),
        MS_HYPHENATE_LIMIT_LINES("msHyphenateLimitLines", "-ms-hyphenate-limit-lines", BrowserConfiguration.ie("no-limit")),
        MS_HYPHENATE_LIMIT_ZONE("msHyphenateLimitZone", "-ms-hyphenate-limit-zone", BrowserConfiguration.ie("0px")),
        MS_HYPHENS("msHyphens", "-ms-hyphens", BrowserConfiguration.ie("manual")),
        MS_IME_ALIGN("msImeAlign", "-ms-ime-align", BrowserConfiguration.ie("")),
        MS_INTERPOLATION_MODE("msInterpolationMode", "-ms-interpolation-mode", BrowserConfiguration.ie("undefined")),
        MS_OVERFLOW_STYLE("msOverflowStyle", "-ms-overflow-style", BrowserConfiguration.ie("scrollbar")),
        MS_PERSPECTIVE("msPerspective", "-ms-perspective", BrowserConfiguration.ie("none")),
        MS_PERSPECTIVE_ORIGIN("msPerspectiveOrigin", "-ms-perspective-origin", BrowserConfiguration.ie("620px 163.2px")),
        MS_SCROLL_CHAINING("msScrollChaining", "-ms-scroll-chaining", BrowserConfiguration.ie("chained")),
        MS_SCROLL_LIMIT("msScrollLimit", "-ms-scroll-limit", BrowserConfiguration.ie("")),
        MS_SCROLL_LIMIT_X_MAX("msScrollLimitXMax", "-ms-scroll-limit-x-max", BrowserConfiguration.ie("0px")),
        MS_SCROLL_LIMIT_X_MIN("msScrollLimitXMin", "-ms-scroll-limit-x-min", BrowserConfiguration.ie("0px")),
        MS_SCROLL_LIMIT_Y_MAX("msScrollLimitYMax", "-ms-scroll-limit-y-max", BrowserConfiguration.ie("0px")),
        MS_SCROLL_LIMIT_Y_MIN("msScrollLimitYMin", "-ms-scroll-limit-y-min", BrowserConfiguration.ie("0px")),
        MS_SCROLL_RAILS("msScrollRails", "-ms-scroll-rails", BrowserConfiguration.ie("railed")),
        MS_SCROLL_SNAP_POINTS_X("msScrollSnapPointsX", "-ms-scroll-snap-points-x", BrowserConfiguration.ie("snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_POINTS_Y("msScrollSnapPointsY", "-ms-scroll-snap-points-y", BrowserConfiguration.ie("snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_TYPE("msScrollSnapType", "-ms-scroll-snap-type", BrowserConfiguration.ie("none")),
        MS_SCROLL_SNAP_X("msScrollSnapX", "-ms-scroll-snap-x", BrowserConfiguration.ie("none snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_Y("msScrollSnapY", "-ms-scroll-snap-y", BrowserConfiguration.ie("none snapInterval(0%, 100%)")),
        MS_SCROLL_TRANSLATION("msScrollTranslation", "-ms-scroll-translation", BrowserConfiguration.ie("none")),
        MS_TEXT_COMBINE_HORIZONTAL("msTextCombineHorizontal", "-ms-text-combine-horizontal", BrowserConfiguration.ie("none")),
        MS_TOUCH_ACTION("msTouchAction", "-ms-touch-action", BrowserConfiguration.ie("auto")),
        MS_TOUCH_SELECT("msTouchSelect", "-ms-touch-select", BrowserConfiguration.ie("")),
        MS_TRANSFORM("msTransform", "-ms-transform", BrowserConfiguration.ie("none")),
        MS_TRANSFORM_ORIGIN("msTransformOrigin", "-ms-transform-origin", BrowserConfiguration.ie("620px 163.2px")),
        MS_TRANSFORM_STYLE("msTransformStyle", "-ms-transform-style", BrowserConfiguration.ie("flat")),
        MS_TRANSITION("msTransition", "-ms-transition", BrowserConfiguration.ie("")),
        MS_TRANSITION_DELAY("msTransitionDelay", "-ms-transition-delay", BrowserConfiguration.ie("0s")),
        MS_TRANSITION_DURATION("msTransitionDuration", "-ms-transition-duration", BrowserConfiguration.ie("0s")),
        MS_TRANSITION_PROPERTY("msTransitionProperty", "-ms-transition-property", BrowserConfiguration.ie("all")),
        MS_TRANSITION_TIMING_FUNCTION("msTransitionTimingFunction", "-ms-transition-timing-function", BrowserConfiguration.ie("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MS_USER_SELECT("msUserSelect", "-ms-user-select", BrowserConfiguration.ie("text")),
        MS_WRAP_FLOW("msWrapFlow", "-ms-wrap-flow", BrowserConfiguration.ie("auto")),
        MS_WRAP_MARGIN("msWrapMargin", "-ms-wrap-margin", BrowserConfiguration.ie("auto")),
        MS_WRAP_THROUGH("msWrapThrough", "-ms-wrap-through", BrowserConfiguration.ie("wrap")),
        OBJECT_FIT("objectFit", "object-fit", BrowserConfiguration.ff("fill"), BrowserConfiguration.chrome("fill")),
        OBJECT_FIT_("object-fit", "object-fit", BrowserConfiguration.ff("fill")),
        OBJECT_POSITION("objectPosition", "object-position", BrowserConfiguration.ff("50% 50%"), BrowserConfiguration.chrome("50% 50%")),
        OBJECT_POSITION_("object-position", "object-position", BrowserConfiguration.ff("50% 50%")),
        OFFSET("offset", "offset", BrowserConfiguration.chrome("none 0px auto 0deg")),
        OFFSET_BLOCK_END("offsetBlockEnd", "offset-block-end", BrowserConfiguration.ff("")),
        OFFSET_BLOCK_END_("offset-block-end", "offset-block-end", BrowserConfiguration.ff("")),
        OFFSET_BLOCK_START("offsetBlockStart", "offset-block-start", BrowserConfiguration.ff("")),
        OFFSET_BLOCK_START_("offset-block-start", "offset-block-start", BrowserConfiguration.ff("")),
        OFFSET_DISTANCE("offsetDistance", "offsetDistance", BrowserConfiguration.chrome("0px")),
        OFFSET_INLINE_END("offsetInlineEnd", "offset-inline-end", BrowserConfiguration.ff("")),
        OFFSET_INLINE_END_("offset-inline-end", "offset-inline-end", BrowserConfiguration.ff("")),
        OFFSET_INLINE_START("offsetInlineStart", "offset-inline-start", BrowserConfiguration.ff("")),
        OFFSET_INLINE_START_("offset-inline-start", "offset-inline-start", BrowserConfiguration.ff("")),
        OFFSET_PATH("offsetPath", "offsetPath", BrowserConfiguration.chrome("none")),
        OFFSET_ROTATE("offsetRotate", "offsetRotate", BrowserConfiguration.chrome("auto 0deg")),
        OPACITY("opacity", "opacity", BrowserConfiguration.chrome("1"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        ORDER("order", "order", BrowserConfiguration.ff("0"), BrowserConfiguration.ie("0"), BrowserConfiguration.chrome("0")),
        ORIENTATION("orientation", "orientation", BrowserConfiguration.chrome("")),
        ORPHANS("orphans", "orphans", BrowserConfiguration.ie("2"), BrowserConfiguration.chrome("2")),
        OUTLINE("outline", "outline", BrowserConfiguration.chrome("rgb(0, 0, 0) none 0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        OUTLINE_COLOR("outlineColor", "outline-color", BrowserConfiguration.ie("transparent"), BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)")),
        OUTLINE_COLOR_("outline-color", "outline-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        OUTLINE_OFFSET("outlineOffset", "outline-offset", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px")),
        OUTLINE_OFFSET_("outline-offset", "outline-offset", BrowserConfiguration.ff("0px")),
        OUTLINE_STYLE("outlineStyle", "outline-style", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        OUTLINE_STYLE_("outline-style", "outline-style", BrowserConfiguration.ff("none")),
        OUTLINE_WIDTH("outlineWidth", "outline-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        OUTLINE_WIDTH_("outline-width", "outline-width", BrowserConfiguration.ff("0px")),
        OVERFLOW("overflow", "overflow", BrowserConfiguration.chrome("visible"), BrowserConfiguration.ff("visible"), BrowserConfiguration.ie("visible")),
        OVERFLOW_ANCHOR("overflowAnchor", "overflow-anchor", BrowserConfiguration.chrome("auto")),
        OVERFLOW_WRAP("overflowWrap", "overflow-wrap", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal")),
        OVERFLOW_WRAP_("overflow-wrap", "overflow-wrap", BrowserConfiguration.ff("normal")),
        OVERFLOW_X("overflowX", "overflow-x", BrowserConfiguration.chrome("visible"), BrowserConfiguration.ff("visible"), BrowserConfiguration.ie("visible")),
        OVERFLOW_X_("overflow-x", "overflow-x", BrowserConfiguration.ff("visible")),
        OVERFLOW_Y("overflowY", "overflow-y", BrowserConfiguration.chrome("visible"), BrowserConfiguration.ff("visible"), BrowserConfiguration.ie("visible")),
        OVERFLOW_Y_("overflow-y", "overflow-y", BrowserConfiguration.ff("visible")),
        OVERSCROLL_BEHAVIOR("overscrollBehavior", "overscroll-behavior", BrowserConfiguration.chrome("auto auto"), BrowserConfiguration.ff60up("")),
        OVERSCROLL_BEHAVIOR_("overscroll-behavior", "overscroll-behavior", BrowserConfiguration.ff60up("")),
        OVERSCROLL_BEHAVIOR_X("overscrollBehaviorX", "overscroll-behavior-x", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff60up("auto")),
        OVERSCROLL_BEHAVIOR_X_("overscroll-behavior-x", "overscroll-behavior-x", BrowserConfiguration.ff60up("auto")),
        OVERSCROLL_BEHAVIOR_Y("overscrollBehaviorY", "overscroll-behavior-y", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff60up("auto")),
        OVERSCROLL_BEHAVIOR_Y_("overscroll-behavior-y", "overscroll-behavior-y", BrowserConfiguration.ff60up("auto")),
        PADDING("padding", "padding", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        PADDING_BLOCK_END("paddingBlockEnd", "padding-block-end", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        PADDING_BLOCK_END_("padding-block-end", "padding-block-end", BrowserConfiguration.ff("")),
        PADDING_BLOCK_START("paddingBlockStart", "padding-block-start", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        PADDING_BLOCK_START_("padding-block-start", "padding-block-start", BrowserConfiguration.ff("")),
        PADDING_BOTTOM("paddingBottom", "padding-bottom", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        PADDING_BOTTOM_("padding-bottom", "padding-bottom", BrowserConfiguration.ff("0px")),
        PADDING_INLINE_END("paddingInlineEnd", "padding-inline-end", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        PADDING_INLINE_END_("padding-inline-end", "padding-inline-end", BrowserConfiguration.ff("")),
        PADDING_INLINE_START("paddingInlineStart", "padding-inline-start", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        PADDING_INLINE_START_("padding-inline-start", "padding-inline-start", BrowserConfiguration.ff("")),
        PADDING_LEFT("paddingLeft", "padding-left", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        PADDING_LEFT_("padding-left", "padding-left", BrowserConfiguration.ff("0px")),
        PADDING_RIGHT("paddingRight", "padding-right", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        PADDING_RIGHT_("padding-right", "padding-right", BrowserConfiguration.ff("0px")),
        PADDING_TOP("paddingTop", "padding-top", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        PADDING_TOP_("padding-top", "padding-top", BrowserConfiguration.ff("0px")),
        PAGE("page", "page", BrowserConfiguration.chrome("")),
        PAGE_BREAK_AFTER("pageBreakAfter", "page-break-after", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto")),
        PAGE_BREAK_AFTER_("page-break-after", "page-break-after", BrowserConfiguration.ff("auto")),
        PAGE_BREAK_BEFORE("pageBreakBefore", "page-break-before", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto")),
        PAGE_BREAK_BEFORE_("page-break-before", "page-break-before", BrowserConfiguration.ff("auto")),
        PAGE_BREAK_INSIDE("pageBreakInside", "page-break-inside", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto")),
        PAGE_BREAK_INSIDE_("page-break-inside", "page-break-inside", BrowserConfiguration.ff("auto")),
        PAINT_ORDER("paintOrder", "paint-order", BrowserConfiguration.ff("normal"), BrowserConfiguration.chrome("normal")),
        PAINT_ORDER_("paint-order", "paint-order", BrowserConfiguration.ff("normal")),
        PAUSE("pause", "pause", new BrowserConfiguration[0]),
        PAUSE_AFTER("pauseAfter", "pause-after", new BrowserConfiguration[0]),
        PAUSE_BEFORE("pauseBefore", "pause-before", new BrowserConfiguration[0]),
        PERSPECTIVE("perspective", "perspective", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        PERSPECTIVE_ORIGIN("perspectiveOrigin", "perspective-origin", BrowserConfiguration.ff("625px 172.5px"), BrowserConfiguration.ie("620px 163.2px"), BrowserConfiguration.chrome("456.5px 161px")),
        PERSPECTIVE_ORIGIN_("perspective-origin", "perspective-origin", BrowserConfiguration.ff("625px 172.5px")),
        PITCH("pitch", "pitch", new BrowserConfiguration[0]),
        PITCH_RANGE("pitchRange", "pitch-range", new BrowserConfiguration[0]),
        PIXEL_BOTTOM("pixelBottom", "pixel-bottom", BrowserConfiguration.ie("")),
        PIXEL_HEIGHT("pixelHeight", "pixel-height", BrowserConfiguration.ie("")),
        PIXEL_LEFT("pixelLeft", "pixel-left", BrowserConfiguration.ie("")),
        PIXEL_RIGHT("pixelRight", "pixel-right", BrowserConfiguration.ie("")),
        PIXEL_TOP("pixelTop", "pixel-top", BrowserConfiguration.ie("")),
        PIXEL_WIDTH("pixelWidth", "pixel-width", BrowserConfiguration.ie("")),
        PLACE_CONTENT("placeContent", "place-content", BrowserConfiguration.chrome("normal normal"), BrowserConfiguration.ff("")),
        PLACE_CONTENT_("place-content", "place-content", BrowserConfiguration.ff("")),
        PLACE_ITEMS("placeItems", "place-items", BrowserConfiguration.chrome("normal normal"), BrowserConfiguration.ff("")),
        PLACE_ITEMS_("place-items", "place-items", BrowserConfiguration.ff("")),
        PLACE_SELF("placeSelf", "place-self", BrowserConfiguration.chrome("auto auto"), BrowserConfiguration.ff("")),
        PLACE_SELF_("place-self", "place-self", BrowserConfiguration.ff("")),
        POINTER_EVENTS("pointerEvents", "pointer-events", BrowserConfiguration.ie("visiblePainted"), BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        POINTER_EVENTS_("pointer-events", "pointer-events", BrowserConfiguration.ff("auto")),
        POS_BOTTOM("posBottom", "pos-bottom", BrowserConfiguration.ie("")),
        POS_HEIGHT("posHeight", "pos-height", BrowserConfiguration.ie("")),
        POS_LEFT("posLeft", "pos-left", BrowserConfiguration.ie("")),
        POS_RIGHT("posRight", "pos-right", BrowserConfiguration.ie("")),
        POS_TOP("posTop", "pos-top", BrowserConfiguration.ie("")),
        POS_WIDTH("posWidth", "pos-width", BrowserConfiguration.ie("")),
        POSITION("position", "position", BrowserConfiguration.chrome("static"), BrowserConfiguration.ff("static"), BrowserConfiguration.ie("static")),
        QUOTES("quotes", "quotes", BrowserConfiguration.ff("\"\u201c\" \"\u201d\" \"\u2018\" \"\u2019\""), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("")),
        R("r", "r", BrowserConfiguration.chrome("0px")),
        RESIZE("resize", "resize", BrowserConfiguration.ff("none"), BrowserConfiguration.chrome("none")),
        RICHNESS("richness", "richness", new BrowserConfiguration[0]),
        RIGHT("right", "right", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        ROW_GAP("rowGap", "rowGap", BrowserConfiguration.chrome("normal")),
        RUBY_ALIGN("rubyAlign", "ruby-align", BrowserConfiguration.ff("space-around"), BrowserConfiguration.ie("")),
        RUBY_ALIGN_("ruby-align", "ruby-align", BrowserConfiguration.ff("space-around")),
        RUBY_OVERHANG("rubyOverhang", "ruby-overhang", BrowserConfiguration.ie("auto")),
        RUBY_POSITION("rubyPosition", "ruby-position", BrowserConfiguration.ie("above"), BrowserConfiguration.ff("over")),
        RUBY_POSITION_("ruby-position", "ruby-position", BrowserConfiguration.ff("over")),
        RX("rx", "rx", BrowserConfiguration.chrome("auto")),
        RY("ry", "ry", BrowserConfiguration.chrome("auto")),
        SCROLL_BEHAVIOR("scrollBehavior", "scroll-behavior", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        SCROLL_BEHAVIOR_("scroll-behavior", "scroll-behavior", BrowserConfiguration.ff("auto")),
        SCROLL_MARGIN("scrollMargin", "scroll-margin", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_BLOCK("scrollMarginBlock", "scroll-margin-block", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_BLOCK_END("scrollMarginBlockEnd", "scroll-margin-block-end", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_BLOCK_START("scrollMarginBlockStart", "scroll-margin-block-start", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_BOTTOM("scrollMarginBottom", "scroll-margin-bottom", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_INLINE("scrollMarginInline", "scroll-margin-inline", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_INLINE_END("scrollMarginInlineEnd", "scroll-margin-inline-end", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_INLINE_START("scrollMarginInlineStart", "scroll-margin-inline-start", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_LEFT("scrollMarginLeft", "scroll-margin-left", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_RIGHT("scrollMarginRight", "scroll-margin-right", BrowserConfiguration.chrome("0px")),
        SCROLL_MARGIN_TOP("scrollMarginTop", "scroll-margin-top", BrowserConfiguration.chrome("0px")),
        SCROLL_PADDING("scrollPadding", "scroll-padding", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_BLOCK("scrollPaddingBlock", "scroll-padding-block", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_BLOCK_END("scrollPaddingBlockEnd", "scroll-padding-block-end", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_BLOCK_START("scrollPaddingBlockStart", "scroll-padding-block-start", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_BOTTOM("scrollPaddingBottom", "scroll-padding-bottom", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_INLINE("scrollPaddingInline", "scroll-padding-inline", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_INLINE_END("scrollPaddingInlineEnd", "scroll-padding-inline-end", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_INLINE_START("scrollPaddingInlineStart", "scroll-padding-inline-start", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_LEFT("scrollPaddingLeft", "scroll-padding-left", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_RIGHT("scrollPaddingRight", "scroll-padding-right", BrowserConfiguration.chrome("auto")),
        SCROLL_PADDING_TOP("scrollPaddingTop", "scroll-padding-top", BrowserConfiguration.chrome("auto")),
        SCROLL_SNAP_ALIGN("scrollSnapAlign", "scroll-snap-align", BrowserConfiguration.chrome("none")),
        SCROLL_SNAP_COORDINATE("scrollSnapCoordinate", "scroll-snap-coordinate", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_COORDINATE_("scroll-snap-coordinate", "scroll-snap-coordinate", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_DESTINATION("scrollSnapDestination", "scroll-snap-destination", BrowserConfiguration.ff("0px 0px")),
        SCROLL_SNAP_DESTINATION_("scroll-snap-destination", "scroll-snap-destination", BrowserConfiguration.ff("0px 0px")),
        SCROLL_SNAP_POINTS_X("scrollSnapPointsX", "scroll-snap-points-x", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_POINTS_X_("scroll-snap-points-x", "scroll-snap-points-x", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_POINTS_Y("scrollSnapPointsY", "scroll-snap-points-y", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_POINTS_Y_("scroll-snap-points-y", "scroll-snap-points-y", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_STOP("scrollSnapStop", "scroll-snap-stop", BrowserConfiguration.chrome("normal")),
        SCROLL_SNAP_TYPE("scrollSnapType", "scroll-snap-type", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("")),
        SCROLL_SNAP_TYPE_("scroll-snap-type", "scroll-snap-type", BrowserConfiguration.ff("")),
        SCROLL_SNAP_TYPE_X("scrollSnapTypeX", "scroll-snap-type-x", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_TYPE_X_("scroll-snap-type-x", "scroll-snap-type-x", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_TYPE_Y("scrollSnapTypeY", "scroll-snap-type-y", BrowserConfiguration.ff("none")),
        SCROLL_SNAP_TYPE_Y_("scroll-snap-type-y", "scroll-snap-type-y", BrowserConfiguration.ff("none")),
        SCROLLBAR_3DLIGHT_COLOR("scrollbar3dLightColor", "scrollbar-3dlight-color", BrowserConfiguration.ie("undefined")),
        SCROLLBAR_ARROW_COLOR("scrollbarArrowColor", "scrollbar-arrow-color", BrowserConfiguration.ie("undefined")),
        SCROLLBAR_BASE_COLOR("scrollbarBaseColor", "scrollbar-base-color", BrowserConfiguration.ie("undefined")),
        SCROLLBAR_DARKSHADOW_COLOR("scrollbarDarkShadowColor", "scrollbar-darkshadow-color", BrowserConfiguration.ie("undefined")),
        SCROLLBAR_FACE_COLOR("scrollbarFaceColor", "scrollbar-face-color", BrowserConfiguration.ie("undefined")),
        SCROLLBAR_HIGHLIGHT_COLOR("scrollbarHighlightColor", "scrollbar-highlight-color", BrowserConfiguration.ie("undefined")),
        SCROLLBAR_SHADOW_COLOR("scrollbarShadowColor", "scrollbar-shadow-color", BrowserConfiguration.ie("undefined")),
        SCROLLBAR_TRACK_COLOR("scrollbarTrackColor", "scrollbar-track-color", BrowserConfiguration.ie("undefined")),
        SHAPE_IMAGE_THRESHOLD("shapeImageThreshold", "shape-image-threshold", BrowserConfiguration.chrome("0")),
        SHAPE_MARGIN("shapeMargin", "shape-margin", BrowserConfiguration.chrome("0px")),
        SHAPE_OUTSIDE("shapeOutside", "shape-outside", BrowserConfiguration.chrome("none")),
        SHAPE_RENDERING("shapeRendering", "shape-rendering", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        SHAPE_RENDERING_("shape-rendering", "shape-rendering", BrowserConfiguration.ff("auto")),
        SIZE("size", "size", BrowserConfiguration.chrome("")),
        SPEAK("speak", "speak", BrowserConfiguration.chrome("normal")),
        SPEAK_HEADER("speakHeader", "speak-header", new BrowserConfiguration[0]),
        SPEAK_NUMERAL("speakNumeral", "speak-numeral", new BrowserConfiguration[0]),
        SPEAK_PUNCTUATION("speakPunctuation", "speak-punctuation", new BrowserConfiguration[0]),
        SPEECH_RATE("speechRate", "speech-rate", new BrowserConfiguration[0]),
        SRC("src", "src", BrowserConfiguration.chrome("")),
        STOP_COLOR("stopColor", "stop-color", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        STOP_COLOR_("stop-color", "stop-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        STOP_OPACITY("stopOpacity", "stop-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie("1"), BrowserConfiguration.chrome("1")),
        STOP_OPACITY_("stop-opacity", "stop-opacity", BrowserConfiguration.ff("1")),
        STRESS("stress", "stress", new BrowserConfiguration[0]),
        STROKE("stroke", "stroke", BrowserConfiguration.ff("none"), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("none")),
        STROKE_DASHARRAY("strokeDasharray", "stroke-dasharray", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        STROKE_DASHARRAY_("stroke-dasharray", "stroke-dasharray", BrowserConfiguration.ff("none")),
        STROKE_DASHOFFSET("strokeDashoffset", "stroke-dashoffset", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px"), BrowserConfiguration.chrome("0px")),
        STROKE_DASHOFFSET_("stroke-dashoffset", "stroke-dashoffset", BrowserConfiguration.ff("0px")),
        STROKE_LINECAP("strokeLinecap", "stroke-linecap", BrowserConfiguration.ff("butt"), BrowserConfiguration.ie("butt"), BrowserConfiguration.chrome("butt")),
        STROKE_LINECAP_("stroke-linecap", "stroke-linecap", BrowserConfiguration.ff("butt")),
        STROKE_LINEJOIN("strokeLinejoin", "stroke-linejoin", BrowserConfiguration.ff("miter"), BrowserConfiguration.ie("miter"), BrowserConfiguration.chrome("miter")),
        STROKE_LINEJOIN_("stroke-linejoin", "stroke-linejoin", BrowserConfiguration.ff("miter")),
        STROKE_MITERLIMIT("strokeMiterlimit", "stroke-miterlimit", BrowserConfiguration.ff("4"), BrowserConfiguration.ie("4"), BrowserConfiguration.chrome("4")),
        STROKE_MITERLIMIT_("stroke-miterlimit", "stroke-miterlimit", BrowserConfiguration.ff("4")),
        STROKE_OPACITY("strokeOpacity", "stroke-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie("1"), BrowserConfiguration.chrome("1")),
        STROKE_OPACITY_("stroke-opacity", "stroke-opacity", BrowserConfiguration.ff("1")),
        STROKE_WIDTH("strokeWidth", "stroke-width", BrowserConfiguration.ff("1px"), BrowserConfiguration.ie("0.01px"), BrowserConfiguration.chrome("1px")),
        STROKE_WIDTH_("stroke-width", "stroke-width", BrowserConfiguration.ff("1px")),
        STYLE_FLOAT("styleFloat", "style-float", BrowserConfiguration.ie("undefined")),
        TAB_SIZE("tabSize", "tab-size", BrowserConfiguration.chrome("8")),
        TABLE_LAYOUT("tableLayout", "table-layout", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto")),
        TABLE_LAYOUT_("table-layout", "table-layout", BrowserConfiguration.ff("auto")),
        TEXT_ALIGN("textAlign", "text-align", BrowserConfiguration.ie("left"), BrowserConfiguration.chrome("start"), BrowserConfiguration.ff("start")),
        TEXT_ALIGN_("text-align", "text-align", BrowserConfiguration.ff("start")),
        TEXT_ALIGN_LAST("textAlignLast", "text-align-last", BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        TEXT_ALIGN_LAST_("text-align-last", "text-align-last", BrowserConfiguration.ff("auto")),
        TEXT_ANCHOR("textAnchor", "text-anchor", BrowserConfiguration.ff("start"), BrowserConfiguration.ie("start"), BrowserConfiguration.chrome("start")),
        TEXT_ANCHOR_("text-anchor", "text-anchor", BrowserConfiguration.ff("start")),
        TEXT_AUTOSPACE("textAutospace", "text-autospace", BrowserConfiguration.ie("undefined")),
        TEXT_COMBINE_UPRIGHT("textCombineUpright", "text-combine-upright", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        TEXT_COMBINE_UPRIGHT_("text-combine-upright", "text-combine-upright", BrowserConfiguration.ff("none")),
        TEXT_DECORATION("textDecoration", "text-decoration", BrowserConfiguration.chrome("none solid rgb(0, 0, 0)"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        TEXT_DECORATION_("text-decoration", "text-decoration", BrowserConfiguration.ff("none")),
        TEXT_DECORATION_BLINK("textDecorationBlink", "text-decoration-blink", BrowserConfiguration.ie("false")),
        TEXT_DECORATION_COLOR("textDecorationColor", "text-decoration-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)")),
        TEXT_DECORATION_COLOR_("text-decoration-color", "text-decoration-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        TEXT_DECORATION_LINE("textDecorationLine", "text-decoration-line", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        TEXT_DECORATION_LINE_("text-decoration-line", "text-decoration-line", BrowserConfiguration.ff("none")),
        TEXT_DECORATION_LINE_THROUGH("textDecorationLineThrough", "text-decoration-line-through", BrowserConfiguration.ie("false")),
        TEXT_DECORATION_NONE("textDecorationNone", "text-decoration-none", BrowserConfiguration.ie("false")),
        TEXT_DECORATION_OVERLINE("textDecorationOverline", "text-decoration-overline", BrowserConfiguration.ie("false")),
        TEXT_DECORATION_SKIP("textDecorationSkipInk", "text-decoration-skip-ink", BrowserConfiguration.chrome("auto")),
        TEXT_DECORATION_STYLE("textDecorationStyle", "text-decoration-style", BrowserConfiguration.chrome("solid"), BrowserConfiguration.ff("solid")),
        TEXT_DECORATION_STYLE_("text-decoration-style", "text-decoration-style", BrowserConfiguration.ff("solid")),
        TEXT_DECORATION_UNDERLINE("textDecorationUnderline", "text-decoration-underline", BrowserConfiguration.ie("false")),
        TEXT_EMPHASIS("textEmphasis", "text-emphasis", BrowserConfiguration.ff("")),
        TEXT_EMPHASIS_("text-emphasis", "text-emphasis", BrowserConfiguration.ff("")),
        TEXT_EMPHASIS_COLOR("textEmphasisColor", "text-emphasis-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        TEXT_EMPHASIS_COLOR_("text-emphasis-color", "text-emphasis-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        TEXT_EMPHASIS_POSITION("textEmphasisPosition", "text-emphasis-position", BrowserConfiguration.ff("over right")),
        TEXT_EMPHASIS_POSITION_("text-emphasis-position", "text-emphasis-position", BrowserConfiguration.ff("over right")),
        TEXT_EMPHASIS_STYLE("textEmphasisStyle", "text-emphasis-style", BrowserConfiguration.ff("none")),
        TEXT_EMPHASIS_STYLE_("text-emphasis-style", "text-emphasis-style", BrowserConfiguration.ff("none")),
        TEXT_INDENT("textIndent", "text-indent", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        TEXT_INDENT_("text-indent", "text-indent", BrowserConfiguration.ff("0px")),
        TEXT_JUSTIFY("textJustify", "text-justify", BrowserConfiguration.ie("auto"), BrowserConfiguration.ff60up("auto")),
        TEXT_JUSTIFY_("text-justify", "text-justify", BrowserConfiguration.ff60up("auto")),
        TEXT_JUSTIFY_TRIM("textJustifyTrim", "text-justify-trim", BrowserConfiguration.ie("undefined")),
        TEXT_KASHIDA("textKashida", "text-kashida", BrowserConfiguration.ie("undefined")),
        TEXT_KASHIDA_SPACE("textKashidaSpace", "text-kashida-space", BrowserConfiguration.ie("undefined")),
        TEXT_ORIENTATION("textOrientation", "text-orientation", BrowserConfiguration.chrome("mixed"), BrowserConfiguration.ff("mixed")),
        TEXT_ORIENTATION_("text-orientation", "text-orientation", BrowserConfiguration.ff("mixed")),
        TEXT_OVERFLOW("textOverflow", "text-overflow", BrowserConfiguration.ff("clip"), BrowserConfiguration.ie("clip"), BrowserConfiguration.chrome("clip")),
        TEXT_OVERFLOW_("text-overflow", "text-overflow", BrowserConfiguration.ff("clip")),
        TEXT_RENDERING("textRendering", "text-rendering", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        TEXT_RENDERING_("text-rendering", "text-rendering", BrowserConfiguration.ff("auto")),
        TEXT_SHADOW("textShadow", "text-shadow", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        TEXT_SHADOW_("text-shadow", "text-shadow", BrowserConfiguration.ff("none")),
        TEXT_SIZE_ADJUST("textSizeAdjust", "text-size-adjust", BrowserConfiguration.chrome("auto")),
        TEXT_TRANSFORM("textTransform", "text-transform", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none")),
        TEXT_TRANSFORM_("text-transform", "text-transform", BrowserConfiguration.ff("none")),
        TEXT_UNDERLINE_POSITION("textUnderlinePosition", "text-underline-position", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ie("auto")),
        TOP("top", "top", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto")),
        TOUCH_ACTION("touchAction", "touch-action", BrowserConfiguration.ie("auto"), BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        TOUCH_ACTION_("touch-action", "touch-action", BrowserConfiguration.ff("auto")),
        TRANSFORM("transform", "transform", BrowserConfiguration.ff("none"), BrowserConfiguration.ie("none"), BrowserConfiguration.chrome("none")),
        TRANSFORM_BOX("transformBox", "transform-box", BrowserConfiguration.chrome("view-box"), BrowserConfiguration.ff60up("border-box")),
        TRANSFORM_BOX_("transform-box", "transform-box", BrowserConfiguration.ff60up("border-box")),
        TRANSFORM_ORIGIN("transformOrigin", "transform-origin", BrowserConfiguration.ff("625px 172.5px"), BrowserConfiguration.ie("620px 163.2px"), BrowserConfiguration.chrome("456.5px 161px")),
        TRANSFORM_ORIGIN_("transform-origin", "transform-origin", BrowserConfiguration.ff("625px 172.5px")),
        TRANSFORM_STYLE("transformStyle", "transform-style", BrowserConfiguration.ff("flat"), BrowserConfiguration.ie("flat"), BrowserConfiguration.chrome("flat")),
        TRANSFORM_STYLE_("transform-style", "transform-style", BrowserConfiguration.ff("flat")),
        TRANSITION("transition", "transition", BrowserConfiguration.ff(""), BrowserConfiguration.ie(""), BrowserConfiguration.chrome("all 0s ease 0s")),
        TRANSITION_DELAY("transitionDelay", "transition-delay", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie("0s"), BrowserConfiguration.chrome("0s")),
        TRANSITION_DELAY_("transition-delay", "transition-delay", BrowserConfiguration.ff("0s")),
        TRANSITION_DURATION("transitionDuration", "transition-duration", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie("0s"), BrowserConfiguration.chrome("0s")),
        TRANSITION_DURATION_("transition-duration", "transition-duration", BrowserConfiguration.ff("0s")),
        TRANSITION_PROPERTY("transitionProperty", "transition-property", BrowserConfiguration.ff("all"), BrowserConfiguration.ie("all"), BrowserConfiguration.chrome("all")),
        TRANSITION_PROPERTY_("transition-property", "transition-property", BrowserConfiguration.ff("all")),
        TRANSITION_TIMING_FUNCTION("transitionTimingFunction", "transition-timing-function", BrowserConfiguration.ff("ease"), BrowserConfiguration.ie("cubic-bezier(0.25, 0.1, 0.25, 1)"), BrowserConfiguration.chrome("ease")),
        TRANSITION_TIMING_FUNCTION_("transition-timing-function", "transition-timing-function", BrowserConfiguration.ff("ease")),
        UNICODE_BIDI("unicodeBidi", "unicode-bidi", BrowserConfiguration.ff("isolate"), BrowserConfiguration.ie("normal"), BrowserConfiguration.chrome("normal")),
        UNICODE_BIDI_("unicode-bidi", "unicode-bidi", BrowserConfiguration.ff("isolate")),
        UNICODE_RANGE("unicodeRange", "unicode-range", BrowserConfiguration.chrome("")),
        USER_SELECT("userSelect", "user-select", BrowserConfiguration.chrome("auto")),
        USER_ZOOM("userZoom", "user-zoom", BrowserConfiguration.chrome("")),
        VECTOR_EFFECT("vectorEffect", "vector-effect", BrowserConfiguration.ff("none"), BrowserConfiguration.chrome("none")),
        VECTOR_EFFECT_("vector-effect", "vector-effect", BrowserConfiguration.ff("none")),
        VERTICAL_ALIGN("verticalAlign", "vertical-align", BrowserConfiguration.chrome("baseline"), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        VERTICAL_ALIGN_("vertical-align", "vertical-align", BrowserConfiguration.ff("baseline")),
        VISIBILITY("visibility", "visibility", BrowserConfiguration.chrome("visible"), BrowserConfiguration.ff("visible"), BrowserConfiguration.ie("visible")),
        VOICE_FAMILY("voiceFamily", "voice-family", new BrowserConfiguration[0]),
        VOLUME("volume", "volume", new BrowserConfiguration[0]),
        WEBKIT_ALIGN_CONTENT("webkitAlignContent", "webkit-align-content", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal")),
        WEBKIT_ALIGN_CONTENT_("WebkitAlignContent", "webkit-align-content", BrowserConfiguration.ff("normal")),
        WEBKIT_ALIGN_CONTENT__("-webkit-align-content", "webkit-align-content", BrowserConfiguration.ff("normal")),
        WEBKIT_ALIGN_ITEMS("webkitAlignItems", "webkit-align-items", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal")),
        WEBKIT_ALIGN_ITEMS_("WebkitAlignItems", "webkit-align-items", BrowserConfiguration.ff("normal")),
        WEBKIT_ALIGN_ITEMS__("-webkit-align-items", "webkit-align-items", BrowserConfiguration.ff("normal")),
        WEBKIT_ALIGN_SELF("webkitAlignSelf", "webkit-align-self", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        WEBKIT_ALIGN_SELF_("WebkitAlignSelf", "webkit-align-self", BrowserConfiguration.ff("auto")),
        WEBKIT_ALIGN_SELF__("-webkit-align-self", "webkit-align-self", BrowserConfiguration.ff("auto")),
        WEBKIT_ANIMATION("webkitAnimation", "webkit-animation", BrowserConfiguration.chrome("none 0s ease 0s 1 normal none running"), BrowserConfiguration.ff("")),
        WEBKIT_ANIMATION_("WebkitAnimation", "webkit-animation", BrowserConfiguration.ff("")),
        WEBKIT_ANIMATION__("-webkit-animation", "webkit-animation", BrowserConfiguration.ff("")),
        WEBKIT_ANIMATION_DELAY("webkitAnimationDelay", "webkit-animation-delay", BrowserConfiguration.chrome("0s"), BrowserConfiguration.ff("0s")),
        WEBKIT_ANIMATION_DELAY_("WebkitAnimationDelay", "webkit-animation-delay", BrowserConfiguration.ff("0s")),
        WEBKIT_ANIMATION_DELAY__("-webkit-animation-delay", "webkit-animation-delay", BrowserConfiguration.ff("0s")),
        WEBKIT_ANIMATION_DIRECTION("webkitAnimationDirection", "webkit-animation-direction", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal")),
        WEBKIT_ANIMATION_DIRECTION_("WebkitAnimationDirection", "webkit-animation-direction", BrowserConfiguration.ff("normal")),
        WEBKIT_ANIMATION_DIRECTION__("-webkit-animation-direction", "webkit-animation-direction", BrowserConfiguration.ff("normal")),
        WEBKIT_ANIMATION_DURATION("webkitAnimationDuration", "webkit-animation-duration", BrowserConfiguration.chrome("0s"), BrowserConfiguration.ff("0s")),
        WEBKIT_ANIMATION_DURATION_("WebkitAnimationDuration", "webkit-animation-duration", BrowserConfiguration.ff("0s")),
        WEBKIT_ANIMATION_DURATION__("-webkit-animation-duration", "webkit-animation-duration", BrowserConfiguration.ff("0s")),
        WEBKIT_ANIMATION_FILL_MODE("webkitAnimationFillMode", "webkit-animation-fill-mode", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        WEBKIT_ANIMATION_FILL_MODE_("WebkitAnimationFillMode", "webkit-animation-fill-mode", BrowserConfiguration.ff("none")),
        WEBKIT_ANIMATION_FILL_MODE__("-webkit-animation-fill-mode", "webkit-animation-fill-mode", BrowserConfiguration.ff("none")),
        WEBKIT_ANIMATION_ITERATION_COUNT("webkitAnimationIterationCount", "webkit-animation-iteration-count", BrowserConfiguration.chrome("1"), BrowserConfiguration.ff("1")),
        WEBKIT_ANIMATION_ITERATION_COUNT_("WebkitAnimationIterationCount", "webkit-animation-iteration-count", BrowserConfiguration.ff("1")),
        WEBKIT_ANIMATION_ITERATION_COUNT__("-webkit-animation-iteration-count", "webkit-animation-iteration-count", BrowserConfiguration.ff("1")),
        WEBKIT_ANIMATION_NAME("webkitAnimationName", "webkit-animation-name", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        WEBKIT_ANIMATION_NAME_("WebkitAnimationName", "webkit-animation-name", BrowserConfiguration.ff("none")),
        WEBKIT_ANIMATION_NAME__("-webkit-animation-name", "webkit-animation-name", BrowserConfiguration.ff("none")),
        WEBKIT_ANIMATION_PLAY_STATE("webkitAnimationPlayState", "webkit-animation-play-state", BrowserConfiguration.chrome("running"), BrowserConfiguration.ff("running")),
        WEBKIT_ANIMATION_PLAY_STATE_("WebkitAnimationPlayState", "webkit-animation-play-state", BrowserConfiguration.ff("running")),
        WEBKIT_ANIMATION_PLAY_STATE__("-webkit-animation-play-state", "webkit-animation-play-state", BrowserConfiguration.ff("running")),
        WEBKIT_ANIMATION_TIMING_FUNCTION("webkitAnimationTimingFunction", "webkit-animation-timing-function", BrowserConfiguration.chrome("ease"), BrowserConfiguration.ff("ease")),
        WEBKIT_ANIMATION_TIMING_FUNCTION_("WebkitAnimationTimingFunction", "webkit-animation-timing-function", BrowserConfiguration.ff("ease")),
        WEBKIT_ANIMATION_TIMING_FUNCTION__("-webkit-animation-timing-function", "webkit-animation-timing-function", BrowserConfiguration.ff("ease")),
        WEBKIT_APP_REGION("webkitAppRegion", "webkit-app-region", BrowserConfiguration.chrome("none")),
        WEBKIT_APPEARANCE("webkitAppearance", "webkit-appearance", BrowserConfiguration.chrome("none")),
        WEBKIT_BACKFACE_VISIBILITY("webkitBackfaceVisibility", "webkit-backface-visibility", BrowserConfiguration.chrome("visible"), BrowserConfiguration.ff("visible")),
        WEBKIT_BACKFACE_VISIBILITY_("WebkitBackfaceVisibility", "webkit-backface-visibility", BrowserConfiguration.ff("visible")),
        WEBKIT_BACKFACE_VISIBILITY__("-webkit-backface-visibility", "webkit-backface-visibility", BrowserConfiguration.ff("visible")),
        WEBKIT_BACKGROUND_CLIP("webkitBackgroundClip", "webkit-background-clip", BrowserConfiguration.chrome("border-box"), BrowserConfiguration.ff("border-box")),
        WEBKIT_BACKGROUND_CLIP_("WebkitBackgroundClip", "webkit-background-clip", BrowserConfiguration.ff("border-box")),
        WEBKIT_BACKGROUND_CLIP__("-webkit-background-clip", "webkit-background-clip", BrowserConfiguration.ff("border-box")),
        WEBKIT_BACKGROUND_ORIGIN("webkitBackgroundOrigin", "webkit-background-origin", BrowserConfiguration.chrome("padding-box"), BrowserConfiguration.ff("padding-box")),
        WEBKIT_BACKGROUND_ORIGIN_("WebkitBackgroundOrigin", "webkit-background-origin", BrowserConfiguration.ff("padding-box")),
        WEBKIT_BACKGROUND_ORIGIN__("-webkit-background-origin", "webkit-background-origin", BrowserConfiguration.ff("padding-box")),
        WEBKIT_BACKGROUND_SIZE("webkitBackgroundSize", "webkit-background-size", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto auto")),
        WEBKIT_BACKGROUND_SIZE_("WebkitBackgroundSize", "webkit-background-size", BrowserConfiguration.ff("auto auto")),
        WEBKIT_BACKGROUND_SIZE__("-webkit-background-size", "webkit-background-size", BrowserConfiguration.ff("auto auto")),
        WEBKIT_BORDER_AFTER("webkitBorderAfter", "webkit-border-after", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_BORDER_AFTER_COLOR("webkitBorderAfterColor", "webkit-border-after-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_BORDER_AFTER_STYLE("webkitBorderAfterStyle", "webkit-border-after-style", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_AFTER_WIDTH("webkitBorderAfterWidth", "webkit-border-after-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_BEFORE("webkitBorderBefore", "webkit-border-before", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_BORDER_BEFORE_COLOR("webkitBorderBeforeColor", "webkit-border-before-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_BORDER_BEFORE_STYLE("webkitBorderBeforeStyle", "webkit-border-before-style", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_BEFORE_WIDTH("webkitBorderBeforeWidth", "webkit-border-before-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_BOTTOM_LEFT_RADIUS("webkitBorderBottomLeftRadius", "webkit-border-bottom-left-radius", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_BOTTOM_LEFT_RADIUS_("WebkitBorderBottomLeftRadius", "webkit-border-bottom-left-radius", BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_BOTTOM_LEFT_RADIUS__("-webkit-border-bottom-left-radius", "webkit-border-bottom-left-radius", BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_BOTTOM_RIGHT_RADIUS("webkitBorderBottomRightRadius", "webkit-border-bottom-right-radius", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_BOTTOM_RIGHT_RADIUS_("WebkitBorderBottomRightRadius", "webkit-border-bottom-right-radius", BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_BOTTOM_RIGHT_RADIUS__("-webkit-border-bottom-right-radius", "webkit-border-bottom-right-radius", BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_END("webkitBorderEnd", "webkit-border-end", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_BORDER_END_COLOR("webkitBorderEndColor", "webkit-border-end-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_BORDER_END_STYLE("webkitBorderEndStyle", "webkit-border-end-style", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_END_WIDTH("webkitBorderEndWidth", "webkit-border-end-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_HORIZONTAL_SPACING("webkitBorderHorizontalSpacing", "webkit-border-horizontal-spacing", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_IMAGE("webkitBorderImage", "webkit-border-image", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("")),
        WEBKIT_BORDER_IMAGE_("WebkitBorderImage", "webkit-border-image", BrowserConfiguration.ff("")),
        WEBKIT_BORDER_IMAGE__("-webkit-border-image", "webkit-border-image", BrowserConfiguration.ff("")),
        WEBKIT_BORDER_RADIUS("webkitBorderRadius", "webkit-border-radius", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("")),
        WEBKIT_BORDER_RADIUS_("WebkitBorderRadius", "webkit-border-radius", BrowserConfiguration.ff("")),
        WEBKIT_BORDER_RADIUS__("-webkit-border-radius", "webkit-border-radius", BrowserConfiguration.ff("")),
        WEBKIT_BORDER_START("webkitBorderStart", "webkit-border-start", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_BORDER_START_COLOR("webkitBorderStartColor", "webkit-border-start-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_BORDER_START_STYLE("webkitBorderStartStyle", "webkit-border-start-style", BrowserConfiguration.chrome("none")),
        WEBKIT_BORDER_START_WIDTH("webkitBorderStartWidth", "webkit-border-start-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_BORDER_TOP_LEFT_RADIUS("webkitBorderTopLeftRadius", "webkit-border-top-left-radius", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_TOP_LEFT_RADIUS_("WebkitBorderTopLeftRadius", "webkit-border-top-left-radius", BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_TOP_LEFT_RADIUS__("-webkit-border-top-left-radius", "webkit-border-top-left-radius", BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_TOP_RIGHT_RADIUS("webkitBorderTopRightRadius", "webkit-border-top-right-radius", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_TOP_RIGHT_RADIUS_("WebkitBorderTopRightRadius", "webkit-border-top-right-radius", BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_TOP_RIGHT_RADIUS__("-webkit-border-top-right-radius", "webkit-border-top-right-radius", BrowserConfiguration.ff("0px")),
        WEBKIT_BORDER_VERTICAL_SPACING("webkitBorderVerticalSpacing", "webkit-border-vertical-spacing", BrowserConfiguration.chrome("0px")),
        WEBKIT_BOX_ALIGN("webkitBoxAlign", "webkit-box-align", BrowserConfiguration.chrome("stretch"), BrowserConfiguration.ff("stretch")),
        WEBKIT_BOX_ALIGN_("WebkitBoxAlign", "webkit-box-align", BrowserConfiguration.ff("stretch")),
        WEBKIT_BOX_ALIGN__("-webkit-box-align", "webkit-box-align", BrowserConfiguration.ff("stretch")),
        WEBKIT_BOX_DECORATION_BREAK("webkitBoxDecorationBreak", "webkit-box-decoration-break", BrowserConfiguration.chrome("slice")),
        WEBKIT_BOX_DIRECTION("webkitBoxDirection", "webkit-box-direction", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal")),
        WEBKIT_BOX_DIRECTION_("WebkitBoxDirection", "webkit-box-direction", BrowserConfiguration.ff("normal")),
        WEBKIT_BOX_DIRECTION__("-webkit-box-direction", "webkit-box-direction", BrowserConfiguration.ff("normal")),
        WEBKIT_BOX_FLEX("webkitBoxFlex", "webkit-box-flex", BrowserConfiguration.chrome("0"), BrowserConfiguration.ff("0")),
        WEBKIT_BOX_FLEX_("WebkitBoxFlex", "webkit-box-flex", BrowserConfiguration.ff("0")),
        WEBKIT_BOX_FLEX__("-webkit-box-flex", "webkit-box-flex", BrowserConfiguration.ff("0")),
        WEBKIT_BOX_FLEX_GROUP("webkitBoxFlexGroup", "webkit-box-flex-group", BrowserConfiguration.chrome("1").setIteratable(false)),
        WEBKIT_BOX_LINES("webkitBoxLines", "webkit-box-lines", BrowserConfiguration.chrome("single").setIteratable(false)),
        WEBKIT_BOX_ORDINAL_GROUP("webkitBoxOrdinalGroup", "webkit-box-ordinal-group", BrowserConfiguration.chrome("1"), BrowserConfiguration.ff("1")),
        WEBKIT_BOX_ORDINAL_GROUP_("WebkitBoxOrdinalGroup", "webkit-box-ordinal-group", BrowserConfiguration.ff("1")),
        WEBKIT_BOX_ORDINAL_GROUP__("-webkit-box-ordinal-group", "webkit-box-ordinal-group", BrowserConfiguration.ff("1")),
        WEBKIT_BOX_ORIENT("webkitBoxOrient", "webkit-box-orient", BrowserConfiguration.chrome("horizontal"), BrowserConfiguration.ff("horizontal")),
        WEBKIT_BOX_ORIENT_("WebkitBoxOrient", "webkit-box-orient", BrowserConfiguration.ff("horizontal")),
        WEBKIT_BOX_ORIENT__("-webkit-box-orient", "webkit-box-orient", BrowserConfiguration.ff("horizontal")),
        WEBKIT_BOX_PACK("webkitBoxPack", "webkit-box-pack", BrowserConfiguration.chrome("start"), BrowserConfiguration.ff("start")),
        WEBKIT_BOX_PACK_("WebkitBoxPack", "webkit-box-pack", BrowserConfiguration.ff("start")),
        WEBKIT_BOX_PACK__("-webkit-box-pack", "webkit-box-pack", BrowserConfiguration.ff("start")),
        WEBKIT_BOX_REFLECT("webkitBoxReflect", "webkit-box-reflect", BrowserConfiguration.chrome("none")),
        WEBKIT_BOX_SHADOW("webkitBoxShadow", "webkit-box-shadow", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        WEBKIT_BOX_SHADOW_("WebkitBoxShadow", "webkit-box-shadow", BrowserConfiguration.ff("none")),
        WEBKIT_BOX_SHADOW__("-webkit-box-shadow", "webkit-box-shadow", BrowserConfiguration.ff("none")),
        WEBKIT_BOX_SIZING("webkitBoxSizing", "webkit-box-sizing", BrowserConfiguration.chrome("content-box"), BrowserConfiguration.ff("content-box")),
        WEBKIT_BOX_SIZING_("WebkitBoxSizing", "webkit-box-sizing", BrowserConfiguration.ff("content-box")),
        WEBKIT_BOX_SIZING__("-webkit-box-sizing", "webkit-box-sizing", BrowserConfiguration.ff("content-box")),
        WEBKIT_CLIP_PATH("webkitClipPath", "webkit-clip-path", BrowserConfiguration.chrome("none")),
        WEBKIT_COLUMN_BREAK_AFTER("webkitColumnBreakAfter", "webkit-column-break-after", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMN_BREAK_BEFORE("webkitColumnBreakBefore", "webkit-column-break-before", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMN_BREAK_INSIDE("webkitColumnBreakInside", "webkit-column-break-inside", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMN_COUNT("webkitColumnCount", "webkit-column-count", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMN_GAP("webkitColumnGap", "webkit-column-gap", BrowserConfiguration.chrome("normal")),
        WEBKIT_COLUMN_RULE("webkitColumnRule", "webkit-column-rule", BrowserConfiguration.chrome("0px none rgb(0, 0, 0)")),
        WEBKIT_COLUMN_RULE_COLOR("webkitColumnRuleColor", "webkit-column-rule-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_COLUMN_RULE_STYLE("webkitColumnRuleStyle", "webkit-column-rule-style", BrowserConfiguration.chrome("none")),
        WEBKIT_COLUMN_RULE_WIDTH("webkitColumnRuleWidth", "webkit-column-rule-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_COLUMN_SPAN("webkitColumnSpan", "webkit-column-rule-span", BrowserConfiguration.chrome("none")),
        WEBKIT_COLUMN_WIDTH("webkitColumnWidth", "webkit-column-width", BrowserConfiguration.chrome("auto")),
        WEBKIT_COLUMNS("webkitColumns", "webkit-columns", BrowserConfiguration.chrome("auto auto")),
        WEBKIT_FILTER("webkitFilter", "webkit-filter", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        WEBKIT_FILTER_("WebkitFilter", "webkit-filter", BrowserConfiguration.ff("none")),
        WEBKIT_FILTER__("-webkit-filter", "webkit-filter", BrowserConfiguration.ff("none")),
        WEBKIT_FLEX("webkitFlex", "webkit-flex", BrowserConfiguration.chrome("0 1 auto"), BrowserConfiguration.ff("")),
        WEBKIT_FLEX_("WebkitFlex", "webkit-flex", BrowserConfiguration.ff("")),
        WEBKIT_FLEX__("-webkit-flex", "webkit-flex", BrowserConfiguration.ff("")),
        WEBKIT_FLEX_BASIS("webkitFlexBasis", "webkit-flex-basis", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        WEBKIT_FLEX_BASIS_("WebkitFlexBasis", "webkit-flex-basis", BrowserConfiguration.ff("auto")),
        WEBKIT_FLEX_BASIS__("-webkit-flex-basis", "webkit-flex-basis", BrowserConfiguration.ff("auto")),
        WEBKIT_FLEX_DIRECTION("webkitFlexDirection", "webkit-flex-direction", BrowserConfiguration.chrome("row"), BrowserConfiguration.ff("row")),
        WEBKIT_FLEX_DIRECTION_("WebkitFlexDirection", "webkit-flex-direction", BrowserConfiguration.ff("row")),
        WEBKIT_FLEX_DIRECTION__("-webkit-flex-direction", "webkit-flex-direction", BrowserConfiguration.ff("row")),
        WEBKIT_FLEX_FLOW("webkitFlexFlow", "webkit-flex-flow", BrowserConfiguration.chrome("row nowrap"), BrowserConfiguration.ff("")),
        WEBKIT_FLEX_FLOW_("WebkitFlexFlow", "webkit-flex-flow", BrowserConfiguration.ff("")),
        WEBKIT_FLEX_FLOW__("-webkit-flex-flow", "webkit-flex-flow", BrowserConfiguration.ff("")),
        WEBKIT_FLEX_GROW("webkitFlexGrow", "webkit-flex-grow", BrowserConfiguration.chrome("0"), BrowserConfiguration.ff("0")),
        WEBKIT_FLEX_GROW_("WebkitFlexGrow", "webkit-flex-grow", BrowserConfiguration.ff("0")),
        WEBKIT_FLEX_GROW__("-webkit-flex-grow", "webkit-flex-grow", BrowserConfiguration.ff("0")),
        WEBKIT_FLEX_SHRINK("webkitFlexShrink", "webkit-flex-shrink", BrowserConfiguration.chrome("1"), BrowserConfiguration.ff("1")),
        WEBKIT_FLEX_SHRINK_("WebkitFlexShrink", "webkit-flex-shrink", BrowserConfiguration.ff("1")),
        WEBKIT_FLEX_SHRINK__("-webkit-flex-shrink", "webkit-flex-shrink", BrowserConfiguration.ff("1")),
        WEBKIT_FLEX_WRAP("webkitFlexWrap", "webkit-flex-wrap", BrowserConfiguration.chrome("nowrap"), BrowserConfiguration.ff("nowrap")),
        WEBKIT_FLEX_WRAP_("WebkitFlexWrap", "webkit-flex-wrap", BrowserConfiguration.ff("nowrap")),
        WEBKIT_FLEX_WRAP__("-webkit-flex-wrap", "webkit-flex-wrap", BrowserConfiguration.ff("nowrap")),
        WEBKIT_FONT_FEATURE_SETTINGS("webkitFontFeatureSettings", "webkit-font-feature-settings", BrowserConfiguration.chrome("normal")),
        WEBKIT_FONT_SIZE_DELTA("webkitFontSizeDelta", "webkit-font-size-delta", BrowserConfiguration.chrome("")),
        WEBKIT_FONT_SMOOTHING("webkitFontSmoothing", "webkit-font-smoothing", BrowserConfiguration.chrome("auto")),
        WEBKIT_HIGHLIGHT("webkitHighlight", "webkit-highlight", BrowserConfiguration.chrome("none")),
        WEBKIT_HYPHENATE_CHARACTER("webkitHyphenateCharacter", "webkit-hyphenate-character", BrowserConfiguration.chrome("auto")),
        WEBKIT_JUSTIFY_CONTENT("webkitJustifyContent", "webkit-justify-content", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal")),
        WEBKIT_JUSTIFY_CONTENT_("WebkitJustifyContent", "webkit-justify-content", BrowserConfiguration.ff("normal")),
        WEBKIT_JUSTIFY_CONTENT__("-webkit-justify-content", "webkit-justify-content", BrowserConfiguration.ff("normal")),
        WEBKIT_LINE_BREAK("webkitLineBreak", "webkit-line-break", BrowserConfiguration.chrome("auto")),
        WEBKIT_LINE_CLAMP("webkitLineClamp", "webkit-line-clamp", BrowserConfiguration.chrome("none")),
        WEBKIT_LOCALE("webkitLocale", "webkit-locale", BrowserConfiguration.chrome("auto")),
        WEBKIT_LOGICAL_HEIGHT("webkitLogicalHeight", "webkit-logical-height", BrowserConfiguration.chrome("322px")),
        WEBKIT_LOGICAL_WIDTH("webkitLogicalWidth", "webkit-logical-width", BrowserConfiguration.chrome("913px")),
        WEBKIT_MARGIN_AFTER("webkitMarginAfter", "webkit-margin-after", BrowserConfiguration.chrome("0px")),
        WEBKIT_MARGIN_AFTER_COLLAPSE("webkitMarginAfterCollapse", "webkit-margin-after-collapse", BrowserConfiguration.chrome("collapse")),
        WEBKIT_MARGIN_BEFORE("webkitMarginBefore", "webkit-margin-before", BrowserConfiguration.chrome("0px")),
        WEBKIT_MARGIN_BEFORE_COLLAPSE("webkitMarginBeforeCollapse", "webkit-margin-before-collapse", BrowserConfiguration.chrome("collapse")),
        WEBKIT_MARGIN_BOTTOM_COLLAPSE("webkitMarginBottomCollapse", "webkit-margin-bottom-collapse", BrowserConfiguration.chrome("collapse")),
        WEBKIT_MARGIN_COLLAPSE("webkitMarginCollapse", "webkit-margin-collapse", BrowserConfiguration.chrome("")),
        WEBKIT_MARGIN_END("webkitMarginEnd", "webkit-margin-end", BrowserConfiguration.chrome("0px")),
        WEBKIT_MARGIN_START("webkitMarginStart", "webkit-margin-start", BrowserConfiguration.chrome("0px")),
        WEBKIT_MARGIN_TOP_COLLAPSE("webkitMarginTopCollapse", "webkit-margin-top-collapse", BrowserConfiguration.chrome("collapse")),
        WEBKIT_MASK("webkitMask", "webkit-mask", BrowserConfiguration.chrome(""), BrowserConfiguration.ff60up("none")),
        WEBKIT_MASK_("WebkitMask", "webkit-mask", BrowserConfiguration.ff60up("none")),
        WEBKIT_MASK__("-webkit-mask", "webkit-mask", BrowserConfiguration.ff60up("none")),
        WEBKIT_MASK_BOX_IMAGE("webkitMaskBoxImage", "webkit-mask-box-image", BrowserConfiguration.chrome("none")),
        WEBKIT_MASK_BOX_IMAGE_OUTSET("webkitMaskBoxImageOutset", "webkit-mask-box-image-outset", BrowserConfiguration.chrome("0px")),
        WEBKIT_MASK_BOX_IMAGE_REPEAT("webkitMaskBoxImageRepeat", "webkit-mask-box-image-repeat", BrowserConfiguration.chrome("stretch")),
        WEBKIT_MASK_BOX_IMAGE_SLICE("webkitMaskBoxImageSlice", "webkit-mask-box-image-slice", BrowserConfiguration.chrome("0 fill")),
        WEBKIT_MASK_BOX_IMAGE_SOURCE("webkitMaskBoxImageSource", "webkit-mask-box-image-source", BrowserConfiguration.chrome("none")),
        WEBKIT_MASK_BOX_IMAGE_WIDTH("webkitMaskBoxImageWidth", "webkit-mask-box-image-width", BrowserConfiguration.chrome("auto")),
        WEBKIT_MASK_CLIP("webkitMaskClip", "webkit-mask-clip", BrowserConfiguration.chrome("border-box"), BrowserConfiguration.ff60up("border-box")),
        WEBKIT_MASK_CLIP_("WebkitMaskClip", "webkit-mask-clip", BrowserConfiguration.ff60up("border-box")),
        WEBKIT_MASK_CLIP__("-webkit-mask-clip", "webkit-mask-clip", BrowserConfiguration.ff60up("border-box")),
        WEBKIT_MASK_COMPOSITE("webkitMaskComposite", "webkit-mask-composite", BrowserConfiguration.chrome("source-over"), BrowserConfiguration.ff60up("add")),
        WEBKIT_MASK_COMPOSITE_("WebkitMaskComposite", "webkit-mask-composite", BrowserConfiguration.ff60up("add")),
        WEBKIT_MASK_COMPOSITE__("-webkit-mask-composite", "webkit-mask-composite", BrowserConfiguration.ff60up("add")),
        WEBKIT_MASK_IMAGE("webkitMaskImage", "webkit-mask-image", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff60up("none")),
        WEBKIT_MASK_IMAGE_("WebkitMaskImage", "webkit-mask-image", BrowserConfiguration.ff60up("none")),
        WEBKIT_MASK_IMAGE__("-webkit-mask-image", "webkit-mask-image", BrowserConfiguration.ff60up("none")),
        WEBKIT_MASK_ORIGIN("webkitMaskOrigin", "webkit-mask-origin", BrowserConfiguration.chrome("border-box"), BrowserConfiguration.ff60up("border-box")),
        WEBKIT_MASK_ORIGIN_("WebkitMaskOrigin", "webkit-mask-origin", BrowserConfiguration.ff60up("border-box")),
        WEBKIT_MASK_ORIGIN__("-webkit-mask-origin", "webkit-mask-origin", BrowserConfiguration.ff60up("border-box")),
        WEBKIT_MASK_POSITION("webkitMaskPosition", "webkit-mask-position", BrowserConfiguration.chrome("0% 0%"), BrowserConfiguration.ff60up("0% 0%")),
        WEBKIT_MASK_POSITION_("WebkitMaskPosition", "webkit-mask-position", BrowserConfiguration.ff60up("0% 0%")),
        WEBKIT_MASK_POSITION__("-webkit-mask-position", "webkit-mask-position", BrowserConfiguration.ff60up("0% 0%")),
        WEBKIT_MASK_POSITION_X("webkitMaskPositionX", "webkit-mask-position-x", BrowserConfiguration.chrome("0%"), BrowserConfiguration.ff60up("0%")),
        WEBKIT_MASK_POSITION_X_("WebkitMaskPositionX", "webkit-mask-position-x", BrowserConfiguration.ff60up("0%")),
        WEBKIT_MASK_POSITION_X__("-webkit-mask-position-x", "webkit-mask-position-x", BrowserConfiguration.ff60up("0%")),
        WEBKIT_MASK_POSITION_Y("webkitMaskPositionY", "webkit-mask-position-y", BrowserConfiguration.chrome("0%"), BrowserConfiguration.ff60up("0%")),
        WEBKIT_MASK_POSITION_Y_("WebkitMaskPositionY", "webkit-mask-position-y", BrowserConfiguration.ff60up("0%")),
        WEBKIT_MASK_POSITION_Y__("-webkit-mask-position-y", "webkit-mask-position-y", BrowserConfiguration.ff60up("0%")),
        WEBKIT_MASK_REPEAT("webkitMaskRepeat", "webkit-mask-repeat", BrowserConfiguration.chrome("repeat"), BrowserConfiguration.ff60up("repeat")),
        WEBKIT_MASK_REPEAT_("WebkitMaskRepeat", "webkit-mask-repeat", BrowserConfiguration.ff60up("repeat")),
        WEBKIT_MASK_REPEAT__("-webkit-mask-repeat", "webkit-mask-repeat", BrowserConfiguration.ff60up("repeat")),
        WEBKIT_MASK_REPEAT_X("webkitMaskRepeatX", "webkit-mask-repeat-x", BrowserConfiguration.chrome("")),
        WEBKIT_MASK_REPEAT_Y("webkitMaskRepeatY", "webkit-mask-repeat-y", BrowserConfiguration.chrome("")),
        WEBKIT_MASK_SIZE("webkitMaskSize", "webkit-mask-size", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff60up("auto auto")),
        WEBKIT_MASK_SIZE_("WebkitMaskSize", "webkit-mask-size", BrowserConfiguration.ff60up("auto auto")),
        WEBKIT_MASK_SIZE__("-webkit-mask-size", "webkit-mask-size", BrowserConfiguration.ff60up("auto auto")),
        WEBKIT_MAX_LOGICAL_HEIGHT("webkitMaxLogicalHeight", "webkit-max-logical-height", BrowserConfiguration.chrome("none")),
        WEBKIT_MAX_LOGICAL_WIDTH("webkitMaxLogicalWidth", "webkit-max-logical-width", BrowserConfiguration.chrome("none")),
        WEBKIT_MIN_LOGICAL_HEIGHT("webkitMinLogicalHeight", "webkit-min-logical-height", BrowserConfiguration.chrome("0px")),
        WEBKIT_MIN_LOGICAL_WIDTH("webkitMinLogicalWidth", "webkit-min-logical-width", BrowserConfiguration.chrome("0px")),
        WEBKIT_OPACITY("webkitOpacity", "webkit-opacity", BrowserConfiguration.chrome("1")),
        WEBKIT_ORDER("webkitOrder", "webkit-order", BrowserConfiguration.chrome("0"), BrowserConfiguration.ff("0")),
        WEBKIT_ORDER_("WebkitOrder", "webkit-order", BrowserConfiguration.ff("0")),
        WEBKIT_ORDER__("-webkit-order", "webkit-order", BrowserConfiguration.ff("0")),
        WEBKIT_PADDING_AFTER("webkitPaddingAfter", "webkit-padding-after", BrowserConfiguration.chrome("0px")),
        WEBKIT_PADDING_BEFORE("webkitPaddingBefore", "webkit-padding-before", BrowserConfiguration.chrome("0px")),
        WEBKIT_PADDING_END("webkitPaddingEnd", "webkit-padding-end", BrowserConfiguration.chrome("0px")),
        WEBKIT_PADDING_START("webkitPaddingStart", "webkit-padding-start", BrowserConfiguration.chrome("0px")),
        WEBKIT_PERSPECTIVE("webkitPerspective", "webkit-perspective", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        WEBKIT_PERSPECTIVE_("WebkitPerspective", "webkit-perspective", BrowserConfiguration.ff("none")),
        WEBKIT_PERSPECTIVE__("-webkit-perspective", "webkit-perspective", BrowserConfiguration.ff("none")),
        WEBKIT_PERSPECTIVE_ORIGIN("webkitPerspectiveOrigin", "webkit-perspective-origin", BrowserConfiguration.chrome("456.5px 161px"), BrowserConfiguration.ff("625px 172.5px")),
        WEBKIT_PERSPECTIVE_ORIGIN_("WebkitPerspectiveOrigin", "webkit-perspective-origin", BrowserConfiguration.ff("625px 172.5px")),
        WEBKIT_PERSPECTIVE_ORIGIN__("-webkit-perspective-origin", "webkit-perspective-origin", BrowserConfiguration.ff("625px 172.5px")),
        WEBKIT_PERSPECTIVE_ORIGIN_X("webkitPerspectiveOriginX", "webkit-perspective-origin-x", BrowserConfiguration.chrome("")),
        WEBKIT_PERSPECTIVE_ORIGIN_Y("webkitPerspectiveOriginY", "webkit-perspective-origin-y", BrowserConfiguration.chrome("")),
        WEBKIT_PRINT_COLOR_ADJUST("webkitPrintColorAdjust", "webkit-print-color-adjust", BrowserConfiguration.chrome("economy")),
        WEBKIT_RTL_ORDERING("webkitRtlOrdering", "webkit-rtl-ordering", BrowserConfiguration.chrome("logical")),
        WEBKIT_RUBY_POSITION("webkitRubyPosition", "webkit-ruby-position", BrowserConfiguration.chrome("before")),
        WEBKIT_SHAPE_IMAGE_THRESHOLD("webkitShapeImageThreshold", "webkit-shape-image-threshold", BrowserConfiguration.chrome("0")),
        WEBKIT_SHAPE_MARGIN("webkitShapeMargin", "webkit-shape-margin", BrowserConfiguration.chrome("0px")),
        WEBKIT_SHAPE_OUTSIDE("webkitShapeOutside", "webkit-shape-outside", BrowserConfiguration.chrome("none")),
        WEBKIT_TAP_HIGHLIGHT_COLOR("webkitTapHighlightColor", "webkit-tap-highlight-color", BrowserConfiguration.chrome("rgba(0, 0, 0, 0.18)")),
        WEBKIT_TEXT_COMBINE("webkitTextCombine", "webkit-text-combine", BrowserConfiguration.chrome("none")),
        WEBKIT_TEXT_DECORATIONS_IN_EFFECT("webkitTextDecorationsInEffect", "webkit-text-decorations-in-effect", BrowserConfiguration.chrome("none")),
        WEBKIT_TEXT_EMPHASIS("webkitTextEmphasis", "webkit-text-emphasis", BrowserConfiguration.chrome("")),
        WEBKIT_TEXT_EMPHASIS_COLOR("webkitTextEmphasisColor", "webkit-text-emphasis-color", BrowserConfiguration.chrome("rgb(0, 0, 0)")),
        WEBKIT_TEXT_EMPHASIS_POSITION("webkitTextEmphasisPosition", "webkit-text-emphasis-position", BrowserConfiguration.chrome("over right")),
        WEBKIT_TEXT_EMPHASIS_STYLE("webkitTextEmphasisStyle", "webkit-text-emphasis-style", BrowserConfiguration.chrome("none")),
        WEBKIT_TEXT_FILL_COLOR("webkitTextFillColor", "webkit-text-fill-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)")),
        WEBKIT_TEXT_FILL_COLOR_("WebkitTextFillColor", "webkit-text-fill-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        WEBKIT_TEXT_FILL_COLOR__("-webkit-text-fill-color", "webkit-text-fill-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        WEBKIT_TEXT_ORIENTATION("webkitTextOrientation", "webkit-text-orientation", BrowserConfiguration.chrome("vertical-right")),
        WEBKIT_TEXT_SECURITY("webkitTextSecurity", "webkit-text-security", BrowserConfiguration.chrome("none")),
        WEBKIT_TEXT_SIZE_ADJUST("webkitTextSizeAdjust", "webkit-text-size-adjust", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        WEBKIT_TEXT_SIZE_ADJUST_("WebkitTextSizeAdjust", "webkit-text-size-adjust", BrowserConfiguration.ff("auto")),
        WEBKIT_TEXT_SIZE_ADJUST__("-webkit-text-size-adjust", "webkit-text-size-adjust", BrowserConfiguration.ff("auto")),
        WEBKIT_TEXT_STROKE("webkitTextStroke", "webkit-text-stroke", BrowserConfiguration.chrome(""), BrowserConfiguration.ff("")),
        WEBKIT_TEXT_STROKE_("WebkitTextStroke", "webkit-text-stroke", BrowserConfiguration.ff("")),
        WEBKIT_TEXT_STROKE__("-webkit-text-stroke", "webkit-text-stroke", BrowserConfiguration.ff("")),
        WEBKIT_TEXT_STROKE_COLOR("webkitTextStrokeColor", "webkit-text-stroke-color", BrowserConfiguration.chrome("rgb(0, 0, 0)"), BrowserConfiguration.ff("rgb(0, 0, 0)")),
        WEBKIT_TEXT_STROKE_COLOR_("WebkitTextStrokeColor", "webkit-text-stroke-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        WEBKIT_TEXT_STROKE_COLOR__("-webkit-text-stroke-color", "webkit-text-stroke-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        WEBKIT_TEXT_STROKE_WIDTH("webkitTextStrokeWidth", "webkit-text-stroke-width", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px")),
        WEBKIT_TEXT_STROKE_WIDTH_("WebkitTextStrokeWidth", "webkit-text-stroke-width", BrowserConfiguration.ff("0px")),
        WEBKIT_TEXT_STROKE_WIDTH__("-webkit-text-stroke-width", "webkit-text-stroke-width", BrowserConfiguration.ff("0px")),
        WEBKIT_TRANSFORM("webkitTransform", "webkit-transform", BrowserConfiguration.chrome("none"), BrowserConfiguration.ff("none")),
        WEBKIT_TRANSFORM_("WebkitTransform", "webkit-transform", BrowserConfiguration.ff("none")),
        WEBKIT_TRANSFORM__("-webkit-transform", "webkit-transform", BrowserConfiguration.ff("none")),
        WEBKIT_TRANSFORM_ORIGIN("webkitTransformOrigin", "webkit-transform-origin", BrowserConfiguration.chrome("620px 161px"), BrowserConfiguration.ff("625px 172.5px")),
        WEBKIT_TRANSFORM_ORIGIN_("WebkitTransformOrigin", "webkit-transform-origin", BrowserConfiguration.ff("625px 172.5px")),
        WEBKIT_TRANSFORM_ORIGIN__("-webkit-transform-origin", "webkit-transform-origin", BrowserConfiguration.ff("625px 172.5px")),
        WEBKIT_TRANSFORM_ORIGIN_X("webkitTransformOriginX", "webkit-transform-origin-x", BrowserConfiguration.chrome("")),
        WEBKIT_TRANSFORM_ORIGIN_Y("webkitTransformOriginY", "webkit-transform-origin-y", BrowserConfiguration.chrome("")),
        WEBKIT_TRANSFORM_ORIGIN_Z("webkitTransformOriginZ", "webkit-transform-origin-z", BrowserConfiguration.chrome("")),
        WEBKIT_TRANSFORM_STYLE("webkitTransformStyle", "webkit-transform-style", BrowserConfiguration.chrome("flat"), BrowserConfiguration.ff("flat")),
        WEBKIT_TRANSFORM_STYLE_("WebkitTransformStyle", "webkit-transform-style", BrowserConfiguration.ff("flat")),
        WEBKIT_TRANSFORM_STYLE__("-webkit-transform-style", "webkit-transform-style", BrowserConfiguration.ff("flat")),
        WEBKIT_TRANSITION("webkitTransition", "webkit-transition", BrowserConfiguration.chrome("all 0s ease 0s"), BrowserConfiguration.ff("")),
        WEBKIT_TRANSITION_("WebkitTransition", "webkit-transition", BrowserConfiguration.ff("")),
        WEBKIT_TRANSITION__("-webkit-transition", "webkit-transition", BrowserConfiguration.ff("")),
        WEBKIT_TRANSITION_DELAY("webkitTransitionDelay", "webkit-transition-delay", BrowserConfiguration.chrome("0s"), BrowserConfiguration.ff("0s")),
        WEBKIT_TRANSITION_DELAY_("WebkitTransitionDelay", "webkit-transition-delay", BrowserConfiguration.ff("0s")),
        WEBKIT_TRANSITION_DELAY__("-webkit-transition-delay", "webkit-transition-delay", BrowserConfiguration.ff("0s")),
        WEBKIT_TRANSITION_DURATION("webkitTransitionDuration", "webkit-transition-duration", BrowserConfiguration.chrome("0s"), BrowserConfiguration.ff("0s")),
        WEBKIT_TRANSITION_DURATION_("WebkitTransitionDuration", "webkit-transition-duration", BrowserConfiguration.ff("0s")),
        WEBKIT_TRANSITION_DURATION__("-webkit-transition-duration", "webkit-transition-duration", BrowserConfiguration.ff("0s")),
        WEBKIT_TRANSITION_PROPERTY("webkitTransitionProperty", "webkit-transition-property", BrowserConfiguration.chrome("all"), BrowserConfiguration.ff("all")),
        WEBKIT_TRANSITION_PROPERTY_("WebkitTransitionProperty", "webkit-transition-property", BrowserConfiguration.ff("all")),
        WEBKIT_TRANSITION_PROPERTY__("-webkit-transition-property", "webkit-transition-property", BrowserConfiguration.ff("all")),
        WEBKIT_TRANSITION_TIMING_FUNCTION("webkitTransitionTimingFunction", "webkit-transition-timing-function", BrowserConfiguration.chrome("ease"), BrowserConfiguration.ff("ease")),
        WEBKIT_TRANSITION_TIMING_FUNCTION_("WebkitTransitionTimingFunction", "webkit-transition-timing-function", BrowserConfiguration.ff("ease")),
        WEBKIT_TRANSITION_TIMING_FUNCTION__("-webkit-transition-timing-function", "webkit-transition-timing-function", BrowserConfiguration.ff("ease")),
        WEBKIT_USER_DRAG("webkitUserDrag", "webkit-user-drag", BrowserConfiguration.chrome("auto")),
        WEBKIT_USER_MODIFY("webkitUserModify", "webkit-user-modify", BrowserConfiguration.chrome("read-only")),
        WEBKIT_USER_SELECT("webkitUserSelect", "webkit-user-select", BrowserConfiguration.chrome("auto"), BrowserConfiguration.ff("auto")),
        WEBKIT_USER_SELECT_("WebkitUserSelect", "webkit-user-select", BrowserConfiguration.ff("auto")),
        WEBKIT_USER_SELECT__("-webkit-user-select", "webkit-user-select", BrowserConfiguration.ff("auto")),
        WEBKIT_WRITING_MODE("webkitWritingMode", "webkit-writing-mode", BrowserConfiguration.chrome("horizontal-tb")),
        WHITE_SPACE("whiteSpace", "white-space", BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal"), BrowserConfiguration.ie("normal")),
        WHITE_SPACE_("white-space", "white-space", BrowserConfiguration.ff("normal")),
        WIDOWS("widows", "widows", BrowserConfiguration.ie("2"), BrowserConfiguration.chrome("2")),
        WIDTH("width", "width", BrowserConfiguration.chrome(""), BrowserConfiguration.ff(""), BrowserConfiguration.ie("")),
        WILL_CHANGE("willChange", "will-change", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto")),
        WILL_CHANGE_("will-change", "will-change", BrowserConfiguration.ff("auto")),
        WORD_BREAK("wordBreak", "word-break", BrowserConfiguration.ff("normal"), BrowserConfiguration.ie("normal"), BrowserConfiguration.chrome("normal")),
        WORD_BREAK_("word-break", "word-break", BrowserConfiguration.ff("normal")),
        WORD_SPACING("wordSpacing", "word-spacing", BrowserConfiguration.chrome("0px"), BrowserConfiguration.ff("0px"), BrowserConfiguration.ie("0px")),
        WORD_SPACING_("word-spacing", "word-spacing", BrowserConfiguration.ff("0px")),
        WORD_WRAP("wordWrap", "word-wrap", BrowserConfiguration.ie(""), BrowserConfiguration.chrome("normal"), BrowserConfiguration.ff("normal")),
        WORD_WRAP_("word-wrap", "word-wrap", BrowserConfiguration.ff("normal")),
        WRITING_MODE("writingMode", "writing-mode", BrowserConfiguration.ie("undefined"), BrowserConfiguration.chrome("horizontal-tb"), BrowserConfiguration.ff("horizontal-tb")),
        WRITING_MODE_("writing-mode", "writing-mode", BrowserConfiguration.ff("horizontal-tb")),
        X("x", "x", BrowserConfiguration.chrome("0px")),
        Y("y", "y", BrowserConfiguration.chrome("0px")),
        Z_INDEX("zIndex", "z-index", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto"), BrowserConfiguration.ie("auto")),
        Z_INDEX_("z-index", "z-index", BrowserConfiguration.ff("auto"), BrowserConfiguration.chrome("auto").setIteratable(false), BrowserConfiguration.ie("auto").setIteratable(false)),
        ZOOM("zoom", "zoom", BrowserConfiguration.ie("undefined"), BrowserConfiguration.chrome("1"));

        private final String propertyName_;
        private final String attributeName_;
        private final BrowserConfiguration[] browserConfigurations_;

        private Definition(String propertyName, String attributeName, BrowserConfiguration ... browserConfigurations) {
            this.propertyName_ = propertyName;
            this.attributeName_ = attributeName;
            this.browserConfigurations_ = browserConfigurations;
        }

        boolean isAvailable(BrowserVersion browserVersion, boolean onlyIfIteratable) {
            if (this.browserConfigurations_ == null) {
                return true;
            }
            BrowserConfiguration config = BrowserConfiguration.getMatchingConfiguration(browserVersion, this.browserConfigurations_);
            return config != null && (!onlyIfIteratable || config.isIteratable());
        }

        public String getPropertyName() {
            return this.propertyName_;
        }

        public String getAttributeName() {
            return this.attributeName_;
        }

        public String getDefaultComputedValue(BrowserVersion browserVersion) {
            BrowserConfiguration config = BrowserConfiguration.getMatchingConfiguration(browserVersion, this.browserConfigurations_);
            if (config == null) {
                return "";
            }
            return config.getDefaultValue();
        }
    }
}

