/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.svg;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.ScriptElement;
import com.gargoylesoftware.htmlunit.html.ScriptElementSupport;
import com.gargoylesoftware.htmlunit.svg.SvgElement;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SvgScript
extends SvgElement
implements ScriptElement {
    public static final String TAG_NAME = "script";
    private boolean executed_;

    SvgScript(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    public boolean isExecuted() {
        return this.executed_;
    }

    @Override
    public void setExecuted(boolean executed) {
        this.executed_ = executed;
    }

    @Override
    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    protected final String getSrcAttributeNormalized() {
        String attrib = this.getAttribute("src");
        if (ATTRIBUTE_NOT_DEFINED == attrib) {
            return attrib;
        }
        return StringUtils.replaceChars((String)attrib, (String)"\r\n", (String)"");
    }

    @Override
    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    @Override
    public final Charset getCharset() {
        return EncodingSniffer.toCharset(this.getCharsetAttribute());
    }

    @Override
    protected void onAllChildrenAddedToPage(boolean postponed) {
        ScriptElementSupport.onAllChildrenAddedToPage(this, postponed);
    }
}

