/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.CharacterDataChangeEvent;
import com.gargoylesoftware.htmlunit.html.CharacterDataChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.dom.MutationRecord;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.TopLevel;

@JsxClass
public class MutationObserver
extends SimpleScriptable
implements HtmlAttributeChangeListener,
CharacterDataChangeListener {
    private Function function_;
    private Node node_;
    private boolean childList_;
    private boolean attaributes_;
    private boolean attributeOldValue_;
    private NativeArray attributeFilter_;
    private boolean characterData_;
    private boolean characterDataOldValue_;
    private boolean subtree_;

    public MutationObserver() {
    }

    @JsxConstructor
    public MutationObserver(Function function) {
        this.function_ = function;
    }

    @JsxFunction
    public void observe(Node node, NativeObject options) {
        this.node_ = node;
        this.attaributes_ = Boolean.TRUE.equals(options.get((Object)"attributes"));
        this.attributeOldValue_ = Boolean.TRUE.equals(options.get((Object)"attributeOldValue"));
        this.childList_ = Boolean.TRUE.equals(options.get((Object)"childList"));
        this.characterData_ = Boolean.TRUE.equals(options.get((Object)"characterData"));
        this.characterDataOldValue_ = Boolean.TRUE.equals(options.get((Object)"characterDataOldValue"));
        this.subtree_ = Boolean.TRUE.equals(options.get((Object)"subtree"));
        this.attributeFilter_ = (NativeArray)options.get((Object)"attributeFilter");
        if (this.attaributes_ && this.node_.getDomNodeOrDie() instanceof HtmlElement) {
            ((HtmlElement)this.node_.getDomNodeOrDie()).addHtmlAttributeChangeListener(this);
        }
        if (this.characterData_) {
            node.getDomNodeOrDie().addCharacterDataChangeListener(this);
        }
    }

    @JsxFunction
    public void disconnect() {
        if (this.attaributes_ && this.node_.getDomNodeOrDie() instanceof HtmlElement) {
            ((HtmlElement)this.node_.getDomNodeOrDie()).removeHtmlAttributeChangeListener(this);
        }
        if (this.characterData_) {
            this.node_.getDomNodeOrDie().removeCharacterDataChangeListener(this);
        }
    }

    @JsxFunction
    public NativeArray takeRecords() {
        return new NativeArray(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void characterDataChanged(CharacterDataChangeEvent event) {
        ScriptableObject target = event.getCharacterData().getScriptableObject();
        if (this.subtree_ || target == this.node_) {
            MutationRecord mutationRecord = new MutationRecord();
            Scriptable scope = this.getParentScope();
            mutationRecord.setParentScope(scope);
            mutationRecord.setPrototype(this.getPrototype(mutationRecord.getClass()));
            mutationRecord.setType("characterData");
            mutationRecord.setTarget(target);
            if (this.characterDataOldValue_) {
                mutationRecord.setOldValue(event.getOldValue());
            }
            NativeArray array = new NativeArray(new Object[]{mutationRecord});
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)array, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
            Context context = Context.enter();
            try {
                this.function_.call(context, scope, (Scriptable)this, new Object[]{array});
            }
            finally {
                Context.exit();
            }
        }
    }

    @Override
    public void attributeAdded(HtmlAttributeChangeEvent event) {
    }

    @Override
    public void attributeRemoved(HtmlAttributeChangeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attributeReplaced(HtmlAttributeChangeEvent event) {
        HtmlElement target = event.getHtmlElement();
        if (this.subtree_ || target == this.node_.getDomNodeOrDie()) {
            String attributeName = event.getName();
            if (this.attributeFilter_ == null || this.attributeFilter_.contains((Object)attributeName)) {
                MutationRecord mutationRecord = new MutationRecord();
                Scriptable scope = this.getParentScope();
                mutationRecord.setParentScope(scope);
                mutationRecord.setPrototype(this.getPrototype(mutationRecord.getClass()));
                mutationRecord.setType("attributes");
                mutationRecord.setTarget(target.getScriptableObject());
                if (this.attributeOldValue_) {
                    mutationRecord.setOldValue(event.getValue());
                }
                NativeArray array = new NativeArray(new Object[]{mutationRecord});
                ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)array, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
                Context context = Context.enter();
                try {
                    this.function_.call(context, scope, (Scriptable)this, new Object[]{array});
                }
                finally {
                    Context.exit();
                }
            }
        }
    }
}

