/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRuleList;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.steadystate.css.dom.CSSImportRuleImpl;
import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.dom.MediaListImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACMediaListImpl;
import com.steadystate.css.parser.SACParserCSS3;
import com.steadystate.css.parser.SelectorListImpl;
import com.steadystate.css.parser.media.MediaQuery;
import com.steadystate.css.parser.selectors.GeneralAdjacentSelectorImpl;
import com.steadystate.css.parser.selectors.PrefixAttributeConditionImpl;
import com.steadystate.css.parser.selectors.PseudoClassConditionImpl;
import com.steadystate.css.parser.selectors.SubstringAttributeConditionImpl;
import com.steadystate.css.parser.selectors.SuffixAttributeConditionImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.MediaList;

@JsxClass
public class CSSStyleSheet
extends StyleSheet {
    private static final Log LOG = LogFactory.getLog(CSSStyleSheet.class);
    private static final Pattern NTH_NUMERIC = Pattern.compile("\\d+");
    private static final Pattern NTH_COMPLEX = Pattern.compile("[+-]?\\d*n\\w*([+-]\\w\\d*)?");
    private static final Pattern UNESCAPE_SELECTOR = Pattern.compile("\\\\([\\[\\]\\.:])");
    private final org.w3c.dom.css.CSSStyleSheet wrapped_;
    private final HTMLElement ownerNode_;
    private CSSRuleList cssRules_;
    private List<Integer> cssRulesIndexFix_;
    private final Map<CSSImportRule, CSSStyleSheet> imports_ = new HashMap<CSSImportRule, CSSStyleSheet>();
    private String uri_;
    private boolean enabled_ = true;
    private static final Set<String> CSS2_PSEUDO_CLASSES = new HashSet<String>(Arrays.asList("link", "visited", "hover", "active", "focus", "lang", "first-child"));
    private static final Set<String> CSS3_PSEUDO_CLASSES = new HashSet<String>(Arrays.asList("checked", "disabled", "enabled", "indeterminated", "root", "target", "not()", "nth-child()", "nth-last-child()", "nth-of-type()", "nth-last-of-type()", "last-child", "first-of-type", "last-of-type", "only-child", "only-of-type", "empty", "optional", "required"));

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public CSSStyleSheet() {
        this.wrapped_ = new CSSStyleSheetImpl();
        this.ownerNode_ = null;
    }

    public CSSStyleSheet(HTMLElement element, InputSource source, String uri) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        if (source != null) {
            source.setURI(uri);
        }
        this.wrapped_ = this.parseCSS(source);
        this.uri_ = uri;
        this.ownerNode_ = element;
    }

    public CSSStyleSheet(HTMLElement element, org.w3c.dom.css.CSSStyleSheet wrapped, String uri) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.wrapped_ = wrapped;
        this.uri_ = uri;
        this.ownerNode_ = element;
    }

    public org.w3c.dom.css.CSSStyleSheet getWrappedSheet() {
        return this.wrapped_;
    }

    public void modifyIfNecessary(ComputedCSSStyleDeclaration style, Element element, String pseudoElement) {
        org.w3c.dom.css.CSSRuleList rules = this.getWrappedSheet().getCssRules();
        this.modifyIfNecessary(style, element, pseudoElement, rules, new HashSet<String>());
    }

    private void modifyIfNecessary(ComputedCSSStyleDeclaration style, Element element, String pseudoElement, org.w3c.dom.css.CSSRuleList rules, Set<String> alreadyProcessing) {
        if (rules == null) {
            return;
        }
        BrowserVersion browser = this.getBrowserVersion();
        DomElement e = element.getDomNodeOrDie();
        int rulesLength = rules.getLength();
        for (int i = 0; i < rulesLength; ++i) {
            CSSMediaRuleImpl mediaRule;
            MediaList mediaList;
            org.w3c.dom.css.CSSRule rule = rules.item(i);
            short ruleType = rule.getType();
            if (1 == ruleType) {
                CSSStyleRuleImpl styleRule = (CSSStyleRuleImpl)rule;
                SelectorList selectors = styleRule.getSelectors();
                for (int j = 0; j < selectors.getLength(); ++j) {
                    Selector selector = selectors.item(j);
                    boolean selected = CSSStyleSheet.selects(browser, selector, e, pseudoElement);
                    if (!selected) continue;
                    CSSStyleDeclaration dec = styleRule.getStyle();
                    style.applyStyleFromSelector(dec, selector);
                }
                continue;
            }
            if (3 == ruleType) {
                CSSImportRuleImpl importRule = (CSSImportRuleImpl)rule;
                mediaList = importRule.getMedia();
                if (!CSSStyleSheet.isActive((SimpleScriptable)this, mediaList)) continue;
                CSSStyleSheet sheet = this.imports_.get(importRule);
                if (sheet == null) {
                    String uri = this.uri_ != null ? this.uri_ : e.getPage().getUrl().toExternalForm();
                    String href = importRule.getHref();
                    String url = UrlUtils.resolveUrl(uri, href);
                    sheet = CSSStyleSheet.loadStylesheet(this.getWindow(), this.ownerNode_, null, url);
                    this.imports_.put((CSSImportRule)importRule, sheet);
                }
                if (alreadyProcessing.contains(sheet.getUri())) continue;
                org.w3c.dom.css.CSSRuleList sheetRules = sheet.getWrappedSheet().getCssRules();
                alreadyProcessing.add(this.getUri());
                sheet.modifyIfNecessary(style, element, pseudoElement, sheetRules, alreadyProcessing);
                continue;
            }
            if (4 != ruleType || !CSSStyleSheet.isActive((SimpleScriptable)this, mediaList = (mediaRule = (CSSMediaRuleImpl)rule).getMedia())) continue;
            org.w3c.dom.css.CSSRuleList internalRules = mediaRule.getCssRules();
            this.modifyIfNecessary(style, element, pseudoElement, internalRules, alreadyProcessing);
        }
    }

    public static CSSStyleSheet loadStylesheet(Window window, HTMLElement element, HtmlLink link, String url) {
        CSSStyleSheet sheet;
        HtmlPage page = (HtmlPage)element.getDomNodeOrDie().getPage();
        String uri = page.getUrl().toExternalForm();
        try {
            WebResponse response;
            WebRequest request;
            WebClient client = page.getWebClient();
            if (link != null) {
                String type;
                request = link.getWebRequest();
                if (element.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLLINK_CHECK_TYPE_FOR_STYLESHEET) && StringUtils.isNotBlank((CharSequence)(type = link.getTypeAttribute())) && !"text/css".equals(type)) {
                    InputSource source = new InputSource((Reader)new StringReader(""));
                    return new CSSStyleSheet(element, source, uri);
                }
                response = link.getWebResponse(true, request);
            } else {
                String accept = client.getBrowserVersion().getCssAcceptHeader();
                request = new WebRequest(new URL(url), accept);
                String referer = page.getUrl().toExternalForm();
                request.setAdditionalHeader("Referer", referer);
                response = client.loadWebResponse(request);
            }
            Cache cache = client.getCache();
            Object fromCache = cache.getCachedObject(request);
            if (fromCache != null && fromCache instanceof org.w3c.dom.css.CSSStyleSheet) {
                uri = request.getUrl().toExternalForm();
                sheet = new CSSStyleSheet(element, (org.w3c.dom.css.CSSStyleSheet)fromCache, uri);
            } else {
                uri = response.getWebRequest().getUrl().toExternalForm();
                client.printContentIfNecessary(response);
                client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
                InputSource source = new InputSource();
                String contentType = response.getContentType();
                if (StringUtils.isEmpty((CharSequence)contentType) || "text/css".equals(contentType)) {
                    source.setByteStream(response.getContentAsStream());
                    source.setEncoding(response.getContentCharset().name());
                } else {
                    source.setCharacterStream((Reader)new StringReader(""));
                }
                sheet = new CSSStyleSheet(element, source, uri);
                if (!cache.cacheIfPossible(request, response, sheet.getWrappedSheet())) {
                    response.cleanUp();
                }
            }
        }
        catch (FailingHttpStatusCodeException e) {
            LOG.error((Object)("Exception loading " + uri), (Throwable)e);
            InputSource source = new InputSource((Reader)new StringReader(""));
            sheet = new CSSStyleSheet(element, source, uri);
        }
        catch (IOException e) {
            LOG.error((Object)("IOException loading " + uri), (Throwable)e);
            InputSource source = new InputSource((Reader)new StringReader(""));
            sheet = new CSSStyleSheet(element, source, uri);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("RuntimeException loading " + uri), (Throwable)e);
            throw Context.reportRuntimeError((String)("Exception: " + e));
        }
        catch (Exception e) {
            LOG.error((Object)("Exception loading " + uri), (Throwable)e);
            throw Context.reportRuntimeError((String)("Exception: " + e));
        }
        return sheet;
    }

    boolean selects(Selector selector, DomElement element) {
        return CSSStyleSheet.selects(this.getBrowserVersion(), selector, element);
    }

    public static boolean selects(BrowserVersion browserVersion, Selector selector, DomElement element) {
        return CSSStyleSheet.selects(browserVersion, selector, element, null);
    }

    public static boolean selects(BrowserVersion browserVersion, Selector selector, DomElement element, String pseudoElement) {
        switch (selector.getSelectorType()) {
            case 1: {
                if (selector instanceof GeneralAdjacentSelectorImpl) {
                    SiblingSelector ss = (SiblingSelector)selector;
                    Selector ssSelector = ss.getSelector();
                    SimpleSelector ssSiblingSelector = ss.getSiblingSelector();
                    for (DomNode prev = element.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
                        if (!(prev instanceof HtmlElement) || !CSSStyleSheet.selects(browserVersion, ssSelector, (DomElement)((HtmlElement)prev)) || !CSSStyleSheet.selects(browserVersion, (Selector)ssSiblingSelector, element)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            case 11: {
                DomNode parentNode = element.getParentNode();
                if (parentNode == element.getPage()) {
                    return false;
                }
                if (!(parentNode instanceof HtmlElement)) {
                    return false;
                }
                DescendantSelector cs = (DescendantSelector)selector;
                return CSSStyleSheet.selects(browserVersion, (Selector)cs.getSimpleSelector(), element) && CSSStyleSheet.selects(browserVersion, cs.getAncestorSelector(), (DomElement)((HtmlElement)parentNode));
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                SimpleSelector simpleSelector = ds.getSimpleSelector();
                if (CSSStyleSheet.selects(browserVersion, (Selector)simpleSelector, element, pseudoElement)) {
                    DomNode ancestor = element;
                    if (simpleSelector.getSelectorType() != 9) {
                        ancestor = ancestor.getParentNode();
                    }
                    Selector dsAncestorSelector = ds.getAncestorSelector();
                    while (ancestor instanceof HtmlElement) {
                        if (CSSStyleSheet.selects(browserVersion, dsAncestorSelector, (HtmlElement)ancestor, pseudoElement)) {
                            return true;
                        }
                        ancestor = ancestor.getParentNode();
                    }
                }
                return false;
            }
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                SimpleSelector simpleSel = conditional.getSimpleSelector();
                return (simpleSel == null || CSSStyleSheet.selects(browserVersion, (Selector)simpleSel, element)) && CSSStyleSheet.selects(browserVersion, conditional.getCondition(), element);
            }
            case 4: {
                ElementSelector es = (ElementSelector)selector;
                String name = es.getLocalName();
                return name == null || name.equalsIgnoreCase(element.getLocalName());
            }
            case 2: {
                return "html".equalsIgnoreCase(element.getTagName());
            }
            case 12: {
                DomNode prev;
                SiblingSelector ss = (SiblingSelector)selector;
                for (prev = element.getPreviousSibling(); prev != null && !(prev instanceof HtmlElement); prev = prev.getPreviousSibling()) {
                }
                return prev != null && CSSStyleSheet.selects(browserVersion, ss.getSelector(), (DomElement)((HtmlElement)prev)) && CSSStyleSheet.selects(browserVersion, (Selector)ss.getSiblingSelector(), element);
            }
            case 3: {
                NegativeSelector ns = (NegativeSelector)selector;
                return !CSSStyleSheet.selects(browserVersion, (Selector)ns.getSimpleSelector(), element);
            }
            case 9: {
                if (pseudoElement != null && !pseudoElement.isEmpty() && pseudoElement.charAt(0) == ':') {
                    String pseudoName = ((ElementSelector)selector).getLocalName();
                    return pseudoName.equals(pseudoElement.substring(1));
                }
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        LOG.error((Object)("Unknown CSS selector type '" + selector.getSelectorType() + "'."));
        return false;
    }

    static boolean selects(BrowserVersion browserVersion, Condition condition, DomElement element) {
        if (condition instanceof PrefixAttributeConditionImpl) {
            AttributeCondition ac = (AttributeCondition)condition;
            String value = ac.getValue();
            return !"".equals(value) && element.getAttribute(ac.getLocalName()).startsWith(value);
        }
        if (condition instanceof SuffixAttributeConditionImpl) {
            AttributeCondition ac = (AttributeCondition)condition;
            String value = ac.getValue();
            return !"".equals(value) && element.getAttribute(ac.getLocalName()).endsWith(value);
        }
        if (condition instanceof SubstringAttributeConditionImpl) {
            AttributeCondition ac = (AttributeCondition)condition;
            String value = ac.getValue();
            return !"".equals(value) && element.getAttribute(ac.getLocalName()).contains(value);
        }
        switch (condition.getConditionType()) {
            case 5: {
                AttributeCondition ac4 = (AttributeCondition)condition;
                return ac4.getValue().equals(element.getId());
            }
            case 9: {
                AttributeCondition ac3 = (AttributeCondition)condition;
                String v3 = ac3.getValue();
                if (v3.indexOf(92) > -1) {
                    v3 = UNESCAPE_SELECTOR.matcher(v3).replaceAll("$1");
                }
                String a3 = element.getAttribute("class");
                return CSSStyleSheet.selectsWhitespaceSeparated(v3, a3);
            }
            case 0: {
                CombinatorCondition cc1 = (CombinatorCondition)condition;
                return CSSStyleSheet.selects(browserVersion, cc1.getFirstCondition(), element) && CSSStyleSheet.selects(browserVersion, cc1.getSecondCondition(), element);
            }
            case 4: {
                AttributeCondition ac1 = (AttributeCondition)condition;
                if (ac1.getSpecified()) {
                    String attrValue;
                    String value = ac1.getValue();
                    if (value.indexOf(92) > -1) {
                        value = UNESCAPE_SELECTOR.matcher(value).replaceAll("$1");
                    }
                    return DomElement.ATTRIBUTE_NOT_DEFINED != (attrValue = element.getAttribute(ac1.getLocalName())) && attrValue.equals(value);
                }
                return element.hasAttribute(ac1.getLocalName());
            }
            case 8: {
                AttributeCondition ac2 = (AttributeCondition)condition;
                String v = ac2.getValue();
                String a = element.getAttribute(ac2.getLocalName());
                return CSSStyleSheet.selects(v, a, '-');
            }
            case 7: {
                AttributeCondition ac5 = (AttributeCondition)condition;
                String v2 = ac5.getValue();
                String a2 = element.getAttribute(ac5.getLocalName());
                return CSSStyleSheet.selects(v2, a2, ' ');
            }
            case 1: {
                CombinatorCondition cc2 = (CombinatorCondition)condition;
                return CSSStyleSheet.selects(browserVersion, cc2.getFirstCondition(), element) || CSSStyleSheet.selects(browserVersion, cc2.getSecondCondition(), element);
            }
            case 2: {
                NegativeCondition nc = (NegativeCondition)condition;
                return !CSSStyleSheet.selects(browserVersion, nc.getCondition(), element);
            }
            case 11: {
                return element.getParentNode().getChildNodes().getLength() == 1;
            }
            case 13: {
                ContentCondition cc = (ContentCondition)condition;
                return element.asText().contains(cc.getData());
            }
            case 6: {
                String lcLang = ((LangCondition)condition).getLang();
                int lcLangLength = lcLang.length();
                DomNode node = element;
                while (node instanceof HtmlElement) {
                    String nodeLang = ((HtmlElement)node).getAttribute("lang");
                    if (DomElement.ATTRIBUTE_NOT_DEFINED != nodeLang) {
                        return nodeLang.startsWith(lcLang) && (nodeLang.length() == lcLangLength || '-' == nodeLang.charAt(lcLangLength));
                    }
                    node = node.getParentNode();
                }
                return false;
            }
            case 12: {
                String tagName = element.getTagName();
                return ((HtmlPage)element.getPage()).getElementsByTagName(tagName).getLength() == 1;
            }
            case 10: {
                return CSSStyleSheet.selectsPseudoClass(browserVersion, (AttributeCondition)condition, element);
            }
            case 3: {
                return false;
            }
        }
        LOG.error((Object)("Unknown CSS condition type '" + condition.getConditionType() + "'."));
        return false;
    }

    private static boolean selects(String condition, String attribute, char separator) {
        int conditionLength = condition.length();
        if (conditionLength < 1) {
            return false;
        }
        int attribLength = attribute.length();
        if (attribLength < conditionLength) {
            return false;
        }
        if (attribLength > conditionLength) {
            if (separator == attribute.charAt(conditionLength) && attribute.startsWith(condition)) {
                return true;
            }
            if (separator == attribute.charAt(attribLength - conditionLength - 1) && attribute.endsWith(condition)) {
                return true;
            }
            if (attribLength + 1 > conditionLength) {
                StringBuilder tmp = new StringBuilder(conditionLength + 2);
                tmp.append(separator).append(condition).append(separator);
                return attribute.contains(tmp);
            }
            return false;
        }
        return attribute.equals(condition);
    }

    private static boolean selectsWhitespaceSeparated(String condition, String attribute) {
        int conditionLength = condition.length();
        if (conditionLength < 1) {
            return false;
        }
        int attribLength = attribute.length();
        if (attribLength < conditionLength) {
            return false;
        }
        int pos = attribute.indexOf(condition);
        while (pos != -1) {
            if (pos > 0 && !Character.isWhitespace(attribute.charAt(pos - 1))) {
                pos = attribute.indexOf(condition, pos + 1);
                continue;
            }
            int lastPos = pos + condition.length();
            if (lastPos >= attribLength || Character.isWhitespace(attribute.charAt(lastPos))) {
                return true;
            }
            pos = attribute.indexOf(condition, pos + 1);
        }
        return false;
    }

    private static boolean selectsPseudoClass(BrowserVersion browserVersion, AttributeCondition condition, DomElement element) {
        String value;
        ScriptableObject sobj;
        if (browserVersion.hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && (sobj = element.getPage().getScriptableObject()) instanceof HTMLDocument && ((HTMLDocument)sobj).getDocumentMode() < 8) {
            return false;
        }
        switch (value = condition.getValue()) {
            case "root": {
                return element == element.getPage().getDocumentElement();
            }
            case "enabled": {
                return element instanceof DisabledElement && !((DisabledElement)((Object)element)).isDisabled();
            }
            case "disabled": {
                return element instanceof DisabledElement && ((DisabledElement)((Object)element)).isDisabled();
            }
            case "focus": {
                HtmlPage htmlPage = element.getHtmlPageOrNull();
                if (htmlPage != null) {
                    DomElement focus = htmlPage.getFocusedElement();
                    return element == focus;
                }
                return false;
            }
            case "checked": {
                return element instanceof HtmlCheckBoxInput && ((HtmlCheckBoxInput)element).isChecked() || element instanceof HtmlRadioButtonInput && ((HtmlRadioButtonInput)element).isChecked() || element instanceof HtmlOption && ((HtmlOption)element).isSelected();
            }
            case "required": {
                return (element instanceof HtmlInput || element instanceof HtmlSelect || element instanceof HtmlTextArea) && element.hasAttribute("required");
            }
            case "optional": {
                return (element instanceof HtmlInput || element instanceof HtmlSelect || element instanceof HtmlTextArea) && !element.hasAttribute("required");
            }
            case "first-child": {
                for (DomNode n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "last-child": {
                for (DomNode n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "first-of-type": {
                String firstType = element.getNodeName();
                for (DomNode n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(firstType)) continue;
                    return false;
                }
                return true;
            }
            case "last-of-type": {
                String lastType = element.getNodeName();
                for (DomNode n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(lastType)) continue;
                    return false;
                }
                return true;
            }
            case "only-child": {
                DomNode n;
                for (n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                for (n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "only-of-type": {
                DomNode n;
                String type = element.getNodeName();
                for (n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(type)) continue;
                    return false;
                }
                for (n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(type)) continue;
                    return false;
                }
                return true;
            }
            case "empty": {
                return CSSStyleSheet.isEmpty(element);
            }
            case "target": {
                if (browserVersion.hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NO_TARGET)) {
                    return false;
                }
                String ref = element.getPage().getUrl().getRef();
                return StringUtils.isNotBlank((CharSequence)ref) && ref.equals(element.getId());
            }
            case "hover": {
                return element.isMouseOver();
            }
        }
        if (value.startsWith("nth-child(")) {
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getPreviousSibling()) {
                if (!(n instanceof DomElement)) continue;
                ++index;
            }
            return CSSStyleSheet.getNth(nth, index);
        }
        if (value.startsWith("nth-last-child(")) {
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getNextSibling()) {
                if (!(n instanceof DomElement)) continue;
                ++index;
            }
            return CSSStyleSheet.getNth(nth, index);
        }
        if (value.startsWith("nth-of-type(")) {
            String nthType = element.getNodeName();
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getPreviousSibling()) {
                if (!(n instanceof DomElement) || !((DomNode)n).getNodeName().equals(nthType)) continue;
                ++index;
            }
            return CSSStyleSheet.getNth(nth, index);
        }
        if (value.startsWith("nth-last-of-type(")) {
            String nthLastType = element.getNodeName();
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getNextSibling()) {
                if (!(n instanceof DomElement) || !((DomNode)n).getNodeName().equals(nthLastType)) continue;
                ++index;
            }
            return CSSStyleSheet.getNth(nth, index);
        }
        if (value.startsWith("not(")) {
            String selectors = value.substring(value.indexOf(40) + 1, value.length() - 1);
            final AtomicBoolean errorOccured = new AtomicBoolean(false);
            ErrorHandler errorHandler = new ErrorHandler(){

                public void warning(CSSParseException exception) throws CSSException {
                }

                public void fatalError(CSSParseException exception) throws CSSException {
                    errorOccured.set(true);
                }

                public void error(CSSParseException exception) throws CSSException {
                    errorOccured.set(true);
                }
            };
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            parser.setErrorHandler(errorHandler);
            try {
                SelectorList selectorList = parser.parseSelectors(new InputSource((Reader)new StringReader(selectors)));
                if (errorOccured.get() || selectorList == null || selectorList.getLength() != 1) {
                    throw new CSSException("Invalid selectors: " + selectors);
                }
                CSSStyleSheet.validateSelectors(selectorList, 9, element);
                return !CSSStyleSheet.selects(browserVersion, selectorList.item(0), element);
            }
            catch (IOException e) {
                throw new CSSException("Error parsing CSS selectors from '" + selectors + "': " + e.getMessage());
            }
        }
        return false;
    }

    private static boolean isEmpty(DomElement element) {
        for (DomNode n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof DomElement) && !(n instanceof DomText)) continue;
            return false;
        }
        return true;
    }

    private static boolean getNth(String nth, int index) {
        String value;
        if ("odd".equalsIgnoreCase(nth)) {
            return index % 2 != 0;
        }
        if ("even".equalsIgnoreCase(nth)) {
            return index % 2 == 0;
        }
        int nIndex = nth.indexOf(110);
        int a = 0;
        if (nIndex != -1) {
            value = nth.substring(0, nIndex).trim();
            if ("-".equals(value)) {
                a = -1;
            } else {
                if (value.startsWith("+")) {
                    value = value.substring(1);
                }
                a = NumberUtils.toInt((String)value, (int)1);
            }
        }
        if ((value = nth.substring(nIndex + 1).trim()).startsWith("+")) {
            value = value.substring(1);
        }
        int b = NumberUtils.toInt((String)value, (int)0);
        if (a == 0) {
            return index == b && b > 0;
        }
        double n = (double)(index - b) / (double)a;
        return n >= 0.0 && n % 1.0 == 0.0;
    }

    private org.w3c.dom.css.CSSStyleSheet parseCSS(InputSource source) {
        org.w3c.dom.css.CSSStyleSheet ss;
        try {
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            parser.setErrorHandler(errorHandler);
            ss = parser.parseStyleSheet(source, null, null);
        }
        catch (Throwable t) {
            LOG.error((Object)("Error parsing CSS from '" + CSSStyleSheet.toString(source) + "': " + t.getMessage()), t);
            ss = new CSSStyleSheetImpl();
        }
        return ss;
    }

    public SelectorList parseSelectors(InputSource source) {
        SelectorList selectors;
        try {
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            parser.setErrorHandler(errorHandler);
            selectors = parser.parseSelectors(source);
            if (null == selectors) {
                selectors = new SelectorListImpl();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Error parsing CSS selectors from '" + CSSStyleSheet.toString(source) + "': " + t.getMessage()), t);
            selectors = new SelectorListImpl();
        }
        return selectors;
    }

    static SACMediaList parseMedia(ErrorHandler errorHandler, String mediaString) {
        try {
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            parser.setErrorHandler(errorHandler);
            InputSource source = new InputSource((Reader)new StringReader(mediaString));
            SACMediaList media = parser.parseMedia(source);
            if (media != null) {
                return media;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error parsing CSS media from '" + mediaString + "': " + e.getMessage()), (Throwable)e);
        }
        return new SACMediaListImpl();
    }

    private static String toString(InputSource source) {
        try {
            Reader reader = source.getCharacterStream();
            if (null != reader) {
                if (reader instanceof StringReader) {
                    StringReader sr = (StringReader)reader;
                    sr.reset();
                }
                return IOUtils.toString((Reader)reader);
            }
            InputStream is = source.getByteStream();
            if (null != is) {
                if (is instanceof ByteArrayInputStream) {
                    ByteArrayInputStream bis = (ByteArrayInputStream)is;
                    bis.reset();
                }
                return IOUtils.toString((InputStream)is, (Charset)TextUtil.DEFAULT_CHARSET);
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    @JsxGetter
    public HTMLElement getOwnerNode() {
        return this.ownerNode_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public HTMLElement getOwningElement() {
        return this.ownerNode_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public CSSRuleList getRules() {
        return this.getCssRules();
    }

    @JsxGetter
    public CSSRuleList getCssRules() {
        this.initCssRules();
        return this.cssRules_;
    }

    @JsxGetter
    public String getHref() {
        HtmlElement node;
        BrowserVersion version = this.getBrowserVersion();
        if (this.ownerNode_ != null && (node = this.ownerNode_.getDomNodeOrDie()) instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)node;
            HtmlPage page = (HtmlPage)link.getPage();
            String href = link.getHrefAttribute();
            if ("".equals(href) && version.hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_EMPTY_IS_NULL)) {
                return null;
            }
            try {
                URL url = page.getFullyQualifiedUrl(href);
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @JsxFunction
    public int insertRule(String rule, int position) {
        try {
            this.initCssRules();
            int result = this.wrapped_.insertRule(rule, this.fixIndex(position));
            this.refreshCssRules();
            return result;
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    private void refreshCssRules() {
        if (this.cssRules_ == null) {
            return;
        }
        this.cssRules_.clearRules();
        this.cssRulesIndexFix_.clear();
        org.w3c.dom.css.CSSRuleList ruleList = this.getWrappedSheet().getCssRules();
        List rules = ((CSSRuleListImpl)ruleList).getRules();
        int pos = 0;
        for (org.w3c.dom.css.CSSRule rule : rules) {
            if (rule instanceof CSSCharsetRule) {
                this.cssRulesIndexFix_.add(pos);
                continue;
            }
            CSSRule cssRule = CSSRule.create(this, rule);
            if (null == cssRule) {
                this.cssRulesIndexFix_.add(pos);
            } else {
                this.cssRules_.addRule(cssRule);
            }
            ++pos;
        }
    }

    private int fixIndex(int index) {
        for (int fix : this.cssRulesIndexFix_) {
            if (fix > index) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @JsxFunction
    public void deleteRule(int position) {
        try {
            this.initCssRules();
            this.wrapped_.deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public int addRule(String selector, String rule) {
        String completeRule = selector + " {" + rule + "}";
        try {
            this.initCssRules();
            this.wrapped_.insertRule(completeRule, this.wrapped_.getCssRules().getLength());
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
        return -1;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public void removeRule(int position) {
        try {
            this.initCssRules();
            this.wrapped_.deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    public String getUri() {
        return this.uri_;
    }

    public boolean isActive() {
        String media;
        HtmlElement e = this.ownerNode_.getDomNodeOrNull();
        if (e instanceof HtmlStyle) {
            HtmlStyle style = (HtmlStyle)e;
            media = style.getMediaAttribute();
        } else if (e instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)e;
            media = link.getMediaAttribute();
        } else {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)media)) {
            return true;
        }
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        SACMediaList mediaList = CSSStyleSheet.parseMedia(webClient.getCssErrorHandler(), media);
        return CSSStyleSheet.isActive((SimpleScriptable)this, (MediaList)new MediaListImpl(mediaList));
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    static boolean isActive(SimpleScriptable scriptable, MediaList mediaList) {
        if (mediaList.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < mediaList.getLength(); ++i) {
            MediaQuery mediaQuery = ((MediaListImpl)mediaList).mediaQuery(i);
            boolean isActive = CSSStyleSheet.isActive(scriptable, mediaQuery);
            if (mediaQuery.isNot()) {
                boolean bl = isActive = !isActive;
            }
            if (!isActive) continue;
            return true;
        }
        return false;
    }

    private static boolean isActive(SimpleScriptable scriptable, MediaQuery mediaQuery) {
        String mediaType = mediaQuery.getMedia();
        if ("screen".equalsIgnoreCase(mediaType) || "all".equalsIgnoreCase(mediaType)) {
            for (Property property : mediaQuery.getProperties()) {
                switch (property.getName()) {
                    case "max-width": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val < (float)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "min-width": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val > (float)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "max-device-width": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val < (float)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "min-device-width": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val > (float)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "max-height": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val < (float)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "min-height": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val > (float)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "max-device-height": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val < (float)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "min-device-height": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val > (float)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "resolution": {
                        float val = CSSStyleSheet.resolutionValue((CSSValueImpl)property.getValue());
                        if (Math.round(val) == scriptable.getWindow().getScreen().getDeviceXDPI()) break;
                        return false;
                    }
                    case "max-resolution": {
                        float val = CSSStyleSheet.resolutionValue((CSSValueImpl)property.getValue());
                        if (!(val < (float)scriptable.getWindow().getScreen().getDeviceXDPI())) break;
                        return false;
                    }
                    case "min-resolution": {
                        float val = CSSStyleSheet.resolutionValue((CSSValueImpl)property.getValue());
                        if (!(val > (float)scriptable.getWindow().getScreen().getDeviceXDPI())) break;
                        return false;
                    }
                    case "orientation": {
                        String orient = property.getValue().getCssText();
                        WebWindow window = scriptable.getWindow().getWebWindow();
                        if ("portrait".equals(orient)) {
                            if (window.getInnerWidth() <= window.getInnerHeight()) break;
                            return false;
                        }
                        if ("landscape".equals(orient)) {
                            if (window.getInnerWidth() >= window.getInnerHeight()) break;
                            return false;
                        }
                        LOG.warn((Object)("CSSValue '" + property.getValue().getCssText() + "' not supported for feature 'orientation'."));
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static float pixelValue(CSSValueImpl cssValue, SimpleScriptable scriptable) {
        switch (cssValue.getPrimitiveType()) {
            case 5: {
                return cssValue.getFloatValue((short)5);
            }
            case 3: {
                return 16.0f * cssValue.getFloatValue((short)3);
            }
            case 2: {
                return 0.16f * cssValue.getFloatValue((short)2);
            }
            case 4: {
                return 0.16f * cssValue.getFloatValue((short)4);
            }
            case 7: {
                int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                return (float)dpi / 25.4f * cssValue.getFloatValue((short)7);
            }
            case 6: {
                int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                return (float)dpi / 254.0f * cssValue.getFloatValue((short)6);
            }
            case 9: {
                int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                return (float)dpi / 72.0f * cssValue.getFloatValue((short)9);
            }
        }
        LOG.warn((Object)("CSSValue '" + cssValue.getCssText() + "' has to be a 'px', 'em', '%', 'mm', 'ex', or 'pt' value."));
        return -1.0f;
    }

    private static float resolutionValue(CSSValueImpl cssValue) {
        if (cssValue.getPrimitiveType() == 18) {
            String text = cssValue.getCssText();
            if (text.endsWith("dpi")) {
                return cssValue.getFloatValue((short)18);
            }
            if (text.endsWith("dpcm")) {
                return 2.54f * cssValue.getFloatValue((short)18);
            }
            if (text.endsWith("dppx")) {
                return 96.0f * cssValue.getFloatValue((short)18);
            }
        }
        LOG.warn((Object)("CSSValue '" + cssValue.getCssText() + "' has to be a 'dpi', 'dpcm', or 'dppx' value."));
        return -1.0f;
    }

    public static void validateSelectors(SelectorList selectorList, int documentMode, DomNode domNode) throws CSSException {
        for (int i = 0; i < selectorList.getLength(); ++i) {
            Selector item = selectorList.item(i);
            if (CSSStyleSheet.isValidSelector(item, documentMode, domNode)) continue;
            throw new CSSException("Invalid selector: " + item);
        }
    }

    private static boolean isValidSelector(Selector selector, int documentMode, DomNode domNode) {
        switch (selector.getSelectorType()) {
            case 4: {
                return true;
            }
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                SimpleSelector simpleSel = conditional.getSimpleSelector();
                return (simpleSel == null || CSSStyleSheet.isValidSelector((Selector)simpleSel, documentMode, domNode)) && CSSStyleSheet.isValidCondition(conditional.getCondition(), documentMode, domNode);
            }
            case 10: 
            case 11: {
                DescendantSelector ds = (DescendantSelector)selector;
                return CSSStyleSheet.isValidSelector(ds.getAncestorSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector((Selector)ds.getSimpleSelector(), documentMode, domNode);
            }
            case 12: {
                SiblingSelector ss = (SiblingSelector)selector;
                return CSSStyleSheet.isValidSelector(ss.getSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector((Selector)ss.getSiblingSelector(), documentMode, domNode);
            }
            case 1: {
                if (!(selector instanceof SiblingSelector)) break;
                SiblingSelector sibling = (SiblingSelector)selector;
                return CSSStyleSheet.isValidSelector(sibling.getSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector((Selector)sibling.getSiblingSelector(), documentMode, domNode);
            }
        }
        LOG.warn((Object)("Unhandled CSS selector type '" + selector.getSelectorType() + "'. Accepting it silently."));
        return true;
    }

    private static boolean isValidCondition(Condition condition, int documentMode, DomNode domNode) {
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition cc1 = (CombinatorCondition)condition;
                return CSSStyleSheet.isValidCondition(cc1.getFirstCondition(), documentMode, domNode) && CSSStyleSheet.isValidCondition(cc1.getSecondCondition(), documentMode, domNode);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
            case 10: {
                PseudoClassConditionImpl pcc = (PseudoClassConditionImpl)condition;
                String value = pcc.getValue();
                if (value.endsWith(")")) {
                    if (value.endsWith("()")) {
                        return false;
                    }
                    value = value.substring(0, value.indexOf(40) + 1) + ')';
                }
                if (documentMode < 9) {
                    return CSS2_PSEUDO_CLASSES.contains(value);
                }
                if (!CSS2_PSEUDO_CLASSES.contains(value) && domNode.hasFeature(BrowserVersionFeatures.QUERYSELECTOR_CSS3_PSEUDO_REQUIRE_ATTACHED_NODE) && !domNode.isAttachedToPage() && !domNode.hasChildNodes()) {
                    throw new CSSException("Syntax Error");
                }
                if ("nth-child()".equals(value)) {
                    String arg = StringUtils.substringBetween((String)pcc.getValue(), (String)"(", (String)")").trim();
                    return "even".equalsIgnoreCase(arg) || "odd".equalsIgnoreCase(arg) || NTH_NUMERIC.matcher(arg).matches() || NTH_COMPLEX.matcher(arg).matches();
                }
                return CSS3_PSEUDO_CLASSES.contains(value);
            }
        }
        LOG.warn((Object)("Unhandled CSS condition type '" + condition.getConditionType() + "'. Accepting it silently."));
        return true;
    }

    private void initCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
            this.cssRulesIndexFix_ = new ArrayList<Integer>();
            this.refreshCssRules();
        }
    }

    static {
        CSS3_PSEUDO_CLASSES.addAll(CSS2_PSEUDO_CLASSES);
    }
}

