/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.ElementFactory;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlColorInput;
import com.gargoylesoftware.htmlunit.html.HtmlDateInput;
import com.gargoylesoftware.htmlunit.html.HtmlDateTimeLocalInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmailInput;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlMonthInput;
import com.gargoylesoftware.htmlunit.html.HtmlNumberInput;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlRangeInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSearchInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTelInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.HtmlTimeInput;
import com.gargoylesoftware.htmlunit.html.HtmlUrlInput;
import com.gargoylesoftware.htmlunit.html.HtmlWeekInput;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public final class InputElementFactory
implements ElementFactory {
    private static final Log LOG = LogFactory.getLog(InputElementFactory.class);
    public static final InputElementFactory instance = new InputElementFactory();

    private InputElementFactory() {
    }

    @Override
    public HtmlElement createElement(SgmlPage page, String tagName, Attributes attributes) {
        return this.createElementNS(page, null, tagName, attributes);
    }

    @Override
    public HtmlElement createElementNS(SgmlPage page, String namespaceURI, String qualifiedName, Attributes attributes) {
        return this.createElementNS(page, namespaceURI, qualifiedName, attributes, false);
    }

    @Override
    public HtmlElement createElementNS(SgmlPage page, String namespaceURI, String qualifiedName, Attributes attributes, boolean asdf) {
        HtmlInput result;
        Map<String, DomAttr> attributeMap = DefaultElementFactory.setAttributes(page, attributes);
        if (attributeMap == null) {
            attributeMap = new HashMap<String, DomAttr>();
        }
        String type = null;
        if (attributes != null) {
            type = attributes.getValue("type");
        }
        if (type == null) {
            type = "";
        }
        switch (type.toLowerCase(Locale.ROOT)) {
            case "": 
            case "text": {
                result = new HtmlTextInput(qualifiedName, page, attributeMap);
                break;
            }
            case "submit": {
                result = new HtmlSubmitInput(qualifiedName, page, attributeMap);
                break;
            }
            case "checkbox": {
                result = new HtmlCheckBoxInput(qualifiedName, page, attributeMap);
                break;
            }
            case "radio": {
                result = new HtmlRadioButtonInput(qualifiedName, page, attributeMap);
                break;
            }
            case "hidden": {
                result = new HtmlHiddenInput(qualifiedName, page, attributeMap);
                break;
            }
            case "password": {
                result = new HtmlPasswordInput(qualifiedName, page, attributeMap);
                break;
            }
            case "image": {
                result = new HtmlImageInput(qualifiedName, page, attributeMap);
                break;
            }
            case "reset": {
                result = new HtmlResetInput(qualifiedName, page, attributeMap);
                break;
            }
            case "button": {
                result = new HtmlButtonInput(qualifiedName, page, attributeMap);
                break;
            }
            case "file": {
                result = new HtmlFileInput(qualifiedName, page, attributeMap);
                break;
            }
            case "color": {
                result = new HtmlColorInput(qualifiedName, page, attributeMap);
                break;
            }
            case "date": {
                result = new HtmlDateInput(qualifiedName, page, attributeMap);
                break;
            }
            case "datetime-local": {
                result = new HtmlDateTimeLocalInput(qualifiedName, page, attributeMap);
                break;
            }
            case "email": {
                result = new HtmlEmailInput(qualifiedName, page, attributeMap);
                break;
            }
            case "month": {
                result = new HtmlMonthInput(qualifiedName, page, attributeMap);
                break;
            }
            case "number": {
                result = new HtmlNumberInput(qualifiedName, page, attributeMap);
                break;
            }
            case "range": {
                result = new HtmlRangeInput(qualifiedName, page, attributeMap);
                break;
            }
            case "search": {
                result = new HtmlSearchInput(qualifiedName, page, attributeMap);
                break;
            }
            case "tel": {
                result = new HtmlTelInput(qualifiedName, page, attributeMap);
                break;
            }
            case "time": {
                result = new HtmlTimeInput(qualifiedName, page, attributeMap);
                break;
            }
            case "url": {
                result = new HtmlUrlInput(qualifiedName, page, attributeMap);
                break;
            }
            case "week": {
                result = new HtmlWeekInput(qualifiedName, page, attributeMap);
                break;
            }
            default: {
                LOG.info((Object)("Bad input type: \"" + type + "\", creating a text input"));
                result = new HtmlTextInput(qualifiedName, page, attributeMap);
            }
        }
        return result;
    }

    public static boolean isSupported(String type) {
        boolean supported = false;
        switch (type) {
            case "text": 
            case "submit": 
            case "checkbox": 
            case "radio": 
            case "hidden": 
            case "password": 
            case "image": 
            case "reset": 
            case "button": 
            case "file": 
            case "color": 
            case "date": 
            case "datetime-local": 
            case "email": 
            case "month": 
            case "number": 
            case "range": 
            case "search": 
            case "tel": 
            case "time": 
            case "url": 
            case "week": {
                supported = true;
                break;
            }
        }
        return supported;
    }
}

