/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMAttribute;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMCDATASection;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocumentFragment;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocumentType;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMElement;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMImplementation;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNodeList;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMParseError;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMText;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLSerializer;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomProcessingInstruction;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE)})
public class XMLDOMDocument
extends XMLDOMNode {
    private static final Log LOG = LogFactory.getLog(XMLDOMDocument.class);
    private boolean async_ = true;
    private XMLDOMImplementation implementation_;
    private boolean preserveWhiteSpace_;
    private boolean preserveWhiteSpaceDuringLoad_ = true;
    private XMLDOMParseError parseError_;
    private Map<String, String> properties_ = new HashMap<String, String>();
    private String url_ = "";

    public XMLDOMDocument() {
        this(null);
    }

    public XMLDOMDocument(WebWindow enclosingWindow) {
        if (enclosingWindow != null) {
            try {
                XmlPage page = new XmlPage(null, enclosingWindow, true, false);
                this.setDomNode(page);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("IOException: " + e));
            }
        }
    }

    @JsxGetter
    public boolean getAsync() {
        return this.async_;
    }

    @JsxSetter
    public void setAsync(boolean async) {
        this.async_ = async;
    }

    @JsxGetter
    public XMLDOMDocumentType getDoctype() {
        DocumentType documentType = this.getPage().getDoctype();
        if (documentType == null) {
            return null;
        }
        return (XMLDOMDocumentType)this.getScriptableFor(documentType);
    }

    @JsxGetter
    public XMLDOMElement getDocumentElement() {
        DomElement documentElement = this.getPage().getDocumentElement();
        if (documentElement == null) {
            return null;
        }
        return (XMLDOMElement)this.getScriptableFor(documentElement);
    }

    @JsxSetter
    public void setDocumentElement(XMLDOMElement element) {
        if (element == null) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        XMLDOMElement documentElement = this.getDocumentElement();
        if (documentElement != null) {
            documentElement.getDomNodeOrDie().remove();
        }
        this.appendChild(element);
    }

    @JsxGetter
    public XMLDOMImplementation getImplementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new XMLDOMImplementation();
            this.implementation_.setParentScope(this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(this.implementation_.getClass()));
        }
        return this.implementation_;
    }

    @Override
    public void setNodeValue(String value) {
        if (value == null || "null".equals(value)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        throw Context.reportRuntimeError((String)"This operation cannot be performed with a node of type DOCUMENT.");
    }

    @Override
    public Object getOwnerDocument() {
        return null;
    }

    @JsxGetter
    public XMLDOMParseError getParseError() {
        if (this.parseError_ == null) {
            this.parseError_ = new XMLDOMParseError();
            this.parseError_.setParentScope(this.getParentScope());
            this.parseError_.setPrototype(this.getPrototype(this.parseError_.getClass()));
        }
        return this.parseError_;
    }

    @JsxGetter
    public boolean getPreserveWhiteSpace() {
        return this.preserveWhiteSpace_;
    }

    @JsxSetter
    public void setPreserveWhiteSpace(boolean preserveWhiteSpace) {
        this.preserveWhiteSpace_ = preserveWhiteSpace;
    }

    @Override
    public Object getText() {
        XMLDOMElement element = this.getDocumentElement();
        if (element == null) {
            return "";
        }
        return element.getText();
    }

    @Override
    public void setText(Object text) {
        if (text == null || "null".equals(text)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        throw Context.reportRuntimeError((String)"This operation cannot be performed with a node of type DOCUMENT.");
    }

    @JsxGetter
    public String getUrl() {
        return this.url_;
    }

    @Override
    @JsxGetter
    public String getXml() {
        XMLSerializer seralizer = new XMLSerializer(this.preserveWhiteSpaceDuringLoad_);
        return seralizer.serializeToString(this.getDocumentElement());
    }

    @Override
    public Object appendChild(Object newChild) {
        this.verifyChild(newChild);
        return super.appendChild(newChild);
    }

    private void verifyChild(Object newChild) {
        if (newChild == null || "null".equals(newChild) || !(newChild instanceof XMLDOMNode)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        if (newChild instanceof XMLDOMCDATASection) {
            throw Context.reportRuntimeError((String)"This operation cannot be performed with a node of type CDATA.");
        }
        if (newChild instanceof XMLDOMText) {
            throw Context.reportRuntimeError((String)"This operation cannot be performed with a node of type TEXT.");
        }
        if (newChild instanceof XMLDOMElement && this.getDocumentElement() != null) {
            throw Context.reportRuntimeError((String)"Only one top level element is allowed in an XML document.");
        }
        if (newChild instanceof XMLDOMDocumentFragment) {
            boolean elementFound = false;
            for (XMLDOMNode child = ((XMLDOMDocumentFragment)newChild).getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof XMLDOMCDATASection) {
                    throw Context.reportRuntimeError((String)"This operation cannot be performed with a node of type CDATA.");
                }
                if (child instanceof XMLDOMText) {
                    throw Context.reportRuntimeError((String)"This operation cannot be performed with a node of type TEXT.");
                }
                if (!(child instanceof XMLDOMElement)) continue;
                if (elementFound) {
                    throw Context.reportRuntimeError((String)"Only one top level element is allowed in an XML document.");
                }
                elementFound = true;
            }
        }
    }

    @JsxFunction
    public Object createAttribute(String name) {
        if (name == null || "null".equals(name)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        if (StringUtils.isBlank((CharSequence)name) || name.indexOf(60) >= 0 || name.indexOf(62) >= 0) {
            throw Context.reportRuntimeError((String)"To create a node of type ATTR a valid name must be given.");
        }
        DomAttr domAttr = this.getPage().createAttribute(name);
        return this.getScriptableFor(domAttr);
    }

    @JsxFunction
    public Object createCDATASection(String data) {
        CDATASection domCDATASection = this.getPage().createCDATASection(data);
        return this.getScriptableFor(domCDATASection);
    }

    @JsxFunction
    public Object createComment(String data) {
        DomComment domComment = new DomComment(this.getPage(), data);
        return this.getScriptableFor(domComment);
    }

    @JsxFunction
    public Object createDocumentFragment() {
        DomDocumentFragment domDocumentFragment = new DomDocumentFragment(this.getPage());
        return this.getScriptableFor(domDocumentFragment);
    }

    @JsxFunction
    public Object createElement(String tagName) {
        if (tagName == null || "null".equals(tagName)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        if (StringUtils.isBlank((CharSequence)tagName) || tagName.indexOf(60) >= 0 || tagName.indexOf(62) >= 0) {
            throw Context.reportRuntimeError((String)"To create a node of type ELEMENT a valid name must be given.");
        }
        Object result = NOT_FOUND;
        try {
            DomElement domElement = (DomElement)this.getPage().createElement(tagName);
            SimpleScriptable jsElement = this.getScriptableFor(domElement);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a JavaScript object for the element " + domElement.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @JsxFunction
    public Object createNode(Object type, String name, Object namespaceURI) {
        switch ((short)Context.toNumber((Object)type)) {
            case 1: {
                return this.createElementNS((String)namespaceURI, name);
            }
            case 2: {
                return this.createAttribute(name);
            }
        }
        throw Context.reportRuntimeError((String)("xmlDoc.createNode(): Unsupported type " + (short)Context.toNumber((Object)type)));
    }

    private Object createElementNS(String namespaceURI, String qualifiedName) {
        if ("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(namespaceURI)) {
            throw Context.reportRuntimeError((String)"XUL not available");
        }
        Element element = "http://www.w3.org/1999/xhtml".equals(namespaceURI) || "http://www.w3.org/2000/svg".equals(namespaceURI) ? this.getPage().createElementNS(namespaceURI, qualifiedName) : new DomElement(namespaceURI, qualifiedName, this.getPage(), null);
        return this.getScriptableFor(element);
    }

    @JsxFunction
    public Object createProcessingInstruction(String target, String data) {
        DomProcessingInstruction domProcessingInstruction = ((XmlPage)this.getPage()).createProcessingInstruction(target, data);
        return this.getScriptableFor(domProcessingInstruction);
    }

    @JsxFunction
    public Object createTextNode(String data) {
        Object result = NOT_FOUND;
        try {
            DomText domText = new DomText(this.getPage(), data);
            SimpleScriptable jsElement = this.getScriptableFor(domText);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("createTextNode(" + data + ") cannot return a result as there isn't a JavaScript object for the DOM node " + domText.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @JsxFunction
    public XMLDOMNodeList getElementsByTagName(final String tagName) {
        DomNode firstChild = this.getDomNodeOrDie().getFirstChild();
        if (firstChild == null) {
            return XMLDOMNodeList.emptyCollection(this);
        }
        XMLDOMNodeList collection = new XMLDOMNodeList(this.getDomNodeOrDie(), false, "XMLDOMDocument.getElementsByTagName"){

            @Override
            protected boolean isMatching(DomNode node) {
                return node.getNodeName().equals(tagName);
            }
        };
        return collection;
    }

    @JsxFunction
    public String getProperty(String name) {
        return this.properties_.get(name);
    }

    @Override
    protected Object insertBeforeImpl(Object[] args) {
        Object newChild = args[0];
        this.verifyChild(newChild);
        if (args.length != 2) {
            throw Context.reportRuntimeError((String)"Wrong number of arguments or invalid property assignment.");
        }
        return super.insertBeforeImpl(args);
    }

    @JsxFunction
    public boolean load(String xmlSource) {
        if (this.async_ && LOG.isDebugEnabled()) {
            LOG.debug((Object)"XMLDOMDocument.load(): 'async' is true, currently treated as false.");
        }
        try {
            HtmlPage htmlPage = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
            URL fullyQualifiedURL = htmlPage.getFullyQualifiedUrl(xmlSource);
            WebRequest request = new WebRequest(fullyQualifiedURL);
            WebResponse webResponse = this.getWindow().getWebWindow().getWebClient().loadWebResponse(request);
            XmlPage page = new XmlPage(webResponse, this.getWindow().getWebWindow(), false, false);
            this.setDomNode(page);
            this.preserveWhiteSpaceDuringLoad_ = this.preserveWhiteSpace_;
            this.url_ = fullyQualifiedURL.toExternalForm();
            return true;
        }
        catch (IOException e) {
            XMLDOMParseError parseError = this.getParseError();
            parseError.setErrorCode(-1);
            parseError.setFilepos(1);
            parseError.setLine(1);
            parseError.setLinepos(1);
            parseError.setReason(e.getMessage());
            parseError.setSrcText("xml");
            parseError.setUrl(xmlSource);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error parsing XML from '" + xmlSource + "'"), (Throwable)e);
            }
            return false;
        }
    }

    @JsxFunction
    public boolean loadXML(String strXML) {
        try {
            WebWindow webWindow = this.getWindow().getWebWindow();
            StringWebResponse webResponse = new StringWebResponse(strXML, webWindow.getEnclosedPage().getUrl());
            XmlPage page = new XmlPage(webResponse, webWindow, false, false);
            this.setDomNode(page);
            this.preserveWhiteSpaceDuringLoad_ = this.preserveWhiteSpace_;
            this.url_ = "";
            return true;
        }
        catch (IOException e) {
            XMLDOMParseError parseError = this.getParseError();
            parseError.setErrorCode(-1);
            parseError.setFilepos(1);
            parseError.setLine(1);
            parseError.setLinepos(1);
            parseError.setReason(e.getMessage());
            parseError.setSrcText("xml");
            parseError.setUrl("");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error parsing XML\n" + strXML), (Throwable)e);
            }
            return false;
        }
    }

    @JsxFunction
    public Object nodeFromID(String id) {
        return null;
    }

    @JsxFunction
    public void setProperty(String name, String value) {
        this.properties_.put(name, value);
    }

    public boolean isPreserveWhiteSpaceDuringLoad() {
        return this.preserveWhiteSpaceDuringLoad_;
    }

    protected SgmlPage getPage() {
        return (SgmlPage)this.getDomNodeOrDie();
    }

    @Override
    public MSXMLScriptable makeScriptableFor(DomNode domNode) {
        XMLDOMNode scriptable;
        if (domNode instanceof DomElement && !(domNode instanceof HtmlElement)) {
            scriptable = new XMLDOMElement();
        } else if (domNode instanceof DomAttr) {
            scriptable = new XMLDOMAttribute();
        } else {
            return (MSXMLScriptable)super.makeScriptableFor(domNode);
        }
        scriptable.setParentScope((Scriptable)this);
        scriptable.setPrototype(this.getPrototype(scriptable.getClass()));
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    @Override
    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        scriptable.setParentScope(this.getParentScope());
    }
}

