/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.AppletConfirmHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.DefaultCssErrorHandler;
import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.IncorrectnessListenerImpl;
import com.gargoylesoftware.htmlunit.NiceRefreshHandler;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.ProxyAutoConfig;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.StorageHolder;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.UrlFetchWebConnection;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebConsole;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseFromCache;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLActiveXObjectFactory;
import com.gargoylesoftware.htmlunit.attachment.Attachment;
import com.gargoylesoftware.htmlunit.attachment.AttachmentHandler;
import com.gargoylesoftware.htmlunit.gae.GAEUtils;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitBrowserCompatCookieSpec;
import com.gargoylesoftware.htmlunit.javascript.DefaultJavaScriptErrorListener;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLIFrameElement;
import com.gargoylesoftware.htmlunit.protocol.data.DataUrlDecoder;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.w3c.css.sac.ErrorHandler;

public class WebClient
implements Serializable,
AutoCloseable {
    private static final Log LOG = LogFactory.getLog(WebClient.class);
    private static final int ALLOWED_REDIRECTIONS_SAME_URL = 20;
    private transient WebConnection webConnection_;
    private CredentialsProvider credentialsProvider_ = new DefaultCredentialsProvider();
    private CookieManager cookieManager_ = new CookieManager();
    private transient JavaScriptEngine scriptEngine_;
    private final Map<String, String> requestHeaders_ = Collections.synchronizedMap(new HashMap(89));
    private IncorrectnessListener incorrectnessListener_ = new IncorrectnessListenerImpl();
    private WebConsole webConsole_;
    private AlertHandler alertHandler_;
    private ConfirmHandler confirmHandler_;
    private PromptHandler promptHandler_;
    private StatusHandler statusHandler_;
    private AttachmentHandler attachmentHandler_;
    private AppletConfirmHandler appletConfirmHandler_;
    private AjaxController ajaxController_ = new AjaxController();
    private BrowserVersion browserVersion_;
    private PageCreator pageCreator_ = new DefaultPageCreator();
    private final Set<WebWindowListener> webWindowListeners_ = new HashSet<WebWindowListener>(5);
    private final Stack<TopLevelWindow> topLevelWindows_ = new Stack();
    private final List<WebWindow> windows_ = Collections.synchronizedList(new ArrayList());
    private transient List<WeakReference<JavaScriptJobManager>> jobManagers_ = Collections.synchronizedList(new ArrayList());
    private WebWindow currentWindow_;
    private HTMLParserListener htmlParserListener_;
    private ErrorHandler cssErrorHandler_ = new DefaultCssErrorHandler();
    private OnbeforeunloadHandler onbeforeunloadHandler_;
    private Cache cache_ = new Cache();
    private static final String TARGET_BLANK = "_blank";
    private static final String TARGET_SELF = "_self";
    private static final String TARGET_PARENT = "_parent";
    private static final String TARGET_TOP = "_top";
    public static final String ABOUT_SCHEME = "about:";
    public static final String ABOUT_BLANK = "about:blank";
    public static final URL URL_ABOUT_BLANK = UrlUtils.toUrlSafe("about:blank");
    private ScriptPreProcessor scriptPreProcessor_;
    private Map<String, String> activeXObjectMap_ = Collections.emptyMap();
    private transient MSXMLActiveXObjectFactory msxmlActiveXObjectFactory_;
    private RefreshHandler refreshHandler_ = new NiceRefreshHandler(2);
    private JavaScriptErrorListener javaScriptErrorListener_ = new DefaultJavaScriptErrorListener();
    private WebClientOptions options_ = new WebClientOptions();
    private final StorageHolder storageHolder_ = new StorageHolder();
    private static final WebResponseData responseDataNoHttpResponse_ = new WebResponseData(0, "No HTTP Response", Collections.emptyList());
    private final List<LoadJob> loadQueue_ = new ArrayList<LoadJob>();

    public WebClient() {
        this(BrowserVersion.getDefault());
    }

    public WebClient(BrowserVersion browserVersion) {
        WebAssert.notNull("browserVersion", browserVersion);
        this.init(browserVersion, new ProxyConfig());
    }

    public WebClient(BrowserVersion browserVersion, String proxyHost, int proxyPort) {
        WebAssert.notNull("browserVersion", browserVersion);
        WebAssert.notNull("proxyHost", proxyHost);
        this.init(browserVersion, new ProxyConfig(proxyHost, proxyPort));
    }

    private void init(BrowserVersion browserVersion, ProxyConfig proxyConfig) {
        this.browserVersion_ = browserVersion;
        this.getOptions().setProxyConfig(proxyConfig);
        this.webConnection_ = this.createWebConnection();
        this.scriptEngine_ = new JavaScriptEngine(this);
        this.addWebWindowListener(new CurrentWindowTracker(this));
        this.currentWindow_ = new TopLevelWindow("", this);
        this.fireWindowOpened(new WebWindowEvent(this.currentWindow_, 1, null, null));
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SUPPORT_VIA_ACTIVEXOBJECT)) {
            this.initMSXMLActiveX();
        }
    }

    private void initMSXMLActiveX() {
        this.msxmlActiveXObjectFactory_ = new MSXMLActiveXObjectFactory();
        try {
            this.msxmlActiveXObjectFactory_.init(this.getBrowserVersion());
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while initializing MSXML ActiveX for the page", (Throwable)e);
            throw new ScriptException(null, (Throwable)e);
        }
    }

    public WebConnection getWebConnection() {
        return this.webConnection_;
    }

    public void setWebConnection(WebConnection webConnection) {
        WebAssert.notNull("webConnection", webConnection);
        this.webConnection_ = webConnection;
    }

    public <P extends Page> P getPage(WebWindow webWindow, WebRequest webRequest) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(webWindow, webRequest, true);
    }

    public <P extends Page> P getPage(WebWindow webWindow, WebRequest webRequest, boolean addToHistory) throws IOException, FailingHttpStatusCodeException {
        WebResponse webResponse;
        String protocol;
        Page page = webWindow.getEnclosedPage();
        if (page != null) {
            HtmlPage htmlPage;
            URL prev = page.getUrl();
            URL current = webRequest.getUrl();
            if (UrlUtils.sameFile(current, prev) && current.getRef() != null && !StringUtils.equals((CharSequence)current.getRef(), (CharSequence)prev.getRef())) {
                Window window;
                page.getWebResponse().getWebRequest().setUrl(current);
                if (addToHistory) {
                    webWindow.getHistory().addPage(page);
                }
                if ((window = (Window)webWindow.getScriptableObject()) != null) {
                    window.getLocation().setHash(current.getRef());
                }
                return (P)page;
            }
            if (page.isHtmlPage() && !(htmlPage = (HtmlPage)page).isOnbeforeunloadAccepted()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The registered OnbeforeunloadHandler rejected to load a new page.");
                }
                return (P)page;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get page for window named '" + webWindow.getName() + "', using " + webRequest));
        }
        if ("javascript".equals(protocol = webRequest.getUrl().getProtocol())) {
            webResponse = this.makeWebResponseForJavaScriptUrl(webWindow, webRequest.getUrl(), webRequest.getCharset());
            if (webWindow.getEnclosedPage() != null && webWindow.getEnclosedPage().getWebResponse() == webResponse) {
                return (P)webWindow.getEnclosedPage();
            }
        } else {
            webResponse = this.loadWebResponse(webRequest);
        }
        this.printContentIfNecessary(webResponse);
        this.loadWebResponseInto(webResponse, webWindow);
        if (this.scriptEngine_ != null) {
            this.scriptEngine_.registerWindowAndMaybeStartEventLoop(webWindow);
        }
        this.throwFailingHttpStatusCodeExceptionIfNecessary(webResponse);
        return (P)webWindow.getEnclosedPage();
    }

    public <P extends Page> P getPage(WebWindow opener, String target, WebRequest params) throws FailingHttpStatusCodeException, IOException {
        return this.getPage(this.openTargetWindow(opener, target, TARGET_SELF), params);
    }

    public <P extends Page> P getPage(String url) throws IOException, FailingHttpStatusCodeException, MalformedURLException {
        return this.getPage(UrlUtils.toUrlUnsafe(url));
    }

    public <P extends Page> P getPage(URL url) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow().getTopWindow(), new WebRequest(url, this.getBrowserVersion().getHtmlAcceptHeader()));
    }

    public <P extends Page> P getPage(WebRequest request) throws IOException, FailingHttpStatusCodeException {
        return this.getPage(this.getCurrentWindow().getTopWindow(), request);
    }

    public Page loadWebResponseInto(WebResponse webResponse, WebWindow webWindow) throws IOException, FailingHttpStatusCodeException {
        WebAssert.notNull("webResponse", webResponse);
        WebAssert.notNull("webWindow", webWindow);
        if (webResponse.getStatusCode() == 204) {
            return webWindow.getEnclosedPage();
        }
        if (this.attachmentHandler_ != null && Attachment.isAttachment(webResponse)) {
            WebWindow w = this.openWindow(null, null, webWindow);
            Page page = this.pageCreator_.createPage(webResponse, w);
            this.attachmentHandler_.handleAttachment(page);
            return page;
        }
        Page oldPage = webWindow.getEnclosedPage();
        if (oldPage != null) {
            oldPage.cleanUp();
        }
        Page newPage = null;
        if (this.windows_.contains(webWindow) || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.WINDOW_EXECUTE_EVENTS)) {
            newPage = this.pageCreator_.createPage(webResponse, webWindow);
            if (this.windows_.contains(webWindow)) {
                this.fireWindowContentChanged(new WebWindowEvent(webWindow, 3, oldPage, newPage));
                if (webWindow.getEnclosedPage() == newPage) {
                    FrameWindow fw;
                    BaseFrameElement frame;
                    newPage.initialize();
                    if (webWindow instanceof FrameWindow && !newPage.isHtmlPage() && (frame = (fw = (FrameWindow)webWindow).getFrameElement()).hasEventHandlers("onload")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Executing onload handler for " + frame));
                        }
                        Event event = new Event(frame, "load");
                        ((Node)frame.getScriptableObject()).executeEventLocally(event);
                    }
                }
            }
        }
        return newPage;
    }

    public void printContentIfNecessary(WebResponse webResponse) {
        boolean successful;
        String contentType = webResponse.getContentType();
        int statusCode = webResponse.getStatusCode();
        boolean bl = successful = statusCode >= 200 && statusCode < 300;
        if (this.getOptions().getPrintContentOnFailingStatusCode() && !successful) {
            LOG.info((Object)("statusCode=[" + statusCode + "] contentType=[" + contentType + "]"));
            LOG.info((Object)webResponse.getContentAsString());
        }
    }

    public void throwFailingHttpStatusCodeExceptionIfNecessary(WebResponse webResponse) {
        boolean successful;
        int statusCode = webResponse.getStatusCode();
        boolean bl = successful = statusCode >= 200 && statusCode < 300 || statusCode == 305 || statusCode == 304;
        if (this.getOptions().isThrowExceptionOnFailingStatusCode() && !successful) {
            throw new FailingHttpStatusCodeException(webResponse);
        }
    }

    public void addRequestHeader(String name, String value) {
        if ("cookie".equalsIgnoreCase(name)) {
            throw new IllegalArgumentException("Do not add 'Cookie' header, use .getCookieManager() instead");
        }
        this.requestHeaders_.put(name, value);
    }

    public void removeRequestHeader(String name) {
        this.requestHeaders_.remove(name);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        WebAssert.notNull("credentialsProvider", credentialsProvider);
        this.credentialsProvider_ = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider_;
    }

    public JavaScriptEngine getJavaScriptEngine() {
        return this.scriptEngine_;
    }

    public void setJavaScriptEngine(JavaScriptEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Can't set JavaScriptEngine to null");
        }
        this.scriptEngine_ = engine;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager_;
    }

    public void setCookieManager(CookieManager cookieManager) {
        WebAssert.notNull("cookieManager", cookieManager);
        this.cookieManager_ = cookieManager;
    }

    public void setAlertHandler(AlertHandler alertHandler) {
        this.alertHandler_ = alertHandler;
    }

    public AlertHandler getAlertHandler() {
        return this.alertHandler_;
    }

    public void setConfirmHandler(ConfirmHandler handler) {
        this.confirmHandler_ = handler;
    }

    public ConfirmHandler getConfirmHandler() {
        return this.confirmHandler_;
    }

    public void setPromptHandler(PromptHandler handler) {
        this.promptHandler_ = handler;
    }

    public PromptHandler getPromptHandler() {
        return this.promptHandler_;
    }

    public void setStatusHandler(StatusHandler statusHandler) {
        this.statusHandler_ = statusHandler;
    }

    public StatusHandler getStatusHandler() {
        return this.statusHandler_;
    }

    public void setJavaScriptErrorListener(JavaScriptErrorListener javaScriptErrorListener) {
        this.javaScriptErrorListener_ = javaScriptErrorListener == null ? new DefaultJavaScriptErrorListener() : javaScriptErrorListener;
    }

    public JavaScriptErrorListener getJavaScriptErrorListener() {
        return this.javaScriptErrorListener_;
    }

    public BrowserVersion getBrowserVersion() {
        return this.browserVersion_;
    }

    public WebWindow getCurrentWindow() {
        return this.currentWindow_;
    }

    public void setCurrentWindow(WebWindow window) {
        HTMLElement activeElement;
        Window jsWindow;
        Page enclosedPage;
        boolean isIFrame;
        DomElement focusedElement;
        Page enclosedPage2;
        WebAssert.notNull("window", window);
        if (this.currentWindow_ == window) {
            return;
        }
        if (this.currentWindow_ != null && !this.currentWindow_.isClosed() && (enclosedPage2 = this.currentWindow_.getEnclosedPage()) != null && enclosedPage2.isHtmlPage() && (focusedElement = ((HtmlPage)enclosedPage2).getFocusedElement()) != null) {
            focusedElement.fireEvent("blur");
        }
        this.currentWindow_ = window;
        boolean bl = isIFrame = this.currentWindow_ instanceof FrameWindow && ((FrameWindow)this.currentWindow_).getFrameElement() instanceof HtmlInlineFrame;
        if (!isIFrame && (enclosedPage = this.currentWindow_.getEnclosedPage()) != null && enclosedPage.isHtmlPage() && (jsWindow = (Window)this.currentWindow_.getScriptableObject()) != null && (activeElement = ((HTMLDocument)jsWindow.getDocument()).getActiveElement()) != null) {
            ((HtmlPage)enclosedPage).setFocusedElement(activeElement.getDomNodeOrDie(), true);
        }
    }

    public void addWebWindowListener(WebWindowListener listener) {
        WebAssert.notNull("listener", listener);
        this.webWindowListeners_.add(listener);
    }

    public void removeWebWindowListener(WebWindowListener listener) {
        WebAssert.notNull("listener", listener);
        this.webWindowListeners_.remove(listener);
    }

    private void fireWindowContentChanged(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowContentChanged(event);
        }
    }

    private void fireWindowOpened(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowOpened(event);
        }
    }

    private void fireWindowClosed(WebWindowEvent event) {
        for (WebWindowListener listener : new ArrayList<WebWindowListener>(this.webWindowListeners_)) {
            listener.webWindowClosed(event);
        }
    }

    public WebWindow openWindow(URL url, String windowName) {
        WebAssert.notNull("windowName", windowName);
        return this.openWindow(url, windowName, this.getCurrentWindow());
    }

    public WebWindow openWindow(URL url, String windowName, WebWindow opener) {
        WebWindow window = this.openTargetWindow(opener, windowName, TARGET_BLANK);
        HtmlPage openerPage = (HtmlPage)opener.getEnclosedPage();
        if (url != null) {
            try {
                WebRequest request = new WebRequest(url, this.getBrowserVersion().getHtmlAcceptHeader());
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.DIALOGWINDOW_REFERER) && openerPage != null) {
                    String referer = openerPage.getUrl().toExternalForm();
                    request.setAdditionalHeader("Referer", referer);
                }
                this.getPage(window, request);
            }
            catch (IOException e) {
                LOG.error((Object)"Error loading content into window", (Throwable)e);
            }
        } else {
            this.initializeEmptyWindow(window);
        }
        return window;
    }

    public WebWindow openTargetWindow(WebWindow opener, String windowName, String defaultName) {
        WebWindow webWindow;
        WebAssert.notNull("opener", opener);
        WebAssert.notNull("defaultName", defaultName);
        String windowToOpen = windowName;
        if (windowToOpen == null || windowToOpen.isEmpty()) {
            windowToOpen = defaultName;
        }
        if ((webWindow = this.resolveWindow(opener, windowToOpen)) == null) {
            if (TARGET_BLANK.equals(windowToOpen)) {
                windowToOpen = "";
            }
            webWindow = new TopLevelWindow(windowToOpen, this);
            this.fireWindowOpened(new WebWindowEvent(webWindow, 1, null, null));
        }
        if (webWindow instanceof TopLevelWindow && webWindow != opener.getTopWindow()) {
            ((TopLevelWindow)webWindow).setOpener(opener);
        }
        return webWindow;
    }

    private WebWindow resolveWindow(WebWindow opener, String name) {
        if (name == null || name.isEmpty() || TARGET_SELF.equals(name)) {
            return opener;
        }
        if (TARGET_PARENT.equals(name)) {
            return opener.getParentWindow();
        }
        if (TARGET_TOP.equals(name)) {
            return opener.getTopWindow();
        }
        if (TARGET_BLANK.equals(name)) {
            return null;
        }
        WebWindow window = opener;
        while (true) {
            Page page;
            if ((page = window.getEnclosedPage()) != null && page.isHtmlPage()) {
                try {
                    FrameWindow frame = ((HtmlPage)page).getFrameByName(name);
                    ScriptableObject scriptable = frame.getFrameElement().getScriptableObject();
                    if (scriptable instanceof HTMLIFrameElement) {
                        ((HTMLIFrameElement)scriptable).onRefresh();
                    }
                    return frame;
                }
                catch (ElementNotFoundException elementNotFoundException) {
                    // empty catch block
                }
            }
            if (window == window.getParentWindow()) break;
            window = window.getParentWindow();
        }
        try {
            return this.getWebWindowByName(name);
        }
        catch (WebWindowNotFoundException webWindowNotFoundException) {
            return null;
        }
    }

    public DialogWindow openDialogWindow(URL url, WebWindow opener, Object dialogArguments) throws IOException {
        WebAssert.notNull("url", url);
        WebAssert.notNull("opener", opener);
        DialogWindow window = new DialogWindow(this, dialogArguments);
        this.fireWindowOpened(new WebWindowEvent(window, 1, null, null));
        HtmlPage openerPage = (HtmlPage)opener.getEnclosedPage();
        WebRequest request = new WebRequest(url, this.getBrowserVersion().getHtmlAcceptHeader());
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.DIALOGWINDOW_REFERER) && openerPage != null) {
            String referer = openerPage.getUrl().toExternalForm();
            request.setAdditionalHeader("Referer", referer);
        }
        this.getPage(window, request);
        return window;
    }

    public void setPageCreator(PageCreator pageCreator) {
        WebAssert.notNull("pageCreator", pageCreator);
        this.pageCreator_ = pageCreator;
    }

    public PageCreator getPageCreator() {
        return this.pageCreator_;
    }

    public WebWindow getWebWindowByName(String name) throws WebWindowNotFoundException {
        WebAssert.notNull("name", name);
        for (WebWindow webWindow : this.windows_) {
            if (!name.equals(webWindow.getName())) continue;
            return webWindow;
        }
        throw new WebWindowNotFoundException(name);
    }

    public void initialize(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.scriptEngine_.initialize(webWindow);
    }

    public void initialize(Page newPage) {
        WebAssert.notNull("newPage", newPage);
        ((Window)newPage.getEnclosingWindow().getScriptableObject()).initialize(newPage);
    }

    public void initializeEmptyWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.initialize(webWindow);
        ((Window)webWindow.getScriptableObject()).initialize();
    }

    public void registerWebWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.windows_.add(webWindow);
        this.jobManagers_.add(new WeakReference<JavaScriptJobManager>(webWindow.getJobManager()));
    }

    public void deregisterWebWindow(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        if (this.windows_.remove(webWindow)) {
            this.fireWindowClosed(new WebWindowEvent(webWindow, 2, webWindow.getEnclosedPage(), null));
        }
    }

    public static URL expandUrl(URL baseUrl, String relativeUrl) throws MalformedURLException {
        String newUrl = UrlUtils.resolveUrl(baseUrl, relativeUrl);
        return UrlUtils.toUrlUnsafe(newUrl);
    }

    private WebResponse makeWebResponseForDataUrl(WebRequest webRequest) throws IOException {
        DataUrlDecoder decoder;
        URL url = webRequest.getUrl();
        ArrayList<NameValuePair> responseHeaders = new ArrayList<NameValuePair>();
        try {
            decoder = DataUrlDecoder.decode(url);
        }
        catch (DecoderException e) {
            throw new IOException(e.getMessage());
        }
        responseHeaders.add(new NameValuePair("content-type", decoder.getMediaType() + ";charset=" + decoder.getCharset()));
        DownloadedContent downloadedContent = HttpWebConnection.downloadContent(url.openStream(), this.getOptions().getMaxInMemory());
        WebResponseData data = new WebResponseData(downloadedContent, 200, "OK", responseHeaders);
        return new WebResponse(data, url, webRequest.getHttpMethod(), 0L);
    }

    private static WebResponse makeWebResponseForAboutUrl(URL url) {
        String urlWithoutQuery = StringUtils.substringBefore((String)url.toExternalForm(), (String)"?");
        if (!"blank".equalsIgnoreCase(StringUtils.substringAfter((String)urlWithoutQuery, (String)ABOUT_SCHEME))) {
            throw new IllegalArgumentException(url + " is not supported, only about:blank is supported now.");
        }
        return new StringWebResponse("", URL_ABOUT_BLANK);
    }

    private WebResponse makeWebResponseForFileUrl(WebRequest webRequest) throws IOException {
        URL cleanUrl = webRequest.getUrl();
        if (cleanUrl.getQuery() != null) {
            cleanUrl = UrlUtils.getUrlWithNewQuery(cleanUrl, null);
        }
        if (cleanUrl.getRef() != null) {
            cleanUrl = UrlUtils.getUrlWithNewRef(cleanUrl, null);
        }
        String fileUrl = cleanUrl.toExternalForm();
        File file = new File((fileUrl = URLDecoder.decode(fileUrl, "UTF-8")).substring(5));
        if (!file.exists()) {
            ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
            compiledHeaders.add(new NameValuePair("Content-Type", "text/html"));
            WebResponseData responseData = new WebResponseData(TextUtil.stringToByteArray("File: " + file.getAbsolutePath(), StandardCharsets.UTF_8), 404, "Not Found", compiledHeaders);
            return new WebResponse(responseData, webRequest, 0L);
        }
        String contentType = this.guessContentType(file);
        DownloadedContent.OnFile content = new DownloadedContent.OnFile(file, false);
        ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
        compiledHeaders.add(new NameValuePair("Content-Type", contentType));
        WebResponseData responseData = new WebResponseData(content, 200, "OK", compiledHeaders);
        return new WebResponse(responseData, webRequest, 0L);
    }

    public String guessContentType(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (file.getName().endsWith(".xhtml")) {
            contentType = "application/xhtml+xml";
        }
        if (contentType == null) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                contentType = URLConnection.guessContentTypeFromStream(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (contentType == null) {
            contentType = file.getName().endsWith(".js") ? "text/javascript" : "application/octet-stream";
        }
        return contentType;
    }

    private WebResponse makeWebResponseForJavaScriptUrl(WebWindow webWindow, URL url, Charset charset) throws FailingHttpStatusCodeException, IOException {
        ScriptResult r;
        HtmlPage page = null;
        if (webWindow instanceof FrameWindow) {
            FrameWindow frameWindow = (FrameWindow)webWindow;
            page = (HtmlPage)frameWindow.getEnclosedPage();
        } else {
            Page currentPage = webWindow.getEnclosedPage();
            if (currentPage == null) {
                currentPage = this.getPage(webWindow, new WebRequest(URL_ABOUT_BLANK));
            } else if (currentPage instanceof HtmlPage) {
                page = (HtmlPage)currentPage;
            }
        }
        if (page == null) {
            page = (HtmlPage)this.getPage(webWindow, new WebRequest(URL_ABOUT_BLANK));
        }
        if ((r = page.executeJavaScriptIfPossible(url.toExternalForm(), "JavaScript URL", 1)).getJavaScriptResult() == null || ScriptResult.isUndefined(r)) {
            return webWindow.getEnclosedPage().getWebResponse();
        }
        String contentString = r.getJavaScriptResult().toString();
        StringWebResponse response = new StringWebResponse(contentString, charset, url);
        response.setFromJavascript(true);
        return response;
    }

    public WebResponse loadWebResponse(WebRequest webRequest) throws IOException {
        String protocol = webRequest.getUrl().getProtocol();
        WebResponse response = "about".equals(protocol) ? WebClient.makeWebResponseForAboutUrl(webRequest.getUrl()) : ("file".equals(protocol) ? this.makeWebResponseForFileUrl(webRequest) : ("data".equals(protocol) ? this.makeWebResponseForDataUrl(webRequest) : this.loadWebResponseFromWebConnection(webRequest, 20)));
        return response;
    }

    private WebResponse loadWebResponseFromWebConnection(WebRequest webRequest, int allowedRedirects) throws IOException {
        WebResponse webResponse;
        URL url = webRequest.getUrl();
        HttpMethod method = webRequest.getHttpMethod();
        List<NameValuePair> parameters = webRequest.getRequestParameters();
        WebAssert.notNull("url", url);
        WebAssert.notNull("method", (Object)method);
        WebAssert.notNull("parameters", parameters);
        url = UrlUtils.encodeUrl(url, this.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_MINIMAL_QUERY_ENCODING), webRequest.getCharset());
        webRequest.setUrl(url);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Load response for " + (Object)((Object)method) + " " + url.toExternalForm()));
        }
        if (webRequest.getProxyHost() == null) {
            ProxyConfig proxyConfig = this.getOptions().getProxyConfig();
            if (proxyConfig.getProxyAutoConfigUrl() != null) {
                if (!UrlUtils.sameFile(new URL(proxyConfig.getProxyAutoConfigUrl()), url)) {
                    int colonIndex;
                    String value;
                    String content = proxyConfig.getProxyAutoConfigContent();
                    if (content == null) {
                        content = this.getPage(proxyConfig.getProxyAutoConfigUrl()).getWebResponse().getContentAsString();
                        proxyConfig.setProxyAutoConfigContent(content);
                    }
                    String allValue = ProxyAutoConfig.evaluate(content, url);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Proxy Auto-Config: value '" + allValue + "' for URL " + url));
                    }
                    if ((value = allValue.split(";")[0].trim()).startsWith("PROXY")) {
                        value = value.substring(6);
                        colonIndex = value.indexOf(58);
                        webRequest.setSocksProxy(false);
                        webRequest.setProxyHost(value.substring(0, colonIndex));
                        webRequest.setProxyPort(Integer.parseInt(value.substring(colonIndex + 1)));
                    } else if (value.startsWith("SOCKS")) {
                        value = value.substring(6);
                        colonIndex = value.indexOf(58);
                        webRequest.setSocksProxy(true);
                        webRequest.setProxyHost(value.substring(0, colonIndex));
                        webRequest.setProxyPort(Integer.parseInt(value.substring(colonIndex + 1)));
                    }
                }
            } else if (!proxyConfig.shouldBypassProxy(webRequest.getUrl().getHost())) {
                webRequest.setProxyHost(proxyConfig.getProxyHost());
                webRequest.setProxyPort(proxyConfig.getProxyPort());
                webRequest.setSocksProxy(proxyConfig.isSocksProxy());
            }
        }
        this.addDefaultHeaders(webRequest);
        WebResponse fromCache = this.getCache().getCachedResponse(webRequest);
        if (fromCache != null) {
            webResponse = new WebResponseFromCache(fromCache, webRequest);
        } else {
            try {
                webResponse = this.getWebConnection().getResponse(webRequest);
            }
            catch (NoHttpResponseException e) {
                return new WebResponse(responseDataNoHttpResponse_, webRequest, 0L);
            }
            this.getCache().cacheIfPossible(webRequest, webResponse, null);
        }
        int status = webResponse.getStatusCode();
        if (status == 305) {
            this.getIncorrectnessListener().notify("Ignoring HTTP status code [305] 'Use Proxy'", this);
        } else if (status >= 301 && status <= (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_REDIRECT_308) ? 308 : 307) && status != 304 && this.getOptions().isRedirectEnabled()) {
            URL newUrl;
            String locationString = null;
            try {
                locationString = webResponse.getResponseHeaderValue("Location");
                if (locationString == null) {
                    return webResponse;
                }
                newUrl = WebClient.expandUrl(url, locationString);
            }
            catch (MalformedURLException e) {
                this.getIncorrectnessListener().notify("Got a redirect status code [" + status + " " + webResponse.getStatusMessage() + "] but the location is not a valid URL [" + locationString + "]. Skipping redirection processing.", this);
                return webResponse;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Got a redirect status code [" + status + "] new location = [" + locationString + "]"));
            }
            if (allowedRedirects == 0) {
                throw new FailingHttpStatusCodeException("Too much redirect for " + webResponse.getWebRequest().getUrl(), webResponse);
            }
            if (status == 301 || status == 302 || status == 303) {
                WebRequest wrs = new WebRequest(newUrl, HttpMethod.GET);
                for (Map.Entry<String, String> entry : webRequest.getAdditionalHeaders().entrySet()) {
                    wrs.setAdditionalHeader(entry.getKey(), entry.getValue());
                }
                return this.loadWebResponseFromWebConnection(wrs, allowedRedirects - 1);
            }
            if (status == 307 || status == 308) {
                WebRequest wrs = new WebRequest(newUrl, webRequest.getHttpMethod());
                wrs.setRequestParameters(parameters);
                for (Map.Entry<String, String> entry : webRequest.getAdditionalHeaders().entrySet()) {
                    wrs.setAdditionalHeader(entry.getKey(), entry.getValue());
                }
                return this.loadWebResponseFromWebConnection(wrs, allowedRedirects - 1);
            }
        }
        return webResponse;
    }

    private void addDefaultHeaders(WebRequest wrs) {
        if (!wrs.isAdditionalHeader("Accept-Language")) {
            wrs.setAdditionalHeader("Accept-Language", this.getBrowserVersion().getBrowserLanguage());
        }
        wrs.getAdditionalHeaders().putAll(this.requestHeaders_);
    }

    public List<WebWindow> getWebWindows() {
        return Collections.unmodifiableList(new ArrayList<WebWindow>(this.windows_));
    }

    public boolean containsWebWindow(WebWindow webWindow) {
        return this.windows_.contains(webWindow);
    }

    public List<TopLevelWindow> getTopLevelWindows() {
        return Collections.unmodifiableList(new ArrayList<TopLevelWindow>(this.topLevelWindows_));
    }

    public void setRefreshHandler(RefreshHandler handler) {
        this.refreshHandler_ = handler == null ? new NiceRefreshHandler(2) : handler;
    }

    public RefreshHandler getRefreshHandler() {
        return this.refreshHandler_;
    }

    public void setScriptPreProcessor(ScriptPreProcessor scriptPreProcessor) {
        this.scriptPreProcessor_ = scriptPreProcessor;
    }

    public ScriptPreProcessor getScriptPreProcessor() {
        return this.scriptPreProcessor_;
    }

    public void setActiveXObjectMap(Map<String, String> activeXObjectMap) {
        this.activeXObjectMap_ = activeXObjectMap;
    }

    public Map<String, String> getActiveXObjectMap() {
        return this.activeXObjectMap_;
    }

    public MSXMLActiveXObjectFactory getMSXMLActiveXObjectFactory() {
        return this.msxmlActiveXObjectFactory_;
    }

    public void setHTMLParserListener(HTMLParserListener listener) {
        this.htmlParserListener_ = listener;
    }

    public HTMLParserListener getHTMLParserListener() {
        return this.htmlParserListener_;
    }

    public ErrorHandler getCssErrorHandler() {
        return this.cssErrorHandler_;
    }

    public void setCssErrorHandler(ErrorHandler cssErrorHandler) {
        WebAssert.notNull("cssErrorHandler", cssErrorHandler);
        this.cssErrorHandler_ = cssErrorHandler;
    }

    public void setJavaScriptTimeout(long timeout) {
        this.scriptEngine_.setJavaScriptTimeout(timeout);
    }

    public long getJavaScriptTimeout() {
        return this.scriptEngine_.getJavaScriptTimeout();
    }

    public IncorrectnessListener getIncorrectnessListener() {
        return this.incorrectnessListener_;
    }

    public void setIncorrectnessListener(IncorrectnessListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null incorrectness listener.");
        }
        this.incorrectnessListener_ = listener;
    }

    public WebConsole getWebConsole() {
        if (this.webConsole_ == null) {
            this.webConsole_ = new WebConsole();
        }
        return this.webConsole_;
    }

    public AjaxController getAjaxController() {
        return this.ajaxController_;
    }

    public void setAjaxController(AjaxController newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.ajaxController_ = newValue;
    }

    public void setAttachmentHandler(AttachmentHandler handler) {
        this.attachmentHandler_ = handler;
    }

    public AttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler_;
    }

    public void setAppletConfirmHandler(AppletConfirmHandler handler) {
        this.appletConfirmHandler_ = handler;
    }

    public AppletConfirmHandler getAppletConfirmHandler() {
        return this.appletConfirmHandler_;
    }

    public void setOnbeforeunloadHandler(OnbeforeunloadHandler onbeforeunloadHandler) {
        this.onbeforeunloadHandler_ = onbeforeunloadHandler;
    }

    public OnbeforeunloadHandler getOnbeforeunloadHandler() {
        return this.onbeforeunloadHandler_;
    }

    public Cache getCache() {
        return this.cache_;
    }

    public void setCache(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache should not be null!");
        }
        this.cache_ = cache;
    }

    @Override
    public void close() {
        ArrayList<TopLevelWindow> topWindows = new ArrayList<TopLevelWindow>(this.topLevelWindows_);
        for (TopLevelWindow topWindow : topWindows) {
            if (!this.topLevelWindows_.contains(topWindow)) continue;
            topWindow.close();
        }
        if (this.scriptEngine_ != null) {
            this.scriptEngine_.shutdown();
        }
        try {
            this.webConnection_.close();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while closing the connection", (Throwable)e);
        }
        this.cache_.clear();
    }

    public int waitForBackgroundJavaScript(long timeoutMillis) {
        int count = 0;
        long endTime = System.currentTimeMillis() + timeoutMillis;
        Iterator<WeakReference<JavaScriptJobManager>> i = this.jobManagers_.iterator();
        while (i.hasNext()) {
            JavaScriptJobManager jobManager;
            block5: {
                try {
                    WeakReference<JavaScriptJobManager> reference = i.next();
                    jobManager = (JavaScriptJobManager)reference.get();
                    if (jobManager == null) {
                        i.remove();
                    }
                    break block5;
                }
                catch (ConcurrentModificationException e) {
                    i = this.jobManagers_.iterator();
                    count = 0;
                }
                continue;
            }
            long newTimeout = endTime - System.currentTimeMillis();
            count += jobManager.waitForJobs(newTimeout);
        }
        if (count != this.getAggregateJobCount()) {
            long newTimeout = endTime - System.currentTimeMillis();
            return this.waitForBackgroundJavaScript(newTimeout);
        }
        return count;
    }

    public int waitForBackgroundJavaScriptStartingBefore(long delayMillis) {
        int count = 0;
        long endTime = System.currentTimeMillis() + delayMillis;
        Iterator<WeakReference<JavaScriptJobManager>> i = this.jobManagers_.iterator();
        while (i.hasNext()) {
            JavaScriptJobManager jobManager;
            block5: {
                try {
                    WeakReference<JavaScriptJobManager> reference = i.next();
                    jobManager = (JavaScriptJobManager)reference.get();
                    if (jobManager == null) {
                        i.remove();
                    }
                    break block5;
                }
                catch (ConcurrentModificationException e) {
                    i = this.jobManagers_.iterator();
                    count = 0;
                }
                continue;
            }
            long newDelay = endTime - System.currentTimeMillis();
            count += jobManager.waitForJobsStartingBefore(newDelay);
        }
        if (count != this.getAggregateJobCount()) {
            long newDelay = endTime - System.currentTimeMillis();
            return this.waitForBackgroundJavaScriptStartingBefore(newDelay);
        }
        return count;
    }

    private int getAggregateJobCount() {
        int count = 0;
        Iterator<WeakReference<JavaScriptJobManager>> i = this.jobManagers_.iterator();
        while (i.hasNext()) {
            JavaScriptJobManager jobManager;
            block4: {
                try {
                    WeakReference<JavaScriptJobManager> reference = i.next();
                    jobManager = (JavaScriptJobManager)reference.get();
                    if (jobManager == null) {
                        i.remove();
                    }
                    break block4;
                }
                catch (ConcurrentModificationException e) {
                    i = this.jobManagers_.iterator();
                    count = 0;
                }
                continue;
            }
            int jobCount = jobManager.getJobCount();
            count += jobCount;
        }
        return count;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.webConnection_ = this.createWebConnection();
        this.scriptEngine_ = new JavaScriptEngine(this);
        this.jobManagers_ = Collections.synchronizedList(new ArrayList());
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SUPPORT_VIA_ACTIVEXOBJECT)) {
            this.initMSXMLActiveX();
        }
    }

    private WebConnection createWebConnection() {
        if (GAEUtils.isGaeMode()) {
            return new UrlFetchWebConnection(this);
        }
        return new HttpWebConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(WebWindow requestingWindow, String target, WebRequest request, boolean checkHash, boolean forceLoad, String description) {
        LoadJob loadJob;
        Object page;
        WebWindow win = this.resolveWindow(requestingWindow, target);
        URL url = request.getUrl();
        boolean justHashJump = false;
        if (win != null && HttpMethod.POST != request.getHttpMethod() && (page = win.getEnclosedPage()) != null) {
            if (page.isHtmlPage() && !((HtmlPage)page).isOnbeforeunloadAccepted()) {
                return;
            }
            if (checkHash) {
                URL current = page.getUrl();
                justHashJump = HttpMethod.GET == request.getHttpMethod() && UrlUtils.sameFile(url, current) && null != url.getRef();
            }
        }
        page = this.loadQueue_;
        synchronized (page) {
            for (LoadJob loadJob2 : this.loadQueue_) {
                if (loadJob2.response_ == null) continue;
                WebRequest otherRequest = loadJob2.request_;
                URL otherUrl = otherRequest.getUrl();
                if (forceLoad || !url.getPath().equals(otherUrl.getPath()) || !url.toString().equals(otherUrl.toString()) || !request.getRequestParameters().equals(otherRequest.getRequestParameters()) || !StringUtils.equals((CharSequence)request.getRequestBody(), (CharSequence)otherRequest.getRequestBody())) continue;
                return;
            }
        }
        if (justHashJump) {
            loadJob = new LoadJob(request, requestingWindow, target, url);
        } else {
            try {
                WebResponse response = this.loadWebResponse(request);
                loadJob = new LoadJob(request, requestingWindow, target, response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        List<LoadJob> list = this.loadQueue_;
        synchronized (list) {
            this.loadQueue_.add(loadJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDownloadedResponses() throws FailingHttpStatusCodeException, IOException {
        ArrayList<LoadJob> queue;
        List<LoadJob> list = this.loadQueue_;
        synchronized (list) {
            if (this.loadQueue_.isEmpty()) {
                return;
            }
            queue = new ArrayList<LoadJob>(this.loadQueue_);
            this.loadQueue_.clear();
        }
        HashSet<WebWindow> updatedWindows = new HashSet<WebWindow>();
        for (int i = queue.size() - 1; i >= 0; --i) {
            LoadJob loadJob = (LoadJob)queue.get(i);
            if (loadJob.isOutdated()) {
                LOG.info((Object)("No usage of download: " + loadJob));
                continue;
            }
            WebWindow window = this.resolveWindow(loadJob.requestingWindow_, loadJob.target_);
            if (!updatedWindows.contains(window)) {
                WebWindow win = this.openTargetWindow(loadJob.requestingWindow_, loadJob.target_, TARGET_SELF);
                if (loadJob.urlWithOnlyHashChange_ != null) {
                    HtmlPage page = (HtmlPage)loadJob.requestingWindow_.getEnclosedPage();
                    String oldURL = page.getUrl().toExternalForm();
                    WebRequest req = page.getWebResponse().getWebRequest();
                    req.setUrl(loadJob.urlWithOnlyHashChange_);
                    Window jsWindow = (Window)win.getScriptableObject();
                    if (null != jsWindow) {
                        Location location = jsWindow.getLocation();
                        location.setHash(oldURL, loadJob.urlWithOnlyHashChange_.getRef());
                    }
                    win.getHistory().addPage(page);
                    continue;
                }
                Page pageBeforeLoad = win.getEnclosedPage();
                this.loadWebResponseInto(loadJob.response_, win);
                if (this.scriptEngine_ != null) {
                    this.scriptEngine_.registerWindowAndMaybeStartEventLoop(win);
                }
                if (pageBeforeLoad != win.getEnclosedPage()) {
                    updatedWindows.add(win);
                }
                this.throwFailingHttpStatusCodeExceptionIfNecessary(loadJob.response_);
                continue;
            }
            LOG.info((Object)("No usage of download: " + loadJob));
        }
    }

    public WebClientOptions getOptions() {
        return this.options_;
    }

    public StorageHolder getStorageHolder() {
        return this.storageHolder_;
    }

    public synchronized Set<Cookie> getCookies(URL url) {
        CookieManager cookieManager = this.getCookieManager();
        if (!cookieManager.isCookiesEnabled()) {
            return Collections.emptySet();
        }
        URL normalizedUrl = cookieManager.replaceForCookieIfNecessary(url);
        String host = normalizedUrl.getHost();
        if (host.isEmpty()) {
            return Collections.emptySet();
        }
        String path = normalizedUrl.getPath();
        String protocol = normalizedUrl.getProtocol();
        boolean secure = "https".equals(protocol);
        int port = cookieManager.getPort(normalizedUrl);
        cookieManager.clearExpired(new Date());
        List<org.apache.http.cookie.Cookie> all = Cookie.toHttpClient(cookieManager.getCookies());
        ArrayList<org.apache.http.cookie.Cookie> matches = new ArrayList<org.apache.http.cookie.Cookie>();
        if (all.size() > 0) {
            CookieOrigin cookieOrigin = new CookieOrigin(host, port, path, secure);
            HtmlUnitBrowserCompatCookieSpec cookieSpec = new HtmlUnitBrowserCompatCookieSpec(this.getBrowserVersion());
            for (org.apache.http.cookie.Cookie cookie : all) {
                if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                matches.add(cookie);
            }
        }
        LinkedHashSet<Cookie> cookies = new LinkedHashSet<Cookie>();
        cookies.addAll(Cookie.fromHttpClient(matches));
        return Collections.unmodifiableSet(cookies);
    }

    public void addCookie(String cookieString, URL pageUrl, Object origin) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager.isCookiesEnabled()) {
            CharArrayBuffer buffer = new CharArrayBuffer(cookieString.length() + 22);
            buffer.append("Set-Cookie: ");
            buffer.append(cookieString);
            HtmlUnitBrowserCompatCookieSpec cookieSpec = new HtmlUnitBrowserCompatCookieSpec(browserVersion);
            try {
                List cookies = cookieSpec.parse((Header)new BufferedHeader(buffer), cookieManager.buildCookieOrigin(pageUrl));
                for (org.apache.http.cookie.Cookie cookie : cookies) {
                    Cookie htmlUnitCookie = new Cookie((ClientCookie)cookie);
                    cookieManager.addCookie(htmlUnitCookie);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Added cookie: '" + cookieString + "'"));
                }
            }
            catch (MalformedCookieException e) {
                this.getIncorrectnessListener().notify("set-cookie http-equiv meta tag: invalid cookie '" + cookieString + "'; reason: '" + e.getMessage() + "'.", origin);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Skipped adding cookie: '" + cookieString + "'"));
        }
    }

    private static class LoadJob {
        private final WebWindow requestingWindow_;
        private final String target_;
        private final WebResponse response_;
        private final URL urlWithOnlyHashChange_;
        private final WeakReference<Page> originalPage_;
        private final WebRequest request_;

        LoadJob(WebRequest request, WebWindow requestingWindow, String target, WebResponse response) {
            this.request_ = request;
            this.requestingWindow_ = requestingWindow;
            this.target_ = target;
            this.response_ = response;
            this.urlWithOnlyHashChange_ = null;
            this.originalPage_ = new WeakReference<Page>(requestingWindow.getEnclosedPage());
        }

        LoadJob(WebRequest request, WebWindow requestingWindow, String target, URL urlWithOnlyHashChange) {
            this.request_ = request;
            this.requestingWindow_ = requestingWindow;
            this.target_ = target;
            this.response_ = null;
            this.urlWithOnlyHashChange_ = urlWithOnlyHashChange;
            this.originalPage_ = new WeakReference<Page>(requestingWindow.getEnclosedPage());
        }

        public boolean isOutdated() {
            if (this.target_ != null && !this.target_.isEmpty()) {
                return false;
            }
            if (this.requestingWindow_.isClosed()) {
                return true;
            }
            return this.requestingWindow_.getEnclosedPage() != this.originalPage_.get();
        }
    }

    private static final class CurrentWindowTracker
    implements WebWindowListener,
    Serializable {
        private final WebClient webClient_;

        private CurrentWindowTracker(WebClient webClient) {
            this.webClient_ = webClient;
        }

        @Override
        public void webWindowClosed(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow) {
                this.webClient_.topLevelWindows_.remove(window);
                if (window == this.webClient_.getCurrentWindow()) {
                    if (this.webClient_.topLevelWindows_.isEmpty()) {
                        TopLevelWindow newWindow = new TopLevelWindow("", this.webClient_);
                        this.webClient_.topLevelWindows_.push(newWindow);
                        this.webClient_.setCurrentWindow(newWindow);
                    } else {
                        this.webClient_.setCurrentWindow((WebWindow)this.webClient_.topLevelWindows_.peek());
                    }
                }
            } else if (window == this.webClient_.getCurrentWindow()) {
                this.webClient_.setCurrentWindow((WebWindow)this.webClient_.topLevelWindows_.peek());
            }
        }

        @Override
        public void webWindowContentChanged(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            boolean use = false;
            if (window instanceof DialogWindow) {
                use = true;
            } else if (window instanceof TopLevelWindow) {
                use = event.getOldPage() == null;
            } else if (window instanceof FrameWindow) {
                FrameWindow fw = (FrameWindow)window;
                String enclosingPageState = fw.getEnclosingPage().getDocumentElement().getReadyState();
                URL frameUrl = fw.getEnclosedPage().getUrl();
                if (!"complete".equals(enclosingPageState) || frameUrl == URL_ABOUT_BLANK) {
                    return;
                }
                BaseFrameElement frameElement = fw.getFrameElement();
                if (frameElement.isDisplayed()) {
                    HTMLElement htmlElement = (HTMLElement)frameElement.getScriptableObject();
                    CSS2Properties style = htmlElement.getWindow().getComputedStyle(htmlElement, null);
                    boolean bl = use = style.getCalculatedWidth(false, false) != 0 && style.getCalculatedHeight(false, false) != 0;
                }
            }
            if (use) {
                this.webClient_.setCurrentWindow(window);
            }
        }

        @Override
        public void webWindowOpened(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow) {
                TopLevelWindow tlw = (TopLevelWindow)window;
                this.webClient_.topLevelWindows_.push(tlw);
            }
        }
    }
}

