/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PropertyUtil {
    private static final Log LOG = LogFactory.getLog((String)PropertyUtil.class.getName());

    private PropertyUtil() {
    }

    public static String extractAndLogProperty(String name, Properties properties) {
        if (properties == null || properties.size() == 0) {
            return null;
        }
        String foundValue = (String)properties.get(name);
        if (foundValue != null) {
            foundValue = foundValue.trim();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value found for " + name + ": " + foundValue));
        }
        return foundValue;
    }

    public static String extractAndLogProperty(String name, Map properties) {
        if (properties == null || properties.size() == 0) {
            return null;
        }
        String foundValue = (String)properties.get(name);
        if (foundValue != null) {
            foundValue = foundValue.trim();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value found for " + name + ": " + foundValue));
        }
        return foundValue;
    }

    public static Properties parseProperties(String propertiesString) {
        if (propertiesString == null) {
            LOG.debug((Object)"propertiesString is null.");
            return null;
        }
        Properties properties = new Properties();
        String propertyLines = propertiesString.trim();
        propertyLines = propertyLines.replace(',', '\n');
        try {
            properties.load(new ByteArrayInputStream(propertyLines.getBytes()));
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot load properties from " + propertiesString));
        }
        return properties;
    }

    public static boolean parseBoolean(String value) {
        return value != null && value.equalsIgnoreCase("true");
    }
}

