/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerFactory;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.util.ClassLoaderUtil;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConfigurationHelper {
    private static final Log LOG = LogFactory.getLog((String)ConfigurationHelper.class.getName());
    private Configuration configuration;
    private CacheManager cacheManager;

    public ConfigurationHelper(CacheManager cacheManager, Configuration configuration) {
        if (cacheManager == null || configuration == null) {
            throw new IllegalArgumentException("Cannot have null parameters");
        }
        this.cacheManager = cacheManager;
        this.configuration = configuration;
    }

    protected static void registerCacheListeners(CacheConfiguration cacheConfiguration, RegisteredEventListeners registeredEventListeners) {
        List cacheEventListenerConfigurations = cacheConfiguration.cacheEventListenerConfigurations;
        for (int i = 0; i < cacheEventListenerConfigurations.size(); ++i) {
            CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheEventListenerFactoryConfiguration)cacheEventListenerConfigurations.get(i);
            CacheEventListener cacheEventListener = ConfigurationHelper.createCacheEventListener(factoryConfiguration);
            registeredEventListeners.registerListener(cacheEventListener);
        }
    }

    private static CacheEventListener createCacheEventListener(CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration) {
        String className = null;
        CacheEventListener cacheEventListener = null;
        try {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (className == null) {
            LOG.debug((Object)"CacheEventListener factory not configured. Skipping...");
        } else {
            CacheEventListenerFactory factory = (CacheEventListenerFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties());
            cacheEventListener = factory.createCacheEventListener(properties);
        }
        return cacheEventListener;
    }

    public final BootstrapCacheLoader createBootstrapCacheLoader(CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration factoryConfiguration) throws CacheException {
        String className = null;
        BootstrapCacheLoader bootstrapCacheLoader = null;
        try {
            className = factoryConfiguration.fullyQualifiedClassPath;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (className != null && className.length() != 0) {
            BootstrapCacheLoaderFactory factory = (BootstrapCacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties());
            return factory.createBootstrapCacheLoader(properties);
        }
        LOG.debug((Object)"No BootstrapCacheLoaderFactory class specified. Skipping...");
        return bootstrapCacheLoader;
    }

    public final CacheManagerPeerProvider createCachePeerProvider() {
        String className = null;
        FactoryConfiguration cachePeerProviderFactoryConfiguration = this.configuration.getCacheManagerPeerProviderFactoryConfiguration();
        try {
            className = cachePeerProviderFactoryConfiguration.fullyQualifiedClassPath;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (className == null) {
            LOG.debug((Object)"No CachePeerProviderFactoryConfiguration specified. Not configuring a CacheManagerPeerProvider.");
            return null;
        }
        CacheManagerPeerProviderFactory cacheManagerPeerProviderFactory = (CacheManagerPeerProviderFactory)ClassLoaderUtil.createNewInstance(className);
        Properties properties = PropertyUtil.parseProperties(cachePeerProviderFactoryConfiguration.properties);
        return cacheManagerPeerProviderFactory.createCachePeerProvider(this.cacheManager, properties);
    }

    public final CacheManagerPeerListener createCachePeerListener() {
        String className = null;
        FactoryConfiguration cachePeerListenerFactoryConfiguration = this.configuration.getCacheManagerPeerListenerFactoryConfiguration();
        try {
            className = cachePeerListenerFactoryConfiguration.fullyQualifiedClassPath;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (className == null) {
            LOG.debug((Object)"No CachePeerListenerFactoryConfiguration specified. Not configuring a CacheManagerPeerListener.");
            return null;
        }
        CacheManagerPeerListenerFactory cacheManagerPeerListenerFactory = (CacheManagerPeerListenerFactory)ClassLoaderUtil.createNewInstance(className);
        Properties properties = PropertyUtil.parseProperties(cachePeerListenerFactoryConfiguration.properties);
        return cacheManagerPeerListenerFactory.createCachePeerListener(this.cacheManager, properties);
    }

    public final CacheManagerEventListener createCacheManagerEventListener() throws CacheException {
        String className = null;
        FactoryConfiguration cacheManagerEventListenerFactoryConfiguration = this.configuration.getCacheManagerEventListenerFactoryConfiguration();
        try {
            className = cacheManagerEventListenerFactoryConfiguration.fullyQualifiedClassPath;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (className == null || className.length() == 0) {
            LOG.debug((Object)"No CacheManagerEventListenerFactory class specified. Skipping...");
            return null;
        }
        CacheManagerEventListenerFactory factory = (CacheManagerEventListenerFactory)ClassLoaderUtil.createNewInstance(className);
        Properties properties = PropertyUtil.parseProperties(cacheManagerEventListenerFactoryConfiguration.properties);
        return factory.createCacheManagerEventListener(properties);
    }

    public final String getDiskStorePath() {
        DiskStoreConfiguration diskStoreConfiguration = this.configuration.getDiskStoreConfiguration();
        if (diskStoreConfiguration == null) {
            return null;
        }
        return diskStoreConfiguration.getPath();
    }

    public final Ehcache createDefaultCache() throws CacheException {
        CacheConfiguration cacheConfiguration = this.configuration.getDefaultCacheConfiguration();
        if (cacheConfiguration == null) {
            throw new CacheException("Illegal configuration. No default cache is configured.");
        }
        cacheConfiguration.name = "default";
        return this.createCache(cacheConfiguration);
    }

    public final Set createCaches() {
        HashSet<Cache> caches = new HashSet<Cache>();
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = cacheConfigurations.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            Cache cache = this.createCache(cacheConfiguration);
            caches.add(cache);
        }
        return caches;
    }

    public final Integer numberOfCachesThatOverflowToDisk() {
        int count = 0;
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = cacheConfigurations.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            if (!cacheConfiguration.overflowToDisk) continue;
            ++count;
        }
        return new Integer(count);
    }

    final Ehcache createCacheFromName(String name) {
        CacheConfiguration cacheConfiguration = null;
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        Iterator iterator = cacheConfigurations.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheConfiguration cacheConfigurationCandidate = (CacheConfiguration)entry.getValue();
            if (!cacheConfigurationCandidate.name.equals(name)) continue;
            cacheConfiguration = cacheConfigurationCandidate;
            break;
        }
        if (cacheConfiguration == null) {
            return null;
        }
        return this.createCache(cacheConfiguration);
    }

    final Cache createCache(CacheConfiguration cacheConfiguration) {
        Cache cache = new Cache(cacheConfiguration.name, cacheConfiguration.maxElementsInMemory, cacheConfiguration.memoryStoreEvictionPolicy, cacheConfiguration.overflowToDisk, this.getDiskStorePath(), cacheConfiguration.eternal, cacheConfiguration.timeToLiveSeconds, cacheConfiguration.timeToIdleSeconds, cacheConfiguration.diskPersistent, cacheConfiguration.diskExpiryThreadIntervalSeconds, null, null, cacheConfiguration.maxElementsOnDisk);
        RegisteredEventListeners listeners = cache.getCacheEventNotificationService();
        ConfigurationHelper.registerCacheListeners(cacheConfiguration, listeners);
        BootstrapCacheLoader bootstrapCacheLoader = this.createBootstrapCacheLoader(cacheConfiguration.bootstrapCacheLoaderFactoryConfiguration);
        cache.setBootstrapCacheLoader(bootstrapCacheLoader);
        return cache;
    }

    public final Configuration getConfigurationBean() {
        return this.configuration;
    }
}

