/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.parser.impl.general;

import com.mingsoft.parser.IParser;
import com.mingsoft.util.FileUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IncludeParser
extends IParser {
    String path;
    private static final String INCLUDE = "\\{ms:include filename\\=(.*?)\\s*/}";

    public IncludeParser(String htmlContent, String path, String mobilePath) {
        this.mobilePath = mobilePath;
        this.htmlCotent = htmlContent;
        this.path = path;
        if (!StringUtil.isBlank((String)mobilePath)) {
            this.path = String.valueOf(path) + File.separator + this.mobilePath;
        }
    }

    public IncludeParser(String htmlContent, String path) {
        this.htmlCotent = htmlContent;
        this.path = path;
    }

    @Override
    public String parse() {
        String html = this.htmlCotent;
        int strNum = this.includeNum(this.htmlCotent);
        while (strNum != 0) {
            String htmlInclude;
            this.newCotent = htmlInclude = IncludeParser.includeContentPrase(this.htmlCotent, this.path);
            html = this.htmlCotent = super.replaceFirst(INCLUDE);
            strNum = this.includeNum(this.htmlCotent);
        }
        return html;
    }

    private static String includeContentPrase(String html, String path) {
        String includeContent = "";
        Pattern patternL = Pattern.compile(INCLUDE);
        Matcher matcherL = patternL.matcher(html);
        if (matcherL.find()) {
            String includeName = matcherL.group(1);
            File file = new File(String.valueOf(path) + File.separator + includeName);
            includeContent = !file.exists() ? String.valueOf(includeName) + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u8be5\u6a21\u7248\u7684\u6587\u4ef6\uff01" : FileUtil.readFile((String)(String.valueOf(path) + File.separator + includeName));
        }
        return includeContent;
    }

    private int includeNum(String html) {
        int includeNum = IncludeParser.count(html, INCLUDE);
        return includeNum;
    }
}

