/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.parser.impl.general;

import com.mingsoft.parser.IParser;
import com.mingsoft.util.StringUtil;

public class ChannelContParser
extends IParser {
    private static final String CHANNELCONT = "\\{ms:contchannel.*?/}";
    private static final String TYPEID_CHANNELCONT = "\\{ms:contchannel.*?(typeid\\=(\\d*).{0,})?/}";
    private static final String TITLELEN_CHANNELCONT = "\\{ms:contchannel.*?(titlelen\\=(\\d*).{0,})?/}";

    public ChannelContParser(String htmlContent, String newContent) {
        this.htmlCotent = htmlContent;
        this.newCotent = ChannelContParser.channelContTitleLen(newContent, htmlContent);
    }

    @Override
    public String parse() {
        return super.replaceAll(CHANNELCONT);
    }

    public static int channelContNum(String html) {
        int channelNum = ChannelContParser.count(html, CHANNELCONT);
        return channelNum;
    }

    public static int channelContTypeId(String htmlContent) {
        int channelContTypeId = 0;
        String typeIdStr = ChannelContParser.parseFirst(htmlContent, TYPEID_CHANNELCONT, 2);
        if (!StringUtil.isBlank((String)typeIdStr)) {
            channelContTypeId = Integer.parseInt(typeIdStr);
        }
        return channelContTypeId;
    }

    public static String channelContTitleLen(String content, String htmlContent) {
        int lengthCon = 0;
        String length = ChannelContParser.parseFirst(htmlContent, TITLELEN_CHANNELCONT, 2);
        if (!StringUtil.isBlank((String)length) && !StringUtil.isBlank((String)content)) {
            lengthCon = Integer.parseInt(length);
        }
        String contentNew = content;
        if (StringUtil.isBlank((String)content)) {
            contentNew = "<!--\u672a\u627e\u5230\u8be5\u6807\u7b7e\u5185\u5bb9-->\uff0c\u8bf7\u68c0\u5c01\u9762\u67e5ID";
        }
        if (lengthCon != 0 && lengthCon <= contentNew.length()) {
            StringBuffer strBuff = new StringBuffer(contentNew);
            contentNew = strBuff.substring(0, lengthCon);
        }
        return contentNew;
    }
}

