/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.parser;

import com.mingsoft.util.RegexUtil;
import com.mingsoft.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class IParser {
    public static final String DO_SUFFIX = ".do";
    public static final String HTM_SUFFIX = ".htm";
    public static final String HTML_SUFFIX = ".html";
    protected static final String PROPERTY_VALUE = "=\\s*(\\w*)";
    protected static final String PRORETY_NAME = "(\\w*)\\s*=";
    protected String htmlCotent = null;
    protected String mobilePath = "";
    protected String newCotent = null;

    protected static int count(String source, String regex) {
        return RegexUtil.count((String)source, (String)regex);
    }

    protected static List<String> parseAll(String source, String regex, int find) {
        return RegexUtil.parseAll((String)source, (String)regex, (int)find);
    }

    protected static String parseFirst(String source, String regex, int find) {
        String temp = RegexUtil.parseFirst((String)source, (String)regex, (int)find);
        return temp == null ? "" : temp;
    }

    public String getNewCotent() {
        return this.newCotent;
    }

    public Map<String, String> getProperty(String regex) {
        HashMap<String, String> listPropertyMap = new HashMap<String, String>();
        String listProperty = IParser.parseFirst(this.htmlCotent, regex, 1);
        if (listProperty == null) {
            return listPropertyMap;
        }
        List<String> listPropertyName = IParser.parseAll(listProperty, PRORETY_NAME, 1);
        List<String> listPropertyValue = IParser.parseAll(listProperty, PROPERTY_VALUE, 1);
        int i = 0;
        while (i < listPropertyName.size()) {
            listPropertyMap.put(listPropertyName.get(i).toString(), listPropertyValue.get(i).toString());
            ++i;
        }
        return listPropertyMap;
    }

    public abstract String parse();

    public String replaceAll(String regex) {
        if (StringUtil.isBlank((String)this.newCotent)) {
            this.newCotent = "<!--\u672a\u627e\u5230\u8be5\u6807\u7b7e\u5185\u5bb9-->";
        }
        return RegexUtil.replaceAll((String)this.htmlCotent, (String)regex, (String)this.newCotent);
    }

    public String replaceAll(String content, String regex) {
        return RegexUtil.replaceAll((String)this.htmlCotent, (String)regex, (String)content);
    }

    public String replaceFirst(String regex) {
        if (StringUtil.isBlank((String)this.newCotent)) {
            this.newCotent = "<!--\u672a\u627e\u5230\u8be5\u6807\u7b7e\u5185\u5bb9-->";
        }
        return RegexUtil.replaceFirst((String)this.htmlCotent, (String)regex, (String)this.newCotent);
    }

    public void setNewCotent(String newCotent) {
        this.newCotent = newCotent;
    }
}

