/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

public final class MongoWrapper {
    private static final Counter SERVICES_COUNTER = MonitoringProxy.getServicesCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(SERVICES_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    private MongoWrapper() {
    }

    public static MongoDatabase createDatabaseProxy(MongoDatabase database) {
        if (DISABLED) {
            return database;
        }
        SERVICES_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        SERVICES_COUNTER.setUsed(true);
        return JdbcWrapper.createProxy(database, new MongoDatabaseHandler(database));
    }

    static <T> MongoCollection<T> createCollectionProxy(MongoCollection<T> collection, String collectionName) {
        return JdbcWrapper.createProxy(collection, new MongoCollectionHandler(collection, collectionName));
    }

    static Object doInvoke(Object object, Method method, Object[] args, String requestName) throws Throwable {
        boolean systemError = false;
        try {
            SERVICES_COUNTER.bindContextIncludingCpu(requestName);
            Object object2 = method.invoke(object, args);
            return object2;
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            SERVICES_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    private static class MongoCollectionHandler
    implements InvocationHandler {
        private final MongoCollection<?> collection;
        private final String collectionName;

        MongoCollectionHandler(MongoCollection<?> collection, String collectionName) {
            this.collection = collection;
            this.collectionName = collectionName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.startsWith("with") && method.getReturnType() != null && MongoCollection.class.isAssignableFrom(method.getReturnType())) {
                MongoCollection<?> result = (MongoCollection<?>)method.invoke(this.collection, args);
                result = MongoWrapper.createCollectionProxy(this.collection, methodName);
                return result;
            }
            if (methodName.startsWith("get")) {
                return method.invoke(this.collection, args);
            }
            String requestName = this.collectionName + '.' + method.getName();
            return MongoWrapper.doInvoke(this.collection, method, args, requestName);
        }
    }

    private static class MongoDatabaseHandler
    implements InvocationHandler {
        private final MongoDatabase database;

        MongoDatabaseHandler(MongoDatabase database) {
            this.database = database;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MongoCollection result = method.invoke((Object)this.database, args);
            if (result instanceof MongoCollection && args != null && args.length > 0 && args[0] instanceof String) {
                result = MongoWrapper.createCollectionProxy((MongoCollection)result, (String)args[0]);
            } else if (result instanceof MongoDatabase) {
                result = MongoWrapper.createDatabaseProxy((MongoDatabase)result);
            }
            return result;
        }
    }
}

