/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.ws.sdk.client;

import eleme.openapi.ws.sdk.config.BusinessHandle;
import eleme.openapi.ws.sdk.config.Context;
import eleme.openapi.ws.sdk.entity.HeartBeatAckPack;
import eleme.openapi.ws.sdk.entity.HeartBeatRecord;
import eleme.openapi.ws.sdk.entity.UpstreamPack;
import eleme.openapi.ws.sdk.task.HeartBeat;
import eleme.openapi.ws.sdk.utils.JacksonUtils;
import eleme.openapi.ws.sdk.utils.UpStreamPackBuild;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.client.SslContextConfigurator;
import org.glassfish.tyrus.client.SslEngineConfigurator;

@ClientEndpoint
public class WsClientEndpoint {
    private String appKey;
    private Session userSession = null;
    private BusinessHandle businessHandle;

    public WsClientEndpoint(URI endpointURI, String appKey) {
        ClientManager client = ClientManager.createClient();
        try {
            SslEngineConfigurator sslEngineConfigurator = new SslEngineConfigurator(new SslContextConfigurator());
            sslEngineConfigurator.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String host, SSLSession sslSession) {
                    return true;
                }
            });
            client.getProperties().put("org.glassfish.tyrus.client.sslEngineConfigurator", sslEngineConfigurator);
            client.connectToServer((Object)this, endpointURI);
            this.appKey = appKey;
        }
        catch (Exception e) {
            Context.elemeSdkLogger.error("connect to server error");
            throw new RuntimeException(e);
        }
    }

    @OnOpen
    public void onOpen(Session userSession) {
        Context.elemeSdkLogger.info("connection onOpen");
        this.userSession = userSession;
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        Context.elemeSdkLogger.info("connection closed :" + reason.getCloseCode());
        this.userSession = null;
    }

    @OnMessage
    public void onMessage(String message) {
        try {
            UpstreamPack upstreamPack = JacksonUtils.json2pojo(message, UpstreamPack.class);
            if ("ack.heartbeat".equalsIgnoreCase(upstreamPack.getTopic())) {
                String srcMsgId = JacksonUtils.json2pojo(upstreamPack.getContent(), HeartBeatAckPack.class).getSrcMsgId();
                ArrayBlockingQueue<HeartBeatRecord> heartBeatQueue = HeartBeat.heartBeatRecordQueueMap.get(this.appKey);
                heartBeatQueue.remove(new HeartBeatRecord(srcMsgId));
            } else if ("openapi.bussiness.message".equalsIgnoreCase(upstreamPack.getTopic())) {
                Context.elemeSdkLogger.info("onMessage: " + JacksonUtils.obj2json(upstreamPack));
                if (this.businessHandle.onMessage(upstreamPack.getContent())) {
                    this.userSession.getAsyncRemote().sendText(JacksonUtils.obj2json(UpStreamPackBuild.buildBussinessAckPack(upstreamPack.getMsgId())));
                }
            }
        }
        catch (Exception e) {
            Context.elemeSdkLogger.error("onMessage error:" + e);
        }
    }

    public void regiterMessageHandler(BusinessHandle businessHandle) {
        this.businessHandle = businessHandle;
    }

    public void sendMessage(String message) throws IOException {
        if (this.userSession == null || !this.userSession.isOpen()) {
            throw new IOException("connection already close");
        }
        this.userSession.getAsyncRemote().sendText(message);
    }

    public void close() {
        try {
            this.userSession.close();
        }
        catch (IOException e) {
            Context.elemeSdkLogger.error("connection close error:" + e);
        }
    }
}

