/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.ws.sdk.task;

import eleme.openapi.ws.sdk.client.ConnectionManagement;
import eleme.openapi.ws.sdk.config.Context;
import eleme.openapi.ws.sdk.entity.Account;
import eleme.openapi.ws.sdk.entity.HeartBeatRecord;
import eleme.openapi.ws.sdk.entity.UpstreamPack;
import eleme.openapi.ws.sdk.utils.JacksonUtils;
import eleme.openapi.ws.sdk.utils.UpStreamPackBuild;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HeartBeat {
    private static ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(2);
    public static ConcurrentHashMap<String, ArrayBlockingQueue<HeartBeatRecord>> heartBeatRecordQueueMap = new ConcurrentHashMap();

    public static void startHeartBeatTask() {
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (Account account : Context.accounts) {
                    try {
                        UpstreamPack upStreamPack = UpStreamPackBuild.buildHeartBeatPack();
                        HeartBeatRecord heartBeatRecord = new HeartBeatRecord(upStreamPack.getMsgId(), System.currentTimeMillis());
                        ConnectionManagement.clientEndPointMap.get(account.getAppKey()).sendMessage(JacksonUtils.obj2json(upStreamPack));
                        if (heartBeatRecordQueueMap.containsKey(account.getAppKey())) {
                            heartBeatRecordQueueMap.get(account.getAppKey()).add(heartBeatRecord);
                            continue;
                        }
                        ArrayBlockingQueue<HeartBeatRecord> heartBeatRecords = new ArrayBlockingQueue<HeartBeatRecord>(1000);
                        heartBeatRecords.add(heartBeatRecord);
                        heartBeatRecordQueueMap.put(account.getAppKey(), heartBeatRecords);
                    }
                    catch (Exception e) {
                        ConnectionManagement.reBuildConnection(account.getAppKey());
                        Context.elemeSdkLogger.error("heartBeat task error :" + e.getCause());
                    }
                }
            }
        }, 1L, 4L, TimeUnit.SECONDS);
    }

    public static void checkHeartBeatTask() {
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry<String, ArrayBlockingQueue<HeartBeatRecord>> entry : heartBeatRecordQueueMap.entrySet()) {
                    try {
                        if (HeartBeat.checkHeartBeat(entry.getKey())) continue;
                        ConnectionManagement.reBuildConnection(entry.getKey());
                        heartBeatRecordQueueMap.get(entry.getKey()).clear();
                    }
                    catch (Exception e) {
                        Context.elemeSdkLogger.error("check heartbeat error :" + e.getMessage());
                    }
                }
            }
        }, 5L, 10L, TimeUnit.SECONDS);
    }

    private static boolean checkHeartBeat(String appKey) {
        if (heartBeatRecordQueueMap.get(appKey) == null) {
            return true;
        }
        HeartBeatRecord heartBeat = heartBeatRecordQueueMap.get(appKey).peek();
        if (heartBeat == null) {
            return true;
        }
        return System.currentTimeMillis() - heartBeat.getTimeStamp() < 15000L;
    }
}

