package eleme.openapi.ws.sdk.utils;

import eleme.openapi.ws.sdk.config.Constants;
import eleme.openapi.ws.sdk.entity.Account;
import eleme.openapi.ws.sdk.exception.UnableConnectionException;
import org.glassfish.grizzly.http.util.Base64Utils;

import java.io.*;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ClientEnvUtils {
    /**
     * 获取本机mac地址
     *
     * @return
     */
    public static String getLocalMac() {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mac.length; i++) {
                if (i != 0) {
                    sb.append("-");
                }
                int temp = mac[i] & 0xff;
                String str = Integer.toHexString(temp);
                if (str.length() == 1) {
                    sb.append("0" + str);
                } else {
                    sb.append(str);
                }
            }
            return sb.toString().toUpperCase();
        } catch (Exception e) {

        }
        return "UNKONOW_MAC";
    }

    /**
     * 获取本机进程ID
     *
     * @return
     */
    public static final int getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        System.out.println(runtimeMXBean.getName());
        return Integer.valueOf(runtimeMXBean.getName().split("@")[0])
                .intValue();
    }

    public static final int getThreadCount() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        System.out.println(runtimeMXBean.getName());
        return Integer.valueOf(runtimeMXBean.getName().split("@")[0])
                .intValue();
    }


    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            Reader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            final char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }

            return response.toString();
        } finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String doCommand(String command) {
        try {
            Process pro = Runtime.getRuntime().exec(command);
            pro.waitFor();
            InputStream in = pro.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder response = new StringBuilder();
            final char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            return response.toString();
        } catch (Exception e) {

        }
        return "";
    }

    public static String getClientProfile() {
        Properties props = System.getProperties(); //获得系统属性集;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("osName :").append(props.getProperty("os.name")).append("\r\n");
        sb.append("osArch :").append(props.getProperty("os.arch")).append("\r\n");
        sb.append("osVersion :").append(props.getProperty("os.version")).append("\r\n");
        sb.append("javaVersion :").append(props.getProperty("java.version")).append("\r\n");
        sb.append("sdkVersion :").append(Constants.SDK_VERSION).append("\r\n");
        sb.append("cpu cores :").append(Runtime.getRuntime().availableProcessors());

        sb.append("traceRoute :").append(getraceRoute());
        return sb.toString();

    }

    private static String getraceRoute() {
        Properties props = System.getProperties(); //获得系统属性集
        String osName = props.getProperty("os.name"); //操作系统名称
        if (osName.toLowerCase().contains("mac")) {
            return doCommand("gtimeout 10 traceroute " + Constants.LONG_CONNECTION_HOST);
        } else if (osName.toLowerCase().contains("linux")) {
            return doCommand("timeout 10 traceroute " + Constants.LONG_CONNECTION_HOST);
        } else {
            return "该操作系统不支持traceRoute";
        }
    }

    public static String generatorToken(Account account) {
        String token = String.format("%s#%s#%s#%s", account.getAppKey(), Md5Util.Md5(account.getAppSecret()), ClientEnvUtils.getLocalMac(), ClientEnvUtils.getProcessID());
        return Base64Utils.encodeToString(token.getBytes(), false);
    }

    public static String getWssAddress(String token) throws UnableConnectionException {

        Map<String, String> contentMap = new HashMap(3);
        contentMap.put("appId", Constants.CHANNEL_ID);
        contentMap.put("token", token);
        contentMap.put("routingKey", "local");
        String requestContent = JacksonUtils.obj2json(contentMap);
        Map<String, String> headMap = new HashMap(2);
        headMap.put("cache-control", "no-cache");
        headMap.put("invocation-protocol", "RESTful-Protocol");

        String wssAddress;
        try {
            wssAddress = HttpUtils.doPost(Constants.LONG_CONNECTION_URL, Constants.CHARSET_UTF8, 3000, 3000, headMap, requestContent);
        } catch (IOException e) {
            throw new UnableConnectionException(e.getMessage());
        }
        return wssAddress.substring(1, wssAddress.length() - 1);
        //return String.format("ws://adca-appinfra-pconn-registry-1.vm.elenet.me:8080/websocket?appId=%s&token=%s", Constants.CHANNEL_ID, token);
    }
}

