package eleme.openapi.ws.sdk.config;

import eleme.openapi.ws.sdk.entity.Account;
import eleme.openapi.ws.sdk.exception.UnableConnectionException;
import eleme.openapi.ws.sdk.utils.ClientEnvUtils;
import eleme.openapi.ws.sdk.utils.LoggerProxy;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;


public class Context {
    public static List<Account> accounts = new ArrayList<Account>();
    public static LoggerProxy elemeSdkLogger;
    public static BusinessHandle businessHandle;
    public static ConcurrentHashMap<String, String> wssAddressMap = new ConcurrentHashMap();


    public static void buildStartContext(Config config) throws UnableConnectionException {
        Context.elemeSdkLogger = new LoggerProxy(config.getElemeSdkLogger());
        if (config.getBusinessHandle() == null) {
            throw new UnableConnectionException("businesshandle must not null");
        }
        Context.businessHandle = config.getBusinessHandle();
        for (Account account : config.getAccounts()) {
            String token = ClientEnvUtils.generatorToken(account);
            account.setToken(token);
            String wssAddress = ClientEnvUtils.getWssAddress(token);
            wssAddressMap.put(account.getAppKey(), wssAddress);
            Context.accounts.add(account);
        }
    }

}
