package eleme.openapi.ws.sdk.client;

import eleme.openapi.ws.sdk.config.BusinessHandle;
import eleme.openapi.ws.sdk.config.Constants;
import eleme.openapi.ws.sdk.config.Context;
import eleme.openapi.ws.sdk.entity.HeartBeatAckPack;
import eleme.openapi.ws.sdk.entity.HeartBeatRecord;
import eleme.openapi.ws.sdk.entity.UpstreamPack;
import eleme.openapi.ws.sdk.task.HeartBeat;
import eleme.openapi.ws.sdk.utils.JacksonUtils;
import eleme.openapi.ws.sdk.utils.UpStreamPackBuild;

import javax.websocket.*;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;


@javax.websocket.ClientEndpoint
public class WsClientEndpoint {

    private String appKey;
    private Session userSession = null;
    private BusinessHandle businessHandle;

    public WsClientEndpoint(URI endpointURI, String appKey) {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.connectToServer(this, endpointURI);
            this.appKey = appKey;
        } catch (Exception e) {
            Context.elemeSdkLogger.error("connect to server error");
            throw new RuntimeException(e);
        }
    }

    @OnOpen
    public void onOpen(Session userSession) {
        Context.elemeSdkLogger.info("connection onOpen");
        this.userSession = userSession;
    }


    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        Context.elemeSdkLogger.info("connection closed :" + reason.getCloseCode());
        this.userSession = null;
    }


    @OnMessage
    public void onMessage(String message) {
        try {
            UpstreamPack upstreamPack = JacksonUtils.json2pojo(message, UpstreamPack.class);
            if (Constants.ACK_HEART_BEAT.equalsIgnoreCase(upstreamPack.getTopic())) {
                String srcMsgId = JacksonUtils.json2pojo(upstreamPack.getContent(), HeartBeatAckPack.class).getSrcMsgId();
                ArrayBlockingQueue heartBeatQueue = HeartBeat.heartBeatRecordQueueMap.get(appKey);
                heartBeatQueue.remove(new HeartBeatRecord(srcMsgId));
            } else if (Constants.BUSSINESS_MESSAGE.equalsIgnoreCase(upstreamPack.getTopic())) {
                Context.elemeSdkLogger.info("onMessage: " + JacksonUtils.obj2json(upstreamPack));
                if (this.businessHandle.onMessage(upstreamPack.getContent())) {
                    this.userSession.getAsyncRemote().sendText(JacksonUtils.obj2json(UpStreamPackBuild.buildBussinessAckPack(upstreamPack.getMsgId())));
                }
            }
        } catch (Exception e) {
            Context.elemeSdkLogger.error("onMessage error:" + e);
        }

    }


    public void regiterMessageHandler(BusinessHandle businessHandle) {
        this.businessHandle = businessHandle;
    }


    public void sendMessage(String message) throws IOException {
        if (this.userSession != null && this.userSession.isOpen()) {
            this.userSession.getAsyncRemote().sendText(message);
        } else {
            throw new IOException("connection already close");
        }
    }

    public void close() {
        try {
            this.userSession.close();
        } catch (IOException e) {
            Context.elemeSdkLogger.error("connection close error:" + e);
        }
    }

}