package eleme.openapi.ws.sdk.client;

import eleme.openapi.ws.sdk.config.Context;
import eleme.openapi.ws.sdk.exception.UnableConnectionException;
import eleme.openapi.ws.sdk.utils.ClientEnvUtils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionManagement {
    private final static int START_SLEEP_TIME = 500;
    private final static int MAX_SLEEP_TIME = 512 * 1000;
    private final static int MIDDLE_SLEEP_TIME = 128 * 1000;


    public static ConcurrentHashMap<String, WsClientEndpoint> clientEndPointMap = new ConcurrentHashMap();

    public static void initConnection() throws UnableConnectionException {
        try {
            for (Map.Entry<String, String> entry : Context.wssAddressMap.entrySet()) {
                WsClientEndpoint clientEndPoint = new WsClientEndpoint(new URI(entry.getValue()), entry.getKey());
                clientEndPointMap.put(entry.getKey(), clientEndPoint);
                clientEndPoint.regiterMessageHandler(Context.businessHandle);
                Context.elemeSdkLogger.info("build connection success,key:" + entry.getKey());
            }
        } catch (URISyntaxException e) {
            Context.elemeSdkLogger.error("build connection error:" + e.getMessage());
            Context.elemeSdkLogger.error("context:" + ClientEnvUtils.getClientProfile());
            throw new UnableConnectionException(e.getMessage());
        }
    }

    public static void buildConnection(String appKey) throws UnableConnectionException {
        try {
            WsClientEndpoint clientEndPoint = new WsClientEndpoint(new URI(Context.wssAddressMap.get(appKey)), appKey);
            clientEndPointMap.put(appKey, clientEndPoint);
            clientEndPoint.regiterMessageHandler(Context.businessHandle);
            Context.elemeSdkLogger.info("build connection success,key:" + appKey);
        } catch (URISyntaxException e) {
            Context.elemeSdkLogger.error("build connection error:" + e.getMessage());
            throw new UnableConnectionException(e.getMessage());
        }
    }

    public static void reBuildConnection(String appkey) {
        int start = START_SLEEP_TIME;
        while (true) {
            try {
                close(clientEndPointMap.get(appkey));
                Thread.sleep(start);
                buildConnection(appkey);
                break;
            } catch (Exception e) {
                start = Math.min(start * 2, MAX_SLEEP_TIME);
                if (start == MAX_SLEEP_TIME || start == MIDDLE_SLEEP_TIME) {
                    Context.elemeSdkLogger.error("rebuild context:" + ClientEnvUtils.getClientProfile());
                }
                Context.elemeSdkLogger.error("rebuild connection:" + e.getMessage());
            }
        }
    }

    private static void close(WsClientEndpoint wsClientEndpoint) {
        if (wsClientEndpoint != null) {
            try {
                wsClientEndpoint.close();
            } catch (Exception ignore) {

            }
        }
    }


}
