/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.MappingDirection;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.property.PropertyResolverStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoringClassMapBuilder<A, B>
extends ClassMapBuilder<A, B> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScoringClassMapBuilder.class);
    private final PropertyMatchingWeights matchingWeights;

    protected ScoringClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults, PropertyMatchingWeights matchingWeights) {
        super(aType, bType, mapperFactory, propertyResolver, defaults);
        this.matchingWeights = matchingWeights;
    }

    @Override
    public ClassMapBuilder<A, B> byDefault(MappingDirection direction, DefaultFieldMapper ... withDefaults) {
        DefaultFieldMapper[] defaults = withDefaults.length == 0 ? this.getDefaultFieldMappers() : withDefaults;
        PriorityQueue<FieldMatchScore> matchScores = new PriorityQueue<FieldMatchScore>();
        Map<String, Property> propertiesForA = this.getPropertyExpressions(this.getAType());
        Map<String, Property> propertiesForB = this.getPropertyExpressions(this.getBType());
        for (Map.Entry<String, Property> propertyA : propertiesForA.entrySet()) {
            if (propertyA.getValue().getName().equals("class")) continue;
            for (Map.Entry<String, Property> propertyB : propertiesForB.entrySet()) {
                if (propertyB.getValue().getName().equals("class")) continue;
                FieldMatchScore matchScore = new FieldMatchScore(propertyA.getValue(), propertyB.getValue(), this.matchingWeights);
                matchScores.add(matchScore);
            }
        }
        LinkedHashSet<String> unmatchedFields = new LinkedHashSet<String>(this.getPropertiesForTypeA());
        unmatchedFields.remove("class");
        for (FieldMatchScore score : matchScores) {
            if (this.getMappedPropertiesForTypeA().contains(score.propertyA.getExpression()) || this.getMappedPropertiesForTypeB().contains(score.propertyB.getExpression())) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("\n" + score.toString());
            }
            if (!score.meetsMinimumScore()) continue;
            this.fieldMap(score.propertyA.getExpression(), score.propertyB.getExpression()).direction(direction).add();
            unmatchedFields.remove(score.propertyA.getExpression());
        }
        for (String propertyNameA : unmatchedFields) {
            Property prop = this.resolvePropertyForA(propertyNameA);
            for (DefaultFieldMapper defaulter : defaults) {
                String suggestion = defaulter.suggestMappedField(propertyNameA, prop.getType());
                if (suggestion == null || !this.getPropertiesForTypeB().contains(suggestion) || this.getMappedPropertiesForTypeB().contains(suggestion)) continue;
                this.fieldMap(propertyNameA, suggestion).direction(direction).add();
            }
        }
        return this;
    }

    public static class FieldMatchScore
    implements Comparable<FieldMatchScore> {
        private static final List<String> IGNORED_WORDS = Arrays.asList("with", "this", "that", "an", "a", "of", "the");
        private static final double MAX_POSSIBLE_SCORE = 50.0;
        private final PropertyMatchingWeights matchingWeights;
        private boolean contains;
        private boolean containsIgnoreCase;
        private double typeMatch;
        private Property propertyA;
        private Property propertyB;
        private int hashCode;
        private double commonWordCount;
        private double avgWordCount;
        private double wordMatchScore;
        private double score;
        private double typeMatchScore;
        private double commonWordsScore;
        private double containsScore;
        private static final String WORD_SPLITTER = String.format("%s|%s|%s|%s", "([\\{\\}\\]\\[-_])", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])");

        public FieldMatchScore(Property propertyA, Property propertyB, PropertyMatchingWeights matchingWeights) {
            this.matchingWeights = matchingWeights;
            this.propertyA = propertyA;
            this.propertyB = propertyB;
            String propertyALower = propertyA.getName().toLowerCase();
            String propertyBLower = propertyB.getName().toLowerCase();
            List<List<String>> aWords = FieldMatchScore.splitIntoLowerCaseWords(propertyA.getExpression());
            List<List<String>> bWords = FieldMatchScore.splitIntoLowerCaseWords(propertyB.getExpression());
            aWords.removeAll(IGNORED_WORDS);
            bWords.removeAll(IGNORED_WORDS);
            Set commonWords = this.intersection(aWords, bWords);
            this.avgWordCount = (double)(aWords.size() + bWords.size()) / 2.0;
            this.commonWordCount = commonWords.size();
            this.wordMatchScore = this.computeWordMatchScore(aWords, bWords);
            this.contains = propertyA.getName().contains(propertyB.getName()) || propertyB.getName().contains(propertyA.getName());
            boolean bl = this.containsIgnoreCase = this.contains || propertyALower.contains(propertyBLower) || propertyBLower.contains(propertyALower);
            this.typeMatch = propertyA.isMultiOccurrence() && !propertyB.isMultiOccurrence() || !propertyA.isMultiOccurrence() && propertyB.isMultiOccurrence() ? Double.NEGATIVE_INFINITY : (propertyA.getType().isAssignableFrom(propertyB.getType()) || propertyB.getType().isAssignableFrom(propertyA.getType()) ? 1.0 : 0.0);
            this.computeOverallScore();
            this.hashCode = this.computeHashCode();
        }

        public String toString() {
            return "[" + this.propertyA.getExpression() + ", " + this.propertyB.getExpression() + "] {\n   wordMatchScore: " + this.wordMatchScore + "\n   commonWordScore: " + this.commonWordsScore + "\n   containsScore: " + this.containsScore + "\n   typeMatchScore: " + this.typeMatchScore + "\n   ------------------- \n   total: " + this.score + "\n}";
        }

        private <T> Set<T> intersection(List<List<T>> setA, List<List<T>> setB) {
            Set<T> intersection = this.flatten(setA);
            Set<T> temp = this.flatten(setB);
            intersection.retainAll(temp);
            return intersection;
        }

        private <T> Set<T> flatten(List<List<T>> aWords) {
            LinkedHashSet<T> set = new LinkedHashSet<T>();
            for (List<T> collection : aWords) {
                for (T item : collection) {
                    set.add(item);
                }
            }
            return set;
        }

        public boolean meetsMinimumScore() {
            double normalizedScore = 25.0 * this.matchingWeights.minimumScore();
            return this.score >= normalizedScore;
        }

        double computeWordMatchScore(List<List<String>> aWords, List<List<String>> bWords) {
            LinkedHashSet aWordsRemaining = new LinkedHashSet(this.flatten(aWords));
            LinkedHashSet bWordsRemaining = new LinkedHashSet(this.flatten(bWords));
            PriorityQueue<WordPair> orderedPairs = new PriorityQueue<WordPair>();
            double aDepth = 0.0;
            for (List aWordList : aWords) {
                aDepth += 1.0;
                for (String aWord : aWordList) {
                    double bDepth = 0.0;
                    for (List bWordList : bWords) {
                        for (String bWord : bWordList) {
                            orderedPairs.add(new WordPair(aWord, bWord, aDepth / (double)aWords.size(), (bDepth += 1.0) / (double)bWords.size(), this.matchingWeights));
                        }
                    }
                }
            }
            double score = 0.0;
            for (WordPair w : orderedPairs) {
                if (!aWordsRemaining.contains(w.aWord) || !bWordsRemaining.contains(w.bWord)) continue;
                score += w.score;
                aWordsRemaining.remove(w.aWord);
                bWordsRemaining.remove(w.bWord);
            }
            double remains = (double)(aWordsRemaining.size() + bWordsRemaining.size()) / 2.0;
            double initial = (double)(aWords.size() + bWords.size()) / 2.0;
            double unmatchedWordsCount = (remains - initial) * this.matchingWeights.unmatchedWords();
            return score + unmatchedWordsCount;
        }

        private void computeOverallScore() {
            this.containsScore = this.matchingWeights.containsName() * (double)(this.containsIgnoreCase ? 10 : 0);
            this.commonWordsScore = this.commonWordCount == 0.0 ? 0.0 : this.matchingWeights.commonWordCount() * (Math.pow(2.0 * this.commonWordCount, 2.0) * ((this.avgWordCount + this.commonWordCount) / this.avgWordCount));
            this.typeMatchScore = this.matchingWeights.typeMatch() * this.typeMatch;
            this.score = this.wordMatchScore + this.commonWordsScore + this.containsScore + this.typeMatchScore;
        }

        private static int getLevenshteinDistance(String s, String t) {
            int indexOfS;
            if (s == null || t == null) {
                throw new IllegalArgumentException("Strings must not be null");
            }
            int lengthOfS = s.length();
            int lengthOfT = t.length();
            if (lengthOfS == 0) {
                return lengthOfT;
            }
            if (lengthOfT == 0) {
                return lengthOfS;
            }
            if (lengthOfS > lengthOfT) {
                String tmp = s;
                s = t;
                t = tmp;
                lengthOfS = lengthOfT;
                lengthOfT = t.length();
            }
            int[] previousCosts = new int[lengthOfS + 1];
            int[] costs = new int[lengthOfS + 1];
            for (indexOfS = 0; indexOfS <= lengthOfS; ++indexOfS) {
                previousCosts[indexOfS] = indexOfS;
            }
            for (int indexOfT = 1; indexOfT <= lengthOfT; ++indexOfT) {
                char charAtIndexOfT = t.charAt(indexOfT - 1);
                costs[0] = indexOfT;
                for (indexOfS = 1; indexOfS <= lengthOfS; ++indexOfS) {
                    int cost = s.charAt(indexOfS - 1) == charAtIndexOfT ? 0 : 1;
                    costs[indexOfS] = Math.min(Math.min(costs[indexOfS - 1] + 1, previousCosts[indexOfS] + 1), previousCosts[indexOfS - 1] + cost);
                }
                int[] swap = previousCosts;
                previousCosts = costs;
                costs = swap;
            }
            return previousCosts[lengthOfS];
        }

        private static List<List<String>> splitIntoLowerCaseWords(String s) {
            ArrayList<List<String>> results = new ArrayList<List<String>>();
            for (String property : s.split("[.]")) {
                LinkedList<String> words = new LinkedList<String>();
                results.add(words);
                for (String word : property.split(WORD_SPLITTER)) {
                    if (word == null || word.trim().length() <= 0) continue;
                    words.add(word.toLowerCase());
                }
            }
            return results;
        }

        @Override
        public int compareTo(FieldMatchScore that) {
            if (this.score < that.score) {
                return 1;
            }
            if (this.score > that.score) {
                return -1;
            }
            return 0;
        }

        private int computeHashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.propertyA == null ? 0 : this.propertyA.hashCode());
            result = 31 * result + (this.propertyB == null ? 0 : this.propertyB.hashCode());
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldMatchScore other = (FieldMatchScore)obj;
            if (this.propertyA == null ? other.propertyA != null : !this.propertyA.equals(other.propertyA)) {
                return false;
            }
            return !(this.propertyB == null ? other.propertyB != null : !this.propertyB.equals(other.propertyB));
        }

        private static class WordPair
        implements Comparable<WordPair> {
            private String aWord;
            private String bWord;
            private double score;

            private WordPair(String aWord, String bWord, double aWordDepth, double bWordDepth, PropertyMatchingWeights matchingWeights) {
                this.aWord = aWord;
                this.bWord = bWord;
                double aDepth = (1.0 + aWordDepth) * matchingWeights.nestedDepth;
                double bDepth = (1.0 + bWordDepth) * matchingWeights.nestedDepth;
                double editDistance = FieldMatchScore.getLevenshteinDistance(aWord, bWord);
                double distanceWeight = matchingWeights.editDistance * (1.0 / (editDistance + 1.0));
                double wordLength = Math.max(aWord.length(), bWord.length());
                double wordLengthWeight = matchingWeights.editDistance * Math.sqrt(wordLength);
                this.score = aDepth + bDepth + distanceWeight + wordLengthWeight;
            }

            @Override
            public int compareTo(WordPair o) {
                double score = this.score - o.score;
                if (score < 0.0) {
                    return 1;
                }
                if (score > 0.0) {
                    return -1;
                }
                return 0;
            }

            public String toString() {
                return "[" + this.aWord + "],[" + this.bWord + "] = " + this.score;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.aWord == null ? 0 : this.aWord.hashCode());
                result = 31 * result + (this.bWord == null ? 0 : this.bWord.hashCode());
                long temp = Double.doubleToLongBits(this.score);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                WordPair other = (WordPair)obj;
                if (this.aWord == null ? other.aWord != null : !this.aWord.equals(other.aWord)) {
                    return false;
                }
                if (this.bWord == null ? other.bWord != null : !this.bWord.equals(other.bWord)) {
                    return false;
                }
                return Double.doubleToLongBits(this.score) == Double.doubleToLongBits(other.score);
            }
        }
    }

    public static class Factory
    extends ClassMapBuilderFactory {
        private PropertyMatchingWeights matchingWeights;

        public Factory() {
            this.matchingWeights = new PropertyMatchingWeights();
        }

        public Factory(PropertyMatchingWeights matchingWeights) {
            this.matchingWeights = matchingWeights;
        }

        @Override
        protected <A, B> ClassMapBuilder<A, B> newClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
            return new ScoringClassMapBuilder<A, B>(aType, bType, mapperFactory, propertyResolver, defaults, this.matchingWeights);
        }
    }

    public static final class PropertyMatchingWeights {
        private static final double MIN_WEIGHT = 0.0;
        private static final double MAX_WEIGHT = 1.0;
        private double nestedDepth = 0.5;
        private double unmatchedWords = 0.5;
        private double editDistance = 0.5;
        private double containsName = 0.5;
        private double typeMatch = 0.5;
        private double commonWordCount = 0.5;
        private double minimumScore = 0.5;

        public double commonWordCount() {
            return this.commonWordCount;
        }

        public PropertyMatchingWeights commonWordCount(double weight) {
            this.validateWeight(weight);
            this.commonWordCount = weight;
            return this;
        }

        public double containsName() {
            return this.containsName;
        }

        public PropertyMatchingWeights containsName(double weight) {
            this.validateWeight(weight);
            this.containsName = weight;
            return this;
        }

        public double typeMatch() {
            return this.typeMatch;
        }

        public PropertyMatchingWeights typeMatch(double weight) {
            this.validateWeight(weight);
            this.typeMatch = weight;
            return this;
        }

        public double nestedDepth() {
            return this.nestedDepth;
        }

        public PropertyMatchingWeights nestedDepth(double weight) {
            this.validateWeight(weight);
            this.nestedDepth = weight;
            return this;
        }

        public double unmatchedWords() {
            return this.unmatchedWords;
        }

        public PropertyMatchingWeights unmatchedWords(double weight) {
            this.validateWeight(weight);
            this.unmatchedWords = weight;
            return this;
        }

        public double editDistance() {
            return this.editDistance;
        }

        public PropertyMatchingWeights editDistance(double weight) {
            this.validateWeight(weight);
            this.editDistance = weight;
            return this;
        }

        public double minimumScore() {
            return this.minimumScore;
        }

        public PropertyMatchingWeights minimumScore(double weight) {
            this.validateWeight(weight);
            this.minimumScore = weight;
            return this;
        }

        private void validateWeight(double weight) {
            if (weight < 0.0 || weight > 1.0) {
                throw new IllegalArgumentException("weights should be between 0.0 and 1.0");
            }
        }
    }
}

