/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;

public class ArrayOrCollectionToArray
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getDestination().isArray() && (fieldMap.getSource().isArray() || fieldMap.getSource().isCollection());
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        String mapArray;
        VariableRef arrayVar = destination.elementRef(destination.name() + "Array__");
        String newArray = String.format("%s[] %s = new %s[%s]", destination.elementTypeName(), arrayVar.validVariableName(), destination.elementTypeName(), source.size());
        if (destination.elementType().isPrimitive()) {
            if (code.isDebugEnabled()) {
                code.debugField(fieldMap, "mapping to primitive array");
            }
            mapArray = String.format("mapArray(%s, asList(%s), %s.class, mappingContext)", arrayVar.validVariableName(), source, arrayVar.typeName());
        } else {
            if (code.isDebugEnabled()) {
                code.debugField(fieldMap, "mapping to array");
            }
            mapArray = String.format("mapperFacade.mapAsArray(%s, asList(%s), %s, %s, mappingContext)", arrayVar.validVariableName(), source, code.usedType(source.elementType()), code.usedType(destination.elementType()));
        }
        String mapNull = ArrayOrCollectionToArray.shouldMapNulls(fieldMap, code) ? String.format(" else { %s; }", destination.assignIfPossible("null", new Object[0])) : "";
        return String.format(" %s { %s; %s; %s; } %s", source.ifNotNull(), newArray, mapArray, destination.assign(arrayVar), mapNull);
    }
}

