/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.lang.reflect.Modifier;

class Analysis {
    static Visibility getMostRestrictiveVisibility(Class<?> classToCheck) {
        Visibility visibility = Visibility.PUBLIC;
        for (Class<?> currentClass = classToCheck; currentClass != null; currentClass = currentClass.getEnclosingClass()) {
            int modifiers = currentClass.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                visibility = Visibility.PRIVATE;
                continue;
            }
            if (Modifier.isProtected(modifiers) && visibility != Visibility.PRIVATE) {
                visibility = Visibility.PROTECTED;
                continue;
            }
            if (Modifier.isPublic(modifiers) || visibility == Visibility.PRIVATE || visibility == Visibility.PROTECTED) continue;
            visibility = Visibility.PACKAGE;
        }
        return visibility;
    }

    private Analysis() {
        throw new UnsupportedOperationException("not instantiable");
    }

    static enum Visibility {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC;

    }
}

