/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;

public class LDAPVirtualListControl
extends LDAPControl {
    public static final String VIRTUALLIST = "2.16.840.1.113730.3.4.9";
    private static final int TAG_BYINDEX = 0;
    private static final int TAG_BYFILTER = 1;
    private int m_beforeCount = 0;
    private int m_afterCount = 0;
    private int m_listIndex = -1;
    private int m_listSize = 0;
    private String m_context = null;

    LDAPVirtualListControl() {
        super(VIRTUALLIST, true, null);
    }

    public LDAPVirtualListControl(int n, int n2, int n3, int n4) {
        super(VIRTUALLIST, true, null);
        this.m_listSize = n4;
        this.setRange(n, n2, n3);
    }

    public LDAPVirtualListControl(int n, int n2, int n3, int n4, String string) {
        this(n, n2, n3, n4);
        this.m_context = string;
    }

    public LDAPVirtualListControl(String string, int n, int n2) {
        super(VIRTUALLIST, true, null);
        this.setRange(string, n, n2);
    }

    public LDAPVirtualListControl(String string, int n, int n2, String string2) {
        this(string, n, n2);
        this.m_context = string2;
    }

    private byte[] createPageSpecification(int n, int n2, int n3, int n4) {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(n3));
        bERSequence.addElement(new BERInteger(n4));
        BERSequence bERSequence2 = new BERSequence();
        bERSequence2.addElement(new BERInteger(n));
        bERSequence2.addElement(new BERInteger(n2));
        bERSequence.addElement(new BERTag(160, bERSequence2, true));
        if (this.m_context != null) {
            bERSequence.addElement(new BEROctetString(this.m_context));
        }
        return this.flattenBER(bERSequence);
    }

    private byte[] createPageSpecification(String string, int n, int n2) {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(n));
        bERSequence.addElement(new BERInteger(n2));
        bERSequence.addElement(new BERTag(129, new BEROctetString(string), true));
        if (this.m_context != null) {
            bERSequence.addElement(new BEROctetString(this.m_context));
        }
        return this.flattenBER(bERSequence);
    }

    public int getAfterCount() {
        return this.m_afterCount;
    }

    public int getBeforeCount() {
        return this.m_beforeCount;
    }

    public String getContext() {
        return this.m_context;
    }

    public int getIndex() {
        return this.m_listIndex;
    }

    public int getListSize() {
        return this.m_listSize;
    }

    public void setContext(String string) {
        this.m_context = string;
    }

    public void setListSize(int n) {
        this.m_listSize = n;
    }

    public void setRange(int n, int n2, int n3) {
        this.m_beforeCount = n2;
        this.m_afterCount = n3;
        this.m_listIndex = n;
        this.m_value = this.createPageSpecification(this.m_listIndex, this.m_listSize, this.m_beforeCount, this.m_afterCount);
    }

    public void setRange(String string, int n, int n2) {
        this.m_beforeCount = n;
        this.m_afterCount = n2;
        this.m_value = this.createPageSpecification(string, this.m_beforeCount, this.m_afterCount);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{VirtListCtrl:");
        stringBuffer.append(" isCritical=");
        stringBuffer.append(this.isCritical());
        stringBuffer.append(" beforeCount=");
        stringBuffer.append(this.m_beforeCount);
        stringBuffer.append(" afterCount=");
        stringBuffer.append(this.m_afterCount);
        stringBuffer.append(" listIndex=");
        stringBuffer.append(this.m_listIndex);
        stringBuffer.append(" listSize=");
        stringBuffer.append(this.m_listSize);
        if (this.m_context != null) {
            stringBuffer.append(" conext=");
            stringBuffer.append(this.m_context);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

