/*
 * Decompiled with CFR 0.152.
 */
package inria.util;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class Utilities {
    public static final long Modulo32 = 0x100000000L;
    protected static InetAddress localhost = null;
    protected static String localHostName = "localhost";
    static Random rand = null;
    static SimpleDateFormat longFormat = null;
    static SimpleDateFormat shortFormat1 = null;
    static SimpleDateFormat shortFormat2 = null;
    static SimpleTimeZone gmtTz = null;
    static TimeZone defTz = null;
    static Date date = null;
    static SimpleDateFormat parseFormat = null;
    static ParsePosition parsePos = null;

    public static String getLocalHostName() {
        if (localhost == null) {
            Utilities.getLocalHost();
        }
        if (localhost != null) {
            localHostName = localhost.getHostName().toLowerCase();
        }
        return localHostName;
    }

    public static InetAddress getLocalHost() {
        if (localhost == null) {
            try {
                localhost = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                try {
                    localhost = InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException unknownHostException2) {
                    return null;
                }
            }
            if (localhost.getHostName().indexOf(46) < 0) {
                try {
                    localhost = InetAddress.getByName(localhost.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return localhost;
    }

    public static String fileExtension(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(".");
        if (string.indexOf(47) >= 0) {
            n = 47;
        } else if (string.indexOf(92) >= 0) {
            n = 92;
        } else {
            if (n2 >= 0) {
                return string.substring(n2 + 1);
            }
            return null;
        }
        int n3 = string.lastIndexOf(n);
        if (n2 >= 0 && n2 > n3) {
            return string.substring(n2 + 1);
        }
        return null;
    }

    public static String convertPathname(String string) {
        if (string == null) {
            return null;
        }
        String string2 = File.separator;
        if (string2.equals("/")) {
            return string.replace('\\', '/');
        }
        return string.replace('/', '\\');
    }

    public static String shortPathname(String string) {
        block9: {
            int n;
            block8: {
                int n2;
                if (string.indexOf(47) < 0) break block8;
                while ((n2 = string.indexOf("/./")) >= 0) {
                    string = string.substring(0, n2) + string.substring(n2 + 2);
                }
                if (string.startsWith("../")) {
                    return string;
                }
                while ((n2 = string.indexOf("/../")) >= 0) {
                    int n3 = string.lastIndexOf(47, n2 - 1);
                    if (n3 <= 0 || n3 > 0 && string.charAt(n3 - 1) == '/') {
                        string = string.substring(0, n2) + string.substring(n2 + 3);
                        continue;
                    }
                    string = string.substring(0, n3) + string.substring(n2 + 3);
                }
                break block9;
            }
            if (string.indexOf(92) < 0) break block9;
            while ((n = string.indexOf("\\.\\")) >= 0) {
                string = string.substring(0, n) + string.substring(n + 2);
            }
            if (string.startsWith("..\\")) {
                return string;
            }
            while ((n = string.indexOf("\\..\\")) >= 0) {
                int n4 = string.lastIndexOf(92, n - 1);
                if (n4 <= 0 || n4 > 0 && string.charAt(n4 - 1) == '\\') {
                    string = string.substring(0, n) + string.substring(n + 3);
                    continue;
                }
                string = string.substring(0, n4) + string.substring(n + 3);
            }
        }
        return string;
    }

    public static String dirname(String string) {
        String string2 = File.separator;
        int n = string.lastIndexOf(string2);
        if (n == 0) {
            return string.substring(0, 1);
        }
        if (n > 0) {
            return string.substring(0, n + 1);
        }
        return "";
    }

    public static String basename(String string) {
        String string2 = File.separator;
        int n = string.lastIndexOf(string2);
        if (n >= 0 && n + 1 < string.length()) {
            return string.substring(n + 1);
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getURLRoot(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(":");
        if (n <= 0) {
            return null;
        }
        if (string.startsWith("file:")) {
            int n2 = string.indexOf("//", n + 1);
            if (n2 <= 0) return string.substring(0, 5);
            if ((n2 = string.indexOf("/", n2 + 2)) <= 0) return null;
            return string.substring(0, n2);
        }
        int n3 = string.indexOf("/", n + 1);
        if (n3 <= 0 || (n3 = string.indexOf("/", n3 + 1)) <= 0 || (n3 = string.indexOf("/", n3 + 1)) <= 0) return null;
        return string.substring(0, n3);
    }

    public static String getHttpRoot(String string) {
        return Utilities.getURLRoot(string);
    }

    public static void intToByte(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static int byteToInt(byte[] byArray, int n) {
        int n2 = byArray[n] << 24 & 0xFF000000;
        n2 |= byArray[n + 1] << 16 & 0xFF0000;
        n2 |= byArray[n + 2] << 8 & 0xFF00;
        return n2 |= byArray[n + 3] & 0xFF;
    }

    public static long byteToLong(byte[] byArray, int n) {
        long l = (long)(byArray[n] << 56) & 0xFF00000000000000L;
        l |= (long)(byArray[n + 1] << 48) & 0xFF000000000000L;
        l |= (long)(byArray[n + 2] << 40) & 0xFF0000000000L;
        l |= (long)(byArray[n + 3] << 32) & 0xFF00000000L;
        l |= (long)(byArray[n + 4] << 24) & 0xFF000000L;
        l |= (long)(byArray[n + 5] << 16) & 0xFF0000L;
        l |= (long)(byArray[n + 6] << 8) & 0xFF00L;
        return l |= (long)byArray[n + 7] & 0xFFL;
    }

    public static int getShort(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static boolean isValidURL(String string) {
        try {
            URL uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public static String toAddressString(int n) {
        return (n >>> 24 & 0xFF) + "." + (n >>> 16 & 0xFF) + "." + (n >>> 8 & 0xFF) + "." + (n >>> 0 & 0xFF);
    }

    public static int pad32(byte[] byArray, int n) {
        int n2 = n % 4;
        if (n2 > 0) {
            int n3 = 4 - n2;
            int n4 = n2;
            while (n4 < 3) {
                byArray[n++] = 0;
                ++n4;
            }
            byArray[n++] = (byte)n3;
            return n3;
        }
        return 0;
    }

    public static int diff32(int n, int n2) {
        int n3 = n - n2;
        if ((long)n3 > 0x80000000L) {
            n3 = (int)((long)n3 - 0x100000000L);
        } else if ((long)n3 < Integer.MIN_VALUE) {
            n3 = (int)((long)n3 + 0x100000000L);
        }
        return n3;
    }

    public static boolean bcomp(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static Vector sortByString(Vector vector, boolean bl) {
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            String string = e.toString();
            if (bl) {
                string = string.toLowerCase();
            }
            int n2 = 0;
            int n3 = vector2.size();
            while (n3 - n2 > 0) {
                int n4;
                int n5 = n3 + n2 >> 1;
                String string2 = vector2.elementAt(n5).toString();
                if (bl) {
                    string2 = string2.toLowerCase();
                }
                if ((n4 = string.compareTo(string2)) > 0) {
                    n2 = n5 + 1;
                    continue;
                }
                if (n4 < 0) {
                    n3 = n5;
                    continue;
                }
                n2 = n5;
                break;
            }
            vector2.insertElementAt(e, n2);
            ++n;
        }
        return vector2;
    }

    public static int getRandomInteger() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextInt();
    }

    public static double getRandomDouble() {
        if (rand == null) {
            rand = new Random();
        }
        return rand.nextDouble();
    }

    public static String GMTDate(long l) {
        if (longFormat == null) {
            longFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss");
            if (date == null) {
                date = new Date();
            }
        }
        if (gmtTz == null) {
            gmtTz = new SimpleTimeZone(0, "GMT");
        }
        longFormat.setTimeZone(gmtTz);
        date.setTime(l);
        return longFormat.format(date) + " " + gmtTz.getID();
    }

    public static String localDate(long l) {
        if (longFormat == null) {
            longFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss");
            if (date == null) {
                date = new Date();
            }
        }
        if (defTz == null) {
            defTz = TimeZone.getDefault();
        }
        longFormat.setTimeZone(defTz);
        date.setTime(l);
        return longFormat.format(date) + " " + defTz.getID();
    }

    public static String shortDateWithWeekday(long l) {
        if (shortFormat1 == null) {
            shortFormat1 = new SimpleDateFormat("EEE d MMM HH:mm:ss");
            if (date == null) {
                date = new Date();
            }
            if (defTz == null) {
                defTz = TimeZone.getDefault();
            }
            shortFormat1.setTimeZone(defTz);
        }
        date.setTime(l);
        return shortFormat1.format(date);
    }

    public static String shortDate(long l) {
        if (shortFormat2 == null) {
            shortFormat2 = new SimpleDateFormat("d MMM HH:mm:ss");
            if (date == null) {
                date = new Date();
            }
            if (defTz == null) {
                defTz = TimeZone.getDefault();
            }
            shortFormat2.setTimeZone(defTz);
        }
        date.setTime(l);
        return shortFormat2.format(date);
    }

    public static long parseGenericDate(String string) {
        Date date;
        if (parseFormat == null) {
            parseFormat = new SimpleDateFormat();
            parsePos = new ParsePosition(0);
            if (defTz == null) {
                defTz = TimeZone.getDefault();
            }
        }
        parseFormat.applyPattern("EEE, dd MMM yyyy HH:mm:ss z");
        parsePos.setIndex(0);
        try {
            date = parseFormat.parse(string, parsePos);
        }
        catch (Exception exception) {
            date = null;
        }
        if (date != null) {
            return date.getTime();
        }
        parseFormat.applyPattern("EEEEEEEEE, dd-MMM-yy HH:mm:ss z");
        parsePos.setIndex(0);
        try {
            date = parseFormat.parse(string, parsePos);
        }
        catch (Exception exception) {
            date = null;
        }
        if (date != null) {
            return date.getTime();
        }
        parseFormat.applyPattern("EEE MMM d HH:mm:ss yyyy");
        parsePos.setIndex(0);
        parseFormat.setTimeZone(defTz);
        try {
            date = parseFormat.parse(string, parsePos);
        }
        catch (Exception exception) {
            date = null;
        }
        if (date != null) {
            return date.getTime();
        }
        return 0L;
    }
}

