/*
 * Decompiled with CFR 0.152.
 */
package inria.util;

import inria.util.LoggerInterface;
import inria.util.Utilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class Logger {
    public static boolean debug = false;
    public static boolean trace = false;
    public static boolean append = true;
    private static PrintWriter errlog = null;
    private static PrintStream err = System.err;
    private static PrintStream out = System.out;
    private static PrintWriter traceOut = null;
    private static LoggerInterface catcher = null;
    protected static int errLogFileMaxSize = 32000;
    protected static String traceFile = null;

    public static void redirect(LoggerInterface loggerInterface) {
        catcher = loggerInterface;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static void setTrace(boolean bl) {
        trace = bl;
    }

    public static void setErrorLogFile(String string) {
        Object object;
        if (string == null || string.length() == 0) {
            return;
        }
        File file = new File(string = Utilities.convertPathname(string));
        if (file.exists() && file.length() > (long)errLogFileMaxSize) {
            object = new File(string + "1");
            file.renameTo((File)object);
        }
        try {
            object = new FileOutputStream(string, append);
            errlog = new PrintWriter((OutputStream)object, true);
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void setTraceFile(String string) {
        Object object;
        if (string == null || string.length() == 0) {
            return;
        }
        File file = new File(string = Utilities.convertPathname(string));
        if (file.exists()) {
            object = new File(string + "1");
            file.renameTo((File)object);
        }
        try {
            object = new FileOutputStream(string);
            traceOut = new PrintWriter((OutputStream)object, true);
        }
        catch (IOException iOException) {
            return;
        }
        traceFile = string;
    }

    public static String getTraceFile() {
        return traceFile;
    }

    public static void error(Object object, String string) {
        if (catcher != null) {
            catcher.error(object, string);
        }
        if (errlog != null) {
            errlog.println(object.getClass().getName() + ": " + string);
        } else if (trace) {
            err.println(object.getClass().getName() + ": error: " + string);
        }
        if (debug) {
            out.println(object.getClass().getName() + ": error: " + string);
        }
    }

    public static void error(String string) {
        if (catcher != null) {
            catcher.error(string);
        }
        if (errlog != null) {
            errlog.println(string);
        } else if (trace) {
            err.println("error: " + string);
        }
    }

    public static void error(Object object, String string, Exception exception) {
        Logger.error(object, string + " - " + exception.getMessage());
    }

    public static void error(String string, Exception exception) {
        Logger.error("error: " + string + " - " + exception.getMessage());
    }

    public static void warning(Object object, String string) {
        if (trace) {
            err.println(object.getClass().getName() + ": warning: " + string);
        }
    }

    public static void warning(String string) {
        if (trace) {
            err.println("warning: " + string);
        }
    }

    public static void debug(String string) {
        if (debug) {
            out.println(string);
        }
    }

    public static void debug(Object object, String string) {
        if (debug) {
            out.println(object.getClass().getName() + ": " + string);
        }
    }

    public static void trace(String string) {
        if (trace) {
            if (catcher != null) {
                catcher.trace(string);
            }
            if (traceOut != null) {
                traceOut.println(string);
            } else {
                out.println(string);
            }
        }
    }

    public static void trace(Object object, String string) {
        if (trace) {
            if (catcher != null) {
                catcher.trace(object, string);
            }
            if (traceOut != null) {
                traceOut.println(Logger.shortClassname(object) + ": " + string);
            } else {
                out.println(object.getClass().getName() + ": " + string);
            }
        }
    }

    public static String shortClassname(Object object) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static void fatal(Object object, String string) {
        if (errlog != null) {
            errlog.println(object.getClass().getName() + ": fatal: " + string);
        }
        err.println(object.getClass().getName() + ": fatal: " + string);
        System.exit(-1);
    }

    public static void fatal(String string) {
        if (errlog != null) {
            errlog.println("fatal: " + string);
        }
        err.println("fatal: " + string);
        System.exit(-1);
    }

    public static void dump(Object object, byte[] byArray, int n, int n2) {
        if (!debug) {
            return;
        }
        Logger.debug(object, "length=" + n2);
        Logger.dump(byArray, n, n2);
    }

    public static void dump(byte[] byArray, int n, int n2) {
        if (!debug) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 % 32 == 0) {
                if (n3 > 0) {
                    out.println(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                out.print("0x" + Logger.toUnsignedString(n3, 4) + ":");
            }
            if (n3 % 4 == 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Character.forDigit((byArray[n + n3] & 0xF0) >> 4, 16));
            stringBuffer.append(Character.forDigit(byArray[n + n3] & 0xF, 16));
            ++n3;
        }
        out.println(stringBuffer.toString());
    }

    public static void stringDump(byte[] byArray, int n, int n2) {
        if (!debug) {
            return;
        }
        Logger.stringDump(out, byArray, n, n2);
    }

    public static void dump(PrintStream printStream, byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 % 32 == 0) {
                if (n3 > 0) {
                    printStream.println(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                printStream.print("0x" + Logger.toUnsignedString(n3, 4) + ":");
            }
            if (n3 % 4 == 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Character.forDigit((byArray[n + n3] & 0xF0) >> 4, 16));
            stringBuffer.append(Character.forDigit(byArray[n + n3] & 0xF, 16));
            ++n3;
        }
        printStream.println(stringBuffer.toString());
    }

    public static void stringDump(PrintStream printStream, byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 % 64 == 0) {
                if (n3 > 0) {
                    printStream.println(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                printStream.print("0x" + Logger.toUnsignedString(n3, 4) + ": ");
            }
            if (Logger.isPrintable(byArray[n + n3])) {
                char c = (char)(byArray[n + n3] & 0xFF);
                stringBuffer.append(c);
            } else {
                stringBuffer.append('.');
            }
            ++n3;
        }
        printStream.println(stringBuffer.toString());
    }

    private static boolean isPrintable(byte by) {
        int n = by & 0xFF;
        if (n < 32) {
            return false;
        }
        return n <= 126 || n >= 160;
    }

    private static String toUnsignedString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 >= 3 ? 11 : 32);
        int n3 = 1 << n2;
        int n4 = n3 - 1;
        int n5 = 0;
        while (n5 < 4) {
            stringBuffer.append(Character.forDigit(n & n4, n3));
            n >>>= n2;
            ++n5;
        }
        return stringBuffer.reverse().toString();
    }

    public static void busy(int n) {
        if (catcher != null) {
            catcher.showBusy(n);
        }
    }
}

