/*
 * Decompiled with CFR 0.152.
 */
package inria.util;

public class FIFOQueue {
    Object[] table;
    int head = 0;
    int tail = 0;
    int count = 0;

    public FIFOQueue(int n) {
        this.table = new Object[n];
    }

    public synchronized void enqueue(Object object) {
        while (this.count >= this.table.length) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.table[this.tail] = object;
        ++this.tail;
        if (this.tail >= this.table.length) {
            this.tail = 0;
        }
        ++this.count;
    }

    public synchronized Object dequeue() {
        if (this.count > 0) {
            Object object = this.table[this.head];
            this.table[this.head] = null;
            ++this.head;
            if (this.head >= this.table.length) {
                this.head = 0;
            }
            --this.count;
            if (this.count == this.table.length - 1 || this.count == 0) {
                this.notify();
            }
            return object;
        }
        return null;
    }

    public synchronized void sync() {
        while (this.count > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public int getSize() {
        return this.count;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = null;
            ++n;
        }
        this.head = 0;
        this.tail = 0;
        this.count = 0;
    }
}

