/*
 * Decompiled with CFR 0.152.
 */
package inria.util;

public class ByteArray
implements Cloneable {
    protected static final byte caseDiff = 32;
    protected byte[] buff;
    protected int count;
    protected String stringValue;

    protected ByteArray() {
    }

    public ByteArray(String string) {
        this.stringValue = string;
        this.buff = string.getBytes();
        this.count = this.buff.length;
    }

    public ByteArray(byte[] byArray, int n, int n2) {
        this.stringValue = null;
        this.count = n2;
        this.buff = new byte[n2];
        System.arraycopy(byArray, n, this.buff, 0, n2);
    }

    public int getLength() {
        return this.count;
    }

    public int length() {
        return this.count;
    }

    public boolean equals(ByteArray byteArray) {
        if (byteArray.count != this.count) {
            return false;
        }
        byte[] byArray = byteArray.buff;
        int n = 0;
        while (n < this.count) {
            if (byArray[n] != this.buff[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int compare(ByteArray byteArray) {
        int n = byteArray.count > this.count ? this.count : byteArray.count;
        byte[] byArray = byteArray.buff;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != this.buff[n2]) {
                return this.buff[n2] - byArray[n2];
            }
            ++n2;
        }
        return 0;
    }

    public boolean containedIn(ByteArray byteArray) {
        return this.containedIn(byteArray.buff, 0);
    }

    public boolean containedIn(byte[] byArray, int n) {
        if (n + this.count > byArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.count) {
            if (byArray[n] != this.buff[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equalsIgnoreCase(ByteArray byteArray) {
        if (byteArray.count != this.count) {
            return false;
        }
        byte[] byArray = byteArray.buff;
        int n = 0;
        while (n < this.count) {
            byte by;
            byte by2 = byArray[n];
            if (by2 >= 97 && by2 <= 122) {
                by2 = (byte)(by2 - 32);
            }
            if ((by = this.buff[n]) >= 97 && by <= 122) {
                by = (byte)(by - 32);
            }
            if (by2 != by) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean containedInIgnoreCase(byte[] byArray, int n) {
        if (n + this.count > byArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.count) {
            byte by;
            byte by2 = byArray[n];
            if (by2 >= 97 && by2 <= 122) {
                by2 = (byte)(by2 - 32);
            }
            if ((by = this.buff[n2]) >= 97 && by <= 122) {
                by = (byte)(by - 32);
            }
            if (by2 != by) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public int compareIgnoreCase(ByteArray byteArray) {
        int n = byteArray.count > this.count ? this.count : byteArray.count;
        byte[] byArray = byteArray.buff;
        int n2 = 0;
        while (n2 < n) {
            byte by;
            byte by2 = byArray[n2];
            if (by2 >= 97 && by2 <= 122) {
                by2 = (byte)(by2 - 32);
            }
            if ((by = this.buff[n2]) >= 97 && by <= 122) {
                by = (byte)(by - 32);
            }
            if (by2 != by) {
                return by - by2;
            }
            ++n2;
        }
        return 0;
    }

    public boolean startsWith(ByteArray byteArray) {
        return this.startsWith(byteArray, 0);
    }

    public boolean startsWith(ByteArray byteArray, int n) {
        if (n < 0 || n > this.count - byteArray.count) {
            return false;
        }
        byte[] byArray = this.buff;
        byte[] byArray2 = byteArray.buff;
        int n2 = 0;
        while (n2 < byteArray.count) {
            if (byArray[n] != byArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean endsWith(ByteArray byteArray) {
        return this.startsWith(byteArray, this.count - byteArray.count);
    }

    public boolean startsWith(byte by) {
        if (this.count == 0) {
            return false;
        }
        return this.buff[0] == by;
    }

    public boolean endsWith(byte by) {
        if (this.count == 0) {
            return false;
        }
        return this.buff[this.count - 1] == by;
    }

    public int indexOf(ByteArray byteArray, int n) {
        if (n >= this.count) {
            if (this.count == 0 && n == 0 && byteArray.count == 0) {
                return 0;
            }
            return -1;
        }
        if (byteArray.count == 0) {
            return n;
        }
        if (n < 0) {
            n = 0;
        }
        byte[] byArray = this.buff;
        byte[] byArray2 = byteArray.buff;
        int n2 = n;
        while (byteArray.count <= this.count - n2) {
            if (byArray[n2] != byArray2[0]) {
                ++n2;
                continue;
            }
            n = n2;
            int n3 = 1;
            n2 = n + 1;
            while (n3 < byteArray.count) {
                if (byArray[n2] != byArray2[n3]) break;
                ++n2;
                ++n3;
            }
            if (n3 == byteArray.count) {
                return n;
            }
            n2 = n + 1;
        }
        return -1;
    }

    public void copyTo(byte[] byArray, int n) {
        if (this.count > 0) {
            System.arraycopy(this.buff, 0, byArray, n, this.count);
        }
    }

    public String toString() {
        if (this.count > 0 && (this.stringValue == null || this.stringValue.length() != this.count)) {
            this.stringValue = new String(this.buff, 0, this.count);
        }
        return this.stringValue;
    }

    public Object clone() {
        try {
            ByteArray byteArray = (ByteArray)super.clone();
            byteArray.buff = new byte[this.buff.length];
            System.arraycopy(this.buff, 0, byteArray.buff, 0, this.count);
            return byteArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

