/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpEntity;
import inria.net.lrmp.LrmpPacket;
import inria.net.lrmp.LrmpPacketCache;
import inria.util.NTP;
import java.net.InetAddress;

public final class LrmpSender
extends LrmpEntity {
    protected long startseq;
    protected long maxseq;
    protected long expected;
    protected long lastseq;
    protected long lastError;
    protected LrmpPacketCache cache = null;
    protected int cacheSize = 128;
    protected boolean lost = false;
    protected long lastTimeForData;
    protected int srPackets;
    protected int srBytes;
    protected long srSeqno;
    protected int srTimestamp;
    protected long nextSRTime;
    protected int rrProb = 6553;
    protected int rrInterval = 10;
    protected int rrTimestamp;
    protected long rrSelectTime;
    protected int rrReplies;
    protected long nextRRTime;
    protected int rrAbsLost;
    protected long rrMaxSeqno;
    protected int packets;
    protected int bytes;
    protected int duplicates;
    protected int repairs;
    protected int drops;
    protected int rate;
    protected int interval;
    protected int transit;
    protected int jitter;

    protected LrmpSender(int n, InetAddress inetAddress, long l) {
        super(n, inetAddress);
        this.reset(l);
    }

    protected void reset(long l) {
        super.reset();
        this.lastError = 0L;
        this.packets = 0;
        this.bytes = 0;
        this.rate = 0;
        this.interval = 64;
        this.transit = 0;
        this.jitter = 0;
        this.lastTimeForData = 0L;
        this.srTimestamp = 0;
        this.nextSRTime = 0L;
        this.nextRRTime = 0L;
        this.duplicates = 0;
        this.repairs = 0;
        this.drops = 0;
        this.clearCache(l);
    }

    protected void initCache(int n) {
        this.cache = new LrmpPacketCache(n);
        this.cacheSize = this.cache.getMaxSize();
    }

    public int getPacketCount() {
        return this.packets;
    }

    public int getDuplicateCount() {
        return this.duplicates;
    }

    public int getRepairCount() {
        return this.repairs;
    }

    public int getBadPacketCount() {
        return this.drops;
    }

    public int getByteCount() {
        return this.bytes;
    }

    public int getDataRate() {
        return this.rate;
    }

    public long getTimeSentData() {
        return this.lastTimeForData;
    }

    public int getJitter() {
        return this.jitter;
    }

    public boolean isLost() {
        return this.lost;
    }

    protected void clearCache(long l) {
        this.startseq = l;
        this.maxseq = l - 1L;
        this.expected = l;
        this.lastseq = this.maxseq;
        this.rrAbsLost = 0;
        this.rrMaxSeqno = this.maxseq;
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public long highestSeqnoGot() {
        return this.maxseq;
    }

    public long expected() {
        return this.expected;
    }

    protected void highestSeqnoGot(long l) {
        this.maxseq = l;
    }

    protected void incPackets() {
        ++this.packets;
    }

    protected void incDuplicate() {
        ++this.duplicates;
    }

    protected void incRepairs() {
        ++this.repairs;
    }

    protected void incDrops() {
        ++this.drops;
    }

    protected void incBytes(int n) {
        this.bytes += n;
    }

    protected void incExpected() {
        ++this.expected;
        this.expected %= 0x100000000L;
    }

    protected void setRate(int n) {
        this.rate = n;
    }

    protected void setInterval(int n) {
        if (n < 1000) {
            this.interval = 3 * this.interval + n >> 2;
        }
    }

    protected void appendPacket(LrmpPacket lrmpPacket) {
        this.cache.addPacket(lrmpPacket);
    }

    protected void putPacket(LrmpPacket lrmpPacket) {
        this.cache.addPacket(lrmpPacket);
    }

    protected void removePacket(LrmpPacket lrmpPacket) {
        this.cache.removePacket(lrmpPacket);
    }

    protected LrmpPacket getPacket(long l) {
        return this.cache.getPacket(l);
    }

    protected boolean isCached(long l) {
        return this.cache.containPacket(l);
    }

    protected void updateJitter(int n) {
        int n2 = NTP.ntp32(this.lastTimeForData - (long)n);
        n2 = NTP.fixedPoint32ToMillis(n2);
        int n3 = this.transit != 0 ? n2 - this.transit : 0;
        this.transit = n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        this.jitter += n3 - (this.jitter + 8 >> 4);
    }
}

