/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpContext;
import inria.net.lrmp.LrmpDomain;
import inria.net.lrmp.LrmpEntity;
import inria.net.lrmp.LrmpImpl;
import inria.net.lrmp.LrmpLossEvent;
import inria.net.lrmp.LrmpLossTable;
import inria.net.lrmp.LrmpPacket;
import inria.net.lrmp.LrmpSender;
import inria.util.EventHandler;
import inria.util.Logger;
import inria.util.NTP;
import java.util.Random;
import java.util.Vector;

final class LrmpRecovery
implements EventHandler {
    protected static final int MaxTries = 8;
    protected LrmpDomain domain;
    protected LrmpContext cxt;
    protected LrmpPacket dummy = null;
    protected Object event = null;
    protected Random rand;

    public LrmpRecovery(int n, LrmpContext lrmpContext) {
        this.cxt = lrmpContext;
        this.domain = new LrmpDomain(n);
        this.domain.lossTab = new LrmpLossTable(4);
        this.domain.lossHistory = new Vector();
        if (n > 63) {
            this.domain.child = new LrmpDomain(63);
            this.domain.child.lossTab = this.domain.lossTab;
            this.domain.child.lossHistory = this.domain.lossHistory;
            this.domain.setChild(this.domain.child);
            this.domain = this.domain.child;
        }
        if (n > 47) {
            this.domain.child = new LrmpDomain(47);
            this.domain.child.lossTab = this.domain.lossTab;
            this.domain.child.lossHistory = this.domain.lossHistory;
            this.domain.setChild(this.domain.child);
            this.domain = this.domain.child;
        }
        if (n > 15) {
            this.domain.child = new LrmpDomain(15);
            this.domain.child.lossTab = this.domain.lossTab;
            this.domain.child.lossHistory = this.domain.lossHistory;
            this.domain.setChild(this.domain.child);
            this.domain = this.domain.child;
        }
        this.rand = new Random();
    }

    public void stop() {
        if (this.event != null) {
            LrmpContext.timer.recallTimer(this.event);
            this.event = null;
            this.domain.lossTab.clear();
        }
    }

    public void handleLoss(LrmpSender lrmpSender) {
        if (this.cxt.profile != null && this.cxt.profile.lossAllowed()) {
            return;
        }
        int n = LrmpImpl.diff32(lrmpSender.highestSeqnoGot(), lrmpSender.expected());
        if (n > lrmpSender.cacheSize) {
            this.cxt.lrmp.handleSyncError(lrmpSender, 1);
            return;
        }
        LrmpLossEvent lrmpLossEvent = this.lookup(lrmpSender, this.cxt.whoami);
        if (lrmpLossEvent == null) {
            LrmpDomain lrmpDomain = this.getDomain();
            lrmpLossEvent = new LrmpLossEvent(lrmpSender);
            lrmpLossEvent.reporter = this.cxt.whoami;
            lrmpLossEvent.scope = lrmpDomain.scope;
            lrmpLossEvent.domain = lrmpDomain;
            lrmpLossEvent.computeBitmask();
            lrmpDomain.lossTab.add(lrmpLossEvent);
            if (Logger.debug) {
                Logger.debug(this, "new loss " + lrmpLossEvent);
            }
            this.nackTimer(lrmpLossEvent);
            this.startTimer();
        } else {
            if (lrmpLossEvent.nackCount > 0) {
                --lrmpLossEvent.nackCount;
            }
            lrmpLossEvent.nextAction = 0;
        }
    }

    public void goUp(LrmpLossEvent lrmpLossEvent) {
        if (lrmpLossEvent.domain.parent != null && lrmpLossEvent.scope < lrmpLossEvent.source.distance) {
            lrmpLossEvent.scope = lrmpLossEvent.domain.parent.scope;
            lrmpLossEvent.domain = lrmpLossEvent.domain.parent;
            lrmpLossEvent.nackCount = 0;
        } else {
            ++lrmpLossEvent.nackCount;
        }
        this.nackTimer(lrmpLossEvent);
    }

    public void goDown(LrmpLossEvent lrmpLossEvent) {
        if (lrmpLossEvent.domain.child != null && lrmpLossEvent.domain.child.isEnabled()) {
            lrmpLossEvent.scope = lrmpLossEvent.domain.child.scope;
            lrmpLossEvent.domain = lrmpLossEvent.domain.child;
            lrmpLossEvent.nackCount = 1;
        } else {
            ++lrmpLossEvent.nackCount;
        }
        this.nackTimer(lrmpLossEvent);
    }

    protected LrmpLossEvent lookup(LrmpSender lrmpSender, LrmpEntity lrmpEntity) {
        LrmpLossEvent[] lrmpLossEventArray = this.domain.lossTab.tab;
        int n = lrmpLossEventArray.length - 1;
        while (n >= 0) {
            if (lrmpLossEventArray[n] != null && lrmpLossEventArray[n].source == lrmpSender && lrmpLossEventArray[n].reporter == lrmpEntity) {
                return lrmpLossEventArray[n];
            }
            --n;
        }
        return null;
    }

    private void nackTimer(LrmpLossEvent lrmpLossEvent) {
        int n = lrmpLossEvent.domain.stats.mrtt << lrmpLossEvent.nackCount >> 3;
        if (lrmpLossEvent.nackCount > 0 || lrmpLossEvent.domain.child != null && lrmpLossEvent.domain.child.isEnabled()) {
            if (n < lrmpLossEvent.domain.initialMRTT) {
                n = lrmpLossEvent.domain.initialMRTT;
            }
            n = (int)((double)n * (1.0 + this.rand.nextDouble()));
            n = lrmpLossEvent.source.interval < 200 ? (n += lrmpLossEvent.source.interval) : (n += 200);
        } else {
            n = (int)((double)n * (1.0 + this.rand.nextDouble()));
        }
        if (Logger.debug) {
            Logger.debug(this, "NACK timer=" + n + " #" + lrmpLossEvent.nackCount + " " + lrmpLossEvent.domain.stats.getRTT() + "/" + lrmpLossEvent.source.interval + "@" + lrmpLossEvent.scope);
        }
        lrmpLossEvent.timeoutTime = System.currentTimeMillis() + (long)n;
    }

    private void resendTimer(LrmpLossEvent lrmpLossEvent) {
        int n = lrmpLossEvent.domain.stats.mrtt >> 3;
        n = (int)((double)n * (1.0 + this.rand.nextDouble()));
        n = lrmpLossEvent.source.interval < 200 ? (n += lrmpLossEvent.source.interval) : (n += 200);
        if (Logger.debug) {
            Logger.debug(this, "resendTimer=" + n + " " + lrmpLossEvent.domain.stats.mrtt + "/" + lrmpLossEvent.source.interval);
        }
        lrmpLossEvent.timeoutTime = System.currentTimeMillis() + (long)n;
    }

    private synchronized void startTimer() {
        long l = Long.MAX_VALUE;
        LrmpLossEvent[] lrmpLossEventArray = this.domain.lossTab.tab;
        int n = lrmpLossEventArray.length - 1;
        while (n >= 0) {
            if (lrmpLossEventArray[n] != null) {
                LrmpLossEvent lrmpLossEvent = lrmpLossEventArray[n];
                if (lrmpLossEvent.timeoutTime < l) {
                    l = lrmpLossEvent.timeoutTime;
                }
            }
            --n;
        }
        if (l < Long.MAX_VALUE) {
            int n2;
            if (this.event != null) {
                LrmpContext.timer.recallTimer(this.event);
            }
            if ((n2 = (int)(l - System.currentTimeMillis())) < 0) {
                n2 = 1;
            }
            this.event = LrmpContext.timer.registerTimer(n2, this, null);
            if (Logger.debug) {
                Logger.debug(this, "Next timeout=" + n2 + " events: " + this.domain.lossTab.size());
            }
        }
    }

    public void handleTimerEvent(Object object, long l) {
        this.event = null;
        if (Logger.debug) {
            Logger.debug(this, "handle timeout: " + this.domain.lossTab.size());
        }
        LrmpLossEvent[] lrmpLossEventArray = this.domain.lossTab.tab;
        int n = lrmpLossEventArray.length - 1;
        while (n >= 0) {
            if (lrmpLossEventArray[n] != null) {
                LrmpLossEvent lrmpLossEvent = lrmpLossEventArray[n];
                if (lrmpLossEvent.timeoutTime <= l) {
                    if (lrmpLossEvent.reporter != this.cxt.whoami) {
                        this.domain.lossTab.remove(lrmpLossEvent);
                        this.resend(lrmpLossEvent);
                    } else {
                        LrmpSender lrmpSender = lrmpLossEvent.source;
                        lrmpLossEvent.computeBitmask();
                        if (lrmpLossEvent.low < 0L) {
                            if (Logger.debug) {
                                Logger.debug(this, "Bravo!");
                            }
                            this.domain.lossTab.remove(lrmpLossEvent);
                        } else if (lrmpSender.lost) {
                            this.cxt.lrmp.handleSyncError(lrmpLossEvent.source, 4);
                            this.domain.lossTab.remove(lrmpLossEvent);
                        } else if (lrmpLossEvent.nackCount >= 8) {
                            this.cxt.lrmp.handleSyncError(lrmpLossEvent.source, 2);
                            this.domain.lossTab.remove(lrmpLossEvent);
                        } else {
                            switch (lrmpLossEvent.nextAction) {
                                case 1: {
                                    ++lrmpLossEvent.nackCount;
                                    this.nackTimer(lrmpLossEvent);
                                    lrmpLossEvent.nextAction = 0;
                                    break;
                                }
                                case 3: {
                                    this.goDown(lrmpLossEvent);
                                    lrmpLossEvent.nextAction = 0;
                                    break;
                                }
                                case 0: {
                                    if (this.dummy == null) {
                                        this.dummy = new LrmpPacket(false, 64);
                                        this.dummy.sender = this.cxt.whoami;
                                    }
                                    this.dummy.scope = lrmpLossEvent.scope;
                                    this.dummy.offset = 0;
                                    this.dummy.appendNack(lrmpLossEvent);
                                    if (Logger.debug) {
                                        Logger.debug(this, "send NACK " + lrmpLossEvent);
                                    }
                                    this.cxt.lrmp.sendControlPacket(this.dummy, lrmpLossEvent.scope);
                                    ++lrmpLossEvent.domain.stats.nack;
                                    ++lrmpLossEvent.domain.failedNack;
                                    lrmpLossEvent.rcvSendTime = l;
                                    this.cxt.whoami.incNack();
                                    this.goUp(lrmpLossEvent);
                                    break;
                                }
                                case 2: {
                                    this.goUp(lrmpLossEvent);
                                    lrmpLossEvent.nextAction = 0;
                                }
                            }
                        }
                    }
                }
            }
            --n;
        }
        this.startTimer();
    }

    protected LrmpDomain getDomain() {
        LrmpDomain lrmpDomain = this.domain;
        while (lrmpDomain != null) {
            lrmpDomain.checkState();
            if (lrmpDomain.stats.enabled) {
                return lrmpDomain;
            }
            lrmpDomain = lrmpDomain.parent;
        }
        return null;
    }

    public LrmpDomain lookupDomain(int n) {
        LrmpDomain lrmpDomain = this.domain;
        while (lrmpDomain != null) {
            if (lrmpDomain.parent == null || n <= lrmpDomain.scope) {
                return lrmpDomain;
            }
            lrmpDomain = lrmpDomain.parent;
        }
        return null;
    }

    public void heardRepair(LrmpPacket lrmpPacket, boolean bl) {
        LrmpDomain lrmpDomain = this.lookupDomain(lrmpPacket.scope);
        ++lrmpDomain.stats.repairPackets;
        lrmpDomain.stats.repairBytes += lrmpPacket.datalen;
        if (lrmpPacket.sender != lrmpPacket.source) {
            ++lrmpDomain.stats.thirdPartyRepairs;
        }
        LrmpSender lrmpSender = (LrmpSender)lrmpPacket.source;
        if (bl) {
            LrmpPacket lrmpPacket2;
            ++lrmpDomain.stats.dupPackets;
            lrmpDomain.stats.dupBytes += lrmpPacket.datalen;
            if (lrmpPacket.sender != lrmpPacket.source) {
                ++lrmpDomain.stats.thirdPartyDuplicates;
            }
            if (Logger.debug) {
                if (lrmpPacket.sender == lrmpSender) {
                    Logger.debug(this, "duplicate #" + lrmpPacket.seqno + " from source");
                } else {
                    Logger.debug(this, "duplicate #" + lrmpPacket.seqno + " from third party");
                }
            }
            this.cxt.sender.cancelResend(lrmpSender, lrmpPacket.seqno, lrmpPacket.scope);
            if (lrmpSender != this.cxt.whoami && (lrmpPacket2 = lrmpSender.getPacket(lrmpPacket.seqno)) != null) {
                long l = (long)lrmpPacket.sender.getID() & 0xFFFFFFFFL;
                long l2 = (long)this.cxt.whoami.getID() & 0xFFFFFFFFL;
                if (l2 > l || lrmpPacket.sender == lrmpSender) {
                    this.cxt.sender.cancelResend(lrmpSender, lrmpPacket2.retransmitID, lrmpPacket.scope);
                }
            }
        } else {
            LrmpLossEvent lrmpLossEvent = this.lookup(lrmpSender, this.cxt.whoami);
            if (lrmpLossEvent != null) {
                if (lrmpLossEvent.high <= lrmpLossEvent.source.expected) {
                    this.domain.lossTab.remove(lrmpLossEvent);
                } else {
                    lrmpLossEvent.nextAction = lrmpPacket.seqno - lrmpLossEvent.low < 33L ? 3 : 1;
                }
            }
            if (!lrmpDomain.stats.enabled) {
                lrmpDomain.enable();
            } else {
                lrmpDomain.failedNack = 0;
            }
        }
    }

    public void processNackReply(LrmpEntity lrmpEntity, LrmpLossEvent lrmpLossEvent, int n) {
        LrmpLossEvent lrmpLossEvent2;
        LrmpDomain lrmpDomain = this.lookupDomain(lrmpLossEvent.scope);
        ++lrmpDomain.stats.nackReply;
        if (this.cxt.whoami == lrmpLossEvent.source) {
            return;
        }
        if (Logger.debug) {
            Logger.debug(this, "got R_NACK " + lrmpLossEvent);
        }
        if ((lrmpLossEvent2 = this.lookup(lrmpLossEvent.source, this.cxt.whoami)) != null && lrmpLossEvent2.low >= lrmpLossEvent.low) {
            lrmpLossEvent2.nextAction = 1;
        }
        if (lrmpLossEvent.reporter == this.cxt.whoami) {
            int n2 = NTP.ntp32(System.currentTimeMillis()) - lrmpLossEvent.timestamp - n;
            lrmpEntity.rtt = n2 = NTP.fixedPoint32ToMillis(n2);
            lrmpDomain.updateMRTT(n2);
            return;
        }
        lrmpLossEvent2 = this.lookup(lrmpLossEvent.source, lrmpLossEvent.reporter);
        if (lrmpLossEvent2 != null) {
            lrmpLossEvent2.remove(lrmpLossEvent);
            if (lrmpLossEvent2.low < 0L) {
                lrmpDomain.lossTab.remove(lrmpLossEvent2);
                if (Logger.debug) {
                    Logger.debug(this, "great! cancel resend: " + lrmpLossEvent2);
                }
            }
            return;
        }
        long l = (long)lrmpEntity.getID() & 0xFFFFFFFFL;
        long l2 = (long)this.cxt.whoami.getID() & 0xFFFFFFFFL;
        if (l2 > l || lrmpEntity == lrmpLossEvent.source) {
            this.cxt.sender.cancelResend(lrmpLossEvent.source, lrmpLossEvent.low, lrmpLossEvent.scope);
            int n3 = 0;
            while (n3 < 32) {
                if ((lrmpLossEvent.bitmask >> n3 & 1) > 0) {
                    long l3 = lrmpLossEvent.low + (long)n3 + 1L;
                    this.cxt.sender.cancelResend(lrmpLossEvent.source, l3, lrmpLossEvent.scope);
                }
                ++n3;
            }
        }
    }

    public void processNack(LrmpLossEvent lrmpLossEvent) {
        long l;
        LrmpDomain lrmpDomain;
        lrmpLossEvent.domain = lrmpDomain = this.lookupDomain(lrmpLossEvent.scope);
        ++lrmpDomain.stats.nack;
        LrmpLossEvent lrmpLossEvent2 = this.lookup(lrmpLossEvent.source, this.cxt.whoami);
        if (lrmpLossEvent2 != null) {
            if (lrmpLossEvent.contains(lrmpLossEvent2) && lrmpLossEvent2.nextAction == 0) {
                this.goUp(lrmpLossEvent2);
                l = (long)lrmpLossEvent.reporter.getID() & 0xFFFFFFFFL;
                long l2 = (long)this.cxt.whoami.getID() & 0xFFFFFFFFL;
                if (l2 > l) {
                    lrmpLossEvent2.nextAction = 1;
                }
            }
            if (lrmpLossEvent2.contains(lrmpLossEvent)) {
                int n = lrmpDomain.stats.mrtt >> 2;
                n = lrmpLossEvent.source.interval < 200 ? (n += lrmpLossEvent.source.interval) : (n += 200);
                if (lrmpLossEvent.rcvSendTime - lrmpLossEvent2.rcvSendTime <= (long)n) {
                    ++lrmpDomain.stats.dupNack;
                    if (Logger.debug) {
                        Logger.debug(this, "Dup nack: " + n + "/" + lrmpDomain.stats.mrtt);
                    }
                }
                return;
            }
        }
        if (lrmpDomain.isDuplicate(lrmpLossEvent)) {
            ++lrmpDomain.stats.dupNack;
            return;
        }
        if (this.cxt.whoami == lrmpLossEvent.source) {
            this.resend(lrmpLossEvent);
        } else if (lrmpDomain.parent != null && this.cxt.profile.sendRepair) {
            lrmpLossEvent = (LrmpLossEvent)lrmpLossEvent.clone();
            l = 0L;
            int n = 0;
            if (lrmpLossEvent.source.isCached(lrmpLossEvent.low)) {
                l = lrmpLossEvent.low;
            }
            int n2 = 0;
            while (n2 < 32) {
                long l3;
                if ((lrmpLossEvent.bitmask >> n2 & 1) > 0 && lrmpLossEvent.source.isCached(l3 = lrmpLossEvent.low + (long)n2 + 1L)) {
                    if (l == 0L) {
                        l = l3;
                    } else {
                        n |= 1 << (int)(l3 - l - 1L);
                    }
                }
                ++n2;
            }
            if (l > 0L) {
                lrmpLossEvent.low = l;
                lrmpLossEvent.bitmask = n;
                lrmpDomain.lossTab.add(lrmpLossEvent);
                this.resendTimer(lrmpLossEvent);
                this.startTimer();
            }
        }
    }

    private void resend(LrmpLossEvent lrmpLossEvent) {
        long l = 0L;
        int n = 0;
        if (this.resend(lrmpLossEvent.low, lrmpLossEvent)) {
            l = lrmpLossEvent.low;
        }
        int n2 = 0;
        while (n2 < 32) {
            long l2;
            if ((lrmpLossEvent.bitmask >> n2 & 1) > 0 && this.resend(l2 = lrmpLossEvent.low + (long)n2 + 1L, lrmpLossEvent)) {
                if (l == 0L) {
                    l = l2;
                } else {
                    n |= 1 << (int)(l2 - l - 1L);
                }
            }
            ++n2;
        }
        if (Logger.debug) {
            Logger.debug(this, "send R_NACK " + lrmpLossEvent.reporter);
        }
        if (l > 0L) {
            LrmpPacket lrmpPacket = new LrmpPacket(false, 64);
            lrmpPacket.scope = lrmpLossEvent.scope;
            lrmpPacket.offset = 0;
            lrmpPacket.appendNackReply(lrmpLossEvent, this.cxt.whoami, (int)l, n);
            this.cxt.lrmp.sendControlPacket(lrmpPacket, lrmpLossEvent.scope);
            ++lrmpLossEvent.domain.stats.nackReply;
        }
    }

    private boolean resend(long l, LrmpLossEvent lrmpLossEvent) {
        LrmpPacket lrmpPacket = lrmpLossEvent.source.getPacket(l);
        if (lrmpPacket == null) {
            if (Logger.debug) {
                Logger.debug(this, "unable resend #" + l);
            }
            return false;
        }
        lrmpPacket.retransmitID = (int)lrmpLossEvent.low;
        this.cxt.sender.enqueueResend(lrmpPacket, lrmpLossEvent.scope);
        return true;
    }
}

