/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpPacket;
import inria.net.lrmp.LrmpSender;
import inria.util.Logger;

final class LrmpPacketQueue {
    static int defalutIncrements = 8;
    int increments;
    LrmpPacket[] table;
    int count;

    public LrmpPacketQueue() {
        this(34, defalutIncrements);
    }

    public LrmpPacketQueue(int n, int n2) {
        this.increments = n2 <= 0 ? 2 : n2;
        if (n <= 0) {
            n = this.increments;
        }
        this.table = new LrmpPacket[n];
        this.clear();
    }

    public void clear() {
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = null;
            ++n;
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public void enqueue(LrmpPacket lrmpPacket) {
        ++this.count;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.table[n2] == null) {
                this.table[n2] = lrmpPacket;
                return;
            }
            ++n2;
        }
        this.table = this.expand(this.table);
        this.table[n] = lrmpPacket;
    }

    public boolean contains(long l) {
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != null && this.table[n].seqno == l) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean contains(LrmpPacket lrmpPacket) {
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != null && this.table[n] == lrmpPacket) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public LrmpPacket dequeue() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.table.length) {
            if (this.table[n2] != null && (n < 0 || this.table[n2].seqno < this.table[n].seqno)) {
                n = n2;
            }
            ++n2;
        }
        if (n >= 0) {
            LrmpPacket lrmpPacket = this.table[n];
            this.table[n] = null;
            --this.count;
            return lrmpPacket;
        }
        return null;
    }

    public void remove(LrmpPacket lrmpPacket) {
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != null && lrmpPacket == this.table[n]) {
                this.table[n] = null;
                --this.count;
                return;
            }
            ++n;
        }
    }

    public void remove(LrmpSender lrmpSender, long l, int n) {
        int n2 = 0;
        while (n2 < this.table.length) {
            if (this.table[n2] != null && lrmpSender == this.table[n2].source && l == this.table[n2].seqno && n >= this.table[n2].scope) {
                this.table[n2] = null;
                --this.count;
                if (Logger.debug) {
                    Logger.debug(this, "cancel resend " + l + " " + this.count);
                }
                return;
            }
            ++n2;
        }
    }

    public void cancel(LrmpSender lrmpSender, int n, int n2) {
        int n3 = 0;
        while (n3 < this.table.length) {
            if (this.table[n3] != null && lrmpSender == this.table[n3].source && n == this.table[n3].retransmitID && n2 >= this.table[n3].scope) {
                if (Logger.debug) {
                    Logger.debug(this, "cancel resend " + this.table[n3].seqno + " " + this.count);
                }
                this.table[n3] = null;
                --this.count;
            }
            ++n3;
        }
    }

    protected LrmpPacket[] expand(LrmpPacket[] lrmpPacketArray) {
        LrmpPacket[] lrmpPacketArray2 = new LrmpPacket[lrmpPacketArray.length + this.increments];
        int n = 0;
        while (n < lrmpPacketArray.length) {
            lrmpPacketArray2[n] = lrmpPacketArray[n];
            ++n;
        }
        return lrmpPacketArray2;
    }
}

