/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpPacket;

final class LrmpPacketCache {
    LrmpPacket[] buffer;
    int mask = 1;

    public LrmpPacketCache(int n) {
        while (this.mask < n) {
            this.mask <<= 1;
        }
        this.buffer = new LrmpPacket[this.mask];
        this.clear();
        --this.mask;
    }

    public int getMaxSize() {
        return this.mask + 1;
    }

    public void addPacket(LrmpPacket lrmpPacket) {
        int n = (int)(lrmpPacket.seqno & (long)this.mask);
        this.buffer[n] = lrmpPacket;
    }

    public boolean containPacket(long l) {
        int n = (int)(l & (long)this.mask);
        if (this.buffer[n] != null) {
            return this.buffer[n].seqno == l;
        }
        return false;
    }

    public LrmpPacket getPacket(long l) {
        int n = (int)(l & (long)this.mask);
        if (this.buffer[n] != null && this.buffer[n].seqno == l) {
            return this.buffer[n];
        }
        return null;
    }

    public void removePacket(LrmpPacket lrmpPacket) {
        int n = (int)(lrmpPacket.seqno & (long)this.mask);
        if (this.buffer[n] != null && this.buffer[n].seqno == lrmpPacket.seqno) {
            this.buffer[n] = null;
        }
    }

    public void removePacket(long l) {
        int n = (int)(l & (long)this.mask);
        if (this.buffer[n] != null && this.buffer[n].seqno == l) {
            this.buffer[n] = null;
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = null;
            ++n;
        }
    }
}

