/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpEntity;
import inria.net.lrmp.LrmpLossEvent;
import inria.net.lrmp.LrmpSender;
import inria.util.Logger;
import inria.util.NTP;
import inria.util.Utilities;
import java.net.InetAddress;

public final class LrmpPacket
implements Cloneable {
    protected static final int padBit = 32;
    protected static final int strtBit = 2;
    protected static final int endBit = 1;
    public static final int MTU = 1400;
    protected LrmpEntity source;
    protected LrmpEntity sender;
    protected byte[] buff;
    protected int offset;
    protected int datalen;
    protected int maxDataLen;
    protected boolean reliable;
    protected boolean first = false;
    protected boolean end = false;
    protected long seqno;
    protected int scope;
    protected long rcvSendTime;
    protected boolean retransmit = false;
    protected int retransmitID = 0;
    static boolean backward = true;

    public LrmpPacket() {
        this(true);
    }

    public LrmpPacket(boolean bl) {
        this(bl, 1400);
    }

    public LrmpPacket(int n) {
        this(true, n);
    }

    public LrmpPacket(boolean bl, int n) {
        this.reliable = bl;
        this.offset = bl ? 16 : 8;
        int n2 = this.offset + n;
        n2 = n2 + 3 & 0xFFFC;
        if (n2 > 1400) {
            n2 = 1400;
        }
        this.buff = new byte[n2];
        this.maxDataLen = n2 - this.offset;
        this.datalen = 0;
    }

    protected LrmpPacket(boolean bl, byte[] byArray, int n, int n2) {
        this.buff = byArray;
        this.reliable = bl;
        if (bl) {
            this.datalen = n2 - 16;
            this.offset = n + 16;
        } else {
            this.datalen = n2 - 8;
            this.offset = n + 8;
        }
        if ((byArray[n] & 0x20) > 0) {
            this.datalen -= byArray[n + n2 - 1] & 0xFF;
        }
        if (backward) {
            if ((byArray[n] & 2) > 0) {
                this.first = true;
            }
            if ((byArray[n] & 1) > 0) {
                this.end = true;
            }
        }
        this.scope = byArray[n + 1] & 0xFF;
        this.rcvSendTime = System.currentTimeMillis();
    }

    public void setDataLength(int n) {
        this.datalen = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getMaxDataLength() {
        return this.maxDataLen;
    }

    public int getDataLength() {
        return this.datalen;
    }

    public byte[] getDataBuffer() {
        return this.buff;
    }

    public InetAddress getAddress() {
        return this.source.getAddress();
    }

    public LrmpEntity getSource() {
        return this.source;
    }

    public int getSourceID() {
        return this.source.getID();
    }

    public boolean isReliable() {
        return this.reliable;
    }

    public void setFirst(boolean bl) {
        this.first = bl;
    }

    public void setLast(boolean bl) {
        this.end = bl;
    }

    public boolean isFirstOfBlock() {
        return this.first;
    }

    public boolean isLastOfBlock() {
        return this.end;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.end;
    }

    protected void setReliable(boolean bl) {
        this.reliable = bl;
    }

    protected void setSource(LrmpEntity lrmpEntity) {
        this.source = lrmpEntity;
    }

    protected int formatDataPacket(boolean bl) {
        this.retransmit = bl;
        int n = this.reliable ? 16 : 8;
        int n2 = this.datalen + n + 3 & 0xFFFC;
        int n3 = this.offset - n;
        this.buff[n3 + 1] = (byte)this.scope;
        if (bl) {
            int n4 = n3;
            this.buff[n4] = (byte)(this.buff[n4] | 4);
            Utilities.intToByte(this.sender.getID(), this.buff, n3 + 4);
            Utilities.intToByte(this.source.getID(), this.buff, n3 + 8);
        } else {
            int n5;
            this.buff[n3] = 64;
            if (this.first) {
                int n6 = n3;
                this.buff[n6] = (byte)(this.buff[n6] | 2);
            }
            if (this.end) {
                int n7 = n3;
                this.buff[n7] = (byte)(this.buff[n7] | 1);
            }
            this.buff[n3 + 2] = (byte)(n2 >> 8 & 0xFF);
            this.buff[n3 + 3] = (byte)(n2 & 0xFF);
            Utilities.intToByte(this.source.getID(), this.buff, n3 + 4);
            if (this.reliable) {
                n5 = backward ? this.source.getID() : NTP.ntp32(System.currentTimeMillis());
                Utilities.intToByte(n5, this.buff, n3 + 8);
                Utilities.intToByte((int)this.seqno, this.buff, n3 + 12);
            } else {
                int n8 = n3;
                this.buff[n8] = (byte)(this.buff[n8] | 8);
            }
            n5 = n2 - (this.datalen + n);
            if (n5 > 0) {
                int n9 = n3;
                this.buff[n9] = (byte)(this.buff[n9] | 0x20);
                int n10 = n3 + n2 - 2;
                while (n10 > n3 + n2 - n5) {
                    this.buff[n10] = 0;
                    --n10;
                }
                this.buff[n3 + n2 - 1] = (byte)n5;
            }
        }
        return n2;
    }

    protected void appendNack(LrmpLossEvent[] lrmpLossEventArray) {
        int n = this.offset;
        int n2 = 0;
        while (n2 < lrmpLossEventArray.length) {
            LrmpLossEvent lrmpLossEvent = lrmpLossEventArray[n2];
            if (lrmpLossEvent != null) {
                if (this.offset == n) {
                    this.buff[this.offset] = 81;
                    ++this.offset;
                    this.buff[this.offset] = (byte)this.scope;
                    this.offset += 3;
                    Utilities.intToByte(lrmpLossEvent.reporter.getID(), this.buff, this.offset);
                    this.offset += 4;
                    Utilities.intToByte(NTP.ntp32(System.currentTimeMillis()), this.buff, this.offset);
                    this.offset += 4;
                }
                Utilities.intToByte(lrmpLossEvent.source.getID(), this.buff, this.offset);
                this.offset += 4;
                Utilities.intToByte((int)lrmpLossEvent.low, this.buff, this.offset);
                this.offset += 4;
                Utilities.intToByte(lrmpLossEvent.bitmask, this.buff, this.offset);
                this.offset += 4;
            }
            ++n2;
        }
        int n3 = this.offset - n;
        if (n3 > 0) {
            this.buff[n + 2] = (byte)(n3 >> 8 & 0xFF);
            this.buff[n + 3] = (byte)(n3 & 0xFF);
        }
    }

    protected void appendNack(LrmpLossEvent lrmpLossEvent) {
        int n = this.offset;
        this.buff[this.offset] = 81;
        ++this.offset;
        this.buff[this.offset] = (byte)this.scope;
        this.offset += 3;
        Utilities.intToByte(lrmpLossEvent.reporter.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(NTP.ntp32(System.currentTimeMillis()), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpLossEvent.source.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte((int)lrmpLossEvent.low, this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpLossEvent.bitmask, this.buff, this.offset);
        this.offset += 4;
        int n2 = this.offset - n;
        this.buff[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.buff[n + 3] = (byte)(n2 & 0xFF);
    }

    protected void appendNackReply(LrmpLossEvent lrmpLossEvent, LrmpSender lrmpSender, int n, int n2) {
        int n3 = this.offset;
        this.buff[this.offset] = 82;
        ++this.offset;
        this.buff[this.offset] = (byte)this.scope;
        this.offset += 3;
        Utilities.intToByte(lrmpSender.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpLossEvent.reporter.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpLossEvent.timestamp, this.buff, this.offset);
        this.offset += 4;
        int n4 = (int)(System.currentTimeMillis() - lrmpLossEvent.rcvSendTime);
        n4 = NTP.millisToFixedPoint32(n4);
        Utilities.intToByte(n4, this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpLossEvent.source.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(n, this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(n2, this.buff, this.offset);
        this.offset += 4;
        int n5 = this.offset - n3;
        if (n5 > 0) {
            this.buff[n3 + 2] = (byte)(n5 >> 8 & 0xFF);
            this.buff[n3 + 3] = (byte)(n5 & 0xFF);
        }
    }

    protected void appendSenderReport(LrmpSender lrmpSender) {
        int n = this.offset;
        this.buff[this.offset] = 83;
        ++this.offset;
        this.buff[this.offset] = (byte)this.scope;
        this.offset += 3;
        Utilities.intToByte(lrmpSender.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(NTP.ntp32(System.currentTimeMillis()), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte((int)lrmpSender.expected(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpSender.packets, this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpSender.bytes, this.buff, this.offset);
        this.offset += 4;
        int n2 = this.offset - n;
        this.buff[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.buff[n + 3] = (byte)(n2 & 0xFF);
    }

    protected void appendRRSelection(LrmpSender lrmpSender, int n, int n2) {
        int n3 = this.offset;
        this.buff[this.offset] = 84;
        ++this.offset;
        this.buff[this.offset] = (byte)this.scope;
        this.offset += 3;
        Utilities.intToByte(lrmpSender.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(NTP.ntp32(System.currentTimeMillis()), this.buff, this.offset);
        this.offset += 4;
        this.buff[this.offset] = (byte)(n >> 8 & 0xFF);
        ++this.offset;
        this.buff[this.offset] = (byte)(n & 0xFF);
        ++this.offset;
        this.buff[this.offset] = (byte)(n2 >> 8 & 0xFF);
        ++this.offset;
        this.buff[this.offset] = (byte)(n2 & 0xFF);
        ++this.offset;
        this.buff[this.offset] = -1;
        ++this.offset;
        this.buff[this.offset] = -1;
        ++this.offset;
        this.buff[this.offset] = -1;
        ++this.offset;
        this.buff[this.offset] = -1;
        ++this.offset;
        int n4 = this.offset - n3;
        this.buff[n3 + 2] = (byte)(n4 >> 8 & 0xFF);
        this.buff[n3 + 3] = (byte)(n4 & 0xFF);
    }

    protected void appendReceiverReport(LrmpSender lrmpSender, LrmpSender lrmpSender2) {
        int n;
        int n2 = this.offset;
        this.buff[this.offset] = 85;
        ++this.offset;
        this.buff[this.offset] = (byte)this.scope;
        this.offset += 3;
        Utilities.intToByte(lrmpSender2.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpSender.getID(), this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte(lrmpSender.rrTimestamp, this.buff, this.offset);
        this.offset += 4;
        int n3 = (int)(System.currentTimeMillis() - lrmpSender.rrSelectTime);
        n3 = NTP.millisToFixedPoint32(n3);
        Utilities.intToByte(n3, this.buff, this.offset);
        this.offset += 4;
        Utilities.intToByte((int)lrmpSender.expected(), this.buff, this.offset);
        this.offset += 4;
        int n4 = (int)(lrmpSender.maxseq - lrmpSender.startseq + 1L - (long)(lrmpSender.packets - lrmpSender.duplicates));
        int n5 = n4 - lrmpSender.rrAbsLost;
        lrmpSender.rrAbsLost = n4;
        if (n5 > 0) {
            n = (int)(lrmpSender.maxseq - lrmpSender.rrMaxSeqno);
            lrmpSender.rrMaxSeqno = lrmpSender.maxseq;
            this.buff[this.offset++] = n > n5 ? (int)((n5 << 8) / n) : -1;
        } else {
            this.buff[this.offset++] = 0;
        }
        if (Logger.debug) {
            Logger.debug(this, "send RR lost/rate:" + n4 + "/" + (double)this.buff[this.offset - 1] / 256.0 + " max/init:" + lrmpSender.maxseq + "/" + lrmpSender.startseq + " packs/dup:" + lrmpSender.packets + "/" + lrmpSender.duplicates);
        }
        if (n4 > 0) {
            this.buff[this.offset++] = (byte)(n4 >> 16 & 0xFF);
            this.buff[this.offset++] = (byte)(n4 >> 8 & 0xFF);
            this.buff[this.offset++] = (byte)(n4 & 0xFF);
        } else {
            this.buff[this.offset++] = 0;
            this.buff[this.offset++] = 0;
            this.buff[this.offset++] = 0;
        }
        n = this.offset - n2;
        this.buff[n2 + 2] = (byte)(n >> 8 & 0xFF);
        this.buff[n2 + 3] = (byte)(n & 0xFF);
    }

    protected boolean equals(LrmpPacket lrmpPacket) {
        return this.source.equals(lrmpPacket.source) && this.seqno == lrmpPacket.seqno;
    }

    public Object clone() {
        try {
            LrmpPacket lrmpPacket = (LrmpPacket)super.clone();
            int n = this.datalen;
            n = this.reliable ? (n += 16) : (n += 8);
            lrmpPacket.buff = new byte[n];
            System.arraycopy(this.buff, 0, lrmpPacket.buff, 0, n);
            return lrmpPacket;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

