/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpDomain;
import inria.net.lrmp.LrmpEntity;
import inria.net.lrmp.LrmpImpl;
import inria.net.lrmp.LrmpSender;

final class LrmpLossEvent
implements Cloneable {
    public LrmpSender source;
    public LrmpEntity reporter;
    public long rcvSendTime = 0L;
    public int scope;
    public int timestamp;
    public long low;
    public int bitmask;
    public long high;
    public int nackCount = 0;
    public long timeoutTime;
    public static final int SendNack = 0;
    public static final int DelayAndStay = 1;
    public static final int DelayAndGoUp = 2;
    public static final int DelayAndGoDown = 3;
    public int nextAction = 0;
    public LrmpDomain domain;

    public LrmpLossEvent(LrmpSender lrmpSender) {
        this.source = lrmpSender;
    }

    public void computeBitmask() {
        this.low = this.source.expected();
        int n = LrmpImpl.diff32(this.source.highestSeqnoGot(), this.low);
        if (n < 0) {
            this.low = -1L;
            return;
        }
        if (n > 32) {
            n = 32;
        }
        this.high = this.low;
        this.bitmask = 0;
        int n2 = 1;
        while (n2 <= n) {
            if (!this.source.isCached(this.low + (long)n2)) {
                this.bitmask |= 1 << n2 - 1;
                this.high = this.low + (long)n2;
            }
            ++n2;
        }
    }

    public boolean equals(LrmpLossEvent lrmpLossEvent) {
        return lrmpLossEvent.source == this.source && lrmpLossEvent.low == this.low && lrmpLossEvent.bitmask == this.bitmask;
    }

    public boolean contains(LrmpLossEvent lrmpLossEvent) {
        int n = LrmpImpl.diff32(lrmpLossEvent.low, this.low);
        if (n == 0) {
            return (lrmpLossEvent.bitmask & ~this.bitmask) == 0;
        }
        if (n > 0 && ((n = this.bitmask >> n - 1) & 1) > 0) {
            return (lrmpLossEvent.bitmask & ~(n >>= 1)) == 0;
        }
        return false;
    }

    public void remove(LrmpLossEvent lrmpLossEvent) {
        int n = LrmpImpl.diff32(lrmpLossEvent.low, this.low);
        if (n == 0) {
            this.bitmask &= ~lrmpLossEvent.bitmask;
            if (this.bitmask == 0) {
                this.low = -1L;
            } else {
                int n2 = 1;
                while (n2 < 32 & (this.bitmask & 1) == 0) {
                    this.bitmask >>= 1;
                    ++n2;
                }
                this.bitmask >>= 1;
                this.low += (long)n2;
            }
        } else if (n > 0) {
            this.bitmask &= ~(1 << n - 1);
            this.bitmask &= ~(lrmpLossEvent.bitmask << n);
        } else {
            n = -n;
            this.bitmask &= ~(lrmpLossEvent.bitmask >> n);
            if ((lrmpLossEvent.bitmask & 1 << n - 1) > 0) {
                if (this.bitmask == 0) {
                    this.low = -1L;
                } else {
                    int n3 = 1;
                    while (n3 < 32 & (this.bitmask & 1) == 0) {
                        this.bitmask >>= 1;
                        ++n3;
                    }
                    this.bitmask >>= 1;
                    this.low += (long)n3;
                }
            }
        }
    }

    public String toString() {
        return this.reporter + "->" + this.source + ":" + this.low + "/" + Integer.toHexString(this.bitmask) + "@" + this.scope;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

