/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.MulticastSession;
import inria.net.lrmp.LrmpContext;
import inria.net.lrmp.LrmpDomain;
import inria.net.lrmp.LrmpDomainStats;
import inria.net.lrmp.LrmpEntity;
import inria.net.lrmp.LrmpEntityManager;
import inria.net.lrmp.LrmpErrorEvent;
import inria.net.lrmp.LrmpException;
import inria.net.lrmp.LrmpFlow;
import inria.net.lrmp.LrmpLossEvent;
import inria.net.lrmp.LrmpPacket;
import inria.net.lrmp.LrmpProfile;
import inria.net.lrmp.LrmpRecovery;
import inria.net.lrmp.LrmpSender;
import inria.net.lrmp.LrmpStats;
import inria.util.EventHandler;
import inria.util.EventManager;
import inria.util.Logger;
import inria.util.NTP;
import inria.util.Utilities;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Random;
import java.util.Vector;

final class LrmpImpl
extends MulticastSession
implements EventHandler {
    public static final int Version = 1;
    public static final long Modulo32 = 0x100000000L;
    public static final int DATA_PT = 0;
    public static final int R_DATA_PT = 4;
    public static final int U_DATA_PT = 8;
    public static final int F_DATA_PT = 12;
    public static final int NACK_PT = 17;
    public static final int R_NACK_PT = 18;
    public static final int SR_PT = 19;
    public static final int RS_PT = 20;
    public static final int RR_PT = 21;
    protected static final int checkInterval = 10000;
    protected LrmpContext cxt;
    private Object event = null;
    private Vector reports;
    int lastDataBytes = 0;
    int lastCtrlBytes = 0;
    long lastUpdateTime = 0L;
    long nextTimeout = 0L;
    int idleTime = 1000;
    Random rand;

    public LrmpImpl(InetAddress inetAddress, int n, int n2, LrmpProfile lrmpProfile) throws LrmpException {
        this(inetAddress, n, lrmpProfile);
        this.setTTL(n2);
    }

    public LrmpImpl(InetAddress inetAddress, int n, LrmpProfile lrmpProfile) throws LrmpException {
        try {
            this.initialize(inetAddress, n);
        }
        catch (IOException iOException) {
            throw new LrmpException(iOException.toString());
        }
        this.cxt = new LrmpContext();
        this.cxt.lrmp = this;
        this.cxt.sm = new LrmpEntityManager();
        this.cxt.whoami = this.cxt.sm.whoami();
        this.cxt.stats = new LrmpStats();
        this.cxt.sender = new LrmpFlow(this.cxt);
        this.reports = new Vector();
        this.MaxPacketSize = 1400;
        this.cxt.setProfile(lrmpProfile);
        this.lastUpdateTime = System.currentTimeMillis();
        this.rand = new Random();
    }

    public void setProfile(LrmpProfile lrmpProfile) throws LrmpException {
        this.cxt.setProfile(lrmpProfile);
    }

    public LrmpSender whoami() {
        return this.cxt.whoami;
    }

    public void startSession() {
        if (LrmpContext.timer == null) {
            LrmpImpl.initTimer();
        }
        if (this.cxt.recover == null) {
            this.initRecover();
        }
        this.start();
        this.startTimer(10000);
    }

    private static synchronized void initTimer() {
        LrmpContext.timer = EventManager.shared();
        if (!LrmpContext.timer.isAlive()) {
            LrmpContext.timer.setDaemon(true);
            LrmpContext.timer.start();
        }
    }

    private void initRecover() {
        if (this.cxt.recover != null) {
            this.cxt.recover.stop();
        }
        this.cxt.recover = new LrmpRecovery(this.ttl, this.cxt);
    }

    public void stopSession() {
        if (this.event != null) {
            LrmpContext.timer.recallTimer(this.event);
            this.event = null;
        }
        this.cxt.recover.stop();
        this.cxt.sender.stop();
        super.stop();
    }

    public void send(LrmpPacket lrmpPacket) {
        if (lrmpPacket.isReliable() && this.cxt.whoami.lastTimeForData == 0L) {
            this.sendSenderReport();
            this.cxt.whoami.initCache(this.cxt.profile.sendWindowSize);
            this.cxt.whoami.lastTimeForData = System.currentTimeMillis();
        }
        this.cxt.sender.enqueue(lrmpPacket);
        if (this.idleTime > 0) {
            this.idleTime = 0;
            this.cxt.whoami.nextSRTime = System.currentTimeMillis() + (long)this.cxt.senderReportInterval;
            this.startTimer(this.cxt.senderReportInterval);
        }
    }

    public void flush() {
        this.cxt.sender.flush();
    }

    protected boolean parse(byte[] byArray, int n, InetAddress inetAddress) {
        if (n < 12) {
            ++this.cxt.stats.badLength;
            if (Logger.debug) {
                Logger.debug(this, "packet too short (" + n + ") " + inetAddress.getHostAddress());
            }
            return true;
        }
        int n2 = (byArray[0] & 0xFF) >> 6;
        if (n2 != 1) {
            ++this.cxt.stats.badVersion;
            if (Logger.debug) {
                Logger.debug(this, "incorrect version (" + n2 + ") " + inetAddress.getHostAddress());
            }
            return true;
        }
        n2 = Utilities.byteToInt(byArray, 4);
        if (this.cxt.whoami.getID() == n2 && this.cxt.whoami.getAddress().equals(inetAddress)) {
            return true;
        }
        LrmpEntity lrmpEntity = this.cxt.sm.lookup(n2, inetAddress);
        if (lrmpEntity == null) {
            Logger.error(this, "rejected packet from " + Integer.toHexString(n2) + "@" + inetAddress.getHostAddress());
            return true;
        }
        n2 = byArray[1] & 0xFF;
        if (lrmpEntity.distance > n2) {
            lrmpEntity.distance = n2;
        }
        int n3 = 0;
        boolean bl = true;
        while (n3 < n) {
            int n4 = (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
            if (n4 < 12 || n4 + n3 > n) {
                ++this.cxt.stats.badLength;
                Logger.error(this, "bad packet length " + n4);
                break;
            }
            n2 = byArray[n3] & 0x1F;
            if (n2 >= 16) {
                ++this.cxt.stats.ctrlPackets;
                this.cxt.stats.ctrlBytes += n4;
                switch (n2) {
                    case 17: {
                        this.processNack(lrmpEntity, byArray, n3, n4);
                        break;
                    }
                    case 18: {
                        this.processNackReply(lrmpEntity, byArray, n3, n4);
                        break;
                    }
                    case 19: {
                        this.processSenderReport(lrmpEntity, byArray, n3, n4);
                        break;
                    }
                    case 20: {
                        this.processRRSelection(lrmpEntity, byArray, n3, n4);
                        break;
                    }
                    case 21: {
                        this.processReceiverReport(lrmpEntity, byArray, n3, n4);
                        break;
                    }
                    default: {
                        Logger.error(this, "bad control pt " + n2);
                        break;
                    }
                }
            } else {
                ++this.cxt.stats.dataPackets;
                this.cxt.stats.dataBytes += n4;
                if (n2 >= 0 && n2 < 4) {
                    this.processData(lrmpEntity, byArray, n3, n4);
                } else if (n2 >= 4 && n2 < 8) {
                    this.processRepairData(lrmpEntity, byArray, n3, n4);
                } else if (n2 >= 8 && n2 < 12) {
                    this.processUnreliableData(lrmpEntity, byArray, n3, n4);
                } else if (n2 == 4) {
                    this.processFecData(lrmpEntity, byArray, n3, n4);
                } else {
                    Logger.error(this, "bad data pt " + n2);
                }
                bl = false;
            }
            n3 += n4;
        }
        lrmpEntity.setLastTimeHeard(System.currentTimeMillis());
        return bl;
    }

    private void processNack(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = Utilities.byteToInt(byArray, n += 8);
        n += 4;
        n2 -= 12;
        while (n2 >= 12) {
            int n5 = Utilities.byteToInt(byArray, n);
            LrmpEntity lrmpEntity2 = this.cxt.sm.get(n5);
            if (lrmpEntity2 != null && lrmpEntity2 instanceof LrmpSender) {
                LrmpLossEvent lrmpLossEvent = new LrmpLossEvent((LrmpSender)lrmpEntity2);
                lrmpLossEvent.rcvSendTime = System.currentTimeMillis();
                lrmpLossEvent.low = this.getSeqno(byArray, n += 4);
                lrmpLossEvent.bitmask = Utilities.byteToInt(byArray, n += 4);
                n += 4;
                lrmpLossEvent.scope = n3;
                lrmpLossEvent.reporter = lrmpEntity;
                lrmpLossEvent.timestamp = n4;
                if (Logger.debug) {
                    Logger.debug(this, "got NACK " + lrmpLossEvent + " @" + lrmpLossEvent.rcvSendTime);
                }
                this.cxt.recover.processNack(lrmpLossEvent);
                if (lrmpEntity2 == this.cxt.whoami) {
                    n5 = (int)(this.cxt.whoami.expected - lrmpLossEvent.low);
                    this.cxt.adjust = n5 > this.cxt.whoami.cacheSize >> 1 ? 2 : (n5 > this.cxt.whoami.cacheSize / 3 ? 4 : (n5 > this.cxt.whoami.cacheSize >> 2 ? 6 : 8));
                }
            }
            n2 -= 12;
        }
        if (n2 > 0) {
            ++this.cxt.stats.badLength;
        } else {
            lrmpEntity.incNack();
        }
    }

    private void processNackReply(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
        int n3 = byArray[n + 1];
        n += 8;
        n2 -= 8;
        while (n2 >= 8) {
            int n4 = Utilities.byteToInt(byArray, n);
            int n5 = Utilities.byteToInt(byArray, n += 4);
            int n6 = Utilities.byteToInt(byArray, n += 4);
            int n7 = Utilities.byteToInt(byArray, n += 4);
            LrmpEntity lrmpEntity2 = this.cxt.sm.get(n7);
            if (lrmpEntity2 == null || !(lrmpEntity2 instanceof LrmpSender)) {
                n += 12;
            } else {
                n += 4;
                LrmpLossEvent lrmpLossEvent = new LrmpLossEvent((LrmpSender)lrmpEntity2);
                lrmpLossEvent.rcvSendTime = System.currentTimeMillis();
                lrmpLossEvent.reporter = this.cxt.sm.get(n4);
                if (lrmpLossEvent.reporter == null) {
                    n += 8;
                } else {
                    lrmpLossEvent.low = this.getSeqno(byArray, n);
                    lrmpLossEvent.bitmask = Utilities.byteToInt(byArray, n += 4);
                    n += 4;
                    lrmpLossEvent.scope = n3;
                    lrmpLossEvent.timestamp = n5;
                    this.cxt.recover.processNackReply(lrmpEntity, lrmpLossEvent, n6);
                }
            }
            n2 -= 24;
        }
        if (n2 > 0) {
            ++this.cxt.stats.badLength;
        }
    }

    private void processSenderReport(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
        LrmpSender lrmpSender;
        int n3 = Utilities.byteToInt(byArray, n += 8);
        long l = this.getSeqno(byArray, n += 4);
        n += 4;
        if (lrmpEntity instanceof LrmpSender) {
            lrmpSender = (LrmpSender)lrmpEntity;
        } else {
            lrmpSender = this.cxt.sm.lookupSender(lrmpEntity.getID(), lrmpEntity.getAddress(), l);
            lrmpSender.setRate(this.cxt.profile.minRate + this.cxt.profile.maxRate >> 1);
        }
        lrmpSender.srSeqno = l;
        int n4 = Utilities.byteToInt(byArray, n);
        int n5 = Utilities.byteToInt(byArray, n += 4);
        n += 4;
        if (LrmpImpl.diff32(l, lrmpSender.expected()) > 0) {
            if (LrmpImpl.diff32(l, lrmpSender.maxseq) > 1) {
                lrmpSender.maxseq = l - 1L;
            }
            this.cxt.recover.handleLoss(lrmpSender);
        }
        if (lrmpSender.srTimestamp != 0) {
            int n6 = n3 - lrmpSender.srTimestamp;
            if ((n6 = (n6 >> 8) * 1000 >> 8) > 0) {
                int n7 = n5 - lrmpSender.srBytes;
                if (n7 > 0) {
                    lrmpSender.setRate(n7 * 1000 / n6);
                }
                if ((n7 = n4 - lrmpSender.srPackets) > 0) {
                    lrmpSender.setInterval(n6 / n7);
                }
            }
        }
        if (Logger.debug) {
            Logger.debug(this, "got SR " + lrmpEntity + " cur/next:" + l + "/" + lrmpSender.expected + " rate:" + lrmpSender.rate);
        }
        lrmpSender.srTimestamp = n3;
        lrmpSender.srPackets = n4;
        lrmpSender.srBytes = n5;
        ++this.cxt.stats.senderReports;
    }

    private void processRRSelection(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
        ++this.cxt.stats.rrSelect;
        if (!(lrmpEntity instanceof LrmpSender)) {
            if (Logger.debug) {
                Logger.debug(this, "receiver report sel from non sender");
            }
            return;
        }
        LrmpSender lrmpSender = (LrmpSender)lrmpEntity;
        lrmpSender.rrTimestamp = Utilities.byteToInt(byArray, n += 8);
        n += 4;
        lrmpSender.rrProb = (byArray[n++] & 0xFF) << 8;
        lrmpSender.rrProb |= byArray[n++] & 0xFF;
        lrmpSender.rrInterval = (byArray[n++] & 0xFF) << 8;
        lrmpSender.rrInterval |= byArray[n++] & 0xFF;
        lrmpSender.rrInterval *= 1000;
        n2 -= 16;
        while (n2 >= 4) {
            int n3 = Utilities.byteToInt(byArray, n);
            if (n3 == -1 || n3 == this.cxt.whoami.getID()) {
                int n4;
                lrmpSender.rrSelectTime = System.currentTimeMillis();
                lrmpSender.rrReplies = 0;
                boolean bl = true;
                if (lrmpSender.rrProb > 0) {
                    n4 = this.rand.nextInt();
                    if ((n4 &= 0xFFFF) > lrmpSender.rrProb) {
                        bl = false;
                    }
                } else if (lrmpSender.rrInterval == 0) {
                    bl = false;
                }
                if (Logger.debug) {
                    Logger.debug(this, "RR select prob=" + lrmpSender.rrProb + " interv=" + lrmpSender.rrInterval + " " + bl);
                }
                if (bl) {
                    n4 = this.randomize(lrmpSender.rrInterval);
                    lrmpSender.nextRRTime = System.currentTimeMillis() + (long)n4;
                    this.startTimer(n4);
                    if (this.reports.contains(lrmpSender)) break;
                    this.reports.addElement(lrmpSender);
                    break;
                }
                if (!this.reports.contains(lrmpSender)) break;
                this.reports.removeElement(lrmpSender);
                break;
            }
            n += 4;
            n2 -= 4;
        }
    }

    private void processReceiverReport(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
        byte by = byArray[n + 1];
        n += 8;
        n2 -= 8;
        long l = System.currentTimeMillis();
        while (n2 >= 20) {
            ++this.cxt.stats.receiverReports;
            int n3 = Utilities.byteToInt(byArray, n);
            n += 4;
            LrmpEntity lrmpEntity2 = this.cxt.sm.get(n3);
            if (lrmpEntity2 != null && lrmpEntity2 instanceof LrmpSender) {
                LrmpSender lrmpSender = (LrmpSender)lrmpEntity2;
                int n4 = Utilities.byteToInt(byArray, n);
                n += 4;
                if (n4 == lrmpSender.rrTimestamp) {
                    ++lrmpSender.rrReplies;
                    if (lrmpSender.rrProb > 0) {
                        this.cxt.stats.populationEstimate = (lrmpSender.rrReplies << 16) / lrmpSender.rrProb + 1;
                        this.cxt.stats.populationEstimateTime = l;
                    }
                } else if (lrmpSender != this.cxt.whoami) {
                    lrmpSender.rrReplies = 0;
                    this.cxt.stats.populationEstimate = 0;
                }
                if (lrmpEntity2 == this.cxt.whoami) {
                    int n5 = Utilities.byteToInt(byArray, n);
                    int n6 = NTP.ntp32(l) - n4 - n5;
                    if ((n6 = NTP.fixedPoint32ToMillis(n6)) >= 0) {
                        lrmpEntity.rtt = n6;
                        LrmpDomain lrmpDomain = this.cxt.recover.lookupDomain(by);
                        if (lrmpDomain != null) {
                            lrmpDomain.updateMRTT(n6);
                        }
                    } else {
                        Logger.error(this, "bad rtt " + n6 + " " + lrmpEntity + " " + NTP.ntp32(l) + "/" + n5 + "/" + n4);
                    }
                    if (Logger.debug) {
                        Logger.debug(this, "RR from " + lrmpEntity + " rtt=" + n6);
                    }
                }
                n += 12;
            } else {
                n += 16;
            }
            n2 -= 20;
        }
    }

    private void processData(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
        LrmpSender lrmpSender;
        long l = this.getSeqno(byArray, n + 12);
        int n3 = LrmpImpl.diff32(l, (lrmpSender = !(lrmpEntity instanceof LrmpSender) ? this.cxt.sm.lookupSender(lrmpEntity.getID(), lrmpEntity.getAddress(), l) : (LrmpSender)lrmpEntity).expected());
        if (n3 < 0) {
            lrmpSender.incDuplicate();
            return;
        }
        LrmpPacket lrmpPacket = lrmpSender.getPacket(l);
        if (lrmpPacket != null) {
            lrmpSender.incDuplicate();
            lrmpPacket.scope = byArray[n + 1] & 0xFF;
            lrmpPacket.rcvSendTime = System.currentTimeMillis();
        }
        lrmpPacket = new LrmpPacket(true, byArray, n, n2);
        lrmpPacket.seqno = l;
        lrmpPacket.retransmit = false;
        lrmpPacket.sender = lrmpEntity;
        lrmpPacket.source = lrmpSender;
        lrmpSender.lastTimeForData = lrmpPacket.rcvSendTime;
        lrmpSender.updateJitter(Utilities.byteToInt(byArray, n + 8));
        lrmpSender.lastseq = l;
        lrmpSender.incPackets();
        lrmpSender.incBytes(lrmpPacket.datalen);
        if (Logger.debug) {
            Logger.debug(this, "data/exp:" + l + "/" + lrmpSender.expected() + " @" + lrmpPacket.rcvSendTime + "/" + lrmpPacket.scope);
        }
        if (lrmpPacket.seqno > lrmpSender.maxseq) {
            lrmpSender.maxseq = lrmpPacket.seqno;
        }
        if (n3 == 0) {
            if (this.cxt.profile.sendRepair) {
                lrmpSender.putPacket(lrmpPacket);
            }
            while (lrmpPacket != null) {
                lrmpSender.incExpected();
                this.deliverData(lrmpPacket);
                lrmpPacket = lrmpSender.getPacket(lrmpSender.expected());
            }
        } else if (n3 <= lrmpSender.cacheSize) {
            lrmpSender.putPacket(lrmpPacket);
            this.cxt.recover.handleLoss(lrmpSender);
        } else {
            this.handleSyncError(lrmpSender, 1);
            if (this.cxt.profile.sendRepair) {
                lrmpSender.putPacket(lrmpPacket);
            }
        }
    }

    private void processRepairData(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
        LrmpEntity lrmpEntity2 = this.cxt.sm.get(Utilities.byteToInt(byArray, n + 8));
        if (lrmpEntity2 == null || !(lrmpEntity2 instanceof LrmpSender)) {
            return;
        }
        LrmpSender lrmpSender = (LrmpSender)lrmpEntity2;
        lrmpSender.incRepairs();
        long l = this.getSeqno(byArray, n + 12);
        LrmpPacket lrmpPacket = lrmpSender.getPacket(l);
        if (lrmpPacket != null) {
            lrmpPacket.scope = byArray[n + 1] & 0xFF;
            lrmpPacket.rcvSendTime = System.currentTimeMillis();
            if (lrmpSender != this.cxt.whoami) {
                lrmpSender.incDuplicate();
                this.cxt.recover.heardRepair(lrmpPacket, true);
            }
            return;
        }
        if (lrmpSender == this.cxt.whoami) {
            return;
        }
        int n3 = LrmpImpl.diff32(l, lrmpSender.expected());
        if (n3 < 0) {
            lrmpSender.incDuplicate();
            return;
        }
        lrmpPacket = new LrmpPacket(true, byArray, n, n2);
        lrmpPacket.retransmit = true;
        lrmpPacket.seqno = l;
        lrmpPacket.source = lrmpSender;
        lrmpPacket.sender = lrmpEntity;
        this.cxt.recover.heardRepair(lrmpPacket, false);
        if (lrmpPacket.sender == lrmpSender) {
            lrmpSender.lastTimeForData = lrmpPacket.rcvSendTime;
            lrmpSender.lastseq = lrmpPacket.seqno;
        }
        lrmpSender.incPackets();
        lrmpSender.incBytes(lrmpPacket.datalen);
        if (Logger.debug) {
            Logger.debug(this, "repair/exp:" + lrmpPacket.seqno + "/" + lrmpSender.expected() + " @" + lrmpPacket.rcvSendTime + "/" + lrmpPacket.scope);
        }
        if (lrmpPacket.seqno > lrmpSender.maxseq) {
            lrmpSender.maxseq = lrmpPacket.seqno;
        }
        if (n3 == 0) {
            if (this.cxt.profile.sendRepair) {
                lrmpSender.putPacket(lrmpPacket);
            }
            while (lrmpPacket != null) {
                lrmpSender.incExpected();
                this.deliverData(lrmpPacket);
                lrmpPacket = lrmpSender.getPacket(lrmpSender.expected());
            }
        } else if (n3 <= lrmpSender.cacheSize) {
            lrmpSender.putPacket(lrmpPacket);
            this.cxt.recover.handleLoss(lrmpSender);
        }
    }

    private void processUnreliableData(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
        ++this.cxt.stats.outOfBand;
        LrmpPacket lrmpPacket = new LrmpPacket(false, byArray, n, n2);
        lrmpPacket.source = lrmpEntity;
        this.deliverData(lrmpPacket);
    }

    private void processFecData(LrmpEntity lrmpEntity, byte[] byArray, int n, int n2) {
    }

    public void handleSyncError(LrmpSender lrmpSender, int n) {
        Cloneable cloneable;
        Logger.error(this, "reception failure @" + lrmpSender.expected + "/" + lrmpSender.maxseq + " cause=" + n);
        LrmpErrorEvent lrmpErrorEvent = null;
        if (lrmpSender.expected != lrmpSender.lastError + 1L) {
            lrmpErrorEvent = new LrmpErrorEvent();
            lrmpErrorEvent.source = lrmpSender;
            lrmpErrorEvent.loser = this.cxt.whoami;
            lrmpErrorEvent.cause = n;
            lrmpErrorEvent.seqlost = (int)lrmpSender.expected;
            ++this.cxt.stats.failures;
            if (this.cxt.profile.handler != null) {
                this.cxt.profile.handler.processEvent(1, lrmpErrorEvent);
            }
        }
        lrmpSender.lastError = lrmpSender.expected;
        int n2 = LrmpImpl.diff32(lrmpSender.maxseq, lrmpSender.expected);
        if (n2 < 0) {
            lrmpSender.clearCache(lrmpSender.maxseq);
        } else {
            lrmpSender.incExpected();
            --n2;
            cloneable = null;
            while (n2 > lrmpSender.cacheSize) {
                LrmpPacket lrmpPacket = lrmpSender.getPacket(lrmpSender.expected);
                if (lrmpPacket != null) {
                    this.deliverData(lrmpPacket);
                } else if (cloneable != null && this.cxt.profile.handler != null) {
                    if (lrmpErrorEvent == null) {
                        lrmpErrorEvent = new LrmpErrorEvent();
                        lrmpErrorEvent.source = lrmpSender;
                        lrmpErrorEvent.loser = this.cxt.whoami;
                        lrmpErrorEvent.cause = n;
                    }
                    lrmpSender.lastError = lrmpSender.expected;
                    lrmpErrorEvent.seqlost = (int)lrmpSender.expected;
                    ++this.cxt.stats.failures;
                    this.cxt.profile.handler.processEvent(1, lrmpErrorEvent);
                }
                cloneable = lrmpPacket;
                lrmpSender.incExpected();
                --n2;
            }
        }
        while ((cloneable = lrmpSender.getPacket(lrmpSender.expected())) != null) {
            this.deliverData((LrmpPacket)cloneable);
            lrmpSender.incExpected();
        }
        if (Logger.debug) {
            Logger.debug(this, "synced to " + lrmpSender.expected);
        }
        if ((cloneable = this.cxt.recover.lookup(lrmpSender, this.cxt.whoami)) != null) {
            ((LrmpLossEvent)cloneable).low = lrmpSender.expected;
            ((LrmpLossEvent)cloneable).nextAction = 0;
            if (((LrmpLossEvent)cloneable).nackCount > 1) {
                --((LrmpLossEvent)cloneable).nackCount;
            }
        } else {
            this.cxt.recover.handleLoss(lrmpSender);
        }
    }

    private void deliverData(LrmpPacket lrmpPacket) {
        if (lrmpPacket.reliable) {
            if (Logger.debug) {
                Logger.debug(this, "deliver #" + lrmpPacket.seqno + " len=" + lrmpPacket.datalen);
            }
            if (!this.cxt.profile.sendRepair) {
                ((LrmpSender)lrmpPacket.source).removePacket(lrmpPacket);
            }
        } else if (Logger.debug) {
            Logger.debug(this, "deliver out-of-band len=" + lrmpPacket.datalen);
        }
        if (this.cxt.profile.handler != null) {
            this.cxt.profile.handler.processData(lrmpPacket);
        }
    }

    private long getSeqno(byte[] byArray, int n) {
        long l = (long)(byArray[n] << 24) & 0xFF000000L;
        l |= (long)(byArray[n + 1] << 16) & 0xFF0000L;
        l |= (long)(byArray[n + 2] << 8) & 0xFF00L;
        return l |= (long)byArray[n + 3] & 0xFFL;
    }

    protected void sendDataPacket(LrmpPacket lrmpPacket, boolean bl) {
        int n = lrmpPacket.formatDataPacket(bl);
        this.send(lrmpPacket.getDataBuffer(), n, lrmpPacket.scope);
        if (bl) {
            LrmpDomain lrmpDomain = this.cxt.recover.lookupDomain(lrmpPacket.scope);
            ++lrmpDomain.stats.repairPackets;
            lrmpDomain.stats.repairBytes += n;
            this.cxt.whoami.incRepairs();
        }
        lrmpPacket.rcvSendTime = System.currentTimeMillis();
        if (lrmpPacket.reliable) {
            this.cxt.whoami.lastTimeForData = lrmpPacket.rcvSendTime;
        }
        this.cxt.whoami.setLastTimeHeard(lrmpPacket.rcvSendTime);
        this.cxt.whoami.incPackets();
        this.cxt.whoami.incBytes(n);
        ++this.cxt.stats.dataPackets;
        this.cxt.stats.dataBytes += n;
    }

    protected void sendControlPacket(LrmpPacket lrmpPacket, int n) {
        this.cxt.whoami.setLastTimeHeard(System.currentTimeMillis());
        ++this.cxt.stats.ctrlPackets;
        this.cxt.stats.ctrlBytes += lrmpPacket.offset;
        this.send(lrmpPacket.buff, lrmpPacket.offset, n);
    }

    public static int diff32(long l, long l2) {
        long l3 = l - l2;
        if (l3 > 0x80000000L) {
            l3 -= 0x100000000L;
        } else if (l3 < Integer.MIN_VALUE) {
            l3 += 0x100000000L;
        }
        return (int)l3;
    }

    private int randomize(int n) {
        return n * (65536 + 3 * (this.rand.nextInt() & 0xFFFF) >> 8) >> 10;
    }

    protected void idle() {
        long l = System.currentTimeMillis();
        int n = (int)(this.cxt.whoami.nextSRTime - l);
        int n2 = this.cxt.sndInterval << 4;
        if (n2 < 1000) {
            n2 = 1000;
        } else if (n2 > 4000) {
            n2 = 4000;
        }
        if (this.event != null) {
            LrmpContext.timer.recallTimer(this.event);
            this.event = null;
        }
        this.cxt.whoami.nextSRTime = l + (long)n2;
        this.startTimer(n2);
    }

    private void startTimer(int n) {
        long l = System.currentTimeMillis() + (long)n;
        if (this.event != null) {
            if (l > this.nextTimeout) {
                return;
            }
            LrmpContext.timer.recallTimer(this.event);
        }
        if (Logger.debug) {
            Logger.debug(this, "next timeout in " + n);
        }
        this.event = LrmpContext.timer.registerTimer(n, this, null);
        this.nextTimeout = l;
    }

    public void handleTimerEvent(Object object, long l) {
        int n;
        int n2;
        this.event = null;
        LrmpPacket lrmpPacket = new LrmpPacket(false, 1024);
        lrmpPacket.scope = this.ttl;
        lrmpPacket.offset = 0;
        int n3 = 10000;
        if (this.cxt.whoami.expected != this.cxt.whoami.startseq) {
            if (l - this.cxt.whoami.lastTimeForData < 600000L) {
                n2 = (int)(this.cxt.whoami.nextSRTime - l);
                if (n2 <= 0) {
                    lrmpPacket.appendSenderReport(this.cxt.whoami);
                    ++this.cxt.stats.senderReports;
                    int n4 = this.cxt.whoami.bytes - this.cxt.whoami.srBytes;
                    n = NTP.ntp32(l);
                    int n5 = n - this.cxt.whoami.srTimestamp;
                    n5 = (n5 >> 8) * 1000 >> 8;
                    if (n5 > 0) {
                        this.cxt.whoami.setRate(n4 * 1000 / n5);
                    }
                    this.cxt.whoami.srBytes = this.cxt.whoami.bytes;
                    this.cxt.whoami.srPackets = this.cxt.whoami.packets;
                    this.cxt.whoami.srSeqno = this.cxt.whoami.expected;
                    this.cxt.whoami.srTimestamp = n;
                    if (l - this.cxt.whoami.lastTimeForData > (long)this.idleTime) {
                        n3 = (int)(l - this.cxt.whoami.lastTimeForData);
                        if (n3 < 2000) {
                            n3 = 2000;
                        }
                    } else {
                        n3 = this.cxt.senderReportInterval;
                    }
                    this.cxt.whoami.nextSRTime = l + (long)n3;
                } else {
                    n3 = n2;
                }
                if (this.cxt.profile.rcvReportSelection != 1 && l - this.cxt.whoami.rrSelectTime > (long)this.cxt.rcvReportSelInterval) {
                    if (this.cxt.stats.populationEstimate < this.cxt.sm.getNumberOfEntities()) {
                        this.cxt.stats.populationEstimate = this.cxt.sm.getNumberOfEntities();
                    }
                    this.cxt.whoami.rrInterval = 10;
                    this.cxt.whoami.rrProb = 0x640000 / (this.cxt.stats.populationEstimate + 1);
                    if (this.cxt.whoami.rrProb > 65535) {
                        this.cxt.whoami.rrProb = 65535;
                    }
                    lrmpPacket.appendRRSelection(this.cxt.whoami, this.cxt.whoami.rrProb, this.cxt.whoami.rrInterval);
                    this.cxt.whoami.rrSelectTime = System.currentTimeMillis();
                    this.cxt.whoami.rrReplies = 0;
                    this.cxt.stats.populationEstimate = 0;
                    ++this.cxt.stats.rrSelect;
                }
            }
            if (Logger.debug) {
                Logger.debug(this, "send sender report " + lrmpPacket.offset);
            }
        }
        n2 = this.reports.size() - 1;
        while (n2 >= 0) {
            LrmpSender lrmpSender = (LrmpSender)this.reports.elementAt(n2);
            n = (int)(lrmpSender.nextRRTime - l);
            if (n <= 0) {
                lrmpPacket.appendReceiverReport(lrmpSender, this.cxt.whoami);
                ++this.cxt.stats.receiverReports;
                if (lrmpSender.rrProb > 0) {
                    this.reports.removeElement(lrmpSender);
                } else {
                    n = this.randomize(lrmpSender.rrInterval);
                    lrmpSender.nextRRTime = l + (long)n;
                }
            }
            if (n > 0 && n < n3) {
                n3 = n;
            }
            --n2;
        }
        if (lrmpPacket.offset > 0) {
            this.sendControlPacket(lrmpPacket, this.ttl);
        }
        this.cxt.sm.prune();
        this.startTimer(n3);
    }

    private void sendSenderReport() {
        LrmpPacket lrmpPacket = new LrmpPacket(false, 64);
        lrmpPacket.scope = this.ttl;
        lrmpPacket.offset = 0;
        lrmpPacket.appendSenderReport(this.cxt.whoami);
        this.sendControlPacket(lrmpPacket, this.ttl);
        ++this.cxt.stats.senderReports;
    }

    private void sendReceiverReport(LrmpSender lrmpSender) {
        LrmpPacket lrmpPacket = new LrmpPacket(false, 64);
        lrmpPacket.scope = this.ttl;
        lrmpPacket.offset = 0;
        lrmpPacket.appendReceiverReport(lrmpSender, this.cxt.whoami);
        this.sendControlPacket(lrmpPacket, this.ttl);
        ++this.cxt.stats.receiverReports;
    }

    private void update(long l) {
        int n = (int)(l - this.lastUpdateTime);
        this.lastUpdateTime = l;
        this.cxt.stats.dataRate = (this.cxt.stats.dataBytes - this.lastDataBytes) * 1000 / n;
        this.lastDataBytes = this.cxt.stats.dataBytes;
        if (this.cxt.stats.dataRate > this.cxt.stats.maxDataRate) {
            this.cxt.stats.maxDataRate = this.cxt.stats.dataRate;
        }
        this.cxt.stats.ctlRate = (this.cxt.stats.ctrlBytes - this.lastCtrlBytes) * 1000 / n;
        this.lastCtrlBytes = this.cxt.stats.ctrlBytes;
        if (this.cxt.stats.ctlRate > this.cxt.stats.maxCtlRate) {
            this.cxt.stats.maxCtlRate = this.cxt.stats.ctlRate;
        }
        if (l - this.cxt.stats.populationEstimateTime > 600000L || this.cxt.stats.populationEstimate < this.cxt.sm.getNumberOfEntities()) {
            this.cxt.stats.populationEstimate = this.cxt.sm.getNumberOfEntities();
        }
    }

    public LrmpStats getLrmpStats() {
        this.update(System.currentTimeMillis());
        LrmpStats lrmpStats = this.cxt.stats;
        lrmpStats.nack = 0;
        lrmpStats.dupNack = 0;
        lrmpStats.nackReply = 0;
        lrmpStats.repairPackets = 0;
        lrmpStats.repairBytes = 0;
        lrmpStats.dupPackets = 0;
        lrmpStats.dupBytes = 0;
        LrmpDomain lrmpDomain = this.cxt.recover.domain;
        while (lrmpDomain != null) {
            LrmpDomainStats lrmpDomainStats = lrmpDomain.stats;
            lrmpStats.nack += lrmpDomainStats.nack;
            lrmpStats.dupNack += lrmpDomainStats.dupNack;
            lrmpStats.nackReply += lrmpDomainStats.nackReply;
            lrmpStats.repairPackets += lrmpDomainStats.repairPackets;
            lrmpStats.repairBytes += lrmpDomainStats.repairBytes;
            lrmpStats.dupPackets += lrmpDomainStats.dupPackets;
            lrmpStats.dupBytes += lrmpDomainStats.dupBytes;
            lrmpDomain = lrmpDomain.parent;
        }
        return lrmpStats;
    }

    public LrmpDomainStats getDomainStats(int n) {
        LrmpDomain lrmpDomain = this.cxt.recover.lookupDomain(n);
        if (lrmpDomain != null) {
            return lrmpDomain.stats;
        }
        return null;
    }

    public InetAddress getAddress() {
        return this.inetAddr;
    }

    public int getPort() {
        return this.port;
    }

    public void setTTL(int n) {
        if (n >= 0 && n < 256 && n != this.ttl) {
            this.ttl = n;
            this.initRecover();
        }
    }
}

