/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpContext;
import inria.net.lrmp.LrmpPacket;
import inria.net.lrmp.LrmpSender;
import inria.util.Logger;

final class LrmpFlow
implements Runnable {
    LrmpContext cxt;
    protected static final int BigDecrease = 2;
    protected static final int MediumDecrease = 4;
    protected static final int SmallDecrease = 6;
    protected static final int None = 8;
    protected static final int SmallIncrease = 9;
    protected static final int MediumIncrease = 12;
    protected static final int BigIncrease = 16;
    private int lastPackets = 0;
    private int lastBytes = 0;
    private long lastTime = 0L;
    private Thread thread = null;

    LrmpFlow(LrmpContext lrmpContext) {
        this.cxt = lrmpContext;
        this.lastTime = System.currentTimeMillis();
    }

    public void enqueue(LrmpPacket lrmpPacket) {
        this.cxt.sendQueue.enqueue(lrmpPacket);
        if (this.thread == null) {
            this.start();
        }
    }

    public void flush() {
        this.cxt.sendQueue.sync();
    }

    private synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setName(this.getClass().getName());
            this.thread.setPriority(5);
            this.thread.start();
        }
    }

    public void stop() {
        this.thread = null;
    }

    public synchronized void run() {
        while (this.thread != null) {
            if (this.cxt.resendQueue.size() > 0) {
                this.resend();
            }
            if (this.cxt.sendQueue.getSize() == 0) break;
            LrmpPacket lrmpPacket = (LrmpPacket)this.cxt.sendQueue.dequeue();
            lrmpPacket.sender = lrmpPacket.source = this.cxt.whoami;
            if (lrmpPacket.isReliable()) {
                lrmpPacket.seqno = this.cxt.whoami.expected();
                this.cxt.whoami.incExpected();
                this.cxt.whoami.appendPacket(lrmpPacket);
                if (Logger.debug) {
                    Logger.debug(this, "sending #" + lrmpPacket.seqno + " len=" + lrmpPacket.getDataLength());
                }
            }
            lrmpPacket.scope = this.cxt.lrmp.getTTL();
            this.cxt.lrmp.sendDataPacket(lrmpPacket, false);
            this.flowControl();
            if (this.cxt.profile.throughput == 1 || this.cxt.sndInterval <= 0) continue;
            try {
                this.wait(this.cxt.sndInterval);
            }
            catch (InterruptedException interruptedException) {
                Logger.error(this, "interrupted!");
            }
        }
        this.thread = null;
        this.cxt.lrmp.idle();
    }

    private void resend() {
        LrmpPacket lrmpPacket;
        while ((lrmpPacket = this.cxt.resendQueue.dequeue()) != null) {
            if (Logger.debug) {
                Logger.debug(this, "resending #" + lrmpPacket.seqno + " @" + lrmpPacket.scope);
            }
            lrmpPacket.sender = this.cxt.whoami;
            this.cxt.lrmp.sendDataPacket(lrmpPacket, true);
            if (this.cxt.resendQueue.size() <= 0) break;
            this.flowControl();
            if (this.cxt.profile.throughput == 1 || this.cxt.sndInterval <= 0) continue;
            try {
                this.wait(this.cxt.sndInterval);
            }
            catch (InterruptedException interruptedException) {
                Logger.error(this, "interrupted!");
            }
        }
    }

    private void flowControl() {
        int n = this.cxt.whoami.packets - this.lastPackets;
        if (n < this.cxt.checkInterval) {
            return;
        }
        this.lastPackets = this.cxt.whoami.packets;
        int n2 = this.cxt.whoami.bytes - this.lastBytes;
        this.lastBytes = this.cxt.whoami.bytes;
        long l = System.currentTimeMillis();
        this.cxt.actualRate = n2 * 1000 / (int)(l - this.lastTime);
        this.cxt.whoami.setRate(this.cxt.actualRate);
        this.lastTime = l;
        if (this.cxt.profile.throughput == 2) {
            return;
        }
        this.cxt.curRate = this.cxt.curRate * this.cxt.adjust >> 3;
        if (this.cxt.curRate < this.cxt.profile.minRate) {
            this.cxt.curRate = this.cxt.profile.minRate;
        } else if (this.cxt.curRate > this.cxt.profile.maxRate) {
            this.cxt.curRate = this.cxt.profile.maxRate;
        }
        this.cxt.adjust = 9;
        if (this.cxt.whoami.bytes > 0) {
            this.cxt.sndInterval = n2 * 1000 / n / this.cxt.curRate;
        }
        if (this.cxt.actualRate < this.cxt.curRate * 3 >> 2) {
            this.cxt.sndInterval = this.cxt.sndInterval * 3 >> 2;
        }
        if (this.cxt.sndInterval > 30000) {
            this.cxt.sndInterval = 30000;
        }
        if (Logger.debug) {
            Logger.debug(this, "rate/interval: " + this.cxt.curRate + "/" + this.cxt.sndInterval);
        }
    }

    private void updateRate() {
    }

    public void reset() {
        this.cxt.sendQueue.clear();
        this.cxt.resendQueue.clear();
        this.cxt.whoami.clearCache(this.cxt.whoami.expected());
    }

    public void enqueueResend(LrmpPacket lrmpPacket, int n) {
        if (this.cxt.resendQueue.contains(lrmpPacket)) {
            if (lrmpPacket.scope < n) {
                lrmpPacket.scope = n;
            }
            return;
        }
        lrmpPacket.scope = n;
        this.cxt.resendQueue.enqueue(lrmpPacket);
        if (this.thread == null) {
            this.start();
        }
    }

    public void cancelResend(LrmpSender lrmpSender, long l, int n) {
        this.cxt.resendQueue.remove(lrmpSender, l, n);
    }

    public void cancelResend(LrmpSender lrmpSender, int n, int n2) {
        this.cxt.resendQueue.cancel(lrmpSender, n, n2);
    }
}

