/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpEntity;
import inria.net.lrmp.LrmpProfile;
import inria.net.lrmp.LrmpSender;
import inria.util.EntityTable;
import inria.util.Logger;
import inria.util.Utilities;
import java.net.InetAddress;
import java.util.Vector;

final class LrmpEntityManager {
    private static final int maxSrc = 128;
    private EntityTable entities = new EntityTable();
    private LrmpSender whoami;
    protected static final int rcvDropTime = 60000;
    protected static final int sndDropTime = 600000;
    protected LrmpProfile profile;

    LrmpEntityManager() {
        int n = this.allocateID();
        int n2 = 0;
        while (n2 <= 0) {
            n2 = Utilities.getRandomInteger() & 0xFFFF;
        }
        this.whoami = new LrmpSender(n, Utilities.getLocalHost(), n2);
        if (Logger.debug) {
            Logger.debug(this, "local user=" + this.whoami.toString() + " seqno=" + this.whoami.expected());
        }
        this.add(this.whoami);
    }

    private int allocateID() {
        int n = Utilities.getRandomInteger();
        return n;
    }

    public int getNumberOfEntities() {
        return this.entities.size();
    }

    public LrmpEntity get(int n) {
        return (LrmpEntity)this.entities.getEntity(n);
    }

    public Vector getEntities() {
        return this.entities;
    }

    public LrmpEntity lookup(int n, InetAddress inetAddress) {
        LrmpEntity lrmpEntity = (LrmpEntity)this.entities.getEntity(n);
        if (lrmpEntity != null) {
            if (!lrmpEntity.getAddress().equals(inetAddress)) {
                if (lrmpEntity instanceof LrmpSender) {
                    return null;
                }
                long l = System.currentTimeMillis() - lrmpEntity.getLastTimeHeard();
                if (l < 60000L) {
                    return null;
                }
                lrmpEntity.setAddress(inetAddress);
                lrmpEntity.reset();
            }
            return lrmpEntity;
        }
        int n2 = this.entities.size() - 1;
        while (n2 >= 0) {
            long l;
            lrmpEntity = (LrmpEntity)this.entities.elementAt(n2);
            if (lrmpEntity != this.whoami && !(lrmpEntity instanceof LrmpSender) && lrmpEntity.getAddress().equals(inetAddress) && (l = System.currentTimeMillis() - lrmpEntity.getLastTimeHeard()) >= 60000L) {
                this.remove(lrmpEntity);
                lrmpEntity.setID(n);
                this.add(lrmpEntity);
                lrmpEntity.reset();
                return lrmpEntity;
            }
            --n2;
        }
        lrmpEntity = new LrmpEntity(n, inetAddress);
        if (Logger.debug) {
            Logger.debug(this, "new entity: " + lrmpEntity);
        }
        this.add(lrmpEntity);
        return lrmpEntity;
    }

    public LrmpEntity demux(int n, InetAddress inetAddress) {
        LrmpEntity lrmpEntity = (LrmpEntity)this.entities.getEntity(n);
        if (lrmpEntity == null) {
            return null;
        }
        if (!lrmpEntity.getAddress().equals(inetAddress)) {
            return null;
        }
        return lrmpEntity;
    }

    public void clear() {
        this.entities.removeAllElements();
    }

    public void dump() {
        int n = this.entities.size() - 1;
        while (n >= 0) {
            LrmpEntity lrmpEntity = (LrmpEntity)this.entities.elementAt(n);
            Logger.debug(this, lrmpEntity.toString());
            --n;
        }
    }

    public void prune() {
        this.prune(60000);
    }

    public void prune(int n) {
        long l = System.currentTimeMillis();
        int n2 = this.entities.size() - 1;
        while (n2 >= 0) {
            LrmpEntity lrmpEntity = (LrmpEntity)this.entities.elementAt(n2);
            if (lrmpEntity != this.whoami) {
                int n3 = (int)(l - lrmpEntity.getLastTimeHeard());
                if (n3 >= 600000) {
                    this.remove(lrmpEntity);
                } else if (!(lrmpEntity instanceof LrmpSender) && n3 >= n) {
                    this.remove(lrmpEntity);
                }
            }
            --n2;
        }
    }

    public LrmpSender whoami() {
        return this.whoami;
    }

    public LrmpSender lookupSender(int n, InetAddress inetAddress, long l) {
        LrmpSender lrmpSender;
        LrmpEntity lrmpEntity = this.demux(n, inetAddress);
        if (lrmpEntity == null) {
            lrmpSender = new LrmpSender(n, inetAddress, l);
            lrmpSender.initCache(this.profile.rcvWindowSize);
            this.add(lrmpSender);
        } else if (!(lrmpEntity instanceof LrmpSender)) {
            lrmpSender = new LrmpSender(n, inetAddress, l);
            lrmpSender.initCache(this.profile.rcvWindowSize);
            this.remove(lrmpEntity);
            this.add(lrmpSender);
        } else {
            lrmpSender = (LrmpSender)lrmpEntity;
        }
        return lrmpSender;
    }

    protected void add(LrmpEntity lrmpEntity) {
        if (this.entities.size() > 128) {
            int n = 60000;
            while (this.entities.size() > 128) {
                this.prune(n);
                if (n <= 10000) break;
                n -= 10000;
            }
        }
        this.entities.addEntity(lrmpEntity);
    }

    protected void remove(LrmpEntity lrmpEntity) {
        if (lrmpEntity != this.whoami) {
            this.entities.removeEntity(lrmpEntity);
            if (lrmpEntity instanceof LrmpSender && this.profile.handler != null) {
                this.profile.handler.processEvent(2, lrmpEntity);
            }
        }
    }
}

