/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.util.Entity;
import java.net.InetAddress;

public class LrmpEntity
extends Entity {
    protected static final long SequenceModulo = 0x100000000L;
    private InetAddress ipAddr;
    private long lastTimeHeard;
    private int nack;
    private int repair;
    protected int rtt = 0;
    protected int distance;

    LrmpEntity(int n, InetAddress inetAddress) {
        super(n);
        this.ipAddr = inetAddress;
        this.reset();
    }

    protected void reset() {
        this.nack = 0;
        this.repair = 0;
        this.lastTimeHeard = 0L;
        this.distance = 255;
    }

    protected void setAddress(InetAddress inetAddress) {
        this.ipAddr = inetAddress;
    }

    protected void setID(int n) {
        this.id = n;
    }

    public InetAddress getAddress() {
        return this.ipAddr;
    }

    public String toString() {
        return Integer.toHexString(this.id) + "@" + this.ipAddr.getHostAddress();
    }

    public int getNackCount() {
        return this.nack;
    }

    public int getRTT() {
        return this.rtt;
    }

    protected void incNack() {
        ++this.nack;
    }

    public long getLastTimeHeard() {
        return this.lastTimeHeard;
    }

    public boolean equals(LrmpEntity lrmpEntity) {
        return this.id == lrmpEntity.getID();
    }

    protected void setLastTimeHeard(long l) {
        this.lastTimeHeard = l;
    }
}

