/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpDomainStats;
import inria.net.lrmp.LrmpLossEvent;
import inria.net.lrmp.LrmpLossTable;
import inria.util.Logger;
import java.util.Vector;

final class LrmpDomain {
    protected static final int MaxDisableTime = 180000;
    protected static final int DisableTries = 5;
    protected static final int MinRTTValue = 2;
    protected static final int MaxRTTValue = 16000;
    protected LrmpDomain parent = null;
    protected LrmpDomain child = null;
    protected int scope;
    protected int initialMRTT;
    protected LrmpDomainStats stats = new LrmpDomainStats();
    protected long lastTimeToggle = 0L;
    protected int failedNack = 0;
    protected LrmpLossTable lossTab;
    protected Vector lossHistory;
    protected static int historySize = 16;

    public LrmpDomain(int n) {
        this.stats.enabled = true;
        this.stats.scope = n;
        this.stats.parentScope = 0;
        this.stats.childScope = 0;
        this.scope = n;
        this.initialMRTT = LrmpDomain.getInitialRTT(this.scope);
        this.stats.mrtt = this.initialMRTT << 3;
    }

    protected void setParent(LrmpDomain lrmpDomain) {
        this.parent = lrmpDomain;
        this.parent.child = this;
        this.stats.parentScope = this.parent.scope;
    }

    protected void setChild(LrmpDomain lrmpDomain) {
        this.child = lrmpDomain;
        this.child.parent = this;
        this.stats.childScope = this.child.scope;
    }

    public static int getInitialRTT(int n) {
        if (n <= 15) {
            return 12;
        }
        if (n >= 126) {
            return 800;
        }
        return (200 * n * n + 1984) / 3969;
    }

    protected void enable() {
        if (this.stats.enabled) {
            return;
        }
        this.stats.enabled = true;
        this.failedNack = 0;
        this.lastTimeToggle = System.currentTimeMillis();
        if (this.parent != null) {
            this.parent.enable();
        }
        if (Logger.debug) {
            Logger.debug(this, "ENABLE scope=" + this.scope);
        }
    }

    protected void disable() {
        if (this.parent == null || !this.stats.enabled) {
            return;
        }
        this.stats.enabled = false;
        this.lastTimeToggle = System.currentTimeMillis();
        if (this.child != null) {
            this.child.disable();
        }
        if (Logger.debug) {
            Logger.debug(this, "DISABLE " + this.scope + " fails=" + this.failedNack);
        }
    }

    protected boolean isEnabled() {
        return this.stats.enabled;
    }

    protected void checkState() {
        if (this.parent == null) {
            return;
        }
        if (this.stats.enabled) {
            if (this.failedNack > 5) {
                this.disable();
            }
        } else if (System.currentTimeMillis() - this.lastTimeToggle > 180000L) {
            this.enable();
        }
    }

    protected void updateMRTT(int n) {
        if (n > 2 && n < 16000) {
            this.stats.mrtt += (n -= this.stats.mrtt >> 3);
            if (this.child != null && this.child.stats.mrtt > this.stats.mrtt) {
                this.child.setMRTT(this.stats.mrtt);
            }
        }
    }

    protected void setMRTT(int n) {
        this.stats.mrtt = n;
        if (this.child != null && this.child.stats.mrtt > this.stats.mrtt) {
            this.child.setMRTT(n);
        }
    }

    protected boolean isDuplicate(LrmpLossEvent lrmpLossEvent) {
        boolean bl = false;
        int n = this.stats.mrtt >> 3;
        n = lrmpLossEvent.source.interval < 200 ? (n += lrmpLossEvent.source.interval) : (n += 200);
        int n2 = this.lossHistory.size() - 1;
        while (n2 >= 0) {
            LrmpLossEvent lrmpLossEvent2 = (LrmpLossEvent)this.lossHistory.elementAt(n2);
            if (lrmpLossEvent2.source == lrmpLossEvent.source) {
                int n3 = (int)(lrmpLossEvent.rcvSendTime - lrmpLossEvent2.rcvSendTime);
                if (n3 < n) {
                    if (lrmpLossEvent2.contains(lrmpLossEvent)) {
                        bl = true;
                        if (!Logger.debug) break;
                        Logger.debug(this, "Dup NACK: " + n3 + "<" + n);
                        break;
                    }
                } else if (lrmpLossEvent.contains(lrmpLossEvent2)) {
                    if (Logger.debug) {
                        Logger.debug(this, "Repeated nack in " + n3);
                    }
                    this.lossHistory.removeElement(lrmpLossEvent2);
                }
            }
            --n2;
        }
        if (!this.lossHistory.contains(lrmpLossEvent)) {
            if (this.lossHistory.size() > historySize) {
                this.lossHistory.removeElementAt(0);
            }
            this.lossHistory.addElement(lrmpLossEvent);
        }
        return bl;
    }
}

