/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpEntityManager;
import inria.net.lrmp.LrmpFlow;
import inria.net.lrmp.LrmpImpl;
import inria.net.lrmp.LrmpPacketQueue;
import inria.net.lrmp.LrmpProfile;
import inria.net.lrmp.LrmpRecovery;
import inria.net.lrmp.LrmpSender;
import inria.net.lrmp.LrmpStats;
import inria.util.EventManager;
import inria.util.FIFOQueue;
import inria.util.Logger;

final class LrmpContext {
    protected LrmpSender whoami;
    protected LrmpProfile profile;
    protected LrmpStats stats;
    protected LrmpImpl lrmp;
    protected LrmpFlow sender;
    protected LrmpRecovery recover;
    protected LrmpEntityManager sm;
    protected int adjust = 9;
    protected int curRate = 0;
    protected int actualRate = 0;
    protected int checkInterval;
    protected int sndInterval = 100;
    protected static final int MaxQueueSize = 16;
    protected FIFOQueue sendQueue = new FIFOQueue(16);
    protected LrmpPacketQueue resendQueue = new LrmpPacketQueue();
    protected int senderReportInterval = 4000;
    public int rcvReportSelInterval = 30000;
    protected static EventManager timer = null;

    protected LrmpContext() {
    }

    protected void setProfile(LrmpProfile lrmpProfile) {
        this.profile = (LrmpProfile)lrmpProfile.clone();
        if (this.profile.sendWindowSize >= 32) {
            this.whoami.cacheSize = this.profile.sendWindowSize;
            if (this.whoami.cache != null) {
                this.whoami.initCache(this.profile.sendWindowSize);
            }
        }
        this.sm.profile = this.profile;
        if (Logger.debug) {
            Logger.debug(this, "rcv/snd window:" + this.profile.rcvWindowSize + "/" + this.profile.sendWindowSize);
        }
        this.profile.minRate = this.profile.minRate <= 0 ? 125 : this.profile.minRate * 1000 >> 3;
        this.profile.maxRate = this.profile.maxRate * 1000 >> 3;
        if (this.profile.maxRate <= this.profile.minRate) {
            this.profile.maxRate = this.profile.minRate;
        }
        if (this.curRate == 0) {
            this.curRate = this.profile.minRate + this.profile.maxRate >> 1;
            if (this.curRate < this.profile.minRate) {
                this.curRate = this.profile.minRate;
            }
            this.sndInterval = 1400000 / this.curRate;
        }
        this.checkInterval = this.profile.sendWindowSize >> 3;
        if (this.checkInterval < 4) {
            this.checkInterval = 4;
        }
        if (Logger.debug) {
            Logger.debug(this, "min/cur/max rate: " + this.profile.minRate + "/" + this.curRate + "/" + this.profile.maxRate + " send/check interval: " + this.sndInterval + "/" + this.checkInterval);
        }
    }
}

