/*
 * Decompiled with CFR 0.152.
 */
package inria.net.lrmp;

import inria.net.lrmp.LrmpDomainStats;
import inria.net.lrmp.LrmpEntity;
import inria.net.lrmp.LrmpException;
import inria.net.lrmp.LrmpImpl;
import inria.net.lrmp.LrmpPacket;
import inria.net.lrmp.LrmpProfile;
import inria.net.lrmp.LrmpStats;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Lrmp {
    public final String Version = "LRMP-1.4.2";
    private LrmpImpl impl;

    public Lrmp(InetAddress inetAddress, int n, int n2, LrmpProfile lrmpProfile) throws LrmpException {
        this.impl = new LrmpImpl(inetAddress, n, n2, lrmpProfile);
    }

    public Lrmp(InetAddress inetAddress, int n, LrmpProfile lrmpProfile) throws LrmpException {
        this(inetAddress, n, 0, lrmpProfile);
    }

    public Lrmp(String string, int n, int n2, LrmpProfile lrmpProfile) throws LrmpException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new LrmpException(unknownHostException.toString());
        }
        this.impl = new LrmpImpl(inetAddress, n, n2, lrmpProfile);
    }

    public Lrmp(String string, int n, LrmpProfile lrmpProfile) throws LrmpException {
        this(string, n, 0, lrmpProfile);
    }

    public void start() {
        this.impl.startSession();
    }

    public void stop() {
        this.impl.stopSession();
    }

    public void startSession() {
        this.impl.startSession();
    }

    public void stopSession() {
        this.impl.stopSession();
    }

    public void setProfile(LrmpProfile lrmpProfile) throws LrmpException {
        this.impl.setProfile(lrmpProfile);
    }

    public void setTTL(int n) {
        this.impl.setTTL(n);
    }

    public InetAddress getAddress() {
        return this.impl.getAddress();
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public int getTTL() {
        return this.impl.getTTL();
    }

    public LrmpStats getLrmpStats() {
        return (LrmpStats)this.impl.getLrmpStats().clone();
    }

    public LrmpDomainStats getDomainStats(int n) {
        LrmpDomainStats lrmpDomainStats = this.impl.getDomainStats(n);
        if (lrmpDomainStats == null) {
            return null;
        }
        return (LrmpDomainStats)lrmpDomainStats.clone();
    }

    public LrmpEntity whoami() {
        return this.impl.whoami();
    }

    public void send(LrmpPacket lrmpPacket) throws LrmpException {
        if (lrmpPacket.getDataLength() > lrmpPacket.getMaxDataLength()) {
            throw new LrmpException("bad packet length");
        }
        this.impl.send(lrmpPacket);
    }

    public void flush() {
        this.impl.flush();
    }
}

